# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InfraModuleTestingArgs', 'InfraModuleTesting']

@pulumi.input_type
class InfraModuleTestingArgs:
    def __init__(__self__, *,
                 module_id: pulumi.Input[_builtins.str],
                 org: pulumi.Input[_builtins.str],
                 pipelines: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 project: pulumi.Input[_builtins.str],
                 provider_connector: pulumi.Input[_builtins.str],
                 provisioner_type: pulumi.Input[_builtins.str],
                 provisioner_version: pulumi.Input[_builtins.str],
                 release_pipeline: Optional[pulumi.Input[_builtins.str]] = None,
                 testing_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 testing_metadata: Optional[pulumi.Input['InfraModuleTestingTestingMetadataArgs']] = None,
                 updated: Optional[pulumi.Input[_builtins.int]] = None,
                 versions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a InfraModuleTesting resource.
        :param pulumi.Input[_builtins.str] module_id: Identifier of the module to enable testing for
        :param pulumi.Input[_builtins.str] org: Organization identifier
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] pipelines: List of pipeline IDs to create webhooks for triggering test executions
        :param pulumi.Input[_builtins.str] project: Project identifier
        :param pulumi.Input[_builtins.str] provider_connector: Provider connector for testing purposes
        :param pulumi.Input[_builtins.str] provisioner_version: Provisioner version for testing purposes
        :param pulumi.Input[_builtins.str] release_pipeline: Pipeline ID to create webhooks for releases
        :param pulumi.Input[_builtins.bool] testing_enabled: Whether testing is enabled for the module
        :param pulumi.Input['InfraModuleTestingTestingMetadataArgs'] testing_metadata: Testing metadata for the module
        :param pulumi.Input[_builtins.int] updated: Timestamp when the module was last modified
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] versions: Versions of the module
        """
        pulumi.set(__self__, "module_id", module_id)
        pulumi.set(__self__, "org", org)
        pulumi.set(__self__, "pipelines", pipelines)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "provider_connector", provider_connector)
        pulumi.set(__self__, "provisioner_type", provisioner_type)
        pulumi.set(__self__, "provisioner_version", provisioner_version)
        if release_pipeline is not None:
            pulumi.set(__self__, "release_pipeline", release_pipeline)
        if testing_enabled is not None:
            pulumi.set(__self__, "testing_enabled", testing_enabled)
        if testing_metadata is not None:
            pulumi.set(__self__, "testing_metadata", testing_metadata)
        if updated is not None:
            pulumi.set(__self__, "updated", updated)
        if versions is not None:
            pulumi.set(__self__, "versions", versions)

    @_builtins.property
    @pulumi.getter(name="moduleId")
    def module_id(self) -> pulumi.Input[_builtins.str]:
        """
        Identifier of the module to enable testing for
        """
        return pulumi.get(self, "module_id")

    @module_id.setter
    def module_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "module_id", value)

    @_builtins.property
    @pulumi.getter
    def org(self) -> pulumi.Input[_builtins.str]:
        """
        Organization identifier
        """
        return pulumi.get(self, "org")

    @org.setter
    def org(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "org", value)

    @_builtins.property
    @pulumi.getter
    def pipelines(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        List of pipeline IDs to create webhooks for triggering test executions
        """
        return pulumi.get(self, "pipelines")

    @pipelines.setter
    def pipelines(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "pipelines", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Input[_builtins.str]:
        """
        Project identifier
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="providerConnector")
    def provider_connector(self) -> pulumi.Input[_builtins.str]:
        """
        Provider connector for testing purposes
        """
        return pulumi.get(self, "provider_connector")

    @provider_connector.setter
    def provider_connector(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "provider_connector", value)

    @_builtins.property
    @pulumi.getter(name="provisionerType")
    def provisioner_type(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "provisioner_type")

    @provisioner_type.setter
    def provisioner_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "provisioner_type", value)

    @_builtins.property
    @pulumi.getter(name="provisionerVersion")
    def provisioner_version(self) -> pulumi.Input[_builtins.str]:
        """
        Provisioner version for testing purposes
        """
        return pulumi.get(self, "provisioner_version")

    @provisioner_version.setter
    def provisioner_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "provisioner_version", value)

    @_builtins.property
    @pulumi.getter(name="releasePipeline")
    def release_pipeline(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Pipeline ID to create webhooks for releases
        """
        return pulumi.get(self, "release_pipeline")

    @release_pipeline.setter
    def release_pipeline(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "release_pipeline", value)

    @_builtins.property
    @pulumi.getter(name="testingEnabled")
    def testing_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether testing is enabled for the module
        """
        return pulumi.get(self, "testing_enabled")

    @testing_enabled.setter
    def testing_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "testing_enabled", value)

    @_builtins.property
    @pulumi.getter(name="testingMetadata")
    def testing_metadata(self) -> Optional[pulumi.Input['InfraModuleTestingTestingMetadataArgs']]:
        """
        Testing metadata for the module
        """
        return pulumi.get(self, "testing_metadata")

    @testing_metadata.setter
    def testing_metadata(self, value: Optional[pulumi.Input['InfraModuleTestingTestingMetadataArgs']]):
        pulumi.set(self, "testing_metadata", value)

    @_builtins.property
    @pulumi.getter
    def updated(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Timestamp when the module was last modified
        """
        return pulumi.get(self, "updated")

    @updated.setter
    def updated(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "updated", value)

    @_builtins.property
    @pulumi.getter
    def versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Versions of the module
        """
        return pulumi.get(self, "versions")

    @versions.setter
    def versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "versions", value)


@pulumi.input_type
class _InfraModuleTestingState:
    def __init__(__self__, *,
                 account: Optional[pulumi.Input[_builtins.str]] = None,
                 created: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 git_tag_style: Optional[pulumi.Input[_builtins.str]] = None,
                 module_error: Optional[pulumi.Input[_builtins.str]] = None,
                 module_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 org: Optional[pulumi.Input[_builtins.str]] = None,
                 pipelines: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_connector: Optional[pulumi.Input[_builtins.str]] = None,
                 provisioner_type: Optional[pulumi.Input[_builtins.str]] = None,
                 provisioner_version: Optional[pulumi.Input[_builtins.str]] = None,
                 release_pipeline: Optional[pulumi.Input[_builtins.str]] = None,
                 repository: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_branch: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_commit: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_connector: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_path: Optional[pulumi.Input[_builtins.str]] = None,
                 repository_url: Optional[pulumi.Input[_builtins.str]] = None,
                 synced: Optional[pulumi.Input[_builtins.int]] = None,
                 system: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[_builtins.str]] = None,
                 testing_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 testing_metadata: Optional[pulumi.Input['InfraModuleTestingTestingMetadataArgs']] = None,
                 updated: Optional[pulumi.Input[_builtins.int]] = None,
                 versions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering InfraModuleTesting resources.
        :param pulumi.Input[_builtins.str] account: Account that owns the module
        :param pulumi.Input[_builtins.int] created: Timestamp when the module was created
        :param pulumi.Input[_builtins.str] description: Description of the module
        :param pulumi.Input[_builtins.str] git_tag_style: Git Tag Style
        :param pulumi.Input[_builtins.str] module_error: Error while retrieving the module
        :param pulumi.Input[_builtins.str] module_id: Identifier of the module to enable testing for
        :param pulumi.Input[_builtins.str] name: Name of the module
        :param pulumi.Input[_builtins.str] org: Organization identifier
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] pipelines: List of pipeline IDs to create webhooks for triggering test executions
        :param pulumi.Input[_builtins.str] project: Project identifier
        :param pulumi.Input[_builtins.str] provider_connector: Provider connector for testing purposes
        :param pulumi.Input[_builtins.str] provisioner_version: Provisioner version for testing purposes
        :param pulumi.Input[_builtins.str] release_pipeline: Pipeline ID to create webhooks for releases
        :param pulumi.Input[_builtins.str] repository: For account connectors, the repository where the module is stored
        :param pulumi.Input[_builtins.str] repository_branch: Repository Branch in which the module should be accessed
        :param pulumi.Input[_builtins.str] repository_commit: Repository Commit in which the module should be accessed
        :param pulumi.Input[_builtins.str] repository_connector: Repository Connector is the reference to the connector for the repository
        :param pulumi.Input[_builtins.str] repository_path: Repository Path is the path in which the module resides
        :param pulumi.Input[_builtins.str] repository_url: URL where the module is stored
        :param pulumi.Input[_builtins.int] synced: Timestamp when the module was last synced
        :param pulumi.Input[_builtins.str] system: Provider of the module
        :param pulumi.Input[_builtins.str] tags: Tags associated with the module
        :param pulumi.Input[_builtins.bool] testing_enabled: Whether testing is enabled for the module
        :param pulumi.Input['InfraModuleTestingTestingMetadataArgs'] testing_metadata: Testing metadata for the module
        :param pulumi.Input[_builtins.int] updated: Timestamp when the module was last modified
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] versions: Versions of the module
        """
        if account is not None:
            pulumi.set(__self__, "account", account)
        if created is not None:
            pulumi.set(__self__, "created", created)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if git_tag_style is not None:
            pulumi.set(__self__, "git_tag_style", git_tag_style)
        if module_error is not None:
            pulumi.set(__self__, "module_error", module_error)
        if module_id is not None:
            pulumi.set(__self__, "module_id", module_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if org is not None:
            pulumi.set(__self__, "org", org)
        if pipelines is not None:
            pulumi.set(__self__, "pipelines", pipelines)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if provider_connector is not None:
            pulumi.set(__self__, "provider_connector", provider_connector)
        if provisioner_type is not None:
            pulumi.set(__self__, "provisioner_type", provisioner_type)
        if provisioner_version is not None:
            pulumi.set(__self__, "provisioner_version", provisioner_version)
        if release_pipeline is not None:
            pulumi.set(__self__, "release_pipeline", release_pipeline)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)
        if repository_branch is not None:
            pulumi.set(__self__, "repository_branch", repository_branch)
        if repository_commit is not None:
            pulumi.set(__self__, "repository_commit", repository_commit)
        if repository_connector is not None:
            pulumi.set(__self__, "repository_connector", repository_connector)
        if repository_path is not None:
            pulumi.set(__self__, "repository_path", repository_path)
        if repository_url is not None:
            pulumi.set(__self__, "repository_url", repository_url)
        if synced is not None:
            pulumi.set(__self__, "synced", synced)
        if system is not None:
            pulumi.set(__self__, "system", system)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if testing_enabled is not None:
            pulumi.set(__self__, "testing_enabled", testing_enabled)
        if testing_metadata is not None:
            pulumi.set(__self__, "testing_metadata", testing_metadata)
        if updated is not None:
            pulumi.set(__self__, "updated", updated)
        if versions is not None:
            pulumi.set(__self__, "versions", versions)

    @_builtins.property
    @pulumi.getter
    def account(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account that owns the module
        """
        return pulumi.get(self, "account")

    @account.setter
    def account(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account", value)

    @_builtins.property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Timestamp when the module was created
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "created", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the module
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="gitTagStyle")
    def git_tag_style(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Git Tag Style
        """
        return pulumi.get(self, "git_tag_style")

    @git_tag_style.setter
    def git_tag_style(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "git_tag_style", value)

    @_builtins.property
    @pulumi.getter(name="moduleError")
    def module_error(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Error while retrieving the module
        """
        return pulumi.get(self, "module_error")

    @module_error.setter
    def module_error(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "module_error", value)

    @_builtins.property
    @pulumi.getter(name="moduleId")
    def module_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identifier of the module to enable testing for
        """
        return pulumi.get(self, "module_id")

    @module_id.setter
    def module_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "module_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the module
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def org(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Organization identifier
        """
        return pulumi.get(self, "org")

    @org.setter
    def org(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "org", value)

    @_builtins.property
    @pulumi.getter
    def pipelines(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of pipeline IDs to create webhooks for triggering test executions
        """
        return pulumi.get(self, "pipelines")

    @pipelines.setter
    def pipelines(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pipelines", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Project identifier
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="providerConnector")
    def provider_connector(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provider connector for testing purposes
        """
        return pulumi.get(self, "provider_connector")

    @provider_connector.setter
    def provider_connector(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provider_connector", value)

    @_builtins.property
    @pulumi.getter(name="provisionerType")
    def provisioner_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "provisioner_type")

    @provisioner_type.setter
    def provisioner_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provisioner_type", value)

    @_builtins.property
    @pulumi.getter(name="provisionerVersion")
    def provisioner_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provisioner version for testing purposes
        """
        return pulumi.get(self, "provisioner_version")

    @provisioner_version.setter
    def provisioner_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "provisioner_version", value)

    @_builtins.property
    @pulumi.getter(name="releasePipeline")
    def release_pipeline(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Pipeline ID to create webhooks for releases
        """
        return pulumi.get(self, "release_pipeline")

    @release_pipeline.setter
    def release_pipeline(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "release_pipeline", value)

    @_builtins.property
    @pulumi.getter
    def repository(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        For account connectors, the repository where the module is stored
        """
        return pulumi.get(self, "repository")

    @repository.setter
    def repository(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository", value)

    @_builtins.property
    @pulumi.getter(name="repositoryBranch")
    def repository_branch(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Repository Branch in which the module should be accessed
        """
        return pulumi.get(self, "repository_branch")

    @repository_branch.setter
    def repository_branch(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository_branch", value)

    @_builtins.property
    @pulumi.getter(name="repositoryCommit")
    def repository_commit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Repository Commit in which the module should be accessed
        """
        return pulumi.get(self, "repository_commit")

    @repository_commit.setter
    def repository_commit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository_commit", value)

    @_builtins.property
    @pulumi.getter(name="repositoryConnector")
    def repository_connector(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Repository Connector is the reference to the connector for the repository
        """
        return pulumi.get(self, "repository_connector")

    @repository_connector.setter
    def repository_connector(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository_connector", value)

    @_builtins.property
    @pulumi.getter(name="repositoryPath")
    def repository_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Repository Path is the path in which the module resides
        """
        return pulumi.get(self, "repository_path")

    @repository_path.setter
    def repository_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository_path", value)

    @_builtins.property
    @pulumi.getter(name="repositoryUrl")
    def repository_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL where the module is stored
        """
        return pulumi.get(self, "repository_url")

    @repository_url.setter
    def repository_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "repository_url", value)

    @_builtins.property
    @pulumi.getter
    def synced(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Timestamp when the module was last synced
        """
        return pulumi.get(self, "synced")

    @synced.setter
    def synced(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "synced", value)

    @_builtins.property
    @pulumi.getter
    def system(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Provider of the module
        """
        return pulumi.get(self, "system")

    @system.setter
    def system(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Tags associated with the module
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="testingEnabled")
    def testing_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether testing is enabled for the module
        """
        return pulumi.get(self, "testing_enabled")

    @testing_enabled.setter
    def testing_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "testing_enabled", value)

    @_builtins.property
    @pulumi.getter(name="testingMetadata")
    def testing_metadata(self) -> Optional[pulumi.Input['InfraModuleTestingTestingMetadataArgs']]:
        """
        Testing metadata for the module
        """
        return pulumi.get(self, "testing_metadata")

    @testing_metadata.setter
    def testing_metadata(self, value: Optional[pulumi.Input['InfraModuleTestingTestingMetadataArgs']]):
        pulumi.set(self, "testing_metadata", value)

    @_builtins.property
    @pulumi.getter
    def updated(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Timestamp when the module was last modified
        """
        return pulumi.get(self, "updated")

    @updated.setter
    def updated(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "updated", value)

    @_builtins.property
    @pulumi.getter
    def versions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Versions of the module
        """
        return pulumi.get(self, "versions")

    @versions.setter
    def versions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "versions", value)


@pulumi.type_token("harness:platform/infraModuleTesting:InfraModuleTesting")
class InfraModuleTesting(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 module_id: Optional[pulumi.Input[_builtins.str]] = None,
                 org: Optional[pulumi.Input[_builtins.str]] = None,
                 pipelines: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_connector: Optional[pulumi.Input[_builtins.str]] = None,
                 provisioner_type: Optional[pulumi.Input[_builtins.str]] = None,
                 provisioner_version: Optional[pulumi.Input[_builtins.str]] = None,
                 release_pipeline: Optional[pulumi.Input[_builtins.str]] = None,
                 testing_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 testing_metadata: Optional[pulumi.Input[Union['InfraModuleTestingTestingMetadataArgs', 'InfraModuleTestingTestingMetadataArgsDict']]] = None,
                 updated: Optional[pulumi.Input[_builtins.int]] = None,
                 versions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import harness:platform/infraModuleTesting:InfraModuleTesting example <module_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] module_id: Identifier of the module to enable testing for
        :param pulumi.Input[_builtins.str] org: Organization identifier
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] pipelines: List of pipeline IDs to create webhooks for triggering test executions
        :param pulumi.Input[_builtins.str] project: Project identifier
        :param pulumi.Input[_builtins.str] provider_connector: Provider connector for testing purposes
        :param pulumi.Input[_builtins.str] provisioner_version: Provisioner version for testing purposes
        :param pulumi.Input[_builtins.str] release_pipeline: Pipeline ID to create webhooks for releases
        :param pulumi.Input[_builtins.bool] testing_enabled: Whether testing is enabled for the module
        :param pulumi.Input[Union['InfraModuleTestingTestingMetadataArgs', 'InfraModuleTestingTestingMetadataArgsDict']] testing_metadata: Testing metadata for the module
        :param pulumi.Input[_builtins.int] updated: Timestamp when the module was last modified
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] versions: Versions of the module
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InfraModuleTestingArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import harness:platform/infraModuleTesting:InfraModuleTesting example <module_id>
        ```

        :param str resource_name: The name of the resource.
        :param InfraModuleTestingArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InfraModuleTestingArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 module_id: Optional[pulumi.Input[_builtins.str]] = None,
                 org: Optional[pulumi.Input[_builtins.str]] = None,
                 pipelines: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 provider_connector: Optional[pulumi.Input[_builtins.str]] = None,
                 provisioner_type: Optional[pulumi.Input[_builtins.str]] = None,
                 provisioner_version: Optional[pulumi.Input[_builtins.str]] = None,
                 release_pipeline: Optional[pulumi.Input[_builtins.str]] = None,
                 testing_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 testing_metadata: Optional[pulumi.Input[Union['InfraModuleTestingTestingMetadataArgs', 'InfraModuleTestingTestingMetadataArgsDict']]] = None,
                 updated: Optional[pulumi.Input[_builtins.int]] = None,
                 versions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InfraModuleTestingArgs.__new__(InfraModuleTestingArgs)

            if module_id is None and not opts.urn:
                raise TypeError("Missing required property 'module_id'")
            __props__.__dict__["module_id"] = module_id
            if org is None and not opts.urn:
                raise TypeError("Missing required property 'org'")
            __props__.__dict__["org"] = org
            if pipelines is None and not opts.urn:
                raise TypeError("Missing required property 'pipelines'")
            __props__.__dict__["pipelines"] = pipelines
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            if provider_connector is None and not opts.urn:
                raise TypeError("Missing required property 'provider_connector'")
            __props__.__dict__["provider_connector"] = provider_connector
            if provisioner_type is None and not opts.urn:
                raise TypeError("Missing required property 'provisioner_type'")
            __props__.__dict__["provisioner_type"] = provisioner_type
            if provisioner_version is None and not opts.urn:
                raise TypeError("Missing required property 'provisioner_version'")
            __props__.__dict__["provisioner_version"] = provisioner_version
            __props__.__dict__["release_pipeline"] = release_pipeline
            __props__.__dict__["testing_enabled"] = testing_enabled
            __props__.__dict__["testing_metadata"] = testing_metadata
            __props__.__dict__["updated"] = updated
            __props__.__dict__["versions"] = versions
            __props__.__dict__["account"] = None
            __props__.__dict__["created"] = None
            __props__.__dict__["description"] = None
            __props__.__dict__["git_tag_style"] = None
            __props__.__dict__["module_error"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["repository"] = None
            __props__.__dict__["repository_branch"] = None
            __props__.__dict__["repository_commit"] = None
            __props__.__dict__["repository_connector"] = None
            __props__.__dict__["repository_path"] = None
            __props__.__dict__["repository_url"] = None
            __props__.__dict__["synced"] = None
            __props__.__dict__["system"] = None
            __props__.__dict__["tags"] = None
        super(InfraModuleTesting, __self__).__init__(
            'harness:platform/infraModuleTesting:InfraModuleTesting',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account: Optional[pulumi.Input[_builtins.str]] = None,
            created: Optional[pulumi.Input[_builtins.int]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            git_tag_style: Optional[pulumi.Input[_builtins.str]] = None,
            module_error: Optional[pulumi.Input[_builtins.str]] = None,
            module_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            org: Optional[pulumi.Input[_builtins.str]] = None,
            pipelines: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            provider_connector: Optional[pulumi.Input[_builtins.str]] = None,
            provisioner_type: Optional[pulumi.Input[_builtins.str]] = None,
            provisioner_version: Optional[pulumi.Input[_builtins.str]] = None,
            release_pipeline: Optional[pulumi.Input[_builtins.str]] = None,
            repository: Optional[pulumi.Input[_builtins.str]] = None,
            repository_branch: Optional[pulumi.Input[_builtins.str]] = None,
            repository_commit: Optional[pulumi.Input[_builtins.str]] = None,
            repository_connector: Optional[pulumi.Input[_builtins.str]] = None,
            repository_path: Optional[pulumi.Input[_builtins.str]] = None,
            repository_url: Optional[pulumi.Input[_builtins.str]] = None,
            synced: Optional[pulumi.Input[_builtins.int]] = None,
            system: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[_builtins.str]] = None,
            testing_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            testing_metadata: Optional[pulumi.Input[Union['InfraModuleTestingTestingMetadataArgs', 'InfraModuleTestingTestingMetadataArgsDict']]] = None,
            updated: Optional[pulumi.Input[_builtins.int]] = None,
            versions: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'InfraModuleTesting':
        """
        Get an existing InfraModuleTesting resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account: Account that owns the module
        :param pulumi.Input[_builtins.int] created: Timestamp when the module was created
        :param pulumi.Input[_builtins.str] description: Description of the module
        :param pulumi.Input[_builtins.str] git_tag_style: Git Tag Style
        :param pulumi.Input[_builtins.str] module_error: Error while retrieving the module
        :param pulumi.Input[_builtins.str] module_id: Identifier of the module to enable testing for
        :param pulumi.Input[_builtins.str] name: Name of the module
        :param pulumi.Input[_builtins.str] org: Organization identifier
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] pipelines: List of pipeline IDs to create webhooks for triggering test executions
        :param pulumi.Input[_builtins.str] project: Project identifier
        :param pulumi.Input[_builtins.str] provider_connector: Provider connector for testing purposes
        :param pulumi.Input[_builtins.str] provisioner_version: Provisioner version for testing purposes
        :param pulumi.Input[_builtins.str] release_pipeline: Pipeline ID to create webhooks for releases
        :param pulumi.Input[_builtins.str] repository: For account connectors, the repository where the module is stored
        :param pulumi.Input[_builtins.str] repository_branch: Repository Branch in which the module should be accessed
        :param pulumi.Input[_builtins.str] repository_commit: Repository Commit in which the module should be accessed
        :param pulumi.Input[_builtins.str] repository_connector: Repository Connector is the reference to the connector for the repository
        :param pulumi.Input[_builtins.str] repository_path: Repository Path is the path in which the module resides
        :param pulumi.Input[_builtins.str] repository_url: URL where the module is stored
        :param pulumi.Input[_builtins.int] synced: Timestamp when the module was last synced
        :param pulumi.Input[_builtins.str] system: Provider of the module
        :param pulumi.Input[_builtins.str] tags: Tags associated with the module
        :param pulumi.Input[_builtins.bool] testing_enabled: Whether testing is enabled for the module
        :param pulumi.Input[Union['InfraModuleTestingTestingMetadataArgs', 'InfraModuleTestingTestingMetadataArgsDict']] testing_metadata: Testing metadata for the module
        :param pulumi.Input[_builtins.int] updated: Timestamp when the module was last modified
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] versions: Versions of the module
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InfraModuleTestingState.__new__(_InfraModuleTestingState)

        __props__.__dict__["account"] = account
        __props__.__dict__["created"] = created
        __props__.__dict__["description"] = description
        __props__.__dict__["git_tag_style"] = git_tag_style
        __props__.__dict__["module_error"] = module_error
        __props__.__dict__["module_id"] = module_id
        __props__.__dict__["name"] = name
        __props__.__dict__["org"] = org
        __props__.__dict__["pipelines"] = pipelines
        __props__.__dict__["project"] = project
        __props__.__dict__["provider_connector"] = provider_connector
        __props__.__dict__["provisioner_type"] = provisioner_type
        __props__.__dict__["provisioner_version"] = provisioner_version
        __props__.__dict__["release_pipeline"] = release_pipeline
        __props__.__dict__["repository"] = repository
        __props__.__dict__["repository_branch"] = repository_branch
        __props__.__dict__["repository_commit"] = repository_commit
        __props__.__dict__["repository_connector"] = repository_connector
        __props__.__dict__["repository_path"] = repository_path
        __props__.__dict__["repository_url"] = repository_url
        __props__.__dict__["synced"] = synced
        __props__.__dict__["system"] = system
        __props__.__dict__["tags"] = tags
        __props__.__dict__["testing_enabled"] = testing_enabled
        __props__.__dict__["testing_metadata"] = testing_metadata
        __props__.__dict__["updated"] = updated
        __props__.__dict__["versions"] = versions
        return InfraModuleTesting(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def account(self) -> pulumi.Output[_builtins.str]:
        """
        Account that owns the module
        """
        return pulumi.get(self, "account")

    @_builtins.property
    @pulumi.getter
    def created(self) -> pulumi.Output[_builtins.int]:
        """
        Timestamp when the module was created
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Description of the module
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="gitTagStyle")
    def git_tag_style(self) -> pulumi.Output[_builtins.str]:
        """
        Git Tag Style
        """
        return pulumi.get(self, "git_tag_style")

    @_builtins.property
    @pulumi.getter(name="moduleError")
    def module_error(self) -> pulumi.Output[_builtins.str]:
        """
        Error while retrieving the module
        """
        return pulumi.get(self, "module_error")

    @_builtins.property
    @pulumi.getter(name="moduleId")
    def module_id(self) -> pulumi.Output[_builtins.str]:
        """
        Identifier of the module to enable testing for
        """
        return pulumi.get(self, "module_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the module
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def org(self) -> pulumi.Output[_builtins.str]:
        """
        Organization identifier
        """
        return pulumi.get(self, "org")

    @_builtins.property
    @pulumi.getter
    def pipelines(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of pipeline IDs to create webhooks for triggering test executions
        """
        return pulumi.get(self, "pipelines")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        Project identifier
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="providerConnector")
    def provider_connector(self) -> pulumi.Output[_builtins.str]:
        """
        Provider connector for testing purposes
        """
        return pulumi.get(self, "provider_connector")

    @_builtins.property
    @pulumi.getter(name="provisionerType")
    def provisioner_type(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "provisioner_type")

    @_builtins.property
    @pulumi.getter(name="provisionerVersion")
    def provisioner_version(self) -> pulumi.Output[_builtins.str]:
        """
        Provisioner version for testing purposes
        """
        return pulumi.get(self, "provisioner_version")

    @_builtins.property
    @pulumi.getter(name="releasePipeline")
    def release_pipeline(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Pipeline ID to create webhooks for releases
        """
        return pulumi.get(self, "release_pipeline")

    @_builtins.property
    @pulumi.getter
    def repository(self) -> pulumi.Output[_builtins.str]:
        """
        For account connectors, the repository where the module is stored
        """
        return pulumi.get(self, "repository")

    @_builtins.property
    @pulumi.getter(name="repositoryBranch")
    def repository_branch(self) -> pulumi.Output[_builtins.str]:
        """
        Repository Branch in which the module should be accessed
        """
        return pulumi.get(self, "repository_branch")

    @_builtins.property
    @pulumi.getter(name="repositoryCommit")
    def repository_commit(self) -> pulumi.Output[_builtins.str]:
        """
        Repository Commit in which the module should be accessed
        """
        return pulumi.get(self, "repository_commit")

    @_builtins.property
    @pulumi.getter(name="repositoryConnector")
    def repository_connector(self) -> pulumi.Output[_builtins.str]:
        """
        Repository Connector is the reference to the connector for the repository
        """
        return pulumi.get(self, "repository_connector")

    @_builtins.property
    @pulumi.getter(name="repositoryPath")
    def repository_path(self) -> pulumi.Output[_builtins.str]:
        """
        Repository Path is the path in which the module resides
        """
        return pulumi.get(self, "repository_path")

    @_builtins.property
    @pulumi.getter(name="repositoryUrl")
    def repository_url(self) -> pulumi.Output[_builtins.str]:
        """
        URL where the module is stored
        """
        return pulumi.get(self, "repository_url")

    @_builtins.property
    @pulumi.getter
    def synced(self) -> pulumi.Output[_builtins.int]:
        """
        Timestamp when the module was last synced
        """
        return pulumi.get(self, "synced")

    @_builtins.property
    @pulumi.getter
    def system(self) -> pulumi.Output[_builtins.str]:
        """
        Provider of the module
        """
        return pulumi.get(self, "system")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[_builtins.str]:
        """
        Tags associated with the module
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="testingEnabled")
    def testing_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether testing is enabled for the module
        """
        return pulumi.get(self, "testing_enabled")

    @_builtins.property
    @pulumi.getter(name="testingMetadata")
    def testing_metadata(self) -> pulumi.Output['outputs.InfraModuleTestingTestingMetadata']:
        """
        Testing metadata for the module
        """
        return pulumi.get(self, "testing_metadata")

    @_builtins.property
    @pulumi.getter
    def updated(self) -> pulumi.Output[_builtins.int]:
        """
        Timestamp when the module was last modified
        """
        return pulumi.get(self, "updated")

    @_builtins.property
    @pulumi.getter
    def versions(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Versions of the module
        """
        return pulumi.get(self, "versions")

