# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['UserArgs', 'User']

@pulumi.input_type
class UserArgs:
    def __init__(__self__, *,
                 email: pulumi.Input[_builtins.str],
                 group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a User resource.
        :param pulumi.Input[_builtins.str] email: The email of the user.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] group_ids: The groups the user belongs to. This is only used during the creation of the user. The groups are not updated after the user is created. When using this option you should also set `lifecycle = { ignore_changes = ["group_ids"] }`.
        :param pulumi.Input[_builtins.str] name: The name of the user.
        """
        pulumi.set(__self__, "email", email)
        if group_ids is not None:
            pulumi.set(__self__, "group_ids", group_ids)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Input[_builtins.str]:
        """
        The email of the user.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter(name="groupIds")
    def group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The groups the user belongs to. This is only used during the creation of the user. The groups are not updated after the user is created. When using this option you should also set `lifecycle = { ignore_changes = ["group_ids"] }`.
        """
        return pulumi.get(self, "group_ids")

    @group_ids.setter
    def group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "group_ids", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the user.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _UserState:
    def __init__(__self__, *,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 is_email_verified: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_imported_from_identity_provider: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_password_expired: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_two_factor_auth_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_user_locked: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering User resources.
        :param pulumi.Input[_builtins.str] email: The email of the user.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] group_ids: The groups the user belongs to. This is only used during the creation of the user. The groups are not updated after the user is created. When using this option you should also set `lifecycle = { ignore_changes = ["group_ids"] }`.
        :param pulumi.Input[_builtins.bool] is_email_verified: Flag indicating whether or not the users email has been verified.
        :param pulumi.Input[_builtins.bool] is_imported_from_identity_provider: Flag indicating whether or not the user was imported from an identity provider.
        :param pulumi.Input[_builtins.bool] is_password_expired: Flag indicating whether or not the users password has expired.
        :param pulumi.Input[_builtins.bool] is_two_factor_auth_enabled: Flag indicating whether or not two-factor authentication is enabled for the user.
        :param pulumi.Input[_builtins.bool] is_user_locked: Flag indicating whether or not the user is locked out.
        :param pulumi.Input[_builtins.str] name: The name of the user.
        """
        if email is not None:
            pulumi.set(__self__, "email", email)
        if group_ids is not None:
            pulumi.set(__self__, "group_ids", group_ids)
        if is_email_verified is not None:
            pulumi.set(__self__, "is_email_verified", is_email_verified)
        if is_imported_from_identity_provider is not None:
            pulumi.set(__self__, "is_imported_from_identity_provider", is_imported_from_identity_provider)
        if is_password_expired is not None:
            pulumi.set(__self__, "is_password_expired", is_password_expired)
        if is_two_factor_auth_enabled is not None:
            pulumi.set(__self__, "is_two_factor_auth_enabled", is_two_factor_auth_enabled)
        if is_user_locked is not None:
            pulumi.set(__self__, "is_user_locked", is_user_locked)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The email of the user.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter(name="groupIds")
    def group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The groups the user belongs to. This is only used during the creation of the user. The groups are not updated after the user is created. When using this option you should also set `lifecycle = { ignore_changes = ["group_ids"] }`.
        """
        return pulumi.get(self, "group_ids")

    @group_ids.setter
    def group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "group_ids", value)

    @_builtins.property
    @pulumi.getter(name="isEmailVerified")
    def is_email_verified(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag indicating whether or not the users email has been verified.
        """
        return pulumi.get(self, "is_email_verified")

    @is_email_verified.setter
    def is_email_verified(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_email_verified", value)

    @_builtins.property
    @pulumi.getter(name="isImportedFromIdentityProvider")
    def is_imported_from_identity_provider(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag indicating whether or not the user was imported from an identity provider.
        """
        return pulumi.get(self, "is_imported_from_identity_provider")

    @is_imported_from_identity_provider.setter
    def is_imported_from_identity_provider(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_imported_from_identity_provider", value)

    @_builtins.property
    @pulumi.getter(name="isPasswordExpired")
    def is_password_expired(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag indicating whether or not the users password has expired.
        """
        return pulumi.get(self, "is_password_expired")

    @is_password_expired.setter
    def is_password_expired(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_password_expired", value)

    @_builtins.property
    @pulumi.getter(name="isTwoFactorAuthEnabled")
    def is_two_factor_auth_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag indicating whether or not two-factor authentication is enabled for the user.
        """
        return pulumi.get(self, "is_two_factor_auth_enabled")

    @is_two_factor_auth_enabled.setter
    def is_two_factor_auth_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_two_factor_auth_enabled", value)

    @_builtins.property
    @pulumi.getter(name="isUserLocked")
    def is_user_locked(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag indicating whether or not the user is locked out.
        """
        return pulumi.get(self, "is_user_locked")

    @is_user_locked.setter
    def is_user_locked(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_user_locked", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the user.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("harness:index/user:User")
class User(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Resource for creating a Harness user

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        john_doe = harness.User("john_doe",
            name="John Doe",
            email="john.doe@example.com")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Import using the email address of the user

        ```sh
        $ pulumi import harness:index/user:User john_doe john.doe@example.com
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] email: The email of the user.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] group_ids: The groups the user belongs to. This is only used during the creation of the user. The groups are not updated after the user is created. When using this option you should also set `lifecycle = { ignore_changes = ["group_ids"] }`.
        :param pulumi.Input[_builtins.str] name: The name of the user.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: UserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource for creating a Harness user

        ## Example Usage

        ```python
        import pulumi
        import pulumi_harness as harness

        john_doe = harness.User("john_doe",
            name="John Doe",
            email="john.doe@example.com")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Import using the email address of the user

        ```sh
        $ pulumi import harness:index/user:User john_doe john.doe@example.com
        ```

        :param str resource_name: The name of the resource.
        :param UserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(UserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = UserArgs.__new__(UserArgs)

            if email is None and not opts.urn:
                raise TypeError("Missing required property 'email'")
            __props__.__dict__["email"] = email
            __props__.__dict__["group_ids"] = group_ids
            __props__.__dict__["name"] = name
            __props__.__dict__["is_email_verified"] = None
            __props__.__dict__["is_imported_from_identity_provider"] = None
            __props__.__dict__["is_password_expired"] = None
            __props__.__dict__["is_two_factor_auth_enabled"] = None
            __props__.__dict__["is_user_locked"] = None
        super(User, __self__).__init__(
            'harness:index/user:User',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            email: Optional[pulumi.Input[_builtins.str]] = None,
            group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            is_email_verified: Optional[pulumi.Input[_builtins.bool]] = None,
            is_imported_from_identity_provider: Optional[pulumi.Input[_builtins.bool]] = None,
            is_password_expired: Optional[pulumi.Input[_builtins.bool]] = None,
            is_two_factor_auth_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            is_user_locked: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None) -> 'User':
        """
        Get an existing User resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] email: The email of the user.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] group_ids: The groups the user belongs to. This is only used during the creation of the user. The groups are not updated after the user is created. When using this option you should also set `lifecycle = { ignore_changes = ["group_ids"] }`.
        :param pulumi.Input[_builtins.bool] is_email_verified: Flag indicating whether or not the users email has been verified.
        :param pulumi.Input[_builtins.bool] is_imported_from_identity_provider: Flag indicating whether or not the user was imported from an identity provider.
        :param pulumi.Input[_builtins.bool] is_password_expired: Flag indicating whether or not the users password has expired.
        :param pulumi.Input[_builtins.bool] is_two_factor_auth_enabled: Flag indicating whether or not two-factor authentication is enabled for the user.
        :param pulumi.Input[_builtins.bool] is_user_locked: Flag indicating whether or not the user is locked out.
        :param pulumi.Input[_builtins.str] name: The name of the user.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _UserState.__new__(_UserState)

        __props__.__dict__["email"] = email
        __props__.__dict__["group_ids"] = group_ids
        __props__.__dict__["is_email_verified"] = is_email_verified
        __props__.__dict__["is_imported_from_identity_provider"] = is_imported_from_identity_provider
        __props__.__dict__["is_password_expired"] = is_password_expired
        __props__.__dict__["is_two_factor_auth_enabled"] = is_two_factor_auth_enabled
        __props__.__dict__["is_user_locked"] = is_user_locked
        __props__.__dict__["name"] = name
        return User(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Output[_builtins.str]:
        """
        The email of the user.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter(name="groupIds")
    def group_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The groups the user belongs to. This is only used during the creation of the user. The groups are not updated after the user is created. When using this option you should also set `lifecycle = { ignore_changes = ["group_ids"] }`.
        """
        return pulumi.get(self, "group_ids")

    @_builtins.property
    @pulumi.getter(name="isEmailVerified")
    def is_email_verified(self) -> pulumi.Output[_builtins.bool]:
        """
        Flag indicating whether or not the users email has been verified.
        """
        return pulumi.get(self, "is_email_verified")

    @_builtins.property
    @pulumi.getter(name="isImportedFromIdentityProvider")
    def is_imported_from_identity_provider(self) -> pulumi.Output[_builtins.bool]:
        """
        Flag indicating whether or not the user was imported from an identity provider.
        """
        return pulumi.get(self, "is_imported_from_identity_provider")

    @_builtins.property
    @pulumi.getter(name="isPasswordExpired")
    def is_password_expired(self) -> pulumi.Output[_builtins.bool]:
        """
        Flag indicating whether or not the users password has expired.
        """
        return pulumi.get(self, "is_password_expired")

    @_builtins.property
    @pulumi.getter(name="isTwoFactorAuthEnabled")
    def is_two_factor_auth_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Flag indicating whether or not two-factor authentication is enabled for the user.
        """
        return pulumi.get(self, "is_two_factor_auth_enabled")

    @_builtins.property
    @pulumi.getter(name="isUserLocked")
    def is_user_locked(self) -> pulumi.Output[_builtins.bool]:
        """
        Flag indicating whether or not the user is locked out.
        """
        return pulumi.get(self, "is_user_locked")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the user.
        """
        return pulumi.get(self, "name")

