# coding: utf-8

"""
    FINBOURNE Access Management API

    FINBOURNE Technology  # noqa: E501

    The version of the OpenAPI document: 0.0.3868
    Contact: info@finbourne.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from finbourne_access.api_client import ApiClient
from finbourne_access.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from finbourne_access.models.add_policy_collection_to_role_request import AddPolicyCollectionToRoleRequest
from finbourne_access.models.lusid_problem_details import LusidProblemDetails
from finbourne_access.models.lusid_validation_problem_details import LusidValidationProblemDetails
from finbourne_access.models.role_creation_request import RoleCreationRequest
from finbourne_access.models.role_response import RoleResponse
from finbourne_access.models.role_update_request import RoleUpdateRequest


class RolesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_policy_collection_to_role(self, scope, code, add_policy_collection_to_role_request, **kwargs):  # noqa: E501
        """AddPolicyCollectionToRole: Add policy collections to a role  # noqa: E501

        Assigns policy collections to a role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_policy_collection_to_role(scope, code, add_policy_collection_to_role_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Role (required)
        :type scope: str
        :param code: The code of the Role (required)
        :type code: str
        :param add_policy_collection_to_role_request: The policy collections to add (required)
        :type add_policy_collection_to_role_request: AddPolicyCollectionToRoleRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RoleResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.add_policy_collection_to_role_with_http_info(scope, code, add_policy_collection_to_role_request, **kwargs)  # noqa: E501

    def add_policy_collection_to_role_with_http_info(self, scope, code, add_policy_collection_to_role_request, **kwargs):  # noqa: E501
        """AddPolicyCollectionToRole: Add policy collections to a role  # noqa: E501

        Assigns policy collections to a role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_policy_collection_to_role_with_http_info(scope, code, add_policy_collection_to_role_request, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Role (required)
        :type scope: str
        :param code: The code of the Role (required)
        :type code: str
        :param add_policy_collection_to_role_request: The policy collections to add (required)
        :type add_policy_collection_to_role_request: AddPolicyCollectionToRoleRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (RoleResponse, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'scope',
            'code',
            'add_policy_collection_to_role_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_policy_collection_to_role" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'scope' is set
        if self.api_client.client_side_validation and ('scope' not in local_var_params or  # noqa: E501
                                                        local_var_params['scope'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `scope` when calling `add_policy_collection_to_role`")  # noqa: E501
        # verify the required parameter 'code' is set
        if self.api_client.client_side_validation and ('code' not in local_var_params or  # noqa: E501
                                                        local_var_params['code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `code` when calling `add_policy_collection_to_role`")  # noqa: E501
        # verify the required parameter 'add_policy_collection_to_role_request' is set
        if self.api_client.client_side_validation and ('add_policy_collection_to_role_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['add_policy_collection_to_role_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `add_policy_collection_to_role_request` when calling `add_policy_collection_to_role`")  # noqa: E501

        if self.api_client.client_side_validation and 'scope' in local_var_params and not re.search(r'^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$', local_var_params['scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `add_policy_collection_to_role`, must conform to the pattern `/^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'code' in local_var_params and not re.search(r'^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$', local_var_params['code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `add_policy_collection_to_role`, must conform to the pattern `/^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'scope' in local_var_params:
            path_params['scope'] = local_var_params['scope']  # noqa: E501
        if 'code' in local_var_params:
            path_params['code'] = local_var_params['code']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'add_policy_collection_to_role_request' in local_var_params:
            body_params = local_var_params['add_policy_collection_to_role_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.0.3868'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "RoleResponse",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/roles/{scope}/{code}/policycollections', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def create_role(self, role_creation_request, **kwargs):  # noqa: E501
        """CreateRole: Create Role  # noqa: E501

        Creates a Role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_role(role_creation_request, async_req=True)
        >>> result = thread.get()

        :param role_creation_request: The definition of the Role (required)
        :type role_creation_request: RoleCreationRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RoleResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.create_role_with_http_info(role_creation_request, **kwargs)  # noqa: E501

    def create_role_with_http_info(self, role_creation_request, **kwargs):  # noqa: E501
        """CreateRole: Create Role  # noqa: E501

        Creates a Role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_role_with_http_info(role_creation_request, async_req=True)
        >>> result = thread.get()

        :param role_creation_request: The definition of the Role (required)
        :type role_creation_request: RoleCreationRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (RoleResponse, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'role_creation_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_role" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'role_creation_request' is set
        if self.api_client.client_side_validation and ('role_creation_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['role_creation_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `role_creation_request` when calling `create_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'role_creation_request' in local_var_params:
            body_params = local_var_params['role_creation_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.0.3868'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            201: "RoleResponse",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/roles', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_role(self, code, **kwargs):  # noqa: E501
        """DeleteRole: Delete Role  # noqa: E501

        Deletes an identified Role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_role(code, async_req=True)
        >>> result = thread.get()

        :param code: The code of the Role (required)
        :type code: str
        :param scope: >Optional. Will use default scope if not supplied. The scope of the Role
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_role_with_http_info(code, **kwargs)  # noqa: E501

    def delete_role_with_http_info(self, code, **kwargs):  # noqa: E501
        """DeleteRole: Delete Role  # noqa: E501

        Deletes an identified Role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_role_with_http_info(code, async_req=True)
        >>> result = thread.get()

        :param code: The code of the Role (required)
        :type code: str
        :param scope: >Optional. Will use default scope if not supplied. The scope of the Role
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'code',
            'scope'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_role" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'code' is set
        if self.api_client.client_side_validation and ('code' not in local_var_params or  # noqa: E501
                                                        local_var_params['code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `code` when calling `delete_role`")  # noqa: E501

        if self.api_client.client_side_validation and 'code' in local_var_params and not re.search(r'^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$', local_var_params['code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `delete_role`, must conform to the pattern `/^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'scope' in local_var_params and not re.search(r'^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$', local_var_params['scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `delete_role`, must conform to the pattern `/^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'code' in local_var_params:
            path_params['code'] = local_var_params['code']  # noqa: E501

        query_params = []
        if 'scope' in local_var_params and local_var_params['scope'] is not None:  # noqa: E501
            query_params.append(('scope', local_var_params['scope']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.0.3868'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/api/roles/{code}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_role(self, code, **kwargs):  # noqa: E501
        """GetRole: Get Role  # noqa: E501

        Gets an identified Role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_role(code, async_req=True)
        >>> result = thread.get()

        :param code: The code of the Role (required)
        :type code: str
        :param as_at: Optional. The AsAt date time of the data
        :type as_at: datetime
        :param scope: Optional. Will use default scope if not supplied. The scope of the Role
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RoleResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.get_role_with_http_info(code, **kwargs)  # noqa: E501

    def get_role_with_http_info(self, code, **kwargs):  # noqa: E501
        """GetRole: Get Role  # noqa: E501

        Gets an identified Role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_role_with_http_info(code, async_req=True)
        >>> result = thread.get()

        :param code: The code of the Role (required)
        :type code: str
        :param as_at: Optional. The AsAt date time of the data
        :type as_at: datetime
        :param scope: Optional. Will use default scope if not supplied. The scope of the Role
        :type scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (RoleResponse, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'code',
            'as_at',
            'scope'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_role" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'code' is set
        if self.api_client.client_side_validation and ('code' not in local_var_params or  # noqa: E501
                                                        local_var_params['code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `code` when calling `get_role`")  # noqa: E501

        if self.api_client.client_side_validation and 'code' in local_var_params and not re.search(r'^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$', local_var_params['code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `get_role`, must conform to the pattern `/^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'scope' in local_var_params and not re.search(r'^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$', local_var_params['scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `get_role`, must conform to the pattern `/^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'code' in local_var_params:
            path_params['code'] = local_var_params['code']  # noqa: E501

        query_params = []
        if 'as_at' in local_var_params and local_var_params['as_at'] is not None:  # noqa: E501
            query_params.append(('asAt', local_var_params['as_at']))  # noqa: E501
        if 'scope' in local_var_params and local_var_params['scope'] is not None:  # noqa: E501
            query_params.append(('scope', local_var_params['scope']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.0.3868'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "RoleResponse",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/roles/{code}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def list_roles(self, **kwargs):  # noqa: E501
        """ListRoles: List Roles  # noqa: E501

        Gets all Roles in a scope  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_roles(async_req=True)
        >>> result = thread.get()

        :param scope: Optional. Will use all scopes if not supplied. The requested scope
        :type scope: str
        :param as_at: Optional. The AsAt date time of the data
        :type as_at: datetime
        :param sort_by: Optional. Order the results by these fields. Use use the '-' sign to denote descending order e.g. -MyFieldName
        :type sort_by: list[str]
        :param start: Optional. When paginating, skip this number of results
        :type start: int
        :param limit: Optional. When paginating, limit the number of returned results to this many.
        :type limit: int
        :param filter: Optional. Expression to filter the result set
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[RoleResponse]
        """
        kwargs['_return_http_data_only'] = True
        return self.list_roles_with_http_info(**kwargs)  # noqa: E501

    def list_roles_with_http_info(self, **kwargs):  # noqa: E501
        """ListRoles: List Roles  # noqa: E501

        Gets all Roles in a scope  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_roles_with_http_info(async_req=True)
        >>> result = thread.get()

        :param scope: Optional. Will use all scopes if not supplied. The requested scope
        :type scope: str
        :param as_at: Optional. The AsAt date time of the data
        :type as_at: datetime
        :param sort_by: Optional. Order the results by these fields. Use use the '-' sign to denote descending order e.g. -MyFieldName
        :type sort_by: list[str]
        :param start: Optional. When paginating, skip this number of results
        :type start: int
        :param limit: Optional. When paginating, limit the number of returned results to this many.
        :type limit: int
        :param filter: Optional. Expression to filter the result set
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (list[RoleResponse], int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'scope',
            'as_at',
            'sort_by',
            'start',
            'limit',
            'filter'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_roles" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'scope' in local_var_params and not re.search(r'^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$', local_var_params['scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `list_roles`, must conform to the pattern `/^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('filter' in local_var_params and  # noqa: E501
                                                        len(local_var_params['filter']) > 16384):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `list_roles`, length must be less than or equal to `16384`")  # noqa: E501
        if self.api_client.client_side_validation and ('filter' in local_var_params and  # noqa: E501
                                                        len(local_var_params['filter']) < 0):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `list_roles`, length must be greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'filter' in local_var_params and not re.search(r'^[\s\S]*$', local_var_params['filter']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `list_roles`, must conform to the pattern `/^[\s\S]*$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'scope' in local_var_params and local_var_params['scope'] is not None:  # noqa: E501
            query_params.append(('scope', local_var_params['scope']))  # noqa: E501
        if 'as_at' in local_var_params and local_var_params['as_at'] is not None:  # noqa: E501
            query_params.append(('asAt', local_var_params['as_at']))  # noqa: E501
        if 'sort_by' in local_var_params and local_var_params['sort_by'] is not None:  # noqa: E501
            query_params.append(('sortBy', local_var_params['sort_by']))  # noqa: E501
            collection_formats['sortBy'] = 'multi'  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'filter' in local_var_params and local_var_params['filter'] is not None:  # noqa: E501
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.0.3868'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "list[RoleResponse]",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/roles', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def remove_policy_collection_from_role(self, scope, code, policycollectionscope, policycollectioncode, **kwargs):  # noqa: E501
        """RemovePolicyCollectionFromRole: Remove policy collection from role  # noqa: E501

        Removes a policy collection from a role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_policy_collection_from_role(scope, code, policycollectionscope, policycollectioncode, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Role (required)
        :type scope: str
        :param code: The code of the Role (required)
        :type code: str
        :param policycollectionscope: The scope of policy collection to remove from the Role (required)
        :type policycollectionscope: str
        :param policycollectioncode: The code of the policy collection to remove from the Role (required)
        :type policycollectioncode: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RoleResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.remove_policy_collection_from_role_with_http_info(scope, code, policycollectionscope, policycollectioncode, **kwargs)  # noqa: E501

    def remove_policy_collection_from_role_with_http_info(self, scope, code, policycollectionscope, policycollectioncode, **kwargs):  # noqa: E501
        """RemovePolicyCollectionFromRole: Remove policy collection from role  # noqa: E501

        Removes a policy collection from a role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_policy_collection_from_role_with_http_info(scope, code, policycollectionscope, policycollectioncode, async_req=True)
        >>> result = thread.get()

        :param scope: The scope of the Role (required)
        :type scope: str
        :param code: The code of the Role (required)
        :type code: str
        :param policycollectionscope: The scope of policy collection to remove from the Role (required)
        :type policycollectionscope: str
        :param policycollectioncode: The code of the policy collection to remove from the Role (required)
        :type policycollectioncode: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (RoleResponse, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'scope',
            'code',
            'policycollectionscope',
            'policycollectioncode'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_policy_collection_from_role" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'scope' is set
        if self.api_client.client_side_validation and ('scope' not in local_var_params or  # noqa: E501
                                                        local_var_params['scope'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `scope` when calling `remove_policy_collection_from_role`")  # noqa: E501
        # verify the required parameter 'code' is set
        if self.api_client.client_side_validation and ('code' not in local_var_params or  # noqa: E501
                                                        local_var_params['code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `code` when calling `remove_policy_collection_from_role`")  # noqa: E501
        # verify the required parameter 'policycollectionscope' is set
        if self.api_client.client_side_validation and ('policycollectionscope' not in local_var_params or  # noqa: E501
                                                        local_var_params['policycollectionscope'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `policycollectionscope` when calling `remove_policy_collection_from_role`")  # noqa: E501
        # verify the required parameter 'policycollectioncode' is set
        if self.api_client.client_side_validation and ('policycollectioncode' not in local_var_params or  # noqa: E501
                                                        local_var_params['policycollectioncode'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `policycollectioncode` when calling `remove_policy_collection_from_role`")  # noqa: E501

        if self.api_client.client_side_validation and 'scope' in local_var_params and not re.search(r'^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$', local_var_params['scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `remove_policy_collection_from_role`, must conform to the pattern `/^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'code' in local_var_params and not re.search(r'^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$', local_var_params['code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `remove_policy_collection_from_role`, must conform to the pattern `/^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'policycollectionscope' in local_var_params and not re.search(r'^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$', local_var_params['policycollectionscope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `policycollectionscope` when calling `remove_policy_collection_from_role`, must conform to the pattern `/^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'policycollectioncode' in local_var_params and not re.search(r'^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$', local_var_params['policycollectioncode']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `policycollectioncode` when calling `remove_policy_collection_from_role`, must conform to the pattern `/^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'scope' in local_var_params:
            path_params['scope'] = local_var_params['scope']  # noqa: E501
        if 'code' in local_var_params:
            path_params['code'] = local_var_params['code']  # noqa: E501
        if 'policycollectionscope' in local_var_params:
            path_params['policycollectionscope'] = local_var_params['policycollectionscope']  # noqa: E501
        if 'policycollectioncode' in local_var_params:
            path_params['policycollectioncode'] = local_var_params['policycollectioncode']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.0.3868'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "RoleResponse",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/roles/{scope}/{code}/policycollections/{policycollectionscope}/{policycollectioncode}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def update_role(self, code, role_update_request, **kwargs):  # noqa: E501
        """UpdateRole: Update Role  # noqa: E501

        Updates a Role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_role(code, role_update_request, async_req=True)
        >>> result = thread.get()

        :param code: The code of the Role (required)
        :type code: str
        :param role_update_request: The updated definition of the Role (required)
        :type role_update_request: RoleUpdateRequest
        :param scope: >Optional. Will use default scope if not supplied. The scope of the Role
        :type scope: str
        :param before_scope: Optional. The scope of the Role. Will use default scope if not supplied.
        :type before_scope: str
        :param before_code: Optional. The code of the Role
        :type before_code: str
        :param after_scope: Optional. The scope of the Role. Will use default scope if not supplied.
        :type after_scope: str
        :param after_code: Optional. The code of the Role
        :type after_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RoleResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.update_role_with_http_info(code, role_update_request, **kwargs)  # noqa: E501

    def update_role_with_http_info(self, code, role_update_request, **kwargs):  # noqa: E501
        """UpdateRole: Update Role  # noqa: E501

        Updates a Role  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_role_with_http_info(code, role_update_request, async_req=True)
        >>> result = thread.get()

        :param code: The code of the Role (required)
        :type code: str
        :param role_update_request: The updated definition of the Role (required)
        :type role_update_request: RoleUpdateRequest
        :param scope: >Optional. Will use default scope if not supplied. The scope of the Role
        :type scope: str
        :param before_scope: Optional. The scope of the Role. Will use default scope if not supplied.
        :type before_scope: str
        :param before_code: Optional. The code of the Role
        :type before_code: str
        :param after_scope: Optional. The scope of the Role. Will use default scope if not supplied.
        :type after_scope: str
        :param after_code: Optional. The code of the Role
        :type after_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (RoleResponse, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'code',
            'role_update_request',
            'scope',
            'before_scope',
            'before_code',
            'after_scope',
            'after_code'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_role" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'code' is set
        if self.api_client.client_side_validation and ('code' not in local_var_params or  # noqa: E501
                                                        local_var_params['code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `code` when calling `update_role`")  # noqa: E501
        # verify the required parameter 'role_update_request' is set
        if self.api_client.client_side_validation and ('role_update_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['role_update_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `role_update_request` when calling `update_role`")  # noqa: E501

        if self.api_client.client_side_validation and 'code' in local_var_params and not re.search(r'^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$', local_var_params['code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `update_role`, must conform to the pattern `/^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'scope' in local_var_params and not re.search(r'^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$', local_var_params['scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `update_role`, must conform to the pattern `/^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'before_scope' in local_var_params and not re.search(r'^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$', local_var_params['before_scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `before_scope` when calling `update_role`, must conform to the pattern `/^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'before_code' in local_var_params and not re.search(r'^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$', local_var_params['before_code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `before_code` when calling `update_role`, must conform to the pattern `/^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'after_scope' in local_var_params and not re.search(r'^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$', local_var_params['after_scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `after_scope` when calling `update_role`, must conform to the pattern `/^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'after_code' in local_var_params and not re.search(r'^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$', local_var_params['after_code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `after_code` when calling `update_role`, must conform to the pattern `/^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'code' in local_var_params:
            path_params['code'] = local_var_params['code']  # noqa: E501

        query_params = []
        if 'scope' in local_var_params and local_var_params['scope'] is not None:  # noqa: E501
            query_params.append(('scope', local_var_params['scope']))  # noqa: E501
        if 'before_scope' in local_var_params and local_var_params['before_scope'] is not None:  # noqa: E501
            query_params.append(('beforeScope', local_var_params['before_scope']))  # noqa: E501
        if 'before_code' in local_var_params and local_var_params['before_code'] is not None:  # noqa: E501
            query_params.append(('beforeCode', local_var_params['before_code']))  # noqa: E501
        if 'after_scope' in local_var_params and local_var_params['after_scope'] is not None:  # noqa: E501
            query_params.append(('afterScope', local_var_params['after_scope']))  # noqa: E501
        if 'after_code' in local_var_params and local_var_params['after_code'] is not None:  # noqa: E501
            query_params.append(('afterCode', local_var_params['after_code']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'role_update_request' in local_var_params:
            body_params = local_var_params['role_update_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.0.3868'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "RoleResponse",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/roles/{code}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
