# coding: utf-8

"""
    FINBOURNE Access Management API

    FINBOURNE Technology  # noqa: E501

    The version of the OpenAPI document: 0.0.3868
    Contact: info@finbourne.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from finbourne_access.api_client import ApiClient
from finbourne_access.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from finbourne_access.models.add_policy_collection_to_role_request import AddPolicyCollectionToRoleRequest
from finbourne_access.models.add_policy_to_role_request import AddPolicyToRoleRequest
from finbourne_access.models.lusid_problem_details import LusidProblemDetails
from finbourne_access.models.lusid_validation_problem_details import LusidValidationProblemDetails
from finbourne_access.models.resource_list_of_user_role_response import ResourceListOfUserRoleResponse
from finbourne_access.models.user_role_creation_request import UserRoleCreationRequest
from finbourne_access.models.user_role_response import UserRoleResponse
from finbourne_access.models.user_role_update_request import UserRoleUpdateRequest


class UserRolesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_policy_collection_to_user_role(self, userid, add_policy_collection_to_role_request, **kwargs):  # noqa: E501
        """AddPolicyCollectionToUserRole: Add a policy collection to a user-role  # noqa: E501

        Adds a policy collection to a user-role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_policy_collection_to_user_role(userid, add_policy_collection_to_role_request, async_req=True)
        >>> result = thread.get()

        :param userid: Id of the User Role to get (required)
        :type userid: str
        :param add_policy_collection_to_role_request: Dto of the policy collection to be added. (required)
        :type add_policy_collection_to_role_request: AddPolicyCollectionToRoleRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UserRoleResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.add_policy_collection_to_user_role_with_http_info(userid, add_policy_collection_to_role_request, **kwargs)  # noqa: E501

    def add_policy_collection_to_user_role_with_http_info(self, userid, add_policy_collection_to_role_request, **kwargs):  # noqa: E501
        """AddPolicyCollectionToUserRole: Add a policy collection to a user-role  # noqa: E501

        Adds a policy collection to a user-role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_policy_collection_to_user_role_with_http_info(userid, add_policy_collection_to_role_request, async_req=True)
        >>> result = thread.get()

        :param userid: Id of the User Role to get (required)
        :type userid: str
        :param add_policy_collection_to_role_request: Dto of the policy collection to be added. (required)
        :type add_policy_collection_to_role_request: AddPolicyCollectionToRoleRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (UserRoleResponse, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'userid',
            'add_policy_collection_to_role_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_policy_collection_to_user_role" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'userid' is set
        if self.api_client.client_side_validation and ('userid' not in local_var_params or  # noqa: E501
                                                        local_var_params['userid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `userid` when calling `add_policy_collection_to_user_role`")  # noqa: E501
        # verify the required parameter 'add_policy_collection_to_role_request' is set
        if self.api_client.client_side_validation and ('add_policy_collection_to_role_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['add_policy_collection_to_role_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `add_policy_collection_to_role_request` when calling `add_policy_collection_to_user_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'userid' in local_var_params:
            path_params['userid'] = local_var_params['userid']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'add_policy_collection_to_role_request' in local_var_params:
            body_params = local_var_params['add_policy_collection_to_role_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.0.3868'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "UserRoleResponse",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/userroles/{userid}/policycollections', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def add_policy_to_user_role(self, userid, add_policy_to_role_request, **kwargs):  # noqa: E501
        """AddPolicyToUserRole: Add a policy to a user-role  # noqa: E501

        Adds a policy to a user-role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_policy_to_user_role(userid, add_policy_to_role_request, async_req=True)
        >>> result = thread.get()

        :param userid: Id of the User Role to get (required)
        :type userid: str
        :param add_policy_to_role_request: Dto of the policy to be added. (required)
        :type add_policy_to_role_request: AddPolicyToRoleRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UserRoleResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.add_policy_to_user_role_with_http_info(userid, add_policy_to_role_request, **kwargs)  # noqa: E501

    def add_policy_to_user_role_with_http_info(self, userid, add_policy_to_role_request, **kwargs):  # noqa: E501
        """AddPolicyToUserRole: Add a policy to a user-role  # noqa: E501

        Adds a policy to a user-role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.add_policy_to_user_role_with_http_info(userid, add_policy_to_role_request, async_req=True)
        >>> result = thread.get()

        :param userid: Id of the User Role to get (required)
        :type userid: str
        :param add_policy_to_role_request: Dto of the policy to be added. (required)
        :type add_policy_to_role_request: AddPolicyToRoleRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (UserRoleResponse, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'userid',
            'add_policy_to_role_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_policy_to_user_role" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'userid' is set
        if self.api_client.client_side_validation and ('userid' not in local_var_params or  # noqa: E501
                                                        local_var_params['userid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `userid` when calling `add_policy_to_user_role`")  # noqa: E501
        # verify the required parameter 'add_policy_to_role_request' is set
        if self.api_client.client_side_validation and ('add_policy_to_role_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['add_policy_to_role_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `add_policy_to_role_request` when calling `add_policy_to_user_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'userid' in local_var_params:
            path_params['userid'] = local_var_params['userid']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'add_policy_to_role_request' in local_var_params:
            body_params = local_var_params['add_policy_to_role_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.0.3868'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "UserRoleResponse",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/userroles/{userid}/policies', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def create_user_role(self, user_role_creation_request, **kwargs):  # noqa: E501
        """CreateUserRole: Create a user-role  # noqa: E501

        Creates a new user-role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_user_role(user_role_creation_request, async_req=True)
        >>> result = thread.get()

        :param user_role_creation_request: Definition of the user-role to create. (required)
        :type user_role_creation_request: UserRoleCreationRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UserRoleResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.create_user_role_with_http_info(user_role_creation_request, **kwargs)  # noqa: E501

    def create_user_role_with_http_info(self, user_role_creation_request, **kwargs):  # noqa: E501
        """CreateUserRole: Create a user-role  # noqa: E501

        Creates a new user-role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_user_role_with_http_info(user_role_creation_request, async_req=True)
        >>> result = thread.get()

        :param user_role_creation_request: Definition of the user-role to create. (required)
        :type user_role_creation_request: UserRoleCreationRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (UserRoleResponse, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'user_role_creation_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_user_role" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'user_role_creation_request' is set
        if self.api_client.client_side_validation and ('user_role_creation_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_role_creation_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_role_creation_request` when calling `create_user_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'user_role_creation_request' in local_var_params:
            body_params = local_var_params['user_role_creation_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.0.3868'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "UserRoleResponse",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/userroles', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_user_role(self, userid, **kwargs):  # noqa: E501
        """DeleteUserRole: Delete a user-role  # noqa: E501

        Deletes an identified user-role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_user_role(userid, async_req=True)
        >>> result = thread.get()

        :param userid: Id of the user-role to delete. (required)
        :type userid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_user_role_with_http_info(userid, **kwargs)  # noqa: E501

    def delete_user_role_with_http_info(self, userid, **kwargs):  # noqa: E501
        """DeleteUserRole: Delete a user-role  # noqa: E501

        Deletes an identified user-role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_user_role_with_http_info(userid, async_req=True)
        >>> result = thread.get()

        :param userid: Id of the user-role to delete. (required)
        :type userid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'userid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_user_role" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'userid' is set
        if self.api_client.client_side_validation and ('userid' not in local_var_params or  # noqa: E501
                                                        local_var_params['userid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `userid` when calling `delete_user_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'userid' in local_var_params:
            path_params['userid'] = local_var_params['userid']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.0.3868'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/api/userroles/{userid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_user_role(self, userid, **kwargs):  # noqa: E501
        """GetUserRole: Get a user-role  # noqa: E501

        Get an identified user-role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_user_role(userid, async_req=True)
        >>> result = thread.get()

        :param userid: Id of the user-role to get. (required)
        :type userid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UserRoleResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.get_user_role_with_http_info(userid, **kwargs)  # noqa: E501

    def get_user_role_with_http_info(self, userid, **kwargs):  # noqa: E501
        """GetUserRole: Get a user-role  # noqa: E501

        Get an identified user-role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_user_role_with_http_info(userid, async_req=True)
        >>> result = thread.get()

        :param userid: Id of the user-role to get. (required)
        :type userid: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (UserRoleResponse, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'userid'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_role" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'userid' is set
        if self.api_client.client_side_validation and ('userid' not in local_var_params or  # noqa: E501
                                                        local_var_params['userid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `userid` when calling `get_user_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'userid' in local_var_params:
            path_params['userid'] = local_var_params['userid']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.0.3868'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "UserRoleResponse",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/userroles/{userid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def list_user_roles(self, **kwargs):  # noqa: E501
        """ListUserRoles: List user-roles  # noqa: E501

        Lists all user-roles and pages.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_user_roles(async_req=True)
        >>> result = thread.get()

        :param filter: Optional. Expression to filter the result set
        :type filter: str
        :param sort_by: Optional. Order the results by these fields. Use the '-' sign to denote descending order e.g. -MyFieldName
        :type sort_by: str
        :param limit: Optional. When paginating, limit the number of returned results to this many.
        :type limit: int
        :param page: Optional. Encoded page string returned from a previous search result that will retrieve              the next page of data.
        :type page: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfUserRoleResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.list_user_roles_with_http_info(**kwargs)  # noqa: E501

    def list_user_roles_with_http_info(self, **kwargs):  # noqa: E501
        """ListUserRoles: List user-roles  # noqa: E501

        Lists all user-roles and pages.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_user_roles_with_http_info(async_req=True)
        >>> result = thread.get()

        :param filter: Optional. Expression to filter the result set
        :type filter: str
        :param sort_by: Optional. Order the results by these fields. Use the '-' sign to denote descending order e.g. -MyFieldName
        :type sort_by: str
        :param limit: Optional. When paginating, limit the number of returned results to this many.
        :type limit: int
        :param page: Optional. Encoded page string returned from a previous search result that will retrieve              the next page of data.
        :type page: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (ResourceListOfUserRoleResponse, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'filter',
            'sort_by',
            'limit',
            'page'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_user_roles" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and ('filter' in local_var_params and  # noqa: E501
                                                        len(local_var_params['filter']) > 16384):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `list_user_roles`, length must be less than or equal to `16384`")  # noqa: E501
        if self.api_client.client_side_validation and ('filter' in local_var_params and  # noqa: E501
                                                        len(local_var_params['filter']) < 0):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `list_user_roles`, length must be greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'filter' in local_var_params and not re.search(r'^[\s\S]*$', local_var_params['filter']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `list_user_roles`, must conform to the pattern `/^[\s\S]*$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('sort_by' in local_var_params and  # noqa: E501
                                                        len(local_var_params['sort_by']) > 16384):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `sort_by` when calling `list_user_roles`, length must be less than or equal to `16384`")  # noqa: E501
        if self.api_client.client_side_validation and ('sort_by' in local_var_params and  # noqa: E501
                                                        len(local_var_params['sort_by']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `sort_by` when calling `list_user_roles`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'sort_by' in local_var_params and not re.search(r'^[\s\S]*$', local_var_params['sort_by']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `sort_by` when calling `list_user_roles`, must conform to the pattern `/^[\s\S]*$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] > 5000:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `list_user_roles`, must be a value less than or equal to `5000`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `list_user_roles`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and ('page' in local_var_params and  # noqa: E501
                                                        len(local_var_params['page']) > 500):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page` when calling `list_user_roles`, length must be less than or equal to `500`")  # noqa: E501
        if self.api_client.client_side_validation and ('page' in local_var_params and  # noqa: E501
                                                        len(local_var_params['page']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page` when calling `list_user_roles`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'page' in local_var_params and not re.search(r'^[a-zA-Z0-9\+\/]*={0,3}$', local_var_params['page']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page` when calling `list_user_roles`, must conform to the pattern `/^[a-zA-Z0-9\+\/]*={0,3}$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter' in local_var_params and local_var_params['filter'] is not None:  # noqa: E501
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501
        if 'sort_by' in local_var_params and local_var_params['sort_by'] is not None:  # noqa: E501
            query_params.append(('sortBy', local_var_params['sort_by']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.0.3868'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "ResourceListOfUserRoleResponse",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/userroles', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def remove_policy_collection_from_user_role(self, userid, policy_collection_scope, policy_collection_code, **kwargs):  # noqa: E501
        """RemovePolicyCollectionFromUserRole: Remove a policy collection from a user-role  # noqa: E501

        Removes a policy collection from a user-role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_policy_collection_from_user_role(userid, policy_collection_scope, policy_collection_code, async_req=True)
        >>> result = thread.get()

        :param userid: Id of the User Role to get (required)
        :type userid: str
        :param policy_collection_scope: The scope of policy collection to remove from the User Role (required)
        :type policy_collection_scope: str
        :param policy_collection_code: The code of the policy collection to remove from the User Role (required)
        :type policy_collection_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.remove_policy_collection_from_user_role_with_http_info(userid, policy_collection_scope, policy_collection_code, **kwargs)  # noqa: E501

    def remove_policy_collection_from_user_role_with_http_info(self, userid, policy_collection_scope, policy_collection_code, **kwargs):  # noqa: E501
        """RemovePolicyCollectionFromUserRole: Remove a policy collection from a user-role  # noqa: E501

        Removes a policy collection from a user-role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_policy_collection_from_user_role_with_http_info(userid, policy_collection_scope, policy_collection_code, async_req=True)
        >>> result = thread.get()

        :param userid: Id of the User Role to get (required)
        :type userid: str
        :param policy_collection_scope: The scope of policy collection to remove from the User Role (required)
        :type policy_collection_scope: str
        :param policy_collection_code: The code of the policy collection to remove from the User Role (required)
        :type policy_collection_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'userid',
            'policy_collection_scope',
            'policy_collection_code'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_policy_collection_from_user_role" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'userid' is set
        if self.api_client.client_side_validation and ('userid' not in local_var_params or  # noqa: E501
                                                        local_var_params['userid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `userid` when calling `remove_policy_collection_from_user_role`")  # noqa: E501
        # verify the required parameter 'policy_collection_scope' is set
        if self.api_client.client_side_validation and ('policy_collection_scope' not in local_var_params or  # noqa: E501
                                                        local_var_params['policy_collection_scope'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `policy_collection_scope` when calling `remove_policy_collection_from_user_role`")  # noqa: E501
        # verify the required parameter 'policy_collection_code' is set
        if self.api_client.client_side_validation and ('policy_collection_code' not in local_var_params or  # noqa: E501
                                                        local_var_params['policy_collection_code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `policy_collection_code` when calling `remove_policy_collection_from_user_role`")  # noqa: E501

        if self.api_client.client_side_validation and 'policy_collection_scope' in local_var_params and not re.search(r'^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$', local_var_params['policy_collection_scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `policy_collection_scope` when calling `remove_policy_collection_from_user_role`, must conform to the pattern `/^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'policy_collection_code' in local_var_params and not re.search(r'^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$', local_var_params['policy_collection_code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `policy_collection_code` when calling `remove_policy_collection_from_user_role`, must conform to the pattern `/^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'userid' in local_var_params:
            path_params['userid'] = local_var_params['userid']  # noqa: E501
        if 'policy_collection_scope' in local_var_params:
            path_params['policyCollectionScope'] = local_var_params['policy_collection_scope']  # noqa: E501
        if 'policy_collection_code' in local_var_params:
            path_params['policyCollectionCode'] = local_var_params['policy_collection_code']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.0.3868'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/api/userroles/{userid}/policycollections/{policyCollectionScope}/{policyCollectionCode}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def remove_policy_from_user_role(self, userid, policy_scope, policy_code, **kwargs):  # noqa: E501
        """RemovePolicyFromUserRole: Remove a policy from a user-role  # noqa: E501

        Removes a policy from a user-role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_policy_from_user_role(userid, policy_scope, policy_code, async_req=True)
        >>> result = thread.get()

        :param userid: Id of the User Role to get (required)
        :type userid: str
        :param policy_scope: The scope of the policy to remove from the User Role (required)
        :type policy_scope: str
        :param policy_code: The code of the policy to remove from the User Role (required)
        :type policy_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.remove_policy_from_user_role_with_http_info(userid, policy_scope, policy_code, **kwargs)  # noqa: E501

    def remove_policy_from_user_role_with_http_info(self, userid, policy_scope, policy_code, **kwargs):  # noqa: E501
        """RemovePolicyFromUserRole: Remove a policy from a user-role  # noqa: E501

        Removes a policy from a user-role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.remove_policy_from_user_role_with_http_info(userid, policy_scope, policy_code, async_req=True)
        >>> result = thread.get()

        :param userid: Id of the User Role to get (required)
        :type userid: str
        :param policy_scope: The scope of the policy to remove from the User Role (required)
        :type policy_scope: str
        :param policy_code: The code of the policy to remove from the User Role (required)
        :type policy_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'userid',
            'policy_scope',
            'policy_code'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_policy_from_user_role" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'userid' is set
        if self.api_client.client_side_validation and ('userid' not in local_var_params or  # noqa: E501
                                                        local_var_params['userid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `userid` when calling `remove_policy_from_user_role`")  # noqa: E501
        # verify the required parameter 'policy_scope' is set
        if self.api_client.client_side_validation and ('policy_scope' not in local_var_params or  # noqa: E501
                                                        local_var_params['policy_scope'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `policy_scope` when calling `remove_policy_from_user_role`")  # noqa: E501
        # verify the required parameter 'policy_code' is set
        if self.api_client.client_side_validation and ('policy_code' not in local_var_params or  # noqa: E501
                                                        local_var_params['policy_code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `policy_code` when calling `remove_policy_from_user_role`")  # noqa: E501

        if self.api_client.client_side_validation and 'policy_scope' in local_var_params and not re.search(r'^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$', local_var_params['policy_scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `policy_scope` when calling `remove_policy_from_user_role`, must conform to the pattern `/^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'policy_code' in local_var_params and not re.search(r'^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$', local_var_params['policy_code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `policy_code` when calling `remove_policy_from_user_role`, must conform to the pattern `/^(?=.*[a-zA-Z])[\w][\w +-]{2,100}$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'userid' in local_var_params:
            path_params['userid'] = local_var_params['userid']  # noqa: E501
        if 'policy_scope' in local_var_params:
            path_params['policyScope'] = local_var_params['policy_scope']  # noqa: E501
        if 'policy_code' in local_var_params:
            path_params['policyCode'] = local_var_params['policy_code']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.0.3868'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {}

        return self.api_client.call_api(
            '/api/userroles/{userid}/policies/{policyScope}/{policyCode}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def update_user_role(self, userid, user_role_update_request, **kwargs):  # noqa: E501
        """UpdateUserRole: Update a user-role  # noqa: E501

        Updates an identified user-role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_user_role(userid, user_role_update_request, async_req=True)
        >>> result = thread.get()

        :param userid: Id of the user-role to be updated. (required)
        :type userid: str
        :param user_role_update_request: Definition of the update to apply to the user-role. (required)
        :type user_role_update_request: UserRoleUpdateRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UserRoleResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.update_user_role_with_http_info(userid, user_role_update_request, **kwargs)  # noqa: E501

    def update_user_role_with_http_info(self, userid, user_role_update_request, **kwargs):  # noqa: E501
        """UpdateUserRole: Update a user-role  # noqa: E501

        Updates an identified user-role.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_user_role_with_http_info(userid, user_role_update_request, async_req=True)
        >>> result = thread.get()

        :param userid: Id of the user-role to be updated. (required)
        :type userid: str
        :param user_role_update_request: Definition of the update to apply to the user-role. (required)
        :type user_role_update_request: UserRoleUpdateRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (UserRoleResponse, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'userid',
            'user_role_update_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_user_role" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'userid' is set
        if self.api_client.client_side_validation and ('userid' not in local_var_params or  # noqa: E501
                                                        local_var_params['userid'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `userid` when calling `update_user_role`")  # noqa: E501
        # verify the required parameter 'user_role_update_request' is set
        if self.api_client.client_side_validation and ('user_role_update_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_role_update_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_role_update_request` when calling `update_user_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'userid' in local_var_params:
            path_params['userid'] = local_var_params['userid']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'user_role_update_request' in local_var_params:
            body_params = local_var_params['user_role_update_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '0.0.3868'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "UserRoleResponse",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/userroles/{userid}/update', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
