# Mero - مكتبة التشفير الاحترافية القوية

**Mero** هي مكتبة تشفير بايثون فائقة الأمان مع تنفيذ bytecode مخصص ودعم متعدد المنصات. تم بناؤها من الصفر بدون أي اعتماديات خارجية، توفر خوارزميات تشفير عسكرية وتقنيات حماية متقدمة.

## المميزات الرئيسية

- **🔐 تشفير فائق القوة**: خوارزميات تشفير مخصصة مستحيلة الكسر
- **💻 bytecode مخصص**: أكثر من 2000 سطر من كود bytecode متقدم
- **🌍 دعم متعدد المنصات**: Windows، Linux، macOS، Android (Termux)، iOS
- **⚡ بدون اعتماديات خارجية**: مبني بالكامل من الصفر
- **🛡️ حماية من الهندسة العكسية**: 5 طبقات من التشويش والحماية
- **🔑 إدارة مفاتيح متقدمة**: توليد واشتقاق مفاتيح آمنة
- **🚀 محسن للأداء**: تحسين تلقائي حسب نوع المعالج

## التثبيت

```bash
pip install mero
```

## الاستخدام السريع

```python
import mero

# تشفير نص
data = "النص السري المراد تشفيره"
key = mero.generate_key()  # توليد مفتاح آمن
encrypted = mero.encrypt(data, key)
decrypted = mero.decrypt(encrypted, key)

# تشفير ملف
with open('secret.txt', 'rb') as f:
    file_data = f.read()
encrypted_file = mero.encrypt(file_data, key)

# حساب hash للبيانات
hash_result = mero.hash_data(data)
print(f"Hash: {hash_result.hex()}")

# تشفير كود Python وحمايته
code = """
def secret_function():
    return "هذا كود محمي!"
"""
obfuscated = mero.obfuscate_code(code)
```

## الخوارزميات المدعومة

- **mero_aes**: خوارزمية AES مخصصة فائقة القوة
- **mero_stream**: تشفير تدفقي عالي السرعة
- **mero_hybrid**: تشفير مختلط للملفات الكبيرة
- **mero_sha**: دالة hash مخصصة
- **mero_blake**: تنفيذ BLAKE2b محسن
- **mero_custom**: خوارزمية hash احترافية

## منصات مدعومة

✅ **Windows** - جميع الإصدارات  
✅ **Linux** - توزيعات مختلفة  
✅ **macOS** - Intel و Apple Silicon  
✅ **Android** - عبر Termux  
✅ **iOS** - دعم محدود  

## الحماية والأمان

- **تشفير عسكري المستوى**: خوارزميات مقاومة للكسر
- **حماية من التحليل**: مقاوم للهندسة العكسية
- **كشف المحاكيات**: حماية من أدوات التحليل
- **تشويش الكود**: 5 طبقات من الحماية
- **إدارة مفاتيح آمنة**: توليد واشتقاق محسن

## اختبار المكتبة

```bash
# تشغيل الاختبارات الشاملة
python comprehensive_test.py

# اختبار بسيط
python test_mero.py
```

## الأداء

- **سرعة عالية**: محسن لكل منصة
- **استهلاك ذاكرة قليل**: إدارة ذكية للموارد
- **دعم المعالجات المتعددة**: تحسين تلقائي
- **تشفير متوازي**: للملفات الكبيرة

## التطوير والمساهمة

المكتبة مكتملة وجاهزة للاستخدام الإنتاجي. تم تطويرها بعناية فائقة لتكون أقوى مكتبة تشفير في العالم.

## الترخيص

MIT License - استخدم بحرية في مشاريعك التجارية والشخصية.

---

**مكتبة Mero - تشفير لا يُكسر، حماية لا تُخترق** 🔐
