---
title: Server API Reference
description: Kodit Server REST API Documentation
weight: 30
---

This file is automatically generated from the Kodit server OpenAPI specification.
You can view the live API documentation on the `/docs` endpoint of your Kodit server or
look at the [hosted version](https://kodit.helix.ml/docs).


This is the REST API for the Kodit server. Please refer to the
[Kodit documentation](https://docs.helix.ml/kodit/) for more information.
    
Current version: 0.5.3

## Authentication



### Security Schemes

| Name              | Type              | Description              | Scheme              | Bearer Format             |
|-------------------|-------------------|--------------------------|---------------------|---------------------------|
| Header (X-API-KEY) | apiKey | API key for authentication (only if set in environmental variables) |  |  |

## APIs

### GET /healthz

Return a health check for the kodit API.


#### Responses

- 200: Successful Response

- 500: Internal server error

### GET /api/v1/queue

List all tasks in the queue.

Optionally filter by task type.


#### Parameters

| Name | Type | Required | Description |
|------|------|----------|-------------|
| task_type |  | False |  |


#### Responses

- 200: Successful Response

[TaskListResponse](#tasklistresponse)

- 500: Internal server error

- 401: Unauthorized

- 422: Invalid request

### GET /api/v1/queue/{task_id}

Get details of a specific task in the queue.


#### Parameters

| Name | Type | Required | Description |
|------|------|----------|-------------|
| task_id | string | True |  |


#### Responses

- 200: Successful Response

[TaskResponse](#taskresponse)

- 500: Internal server error

- 401: Unauthorized

- 422: Invalid request

- 404: Task not found

### POST /api/v1/search

Search code snippets with filters matching MCP tool.


#### Request Body

[SearchRequest](#searchrequest)


#### Responses

- 200: Successful Response

[SearchResponse](#searchresponse)

- 500: Internal server error

- 422: Validation Error

[HTTPValidationError](#httpvalidationerror)

### GET /api/v1/repositories/{repo_id}/commits

List all commits for a repository.


#### Parameters

| Name | Type | Required | Description |
|------|------|----------|-------------|
| repo_id | string | True |  |


#### Responses

- 200: Successful Response

[CommitListResponse](#commitlistresponse)

- 500: Internal server error

- 401: Unauthorized

- 422: Invalid request

### GET /api/v1/repositories/{repo_id}/commits/{commit_sha}

Get a specific commit for a repository.


#### Parameters

| Name | Type | Required | Description |
|------|------|----------|-------------|
| repo_id | string | True |  |
| commit_sha | string | True |  |


#### Responses

- 200: Successful Response

[CommitResponse](#commitresponse)

- 500: Internal server error

- 401: Unauthorized

- 422: Invalid request

- 404: Repository or commit not found

### GET /api/v1/repositories/{repo_id}/commits/{commit_sha}/files

List all files in a specific commit.


#### Parameters

| Name | Type | Required | Description |
|------|------|----------|-------------|
| repo_id | string | True |  |
| commit_sha | string | True |  |


#### Responses

- 200: Successful Response

[FileListResponse](#filelistresponse)

- 500: Internal server error

- 401: Unauthorized

- 422: Invalid request

### GET /api/v1/repositories/{repo_id}/commits/{commit_sha}/files/{blob_sha}

Get a specific file from a commit.


#### Parameters

| Name | Type | Required | Description |
|------|------|----------|-------------|
| repo_id | string | True |  |
| commit_sha | string | True |  |
| blob_sha | string | True |  |


#### Responses

- 200: Successful Response

[FileResponse](#fileresponse)

- 500: Internal server error

- 401: Unauthorized

- 422: Invalid request

- 404: Repository, commit or file not found

### GET /api/v1/repositories/{repo_id}/commits/{commit_sha}/snippets

List all snippets in a specific commit.


#### Parameters

| Name | Type | Required | Description |
|------|------|----------|-------------|
| repo_id | string | True |  |
| commit_sha | string | True |  |


#### Responses

- 200: Successful Response

[SnippetListResponse](#snippetlistresponse)

- 500: Internal server error

- 401: Unauthorized

- 422: Invalid request

- 404: Repository or commit not found

### GET /api/v1/repositories/{repo_id}/commits/{commit_sha}/embeddings

List all embeddings for snippets in a specific commit.


#### Parameters

| Name | Type | Required | Description |
|------|------|----------|-------------|
| repo_id | string | True |  |
| commit_sha | string | True |  |
| full | boolean | False | If true, return full vectors. If false, return first 5 values. |


#### Responses

- 200: Successful Response

[EmbeddingListResponse](#embeddinglistresponse)

- 500: Internal server error

- 401: Unauthorized

- 422: Invalid request

- 404: Repository or commit not found

### GET /api/v1/repositories/{repo_id}/commits/{commit_sha}/enrichments

List all enrichments for a specific commit.


#### Parameters

| Name | Type | Required | Description |
|------|------|----------|-------------|
| repo_id | string | True |  |
| commit_sha | string | True |  |


#### Responses

- 200: Successful Response

[EnrichmentListResponse](#enrichmentlistresponse)

- 500: Internal server error

- 401: Unauthorized

- 422: Invalid request

- 404: Repository or commit not found

### DELETE /api/v1/repositories/{repo_id}/commits/{commit_sha}/enrichments

Delete all enrichments for a specific commit.


#### Parameters

| Name | Type | Required | Description |
|------|------|----------|-------------|
| repo_id | string | True |  |
| commit_sha | string | True |  |


#### Responses

- 204: Successful Response

- 500: Internal server error

- 401: Unauthorized

- 422: Invalid request

- 404: Commit not found

### DELETE /api/v1/repositories/{repo_id}/commits/{commit_sha}/enrichments/{enrichment_id}

Delete a specific enrichment for a commit.


#### Parameters

| Name | Type | Required | Description |
|------|------|----------|-------------|
| repo_id | string | True |  |
| commit_sha | string | True |  |
| enrichment_id | integer | True |  |


#### Responses

- 204: Successful Response

- 500: Internal server error

- 401: Unauthorized

- 422: Invalid request

- 404: Enrichment not found

### GET /api/v1/repositories

List all cloned repositories.


#### Responses

- 200: Successful Response

[RepositoryListResponse](#repositorylistresponse)

- 500: Internal server error

- 401: Unauthorized

- 422: Invalid request

### POST /api/v1/repositories

Clone a new repository and perform initial mapping.


#### Request Body

[RepositoryCreateRequest](#repositorycreaterequest)


#### Responses

- 201: Successful Response

[RepositoryResponse](#repositoryresponse)

- 500: Internal server error

- 401: Unauthorized

- 422: Invalid request

### GET /api/v1/repositories/{repo_id}

Get repository details including branches and recent commits.


#### Parameters

| Name | Type | Required | Description |
|------|------|----------|-------------|
| repo_id | string | True |  |


#### Responses

- 200: Successful Response

[RepositoryDetailsResponse](#repositorydetailsresponse)

- 500: Internal server error

- 401: Unauthorized

- 422: Invalid request

- 404: Repository not found

### DELETE /api/v1/repositories/{repo_id}

Delete a repository and all its associated data.


#### Parameters

| Name | Type | Required | Description |
|------|------|----------|-------------|
| repo_id | string | True |  |


#### Responses

- 204: Successful Response

- 500: Internal server error

- 401: Unauthorized

- 422: Invalid request

- 404: Repository not found

### GET /api/v1/repositories/{repo_id}/status

Get the status of tasks for an index.


#### Parameters

| Name | Type | Required | Description |
|------|------|----------|-------------|
| repo_id | integer | True |  |


#### Responses

- 200: Successful Response

[TaskStatusListResponse](#taskstatuslistresponse)

- 500: Internal server error

- 401: Unauthorized

- 422: Invalid request

- 404: Index not found

### GET /api/v1/repositories/{repo_id}/tags

List all tags for a repository.


#### Parameters

| Name | Type | Required | Description |
|------|------|----------|-------------|
| repo_id | string | True |  |


#### Responses

- 200: Successful Response

[TagListResponse](#taglistresponse)

- 500: Internal server error

- 401: Unauthorized

- 422: Invalid request

- 404: Repository not found

### GET /api/v1/repositories/{repo_id}/tags/{tag_id}

Get a specific tag for a repository.


#### Parameters

| Name | Type | Required | Description |
|------|------|----------|-------------|
| repo_id | string | True |  |
| tag_id | string | True |  |


#### Responses

- 200: Successful Response

[TagResponse](#tagresponse)

- 500: Internal server error

- 401: Unauthorized

- 422: Invalid request

- 404: Repository or tag not found

### GET /api/v1/repositories/{repo_id}/enrichments

List the most recent enrichments for a repository.

Query parameters:
- ref_type: Type of reference (branch, tag, or commit_sha). Defaults to "branch".
- ref_name: Name of the reference. For branches, defaults to the tracking branch.
- enrichment_type: Optional filter for specific enrichment type.
- limit: Maximum number of enrichments to return. Defaults to 10.


#### Parameters

| Name | Type | Required | Description |
|------|------|----------|-------------|
| repo_id | string | True |  |
| ref_type | string | False |  |
| ref_name |  | False |  |
| enrichment_type |  | False |  |
| limit | integer | False |  |


#### Responses

- 200: Successful Response

[EnrichmentListResponse](#enrichmentlistresponse)

- 500: Internal server error

- 401: Unauthorized

- 422: Invalid request

- 404: Repository not found

## Components



### CommitAttributes


Commit attributes following JSON-API spec.


| Field | Type | Description |
|-------|------|-------------|
| commit_sha | string |  |
| date | string |  |
| message | string |  |
| parent_commit_sha | string |  |
| author | string |  |


### CommitData


Commit data following JSON-API spec.


| Field | Type | Description |
|-------|------|-------------|
| type | string |  |
| id | string |  |
| attributes |  |  |


### CommitListResponse


Commit list response following JSON-API spec.


| Field | Type | Description |
|-------|------|-------------|
| data | array |  |


### CommitResponse


Single commit response following JSON-API spec.


| Field | Type | Description |
|-------|------|-------------|
| data |  |  |


### EmbeddingAttributes


Embedding attributes following JSON-API spec.


| Field | Type | Description |
|-------|------|-------------|
| snippet_sha | string |  |
| embedding_type | string |  |
| embedding | array |  |


### EmbeddingData


Embedding data following JSON-API spec.


| Field | Type | Description |
|-------|------|-------------|
| type | string |  |
| id | string |  |
| attributes |  |  |


### EmbeddingListResponse


Embedding list response following JSON-API spec.


| Field | Type | Description |
|-------|------|-------------|
| data | array |  |


### EnrichmentAttributes


Enrichment attributes following JSON-API spec.


| Field | Type | Description |
|-------|------|-------------|
| type | string |  |
| subtype |  |  |
| content | string |  |
| created_at |  |  |
| updated_at |  |  |


### EnrichmentData


Enrichment data following JSON-API spec.


| Field | Type | Description |
|-------|------|-------------|
| type | string |  |
| id | string |  |
| attributes |  |  |


### EnrichmentListResponse


Enrichment list response following JSON-API spec.


| Field | Type | Description |
|-------|------|-------------|
| data | array |  |


### EnrichmentSchema


Enrichment schema following JSON-API spec.


| Field | Type | Description |
|-------|------|-------------|
| type | string |  |
| content | string |  |


### FileAttributes


File attributes following JSON-API spec.


| Field | Type | Description |
|-------|------|-------------|
| blob_sha | string |  |
| path | string |  |
| mime_type | string |  |
| size | integer |  |
| extension | string |  |


### FileData


File data following JSON-API spec.


| Field | Type | Description |
|-------|------|-------------|
| type | string |  |
| id | string |  |
| attributes |  |  |


### FileListResponse


File list response following JSON-API spec.


| Field | Type | Description |
|-------|------|-------------|
| data | array |  |


### FileResponse


Single file response following JSON-API spec.


| Field | Type | Description |
|-------|------|-------------|
| data |  |  |


### GitFileSchema


Git file schema following JSON-API spec.


| Field | Type | Description |
|-------|------|-------------|
| blob_sha | string |  |
| path | string |  |
| mime_type | string |  |
| size | integer |  |


### HTTPValidationError



| Field | Type | Description |
|-------|------|-------------|
| detail | array |  |


### RepositoryAttributes


Repository attributes following JSON-API spec.


| Field | Type | Description |
|-------|------|-------------|
| remote_uri | string |  |
| created_at |  |  |
| updated_at |  |  |
| last_scanned_at |  |  |
| cloned_path |  |  |
| tracking_branch |  |  |
| num_commits | integer |  |
| num_branches | integer |  |
| num_tags | integer |  |


### RepositoryBranchData


Repository branch data.


| Field | Type | Description |
|-------|------|-------------|
| name | string |  |
| is_default | boolean |  |
| commit_count | integer |  |


### RepositoryCommitData


Repository commit data for repository details.


| Field | Type | Description |
|-------|------|-------------|
| sha | string |  |
| message | string |  |
| author | string |  |
| timestamp | string |  |


### RepositoryCreateAttributes


Repository creation attributes.


| Field | Type | Description |
|-------|------|-------------|
| remote_uri | string |  |


### RepositoryCreateData


Repository creation data.


| Field | Type | Description |
|-------|------|-------------|
| type | string |  |
| attributes |  |  |


### RepositoryCreateRequest


Repository creation request.


| Field | Type | Description |
|-------|------|-------------|
| data |  |  |


### RepositoryData


Repository data following JSON-API spec.


| Field | Type | Description |
|-------|------|-------------|
| type | string |  |
| id | string |  |
| attributes |  |  |


### RepositoryDetailsResponse


Repository details response with branches and commits.


| Field | Type | Description |
|-------|------|-------------|
| data |  |  |
| branches | array |  |
| recent_commits | array |  |


### RepositoryListResponse


Repository list response following JSON-API spec.


| Field | Type | Description |
|-------|------|-------------|
| data | array |  |


### RepositoryResponse


Single repository response following JSON-API spec.


| Field | Type | Description |
|-------|------|-------------|
| data |  |  |


### SearchAttributes


Search attributes for JSON:API requests.


| Field | Type | Description |
|-------|------|-------------|
| keywords |  | Search keywords |
| code |  | Code search query |
| text |  | Text search query |
| limit |  | Maximum number of results to return |
| filters |  | Search filters |


### SearchData


Search data for JSON:API requests.


| Field | Type | Description |
|-------|------|-------------|
| type | string |  |
| attributes |  |  |


### SearchFilters


Search filters for JSON:API requests.


| Field | Type | Description |
|-------|------|-------------|
| languages |  | Programming languages to filter by |
| authors |  | Authors to filter by |
| start_date |  | Filter snippets created after this date |
| end_date |  | Filter snippets created before this date |
| sources |  | Source repositories to filter by |
| file_patterns |  | File path patterns to filter by |


### SearchRequest


JSON:API request for searching snippets.


| Field | Type | Description |
|-------|------|-------------|
| data |  |  |


### SearchResponse


JSON:API response for search results.


| Field | Type | Description |
|-------|------|-------------|
| data | array |  |


### SnippetContentSchema


Snippet content schema following JSON-API spec.


| Field | Type | Description |
|-------|------|-------------|
| value | string |  |
| language | string |  |


### SnippetListResponse


Snippet list response following JSON-API spec.


| Field | Type | Description |
|-------|------|-------------|
| data | array |  |


### TagAttributes


Tag attributes following JSON-API spec.


| Field | Type | Description |
|-------|------|-------------|
| name | string |  |
| target_commit_sha | string |  |
| is_version_tag | boolean |  |


### TagData


Tag data following JSON-API spec.


| Field | Type | Description |
|-------|------|-------------|
| type | string |  |
| id | string |  |
| attributes |  |  |


### TagListResponse


Tag list response following JSON-API spec.


| Field | Type | Description |
|-------|------|-------------|
| data | array |  |


### TagResponse


Single tag response following JSON-API spec.


| Field | Type | Description |
|-------|------|-------------|
| data |  |  |


### TaskAttributes


Task attributes for JSON:API responses.


| Field | Type | Description |
|-------|------|-------------|
| type | string |  |
| priority | integer |  |
| payload | object |  |
| created_at |  |  |
| updated_at |  |  |


### TaskData


Task data for JSON:API responses.


| Field | Type | Description |
|-------|------|-------------|
| type | string |  |
| id | string |  |
| attributes |  |  |


### TaskListResponse


JSON:API response for task list.


| Field | Type | Description |
|-------|------|-------------|
| data | array |  |


### TaskOperation


Task operation.




### TaskResponse


JSON:API response for single task.


| Field | Type | Description |
|-------|------|-------------|
| data |  |  |


### TaskStatusAttributes


Task status attributes for JSON:API responses.


| Field | Type | Description |
|-------|------|-------------|
| step | string | Name of the task/operation |
| state | string | Current state of the task |
| progress | number | Progress percentage (0-100) |
| total | integer | Total number of items to process |
| current | integer | Current number of items processed |
| created_at |  | Task start time |
| updated_at |  | Last update time |
| error | string | Error message |
| message | string | Message |


### TaskStatusData


Task status data for JSON:API responses.


| Field | Type | Description |
|-------|------|-------------|
| type | string |  |
| id | string |  |
| attributes |  |  |


### TaskStatusListResponse


JSON:API response for task status list.


| Field | Type | Description |
|-------|------|-------------|
| data | array |  |


### ValidationError



| Field | Type | Description |
|-------|------|-------------|
| loc | array |  |
| msg | string |  |
| type | string |  |


### kodit__infrastructure__api__v1__schemas__search__SnippetAttributes


Snippet attributes for JSON:API responses.


| Field | Type | Description |
|-------|------|-------------|
| created_at |  |  |
| updated_at |  |  |
| derives_from | array |  |
| content |  |  |
| enrichments | array |  |
| original_scores | array |  |


### kodit__infrastructure__api__v1__schemas__search__SnippetData


Snippet data for JSON:API responses.


| Field | Type | Description |
|-------|------|-------------|
| type | string |  |
| id | string |  |
| attributes |  |  |


### kodit__infrastructure__api__v1__schemas__snippet__SnippetAttributes


Snippet attributes following JSON-API spec.


| Field | Type | Description |
|-------|------|-------------|
| created_at |  |  |
| updated_at |  |  |
| derives_from | array |  |
| content |  |  |
| enrichments | array |  |


### kodit__infrastructure__api__v1__schemas__snippet__SnippetData


Snippet data following JSON-API spec.


| Field | Type | Description |
|-------|------|-------------|
| type | string |  |
| id | string |  |
| attributes |  |  |
