# ruff: noqa
"""add embeddings table

Revision ID: 7c3bbc2ab32b
Revises: 85155663351e
Create Date: 2025-05-23 17:23:09.924980

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = "7c3bbc2ab32b"
down_revision: Union[str, None] = "85155663351e"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "embeddings",
        sa.Column("snippet_id", sa.Integer(), nullable=False),
        sa.Column(
            "type", sa.Enum("CODE", "TEXT", name="embeddingtype"), nullable=False
        ),
        sa.Column("embedding", sa.JSON(), nullable=False),
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("created_at", sa.DateTime(), nullable=False),
        sa.Column("updated_at", sa.DateTime(), nullable=False),
        sa.ForeignKeyConstraint(
            ["snippet_id"],
            ["snippets.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_embeddings_snippet_id"), "embeddings", ["snippet_id"], unique=False
    )
    op.create_index(op.f("ix_embeddings_type"), "embeddings", ["type"], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_embeddings_type"), table_name="embeddings")
    op.drop_index(op.f("ix_embeddings_snippet_id"), table_name="embeddings")
    op.drop_table("embeddings")
    # ### end Alembic commands ###
