# ruff: noqa
"""add queue

Revision ID: 9cf0e87de578
Revises: 4073b33f9436
Create Date: 2025-08-06 17:38:21.055235

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '9cf0e87de578'
down_revision: Union[str, None] = '4073b33f9436'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('tasks',
    sa.Column('dedup_key', sa.String(length=255), nullable=False),
    sa.Column('type', sa.Enum('INDEX_UPDATE', name='tasktype'), nullable=False),
    sa.Column('payload', sa.JSON(), nullable=False),
    sa.Column('priority', sa.Integer(), nullable=False),
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('created_at', sa.DateTime(timezone=True), nullable=False),
    sa.Column('updated_at', sa.DateTime(timezone=True), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_tasks_dedup_key'), 'tasks', ['dedup_key'], unique=False)
    op.create_index(op.f('ix_tasks_type'), 'tasks', ['type'], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_tasks_type'), table_name='tasks')
    op.drop_index(op.f('ix_tasks_dedup_key'), table_name='tasks')
    op.drop_table('tasks')
    # ### end Alembic commands ###
