# ruff: noqa
"""add task status

Revision ID: b9cd1c3fd762
Revises: 9cf0e87de578
Create Date: 2025-09-05 13:41:29.645898

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = "b9cd1c3fd762"
down_revision: Union[str, None] = "9cf0e87de578"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "task_status",
        sa.Column("id", sa.String(length=255), nullable=False),
        sa.Column("created_at", sa.DateTime(timezone=True), nullable=False),
        sa.Column("updated_at", sa.DateTime(timezone=True), nullable=False),
        sa.Column("operation", sa.String(length=255), nullable=False),
        sa.Column("trackable_id", sa.Integer(), nullable=True),
        sa.Column("trackable_type", sa.String(length=255), nullable=True),
        sa.Column("parent", sa.String(length=255), nullable=True),
        sa.Column("message", sa.UnicodeText(), nullable=False),
        sa.Column("state", sa.String(length=255), nullable=False),
        sa.Column("error", sa.UnicodeText(), nullable=False),
        sa.Column("total", sa.Integer(), nullable=False),
        sa.Column("current", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["parent"],
            ["task_status.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(op.f("ix_task_status_id"), "task_status", ["id"], unique=False)
    op.create_index(
        op.f("ix_task_status_operation"), "task_status", ["operation"], unique=False
    )
    op.create_index(
        op.f("ix_task_status_parent"), "task_status", ["parent"], unique=False
    )
    op.create_index(
        op.f("ix_task_status_trackable_id"),
        "task_status",
        ["trackable_id"],
        unique=False,
    )
    op.create_index(
        op.f("ix_task_status_trackable_type"),
        "task_status",
        ["trackable_type"],
        unique=False,
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_task_status_trackable_type"), table_name="task_status")
    op.drop_index(op.f("ix_task_status_trackable_id"), table_name="task_status")
    op.drop_index(op.f("ix_task_status_parent"), table_name="task_status")
    op.drop_index(op.f("ix_task_status_operation"), table_name="task_status")
    op.drop_index(op.f("ix_task_status_id"), table_name="task_status")
    op.drop_table("task_status")
    # ### end Alembic commands ###
