# ruff: noqa
"""index all the things

Revision ID: c3f5137d30f5
Revises: 7c3bbc2ab32b
Create Date: 2025-06-05 17:17:32.440740

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = "c3f5137d30f5"
down_revision: Union[str, None] = "7c3bbc2ab32b"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_index(
        op.f("ix_files_cloned_path"), "files", ["cloned_path"], unique=False
    )
    op.create_index(op.f("ix_files_mime_type"), "files", ["mime_type"], unique=False)
    op.create_index(op.f("ix_files_uri"), "files", ["uri"], unique=False)
    op.create_index(op.f("ix_snippets_file_id"), "snippets", ["file_id"], unique=False)
    op.create_index(
        op.f("ix_snippets_index_id"), "snippets", ["index_id"], unique=False
    )
    op.create_index(
        op.f("ix_sources_cloned_path"), "sources", ["cloned_path"], unique=False
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_sources_cloned_path"), table_name="sources")
    op.drop_index(op.f("ix_snippets_index_id"), table_name="snippets")
    op.drop_index(op.f("ix_snippets_file_id"), table_name="snippets")
    op.drop_index(op.f("ix_files_uri"), table_name="files")
    op.drop_index(op.f("ix_files_mime_type"), table_name="files")
    op.drop_index(op.f("ix_files_cloned_path"), table_name="files")
    # ### end Alembic commands ###
