<h1 align="center"><img src="https://raw.githubusercontent.com/photobooth-app/photobooth-app/main/assets/logo/logo-text-blue-transparent.png" alt="photobooth app logo" /></h1>

Welcome to your brand-new open-source photobooth-app! Written in Python 🐍, coming along with a modern Vue3 frontend.

[![PyPI](https://img.shields.io/pypi/v/photobooth-app)](https://pypi.org/project/photobooth-app/)
[![ruff](https://github.com/photobooth-app/photobooth-app/actions/workflows/ruff.yml/badge.svg)](https://github.com/photobooth-app/photobooth-app/actions/workflows/ruff.yml)
[![pytest](https://github.com/photobooth-app/photobooth-app/actions/workflows/pytests.yml/badge.svg)](https://github.com/photobooth-app/photobooth-app/actions/workflows/pytests.yml)
[![codecov](https://codecov.io/gh/photobooth-app/photobooth-app/branch/main/graph/badge.svg?token=SBB5DGX17V)](https://codecov.io/gh/photobooth-app/photobooth-app)
[![crowdin](https://badges.crowdin.net/photobooth-app/localized.svg)](https://crowdin.com/project/photobooth-app)

**[Installation](https://photobooth-app.org/setup/installation/)** - **[Documentation](https://photobooth-app.org/)** - **[PyPI package](https://pypi.org/project/photobooth-app/)** - **[3d printed box](https://photobooth-app.org/photobox3dprint/)**

## 😍 Features

📷 Capture stills, animated gif, collages and even 📹 videos!  
🫶 Supports DSLR, Raspberry Pi cameras and webcameras  
🎉 Camera live preview with shortest delay as possible, permanent video live view in background  
🛫 Optimized for speed, highly response UI  
🫶 Several camera backends supported for high quality stills and livestream  
💡 Countdown animation using customizable WLED module
🤝 Linux 🐧, Raspberry Pi 🍓 and Windows 🪟 platforms supported  
🔓 Open-source, non-restrictive MIT license  

[![photobooth-app screenshot of the frontpage](https://raw.githubusercontent.com/photobooth-app/photobooth-app/main/assets/screenshots/frontpage.png)](https://photobooth-app.org/screenshots/)

[Find more screenshots in the documentation](https://photobooth-app.org/screenshots/)

## 🔧 Build your own

Following resources are helpful to start building your own photobooth:

- [Requirements](https://photobooth-app.org/setup/installation/#prerequisites)
- [Installation instructions](https://photobooth-app.org/setup/installation/)
- [Camera specific setup](https://photobooth-app.org/setup/camera_setup/)

You need inspiration first, have a look what others did:

- [3d-printed reference photobooth-box](https://photobooth-app.org/photobox3dprint/)
- [Example projects](https://photobooth-app.org/projects/)
- [Find screenshots in the documentation](https://photobooth-app.org/screenshots)

### ©️ License

The software is licensed under the MIT license.

### 🎉 Donation

If you like my work and like to keep me motivated you can sponsor me:

[![Donate](https://img.shields.io/badge/Donate-PayPal-green.svg)](https://www.paypal.com/donate/?hosted_button_id=8255Y566TBNEC)

Or help [translate the software in your language](https://github.com/photobooth-app/photobooth-app/blob/main/CONTRIBUTING.md#help-translate-the-app).
