<a id="mypy-boto3-lexv2-models"></a>

# mypy-boto3-lexv2-models

[![PyPI - mypy-boto3-lexv2-models](https://img.shields.io/pypi/v/mypy-boto3-lexv2-models.svg?color=blue)](https://pypi.org/project/mypy-boto3-lexv2-models)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-lexv2-models.svg?color=blue)](https://pypi.org/project/mypy-boto3-lexv2-models)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-lexv2-models?color=blue)](https://pypistats.org/packages/mypy-boto3-lexv2-models)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.LexModelsV2 1.18.49](https://boto3.amazonaws.com/v1/documentation/api/1.18.49/reference/services/lexv2-models.html#LexModelsV2)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 5.4.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-lexv2-models docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_lexv2_models/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-lexv2-models](#mypy-boto3-lexv2-models)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `LexModelsV2` service.

```bash
python -m pip install boto3-stubs[lexv2-models]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[lexv2-models]` in your environment:
  `python -m pip install 'boto3-stubs[lexv2-models]'`

Both type checking and auto-complete should work for `LexModelsV2` service. No
explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[lexv2-models]` in your environment:
  `python -m pip install 'boto3-stubs[lexv2-models]'`

Both type checking and auto-complete should work for `LexModelsV2` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[lexv2-models]` in your environment:
  `python -m pip install 'boto3-stubs[lexv2-models]'`
- Run `mypy` as usual

Type checking should work for `LexModelsV2` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[lexv2-models]` in your environment:
  `python -m pip install 'boto3-stubs[lexv2-models]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `LexModelsV2` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`LexModelsV2Client` provides annotations for `boto3.client("lexv2-models")`.

```python
import boto3

from mypy_boto3_lexv2_models import LexModelsV2Client

client: LexModelsV2Client = boto3.client("lexv2-models")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: LexModelsV2Client = session.client("lexv2-models")
```

<a id="waiters-annotations"></a>

### Waiters annotations

`mypy_boto3_lexv2_models.waiter` module contains type annotations for all
waiters.

```python
from mypy_boto3_lexv2_models import LexModelsV2Client
from mypy_boto3_lexv2_models.waiter import (
    BotAliasAvailableWaiter,
    BotAvailableWaiter,
    BotExportCompletedWaiter,
    BotImportCompletedWaiter,
    BotLocaleBuiltWaiter,
    BotLocaleCreatedWaiter,
    BotLocaleExpressTestingAvailableWaiter,
    BotVersionAvailableWaiter,
)

client: LexModelsV2Client = boto3.client("lexv2-models")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
bot_alias_available_waiter: BotAliasAvailableWaiter = client.get_waiter("bot_alias_available")
bot_available_waiter: BotAvailableWaiter = client.get_waiter("bot_available")
bot_export_completed_waiter: BotExportCompletedWaiter = client.get_waiter("bot_export_completed")
bot_import_completed_waiter: BotImportCompletedWaiter = client.get_waiter("bot_import_completed")
bot_locale_built_waiter: BotLocaleBuiltWaiter = client.get_waiter("bot_locale_built")
bot_locale_created_waiter: BotLocaleCreatedWaiter = client.get_waiter("bot_locale_created")
bot_locale_express_testing_available_waiter: BotLocaleExpressTestingAvailableWaiter = client.get_waiter("bot_locale_express_testing_available")
bot_version_available_waiter: BotVersionAvailableWaiter = client.get_waiter("bot_version_available")
```

<a id="literals"></a>

### Literals

`mypy_boto3_lexv2_models.literals` module contains literals extracted from
shapes that can be used in user code for type checking.

```python
from mypy_boto3_lexv2_models.literals import (
    AggregatedUtterancesFilterNameType,
    AggregatedUtterancesFilterOperatorType,
    AggregatedUtterancesSortAttributeType,
    BotAliasAvailableWaiterName,
    BotAliasStatusType,
    BotAvailableWaiterName,
    BotExportCompletedWaiterName,
    BotFilterNameType,
    BotFilterOperatorType,
    BotImportCompletedWaiterName,
    BotLocaleBuiltWaiterName,
    BotLocaleCreatedWaiterName,
    BotLocaleExpressTestingAvailableWaiterName,
    BotLocaleFilterNameType,
    BotLocaleFilterOperatorType,
    BotLocaleSortAttributeType,
    BotLocaleStatusType,
    BotSortAttributeType,
    BotStatusType,
    BotVersionAvailableWaiterName,
    BotVersionSortAttributeType,
    BuiltInIntentSortAttributeType,
    BuiltInSlotTypeSortAttributeType,
    EffectType,
    ExportFilterNameType,
    ExportFilterOperatorType,
    ExportSortAttributeType,
    ExportStatusType,
    ImportExportFileFormatType,
    ImportFilterNameType,
    ImportFilterOperatorType,
    ImportSortAttributeType,
    ImportStatusType,
    IntentFilterNameType,
    IntentFilterOperatorType,
    IntentSortAttributeType,
    MergeStrategyType,
    ObfuscationSettingTypeType,
    SlotConstraintType,
    SlotFilterNameType,
    SlotFilterOperatorType,
    SlotSortAttributeType,
    SlotTypeFilterNameType,
    SlotTypeFilterOperatorType,
    SlotTypeSortAttributeType,
    SlotValueResolutionStrategyType,
    SortOrderType,
    TimeDimensionType,
    ServiceName,
    WaiterName,
)

def check_value(value: AggregatedUtterancesFilterNameType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_lexv2_models.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_lexv2_models.type_defs import (
    AggregatedUtterancesFilterTypeDef,
    AggregatedUtterancesSortByTypeDef,
    AggregatedUtterancesSummaryTypeDef,
    AudioLogDestinationTypeDef,
    AudioLogSettingTypeDef,
    BotAliasHistoryEventTypeDef,
    BotAliasLocaleSettingsTypeDef,
    BotAliasSummaryTypeDef,
    BotExportSpecificationTypeDef,
    BotFilterTypeDef,
    BotImportSpecificationTypeDef,
    BotLocaleExportSpecificationTypeDef,
    BotLocaleFilterTypeDef,
    BotLocaleHistoryEventTypeDef,
    BotLocaleImportSpecificationTypeDef,
    BotLocaleSortByTypeDef,
    BotLocaleSummaryTypeDef,
    BotSortByTypeDef,
    BotSummaryTypeDef,
    BotVersionLocaleDetailsTypeDef,
    BotVersionSortByTypeDef,
    BotVersionSummaryTypeDef,
    BuildBotLocaleRequestRequestTypeDef,
    BuildBotLocaleResponseTypeDef,
    BuiltInIntentSortByTypeDef,
    BuiltInIntentSummaryTypeDef,
    BuiltInSlotTypeSortByTypeDef,
    BuiltInSlotTypeSummaryTypeDef,
    ButtonTypeDef,
    CloudWatchLogGroupLogDestinationTypeDef,
    CodeHookSpecificationTypeDef,
    ConversationLogSettingsTypeDef,
    CreateBotAliasRequestRequestTypeDef,
    CreateBotAliasResponseTypeDef,
    CreateBotLocaleRequestRequestTypeDef,
    CreateBotLocaleResponseTypeDef,
    CreateBotRequestRequestTypeDef,
    CreateBotResponseTypeDef,
    CreateBotVersionRequestRequestTypeDef,
    CreateBotVersionResponseTypeDef,
    CreateExportRequestRequestTypeDef,
    CreateExportResponseTypeDef,
    CreateIntentRequestRequestTypeDef,
    CreateIntentResponseTypeDef,
    CreateResourcePolicyRequestRequestTypeDef,
    CreateResourcePolicyResponseTypeDef,
    CreateResourcePolicyStatementRequestRequestTypeDef,
    CreateResourcePolicyStatementResponseTypeDef,
    CreateSlotRequestRequestTypeDef,
    CreateSlotResponseTypeDef,
    CreateSlotTypeRequestRequestTypeDef,
    CreateSlotTypeResponseTypeDef,
    CreateUploadUrlResponseTypeDef,
    CustomPayloadTypeDef,
    DataPrivacyTypeDef,
    DeleteBotAliasRequestRequestTypeDef,
    DeleteBotAliasResponseTypeDef,
    DeleteBotLocaleRequestRequestTypeDef,
    DeleteBotLocaleResponseTypeDef,
    DeleteBotRequestRequestTypeDef,
    DeleteBotResponseTypeDef,
    DeleteBotVersionRequestRequestTypeDef,
    DeleteBotVersionResponseTypeDef,
    DeleteExportRequestRequestTypeDef,
    DeleteExportResponseTypeDef,
    DeleteImportRequestRequestTypeDef,
    DeleteImportResponseTypeDef,
    DeleteIntentRequestRequestTypeDef,
    DeleteResourcePolicyRequestRequestTypeDef,
    DeleteResourcePolicyResponseTypeDef,
    DeleteResourcePolicyStatementRequestRequestTypeDef,
    DeleteResourcePolicyStatementResponseTypeDef,
    DeleteSlotRequestRequestTypeDef,
    DeleteSlotTypeRequestRequestTypeDef,
    DeleteUtterancesRequestRequestTypeDef,
    DescribeBotAliasRequestRequestTypeDef,
    DescribeBotAliasResponseTypeDef,
    DescribeBotLocaleRequestRequestTypeDef,
    DescribeBotLocaleResponseTypeDef,
    DescribeBotRequestRequestTypeDef,
    DescribeBotResponseTypeDef,
    DescribeBotVersionRequestRequestTypeDef,
    DescribeBotVersionResponseTypeDef,
    DescribeExportRequestRequestTypeDef,
    DescribeExportResponseTypeDef,
    DescribeImportRequestRequestTypeDef,
    DescribeImportResponseTypeDef,
    DescribeIntentRequestRequestTypeDef,
    DescribeIntentResponseTypeDef,
    DescribeResourcePolicyRequestRequestTypeDef,
    DescribeResourcePolicyResponseTypeDef,
    DescribeSlotRequestRequestTypeDef,
    DescribeSlotResponseTypeDef,
    DescribeSlotTypeRequestRequestTypeDef,
    DescribeSlotTypeResponseTypeDef,
    DialogCodeHookSettingsTypeDef,
    ExportFilterTypeDef,
    ExportResourceSpecificationTypeDef,
    ExportSortByTypeDef,
    ExportSummaryTypeDef,
    FulfillmentCodeHookSettingsTypeDef,
    ImageResponseCardTypeDef,
    ImportFilterTypeDef,
    ImportResourceSpecificationTypeDef,
    ImportSortByTypeDef,
    ImportSummaryTypeDef,
    InputContextTypeDef,
    IntentClosingSettingTypeDef,
    IntentConfirmationSettingTypeDef,
    IntentFilterTypeDef,
    IntentSortByTypeDef,
    IntentSummaryTypeDef,
    KendraConfigurationTypeDef,
    LambdaCodeHookTypeDef,
    ListAggregatedUtterancesRequestRequestTypeDef,
    ListAggregatedUtterancesResponseTypeDef,
    ListBotAliasesRequestRequestTypeDef,
    ListBotAliasesResponseTypeDef,
    ListBotLocalesRequestRequestTypeDef,
    ListBotLocalesResponseTypeDef,
    ListBotVersionsRequestRequestTypeDef,
    ListBotVersionsResponseTypeDef,
    ListBotsRequestRequestTypeDef,
    ListBotsResponseTypeDef,
    ListBuiltInIntentsRequestRequestTypeDef,
    ListBuiltInIntentsResponseTypeDef,
    ListBuiltInSlotTypesRequestRequestTypeDef,
    ListBuiltInSlotTypesResponseTypeDef,
    ListExportsRequestRequestTypeDef,
    ListExportsResponseTypeDef,
    ListImportsRequestRequestTypeDef,
    ListImportsResponseTypeDef,
    ListIntentsRequestRequestTypeDef,
    ListIntentsResponseTypeDef,
    ListSlotTypesRequestRequestTypeDef,
    ListSlotTypesResponseTypeDef,
    ListSlotsRequestRequestTypeDef,
    ListSlotsResponseTypeDef,
    ListTagsForResourceRequestRequestTypeDef,
    ListTagsForResourceResponseTypeDef,
    MessageGroupTypeDef,
    MessageTypeDef,
    MultipleValuesSettingTypeDef,
    ObfuscationSettingTypeDef,
    OutputContextTypeDef,
    PlainTextMessageTypeDef,
    PrincipalTypeDef,
    PromptSpecificationTypeDef,
    RelativeAggregationDurationTypeDef,
    ResponseMetadataTypeDef,
    ResponseSpecificationTypeDef,
    S3BucketLogDestinationTypeDef,
    SSMLMessageTypeDef,
    SampleUtteranceTypeDef,
    SampleValueTypeDef,
    SentimentAnalysisSettingsTypeDef,
    SlotDefaultValueSpecificationTypeDef,
    SlotDefaultValueTypeDef,
    SlotFilterTypeDef,
    SlotPriorityTypeDef,
    SlotSortByTypeDef,
    SlotSummaryTypeDef,
    SlotTypeFilterTypeDef,
    SlotTypeSortByTypeDef,
    SlotTypeSummaryTypeDef,
    SlotTypeValueTypeDef,
    SlotValueElicitationSettingTypeDef,
    SlotValueRegexFilterTypeDef,
    SlotValueSelectionSettingTypeDef,
    StartImportRequestRequestTypeDef,
    StartImportResponseTypeDef,
    StillWaitingResponseSpecificationTypeDef,
    TagResourceRequestRequestTypeDef,
    TextLogDestinationTypeDef,
    TextLogSettingTypeDef,
    UntagResourceRequestRequestTypeDef,
    UpdateBotAliasRequestRequestTypeDef,
    UpdateBotAliasResponseTypeDef,
    UpdateBotLocaleRequestRequestTypeDef,
    UpdateBotLocaleResponseTypeDef,
    UpdateBotRequestRequestTypeDef,
    UpdateBotResponseTypeDef,
    UpdateExportRequestRequestTypeDef,
    UpdateExportResponseTypeDef,
    UpdateIntentRequestRequestTypeDef,
    UpdateIntentResponseTypeDef,
    UpdateResourcePolicyRequestRequestTypeDef,
    UpdateResourcePolicyResponseTypeDef,
    UpdateSlotRequestRequestTypeDef,
    UpdateSlotResponseTypeDef,
    UpdateSlotTypeRequestRequestTypeDef,
    UpdateSlotTypeResponseTypeDef,
    UtteranceAggregationDurationTypeDef,
    VoiceSettingsTypeDef,
    WaitAndContinueSpecificationTypeDef,
    WaiterConfigTypeDef,
)

def get_structure() -> AggregatedUtterancesFilterTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-lexv2-models` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-lexv2-models docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_lexv2_models/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
