# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    The version of the OpenAPI document: 1.1.92
    Contact: info@finbourne.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from lusid.api_client import ApiClient
from lusid.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from lusid.models.compliance_rule_response import ComplianceRuleResponse
from lusid.models.compliance_rule_result_v2 import ComplianceRuleResultV2
from lusid.models.compliance_run_info_v2 import ComplianceRunInfoV2
from lusid.models.compliance_template import ComplianceTemplate
from lusid.models.decorated_compliance_run_summary import DecoratedComplianceRunSummary
from lusid.models.deleted_entity_response import DeletedEntityResponse
from lusid.models.lusid_problem_details import LusidProblemDetails
from lusid.models.lusid_validation_problem_details import LusidValidationProblemDetails
from lusid.models.paged_resource_list_of_compliance_rule_response import PagedResourceListOfComplianceRuleResponse
from lusid.models.paged_resource_list_of_compliance_run_info_v2 import PagedResourceListOfComplianceRunInfoV2
from lusid.models.paged_resource_list_of_compliance_template import PagedResourceListOfComplianceTemplate
from lusid.models.upsert_compliance_rule_request import UpsertComplianceRuleRequest
from lusid.models.upsert_compliance_run_summary_request import UpsertComplianceRunSummaryRequest
from lusid.models.upsert_compliance_run_summary_result import UpsertComplianceRunSummaryResult


class ComplianceApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_compliance_rule(self, scope, code, **kwargs):  # noqa: E501
        """[EARLY ACCESS] DeleteComplianceRule: Delete compliance rule.  # noqa: E501

        Use this endpoint to delete a compliance rule. The rule will be recoverable for asat times earlier than the  delete time, but will otherwise appear to have never existed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_compliance_rule(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: The compliance rule's scope. (required)
        :type scope: str
        :param code: The compliance rule's code. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeletedEntityResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_compliance_rule_with_http_info(scope, code, **kwargs)  # noqa: E501

    def delete_compliance_rule_with_http_info(self, scope, code, **kwargs):  # noqa: E501
        """[EARLY ACCESS] DeleteComplianceRule: Delete compliance rule.  # noqa: E501

        Use this endpoint to delete a compliance rule. The rule will be recoverable for asat times earlier than the  delete time, but will otherwise appear to have never existed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_compliance_rule_with_http_info(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: The compliance rule's scope. (required)
        :type scope: str
        :param code: The compliance rule's code. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (DeletedEntityResponse, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'scope',
            'code'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_compliance_rule" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'scope' is set
        if self.api_client.client_side_validation and ('scope' not in local_var_params or  # noqa: E501
                                                        local_var_params['scope'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `scope` when calling `delete_compliance_rule`")  # noqa: E501
        # verify the required parameter 'code' is set
        if self.api_client.client_side_validation and ('code' not in local_var_params or  # noqa: E501
                                                        local_var_params['code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `code` when calling `delete_compliance_rule`")  # noqa: E501

        if self.api_client.client_side_validation and ('scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['scope']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `delete_compliance_rule`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['scope']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `delete_compliance_rule`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'scope' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `delete_compliance_rule`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('code' in local_var_params and  # noqa: E501
                                                        len(local_var_params['code']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `delete_compliance_rule`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('code' in local_var_params and  # noqa: E501
                                                        len(local_var_params['code']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `delete_compliance_rule`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'code' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `delete_compliance_rule`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'scope' in local_var_params:
            path_params['scope'] = local_var_params['scope']  # noqa: E501
        if 'code' in local_var_params:
            path_params['code'] = local_var_params['code']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '1.1.92'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "DeletedEntityResponse",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/compliance/rules/{scope}/{code}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_compliance_rule(self, scope, code, **kwargs):  # noqa: E501
        """[EARLY ACCESS] GetComplianceRule: Get compliance rule.  # noqa: E501

        Use this endpoint to retrieve a single compliance rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_compliance_rule(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: The compliance rule's scope. (required)
        :type scope: str
        :param code: The compliance rule's code. (required)
        :type code: str
        :param as_at: Optional. Asat time for query.
        :type as_at: datetime
        :param property_keys: A list of property keys from the 'Compliance' domain to decorate onto the rule.              These must take the format {domain}/{scope}/{code}, for example 'Compliance/live/UCITS'.
        :type property_keys: list[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ComplianceRuleResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.get_compliance_rule_with_http_info(scope, code, **kwargs)  # noqa: E501

    def get_compliance_rule_with_http_info(self, scope, code, **kwargs):  # noqa: E501
        """[EARLY ACCESS] GetComplianceRule: Get compliance rule.  # noqa: E501

        Use this endpoint to retrieve a single compliance rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_compliance_rule_with_http_info(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: The compliance rule's scope. (required)
        :type scope: str
        :param code: The compliance rule's code. (required)
        :type code: str
        :param as_at: Optional. Asat time for query.
        :type as_at: datetime
        :param property_keys: A list of property keys from the 'Compliance' domain to decorate onto the rule.              These must take the format {domain}/{scope}/{code}, for example 'Compliance/live/UCITS'.
        :type property_keys: list[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (ComplianceRuleResponse, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'scope',
            'code',
            'as_at',
            'property_keys'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_compliance_rule" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'scope' is set
        if self.api_client.client_side_validation and ('scope' not in local_var_params or  # noqa: E501
                                                        local_var_params['scope'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `scope` when calling `get_compliance_rule`")  # noqa: E501
        # verify the required parameter 'code' is set
        if self.api_client.client_side_validation and ('code' not in local_var_params or  # noqa: E501
                                                        local_var_params['code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `code` when calling `get_compliance_rule`")  # noqa: E501

        if self.api_client.client_side_validation and ('scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['scope']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `get_compliance_rule`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['scope']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `get_compliance_rule`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'scope' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `get_compliance_rule`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('code' in local_var_params and  # noqa: E501
                                                        len(local_var_params['code']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `get_compliance_rule`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('code' in local_var_params and  # noqa: E501
                                                        len(local_var_params['code']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `get_compliance_rule`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'code' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `get_compliance_rule`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'scope' in local_var_params:
            path_params['scope'] = local_var_params['scope']  # noqa: E501
        if 'code' in local_var_params:
            path_params['code'] = local_var_params['code']  # noqa: E501

        query_params = []
        if 'as_at' in local_var_params and local_var_params['as_at'] is not None:  # noqa: E501
            query_params.append(('asAt', local_var_params['as_at']))  # noqa: E501
        if 'property_keys' in local_var_params and local_var_params['property_keys'] is not None:  # noqa: E501
            query_params.append(('propertyKeys', local_var_params['property_keys']))  # noqa: E501
            collection_formats['propertyKeys'] = 'multi'  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '1.1.92'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "ComplianceRuleResponse",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/compliance/rules/{scope}/{code}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_compliance_rule_result(self, run_scope, run_code, rule_scope, rule_code, **kwargs):  # noqa: E501
        """[EARLY ACCESS] GetComplianceRuleResult: Get detailed results for a specific rule within a compliance run.  # noqa: E501

        Specify a run scope and code from a previously run compliance check, and the scope and code of a rule within that run, to get detailed results for that rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_compliance_rule_result(run_scope, run_code, rule_scope, rule_code, async_req=True)
        >>> result = thread.get()

        :param run_scope: Required: Run Scope. (required)
        :type run_scope: str
        :param run_code: Required: Run Code. (required)
        :type run_code: str
        :param rule_scope: Required: Rule Scope. (required)
        :type rule_scope: str
        :param rule_code: Required: Rule Code. (required)
        :type rule_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ComplianceRuleResultV2
        """
        kwargs['_return_http_data_only'] = True
        return self.get_compliance_rule_result_with_http_info(run_scope, run_code, rule_scope, rule_code, **kwargs)  # noqa: E501

    def get_compliance_rule_result_with_http_info(self, run_scope, run_code, rule_scope, rule_code, **kwargs):  # noqa: E501
        """[EARLY ACCESS] GetComplianceRuleResult: Get detailed results for a specific rule within a compliance run.  # noqa: E501

        Specify a run scope and code from a previously run compliance check, and the scope and code of a rule within that run, to get detailed results for that rule.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_compliance_rule_result_with_http_info(run_scope, run_code, rule_scope, rule_code, async_req=True)
        >>> result = thread.get()

        :param run_scope: Required: Run Scope. (required)
        :type run_scope: str
        :param run_code: Required: Run Code. (required)
        :type run_code: str
        :param rule_scope: Required: Rule Scope. (required)
        :type rule_scope: str
        :param rule_code: Required: Rule Code. (required)
        :type rule_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (ComplianceRuleResultV2, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'run_scope',
            'run_code',
            'rule_scope',
            'rule_code'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_compliance_rule_result" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'run_scope' is set
        if self.api_client.client_side_validation and ('run_scope' not in local_var_params or  # noqa: E501
                                                        local_var_params['run_scope'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `run_scope` when calling `get_compliance_rule_result`")  # noqa: E501
        # verify the required parameter 'run_code' is set
        if self.api_client.client_side_validation and ('run_code' not in local_var_params or  # noqa: E501
                                                        local_var_params['run_code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `run_code` when calling `get_compliance_rule_result`")  # noqa: E501
        # verify the required parameter 'rule_scope' is set
        if self.api_client.client_side_validation and ('rule_scope' not in local_var_params or  # noqa: E501
                                                        local_var_params['rule_scope'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `rule_scope` when calling `get_compliance_rule_result`")  # noqa: E501
        # verify the required parameter 'rule_code' is set
        if self.api_client.client_side_validation and ('rule_code' not in local_var_params or  # noqa: E501
                                                        local_var_params['rule_code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `rule_code` when calling `get_compliance_rule_result`")  # noqa: E501

        if self.api_client.client_side_validation and ('run_scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['run_scope']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `run_scope` when calling `get_compliance_rule_result`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('run_scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['run_scope']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `run_scope` when calling `get_compliance_rule_result`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'run_scope' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['run_scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `run_scope` when calling `get_compliance_rule_result`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('run_code' in local_var_params and  # noqa: E501
                                                        len(local_var_params['run_code']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `run_code` when calling `get_compliance_rule_result`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('run_code' in local_var_params and  # noqa: E501
                                                        len(local_var_params['run_code']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `run_code` when calling `get_compliance_rule_result`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'run_code' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['run_code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `run_code` when calling `get_compliance_rule_result`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('rule_scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['rule_scope']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `rule_scope` when calling `get_compliance_rule_result`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('rule_scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['rule_scope']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `rule_scope` when calling `get_compliance_rule_result`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'rule_scope' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['rule_scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `rule_scope` when calling `get_compliance_rule_result`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('rule_code' in local_var_params and  # noqa: E501
                                                        len(local_var_params['rule_code']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `rule_code` when calling `get_compliance_rule_result`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('rule_code' in local_var_params and  # noqa: E501
                                                        len(local_var_params['rule_code']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `rule_code` when calling `get_compliance_rule_result`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'rule_code' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['rule_code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `rule_code` when calling `get_compliance_rule_result`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'run_scope' in local_var_params:
            path_params['runScope'] = local_var_params['run_scope']  # noqa: E501
        if 'run_code' in local_var_params:
            path_params['runCode'] = local_var_params['run_code']  # noqa: E501
        if 'rule_scope' in local_var_params:
            path_params['ruleScope'] = local_var_params['rule_scope']  # noqa: E501
        if 'rule_code' in local_var_params:
            path_params['ruleCode'] = local_var_params['rule_code']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '1.1.92'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "ComplianceRuleResultV2",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/compliance/runs/summary/{runScope}/{runCode}/{ruleScope}/{ruleCode}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_compliance_template(self, scope, code, **kwargs):  # noqa: E501
        """[EARLY ACCESS] GetComplianceTemplate: Get the requested compliance template.  # noqa: E501

        Use this endpoint to fetch a specific compliance template.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_compliance_template(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: Scope of TemplateID (required)
        :type scope: str
        :param code: Code of TemplateID (required)
        :type code: str
        :param as_at: Optional. The time at which to get results from. Default : latest
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ComplianceTemplate
        """
        kwargs['_return_http_data_only'] = True
        return self.get_compliance_template_with_http_info(scope, code, **kwargs)  # noqa: E501

    def get_compliance_template_with_http_info(self, scope, code, **kwargs):  # noqa: E501
        """[EARLY ACCESS] GetComplianceTemplate: Get the requested compliance template.  # noqa: E501

        Use this endpoint to fetch a specific compliance template.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_compliance_template_with_http_info(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: Scope of TemplateID (required)
        :type scope: str
        :param code: Code of TemplateID (required)
        :type code: str
        :param as_at: Optional. The time at which to get results from. Default : latest
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (ComplianceTemplate, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'scope',
            'code',
            'as_at'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_compliance_template" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'scope' is set
        if self.api_client.client_side_validation and ('scope' not in local_var_params or  # noqa: E501
                                                        local_var_params['scope'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `scope` when calling `get_compliance_template`")  # noqa: E501
        # verify the required parameter 'code' is set
        if self.api_client.client_side_validation and ('code' not in local_var_params or  # noqa: E501
                                                        local_var_params['code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `code` when calling `get_compliance_template`")  # noqa: E501

        if self.api_client.client_side_validation and ('scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['scope']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `get_compliance_template`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['scope']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `get_compliance_template`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'scope' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `get_compliance_template`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('code' in local_var_params and  # noqa: E501
                                                        len(local_var_params['code']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `get_compliance_template`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('code' in local_var_params and  # noqa: E501
                                                        len(local_var_params['code']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `get_compliance_template`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'code' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `get_compliance_template`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'scope' in local_var_params:
            path_params['scope'] = local_var_params['scope']  # noqa: E501
        if 'code' in local_var_params:
            path_params['code'] = local_var_params['code']  # noqa: E501

        query_params = []
        if 'as_at' in local_var_params and local_var_params['as_at'] is not None:  # noqa: E501
            query_params.append(('asAt', local_var_params['as_at']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '1.1.92'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "ComplianceTemplate",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/compliance/templates/{scope}/{code}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_decorated_compliance_run_summary(self, scope, code, **kwargs):  # noqa: E501
        """[EARLY ACCESS] GetDecoratedComplianceRunSummary: Get decorated summary results for a specific compliance run.  # noqa: E501

        Specify a run scope and code from a previously run compliance check to get an overview of result details.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_decorated_compliance_run_summary(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: Required: Run Scope. (required)
        :type scope: str
        :param code: Required: Run Code. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DecoratedComplianceRunSummary
        """
        kwargs['_return_http_data_only'] = True
        return self.get_decorated_compliance_run_summary_with_http_info(scope, code, **kwargs)  # noqa: E501

    def get_decorated_compliance_run_summary_with_http_info(self, scope, code, **kwargs):  # noqa: E501
        """[EARLY ACCESS] GetDecoratedComplianceRunSummary: Get decorated summary results for a specific compliance run.  # noqa: E501

        Specify a run scope and code from a previously run compliance check to get an overview of result details.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_decorated_compliance_run_summary_with_http_info(scope, code, async_req=True)
        >>> result = thread.get()

        :param scope: Required: Run Scope. (required)
        :type scope: str
        :param code: Required: Run Code. (required)
        :type code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (DecoratedComplianceRunSummary, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'scope',
            'code'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_decorated_compliance_run_summary" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'scope' is set
        if self.api_client.client_side_validation and ('scope' not in local_var_params or  # noqa: E501
                                                        local_var_params['scope'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `scope` when calling `get_decorated_compliance_run_summary`")  # noqa: E501
        # verify the required parameter 'code' is set
        if self.api_client.client_side_validation and ('code' not in local_var_params or  # noqa: E501
                                                        local_var_params['code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `code` when calling `get_decorated_compliance_run_summary`")  # noqa: E501

        if self.api_client.client_side_validation and ('scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['scope']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `get_decorated_compliance_run_summary`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['scope']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `get_decorated_compliance_run_summary`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'scope' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `scope` when calling `get_decorated_compliance_run_summary`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('code' in local_var_params and  # noqa: E501
                                                        len(local_var_params['code']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `get_decorated_compliance_run_summary`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('code' in local_var_params and  # noqa: E501
                                                        len(local_var_params['code']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `get_decorated_compliance_run_summary`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'code' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `code` when calling `get_decorated_compliance_run_summary`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'scope' in local_var_params:
            path_params['scope'] = local_var_params['scope']  # noqa: E501
        if 'code' in local_var_params:
            path_params['code'] = local_var_params['code']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '1.1.92'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "DecoratedComplianceRunSummary",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/compliance/runs/summary/{scope}/{code}/$decorate', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def list_compliance_rules(self, **kwargs):  # noqa: E501
        """[EARLY ACCESS] ListComplianceRules: List compliance rules.  # noqa: E501

        Use this endpoint to retrieve all compliance rules, or a subset defined by an optional filter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_compliance_rules(async_req=True)
        >>> result = thread.get()

        :param as_at: Optional. Asat time.
        :type as_at: datetime
        :param page: Optional. Pagination token.
        :type page: str
        :param limit: Optional. Entries per page.
        :type limit: int
        :param filter: Optional. Filter.
        :type filter: str
        :param property_keys: A list of property keys from the 'Compliance' domain to decorate onto each rule.              These must take the format {domain}/{scope}/{code}, for example 'Compliance/live/UCITS'. If not provided will return all the entitled properties for each rule.
        :type property_keys: list[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfComplianceRuleResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.list_compliance_rules_with_http_info(**kwargs)  # noqa: E501

    def list_compliance_rules_with_http_info(self, **kwargs):  # noqa: E501
        """[EARLY ACCESS] ListComplianceRules: List compliance rules.  # noqa: E501

        Use this endpoint to retrieve all compliance rules, or a subset defined by an optional filter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_compliance_rules_with_http_info(async_req=True)
        >>> result = thread.get()

        :param as_at: Optional. Asat time.
        :type as_at: datetime
        :param page: Optional. Pagination token.
        :type page: str
        :param limit: Optional. Entries per page.
        :type limit: int
        :param filter: Optional. Filter.
        :type filter: str
        :param property_keys: A list of property keys from the 'Compliance' domain to decorate onto each rule.              These must take the format {domain}/{scope}/{code}, for example 'Compliance/live/UCITS'. If not provided will return all the entitled properties for each rule.
        :type property_keys: list[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (PagedResourceListOfComplianceRuleResponse, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'as_at',
            'page',
            'limit',
            'filter',
            'property_keys'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_compliance_rules" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and ('page' in local_var_params and  # noqa: E501
                                                        len(local_var_params['page']) > 500):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page` when calling `list_compliance_rules`, length must be less than or equal to `500`")  # noqa: E501
        if self.api_client.client_side_validation and ('page' in local_var_params and  # noqa: E501
                                                        len(local_var_params['page']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page` when calling `list_compliance_rules`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'page' in local_var_params and not re.search(r'^[a-zA-Z0-9\+\/]*={0,3}$', local_var_params['page']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page` when calling `list_compliance_rules`, must conform to the pattern `/^[a-zA-Z0-9\+\/]*={0,3}$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] > 5000:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `list_compliance_rules`, must be a value less than or equal to `5000`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `list_compliance_rules`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and ('filter' in local_var_params and  # noqa: E501
                                                        len(local_var_params['filter']) > 16384):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `list_compliance_rules`, length must be less than or equal to `16384`")  # noqa: E501
        if self.api_client.client_side_validation and ('filter' in local_var_params and  # noqa: E501
                                                        len(local_var_params['filter']) < 0):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `list_compliance_rules`, length must be greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'filter' in local_var_params and not re.search(r'^[\s\S]*$', local_var_params['filter']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `list_compliance_rules`, must conform to the pattern `/^[\s\S]*$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'as_at' in local_var_params and local_var_params['as_at'] is not None:  # noqa: E501
            query_params.append(('asAt', local_var_params['as_at']))  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'filter' in local_var_params and local_var_params['filter'] is not None:  # noqa: E501
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501
        if 'property_keys' in local_var_params and local_var_params['property_keys'] is not None:  # noqa: E501
            query_params.append(('propertyKeys', local_var_params['property_keys']))  # noqa: E501
            collection_formats['propertyKeys'] = 'multi'  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '1.1.92'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "PagedResourceListOfComplianceRuleResponse",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/compliance/rules', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def list_compliance_runs(self, **kwargs):  # noqa: E501
        """[EARLY ACCESS] ListComplianceRuns: List historical compliance run identifiers.  # noqa: E501

        Lists RunIds of prior compliance runs, or a subset with a filter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_compliance_runs(async_req=True)
        >>> result = thread.get()

        :param as_at: Optional. The time at which to get results from. Default : latest
        :type as_at: datetime
        :param page: Optional. The pagination token to use to continue listing compliance runs from a previous call to list compliance runs.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, and asAt fields              must not have changed since the original request.
        :type page: str
        :param limit: Optional. When paginating, limit the number of returned results to this many.
        :type limit: int
        :param filter: Optional. Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param sort_by: Optional. A list of field names to sort by, each suffixed by \"ASC\" or \"DESC\"
        :type sort_by: list[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfComplianceRunInfoV2
        """
        kwargs['_return_http_data_only'] = True
        return self.list_compliance_runs_with_http_info(**kwargs)  # noqa: E501

    def list_compliance_runs_with_http_info(self, **kwargs):  # noqa: E501
        """[EARLY ACCESS] ListComplianceRuns: List historical compliance run identifiers.  # noqa: E501

        Lists RunIds of prior compliance runs, or a subset with a filter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_compliance_runs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param as_at: Optional. The time at which to get results from. Default : latest
        :type as_at: datetime
        :param page: Optional. The pagination token to use to continue listing compliance runs from a previous call to list compliance runs.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, and asAt fields              must not have changed since the original request.
        :type page: str
        :param limit: Optional. When paginating, limit the number of returned results to this many.
        :type limit: int
        :param filter: Optional. Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param sort_by: Optional. A list of field names to sort by, each suffixed by \"ASC\" or \"DESC\"
        :type sort_by: list[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (PagedResourceListOfComplianceRunInfoV2, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'as_at',
            'page',
            'limit',
            'filter',
            'sort_by'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_compliance_runs" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and ('page' in local_var_params and  # noqa: E501
                                                        len(local_var_params['page']) > 500):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page` when calling `list_compliance_runs`, length must be less than or equal to `500`")  # noqa: E501
        if self.api_client.client_side_validation and ('page' in local_var_params and  # noqa: E501
                                                        len(local_var_params['page']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page` when calling `list_compliance_runs`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'page' in local_var_params and not re.search(r'^[a-zA-Z0-9\+\/]*={0,3}$', local_var_params['page']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page` when calling `list_compliance_runs`, must conform to the pattern `/^[a-zA-Z0-9\+\/]*={0,3}$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] > 5000:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `list_compliance_runs`, must be a value less than or equal to `5000`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `list_compliance_runs`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and ('filter' in local_var_params and  # noqa: E501
                                                        len(local_var_params['filter']) > 16384):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `list_compliance_runs`, length must be less than or equal to `16384`")  # noqa: E501
        if self.api_client.client_side_validation and ('filter' in local_var_params and  # noqa: E501
                                                        len(local_var_params['filter']) < 0):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `list_compliance_runs`, length must be greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'filter' in local_var_params and not re.search(r'^[\s\S]*$', local_var_params['filter']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `list_compliance_runs`, must conform to the pattern `/^[\s\S]*$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'as_at' in local_var_params and local_var_params['as_at'] is not None:  # noqa: E501
            query_params.append(('asAt', local_var_params['as_at']))  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'filter' in local_var_params and local_var_params['filter'] is not None:  # noqa: E501
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501
        if 'sort_by' in local_var_params and local_var_params['sort_by'] is not None:  # noqa: E501
            query_params.append(('sortBy', local_var_params['sort_by']))  # noqa: E501
            collection_formats['sortBy'] = 'multi'  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '1.1.92'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "PagedResourceListOfComplianceRunInfoV2",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/compliance/runs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def list_compliance_templates(self, **kwargs):  # noqa: E501
        """[EARLY ACCESS] ListComplianceTemplates: List compliance templates.  # noqa: E501

        Use this endpoint to fetch a list of all available compliance template ids, or a subset using a filter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_compliance_templates(async_req=True)
        >>> result = thread.get()

        :param as_at: Optional. The time at which to get results from. Default : latest
        :type as_at: datetime
        :param page: Optional. The pagination token to use to continue listing compliance runs from a previous call to list compliance runs.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, and asAt fields              must not have changed since the original request.
        :type page: str
        :param limit: Optional. When paginating, limit the number of returned results to this many.
        :type limit: int
        :param filter: Optional. Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfComplianceTemplate
        """
        kwargs['_return_http_data_only'] = True
        return self.list_compliance_templates_with_http_info(**kwargs)  # noqa: E501

    def list_compliance_templates_with_http_info(self, **kwargs):  # noqa: E501
        """[EARLY ACCESS] ListComplianceTemplates: List compliance templates.  # noqa: E501

        Use this endpoint to fetch a list of all available compliance template ids, or a subset using a filter.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_compliance_templates_with_http_info(async_req=True)
        >>> result = thread.get()

        :param as_at: Optional. The time at which to get results from. Default : latest
        :type as_at: datetime
        :param page: Optional. The pagination token to use to continue listing compliance runs from a previous call to list compliance runs.              This value is returned from the previous call. If a pagination token is provided the sortBy, filter, and asAt fields              must not have changed since the original request.
        :type page: str
        :param limit: Optional. When paginating, limit the number of returned results to this many.
        :type limit: int
        :param filter: Optional. Expression to filter the result set. Read more about filtering results from LUSID here https://support.lusid.com/filtering-results-from-lusid.
        :type filter: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (PagedResourceListOfComplianceTemplate, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'as_at',
            'page',
            'limit',
            'filter'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_compliance_templates" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and ('page' in local_var_params and  # noqa: E501
                                                        len(local_var_params['page']) > 500):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page` when calling `list_compliance_templates`, length must be less than or equal to `500`")  # noqa: E501
        if self.api_client.client_side_validation and ('page' in local_var_params and  # noqa: E501
                                                        len(local_var_params['page']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page` when calling `list_compliance_templates`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'page' in local_var_params and not re.search(r'^[a-zA-Z0-9\+\/]*={0,3}$', local_var_params['page']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page` when calling `list_compliance_templates`, must conform to the pattern `/^[a-zA-Z0-9\+\/]*={0,3}$/`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] > 5000:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `list_compliance_templates`, must be a value less than or equal to `5000`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `list_compliance_templates`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and ('filter' in local_var_params and  # noqa: E501
                                                        len(local_var_params['filter']) > 16384):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `list_compliance_templates`, length must be less than or equal to `16384`")  # noqa: E501
        if self.api_client.client_side_validation and ('filter' in local_var_params and  # noqa: E501
                                                        len(local_var_params['filter']) < 0):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `list_compliance_templates`, length must be greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'filter' in local_var_params and not re.search(r'^[\s\S]*$', local_var_params['filter']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `list_compliance_templates`, must conform to the pattern `/^[\s\S]*$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'as_at' in local_var_params and local_var_params['as_at'] is not None:  # noqa: E501
            query_params.append(('asAt', local_var_params['as_at']))  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'filter' in local_var_params and local_var_params['filter'] is not None:  # noqa: E501
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '1.1.92'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "PagedResourceListOfComplianceTemplate",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/compliance/templates', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def run_compliance(self, run_scope, rule_scope, is_pre_trade, recipe_id_scope, recipe_id_code, **kwargs):  # noqa: E501
        """[EARLY ACCESS] RunCompliance: Run a compliance check.  # noqa: E501

        Use this endpoint to run a compliance check using rules from a specific scope.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.run_compliance(run_scope, rule_scope, is_pre_trade, recipe_id_scope, recipe_id_code, async_req=True)
        >>> result = thread.get()

        :param run_scope: Required: Scope to save the run results in. (required)
        :type run_scope: str
        :param rule_scope: Required: Scope from which to select rules to be run. (required)
        :type rule_scope: str
        :param is_pre_trade: Required: Boolean flag indicating if a run should be PreTrade (Including orders). For post-trade only, set to false (required)
        :type is_pre_trade: bool
        :param recipe_id_scope: Required: the scope of the recipe to be used (required)
        :type recipe_id_scope: str
        :param recipe_id_code: Required: The code of the recipe to be used. If left blank, the default recipe will be used. (required)
        :type recipe_id_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ComplianceRunInfoV2
        """
        kwargs['_return_http_data_only'] = True
        return self.run_compliance_with_http_info(run_scope, rule_scope, is_pre_trade, recipe_id_scope, recipe_id_code, **kwargs)  # noqa: E501

    def run_compliance_with_http_info(self, run_scope, rule_scope, is_pre_trade, recipe_id_scope, recipe_id_code, **kwargs):  # noqa: E501
        """[EARLY ACCESS] RunCompliance: Run a compliance check.  # noqa: E501

        Use this endpoint to run a compliance check using rules from a specific scope.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.run_compliance_with_http_info(run_scope, rule_scope, is_pre_trade, recipe_id_scope, recipe_id_code, async_req=True)
        >>> result = thread.get()

        :param run_scope: Required: Scope to save the run results in. (required)
        :type run_scope: str
        :param rule_scope: Required: Scope from which to select rules to be run. (required)
        :type rule_scope: str
        :param is_pre_trade: Required: Boolean flag indicating if a run should be PreTrade (Including orders). For post-trade only, set to false (required)
        :type is_pre_trade: bool
        :param recipe_id_scope: Required: the scope of the recipe to be used (required)
        :type recipe_id_scope: str
        :param recipe_id_code: Required: The code of the recipe to be used. If left blank, the default recipe will be used. (required)
        :type recipe_id_code: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (ComplianceRunInfoV2, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'run_scope',
            'rule_scope',
            'is_pre_trade',
            'recipe_id_scope',
            'recipe_id_code'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method run_compliance" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'run_scope' is set
        if self.api_client.client_side_validation and ('run_scope' not in local_var_params or  # noqa: E501
                                                        local_var_params['run_scope'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `run_scope` when calling `run_compliance`")  # noqa: E501
        # verify the required parameter 'rule_scope' is set
        if self.api_client.client_side_validation and ('rule_scope' not in local_var_params or  # noqa: E501
                                                        local_var_params['rule_scope'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `rule_scope` when calling `run_compliance`")  # noqa: E501
        # verify the required parameter 'is_pre_trade' is set
        if self.api_client.client_side_validation and ('is_pre_trade' not in local_var_params or  # noqa: E501
                                                        local_var_params['is_pre_trade'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `is_pre_trade` when calling `run_compliance`")  # noqa: E501
        # verify the required parameter 'recipe_id_scope' is set
        if self.api_client.client_side_validation and ('recipe_id_scope' not in local_var_params or  # noqa: E501
                                                        local_var_params['recipe_id_scope'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `recipe_id_scope` when calling `run_compliance`")  # noqa: E501
        # verify the required parameter 'recipe_id_code' is set
        if self.api_client.client_side_validation and ('recipe_id_code' not in local_var_params or  # noqa: E501
                                                        local_var_params['recipe_id_code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `recipe_id_code` when calling `run_compliance`")  # noqa: E501

        if self.api_client.client_side_validation and ('run_scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['run_scope']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `run_scope` when calling `run_compliance`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('run_scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['run_scope']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `run_scope` when calling `run_compliance`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'run_scope' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['run_scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `run_scope` when calling `run_compliance`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('rule_scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['rule_scope']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `rule_scope` when calling `run_compliance`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('rule_scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['rule_scope']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `rule_scope` when calling `run_compliance`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'rule_scope' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['rule_scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `rule_scope` when calling `run_compliance`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('recipe_id_scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['recipe_id_scope']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `recipe_id_scope` when calling `run_compliance`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('recipe_id_scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['recipe_id_scope']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `recipe_id_scope` when calling `run_compliance`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'recipe_id_scope' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['recipe_id_scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `recipe_id_scope` when calling `run_compliance`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('recipe_id_code' in local_var_params and  # noqa: E501
                                                        len(local_var_params['recipe_id_code']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `recipe_id_code` when calling `run_compliance`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('recipe_id_code' in local_var_params and  # noqa: E501
                                                        len(local_var_params['recipe_id_code']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `recipe_id_code` when calling `run_compliance`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'recipe_id_code' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['recipe_id_code']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `recipe_id_code` when calling `run_compliance`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'run_scope' in local_var_params and local_var_params['run_scope'] is not None:  # noqa: E501
            query_params.append(('runScope', local_var_params['run_scope']))  # noqa: E501
        if 'rule_scope' in local_var_params and local_var_params['rule_scope'] is not None:  # noqa: E501
            query_params.append(('ruleScope', local_var_params['rule_scope']))  # noqa: E501
        if 'is_pre_trade' in local_var_params and local_var_params['is_pre_trade'] is not None:  # noqa: E501
            query_params.append(('isPreTrade', local_var_params['is_pre_trade']))  # noqa: E501
        if 'recipe_id_scope' in local_var_params and local_var_params['recipe_id_scope'] is not None:  # noqa: E501
            query_params.append(('recipeIdScope', local_var_params['recipe_id_scope']))  # noqa: E501
        if 'recipe_id_code' in local_var_params and local_var_params['recipe_id_code'] is not None:  # noqa: E501
            query_params.append(('recipeIdCode', local_var_params['recipe_id_code']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '1.1.92'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "ComplianceRunInfoV2",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/compliance/runs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def upsert_compliance_rule(self, **kwargs):  # noqa: E501
        """[EARLY ACCESS] UpsertComplianceRule: Upsert a compliance rule.  # noqa: E501

        Use this endpoint to upsert a single compliance rule. The template and variation specified must already  exist, as must the portfolio group. The parameters passed must match those required by the template variation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_compliance_rule(async_req=True)
        >>> result = thread.get()

        :param upsert_compliance_rule_request:
        :type upsert_compliance_rule_request: UpsertComplianceRuleRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ComplianceRuleResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.upsert_compliance_rule_with_http_info(**kwargs)  # noqa: E501

    def upsert_compliance_rule_with_http_info(self, **kwargs):  # noqa: E501
        """[EARLY ACCESS] UpsertComplianceRule: Upsert a compliance rule.  # noqa: E501

        Use this endpoint to upsert a single compliance rule. The template and variation specified must already  exist, as must the portfolio group. The parameters passed must match those required by the template variation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_compliance_rule_with_http_info(async_req=True)
        >>> result = thread.get()

        :param upsert_compliance_rule_request:
        :type upsert_compliance_rule_request: UpsertComplianceRuleRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (ComplianceRuleResponse, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'upsert_compliance_rule_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_compliance_rule" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'upsert_compliance_rule_request' in local_var_params:
            body_params = local_var_params['upsert_compliance_rule_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '1.1.92'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "ComplianceRuleResponse",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/compliance/rules', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def upsert_compliance_run_summary(self, **kwargs):  # noqa: E501
        """[EARLY ACCESS] UpsertComplianceRunSummary: Upsert a compliance run summary.  # noqa: E501

        Use this endpoint to upsert a compliance run result summary.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_compliance_run_summary(async_req=True)
        >>> result = thread.get()

        :param upsert_compliance_run_summary_request:
        :type upsert_compliance_run_summary_request: UpsertComplianceRunSummaryRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UpsertComplianceRunSummaryResult
        """
        kwargs['_return_http_data_only'] = True
        return self.upsert_compliance_run_summary_with_http_info(**kwargs)  # noqa: E501

    def upsert_compliance_run_summary_with_http_info(self, **kwargs):  # noqa: E501
        """[EARLY ACCESS] UpsertComplianceRunSummary: Upsert a compliance run summary.  # noqa: E501

        Use this endpoint to upsert a compliance run result summary.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_compliance_run_summary_with_http_info(async_req=True)
        >>> result = thread.get()

        :param upsert_compliance_run_summary_request:
        :type upsert_compliance_run_summary_request: UpsertComplianceRunSummaryRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (UpsertComplianceRunSummaryResult, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'upsert_compliance_run_summary_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_compliance_run_summary" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'upsert_compliance_run_summary_request' in local_var_params:
            body_params = local_var_params['upsert_compliance_run_summary_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '1.1.92'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "UpsertComplianceRunSummaryResult",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/compliance/runs/summary', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
