# coding: utf-8

"""
    LUSID API

    FINBOURNE Technology  # noqa: E501

    The version of the OpenAPI document: 1.1.92
    Contact: info@finbourne.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from lusid.api_client import ApiClient
from lusid.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)
from lusid.models.access_metadata_operation import AccessMetadataOperation
from lusid.models.access_metadata_value import AccessMetadataValue
from lusid.models.custom_entity_request import CustomEntityRequest
from lusid.models.custom_entity_response import CustomEntityResponse
from lusid.models.deleted_entity_response import DeletedEntityResponse
from lusid.models.lusid_problem_details import LusidProblemDetails
from lusid.models.lusid_validation_problem_details import LusidValidationProblemDetails
from lusid.models.paged_resource_list_of_custom_entity_response import PagedResourceListOfCustomEntityResponse
from lusid.models.resource_list_of_relationship import ResourceListOfRelationship
from lusid.models.upsert_custom_entities_response import UpsertCustomEntitiesResponse
from lusid.models.upsert_custom_entity_access_metadata_request import UpsertCustomEntityAccessMetadataRequest


class CustomEntitiesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_custom_entity(self, entity_type, identifier_type, identifier_value, identifier_scope, **kwargs):  # noqa: E501
        """[EARLY ACCESS] DeleteCustomEntity: Delete a Custom Entity instance.  # noqa: E501

        Delete a Custom Entity instance by a specific entity type.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_custom_entity(entity_type, identifier_type, identifier_value, identifier_scope, async_req=True)
        >>> result = thread.get()

        :param entity_type: The type of Custom Entity to remove. (required)
        :type entity_type: str
        :param identifier_type: An identifier type attached to the Custom Entity instance. (required)
        :type identifier_type: str
        :param identifier_value: The identifier value. (required)
        :type identifier_value: str
        :param identifier_scope: The identifier scope. (required)
        :type identifier_scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeletedEntityResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_custom_entity_with_http_info(entity_type, identifier_type, identifier_value, identifier_scope, **kwargs)  # noqa: E501

    def delete_custom_entity_with_http_info(self, entity_type, identifier_type, identifier_value, identifier_scope, **kwargs):  # noqa: E501
        """[EARLY ACCESS] DeleteCustomEntity: Delete a Custom Entity instance.  # noqa: E501

        Delete a Custom Entity instance by a specific entity type.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_custom_entity_with_http_info(entity_type, identifier_type, identifier_value, identifier_scope, async_req=True)
        >>> result = thread.get()

        :param entity_type: The type of Custom Entity to remove. (required)
        :type entity_type: str
        :param identifier_type: An identifier type attached to the Custom Entity instance. (required)
        :type identifier_type: str
        :param identifier_value: The identifier value. (required)
        :type identifier_value: str
        :param identifier_scope: The identifier scope. (required)
        :type identifier_scope: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (DeletedEntityResponse, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'entity_type',
            'identifier_type',
            'identifier_value',
            'identifier_scope'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_custom_entity" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'entity_type' is set
        if self.api_client.client_side_validation and ('entity_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['entity_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `entity_type` when calling `delete_custom_entity`")  # noqa: E501
        # verify the required parameter 'identifier_type' is set
        if self.api_client.client_side_validation and ('identifier_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['identifier_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier_type` when calling `delete_custom_entity`")  # noqa: E501
        # verify the required parameter 'identifier_value' is set
        if self.api_client.client_side_validation and ('identifier_value' not in local_var_params or  # noqa: E501
                                                        local_var_params['identifier_value'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier_value` when calling `delete_custom_entity`")  # noqa: E501
        # verify the required parameter 'identifier_scope' is set
        if self.api_client.client_side_validation and ('identifier_scope' not in local_var_params or  # noqa: E501
                                                        local_var_params['identifier_scope'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier_scope` when calling `delete_custom_entity`")  # noqa: E501

        if self.api_client.client_side_validation and ('entity_type' in local_var_params and  # noqa: E501
                                                        len(local_var_params['entity_type']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `entity_type` when calling `delete_custom_entity`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('entity_type' in local_var_params and  # noqa: E501
                                                        len(local_var_params['entity_type']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `entity_type` when calling `delete_custom_entity`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_type' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_type']) > 65):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_type` when calling `delete_custom_entity`, length must be less than or equal to `65`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_type' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_type']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_type` when calling `delete_custom_entity`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'identifier_type' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['identifier_type']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_type` when calling `delete_custom_entity`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_value' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_value']) > 1024):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_value` when calling `delete_custom_entity`, length must be less than or equal to `1024`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_value' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_value']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_value` when calling `delete_custom_entity`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'identifier_value' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['identifier_value']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_value` when calling `delete_custom_entity`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_scope']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_scope` when calling `delete_custom_entity`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_scope']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_scope` when calling `delete_custom_entity`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'identifier_scope' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['identifier_scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_scope` when calling `delete_custom_entity`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'entity_type' in local_var_params:
            path_params['entityType'] = local_var_params['entity_type']  # noqa: E501
        if 'identifier_type' in local_var_params:
            path_params['identifierType'] = local_var_params['identifier_type']  # noqa: E501
        if 'identifier_value' in local_var_params:
            path_params['identifierValue'] = local_var_params['identifier_value']  # noqa: E501

        query_params = []
        if 'identifier_scope' in local_var_params and local_var_params['identifier_scope'] is not None:  # noqa: E501
            query_params.append(('identifierScope', local_var_params['identifier_scope']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '1.1.92'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "DeletedEntityResponse",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/customentities/{entityType}/{identifierType}/{identifierValue}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def delete_custom_entity_access_metadata(self, entity_type, identifier_type, identifier_value, metadata_key, identifier_scope, **kwargs):  # noqa: E501
        """[EARLY ACCESS] DeleteCustomEntityAccessMetadata: Delete a Custom Entity Access Metadata entry  # noqa: E501

        Deletes the Custom Entity Access Metadata entry that exactly matches the provided identifier parts.    It is important to always check to verify success (or failure).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_custom_entity_access_metadata(entity_type, identifier_type, identifier_value, metadata_key, identifier_scope, async_req=True)
        >>> result = thread.get()

        :param entity_type: The type of the Custom Entity. (required)
        :type entity_type: str
        :param identifier_type: An identifier type attached to the Custom Entity instance. (required)
        :type identifier_type: str
        :param identifier_value: The identifier value. (required)
        :type identifier_value: str
        :param metadata_key: Key of the metadata entry to delete. (required)
        :type metadata_key: str
        :param identifier_scope: The identifier scope. (required)
        :type identifier_scope: str
        :param effective_at: The effectiveAt datetime at which to retrieve the Access Metadata.
        :type effective_at: str
        :param effective_until: The effective datetime until which the Access Metadata is valid. If not supplied this will be valid indefinitely, or until the next 'effectiveAt' datetime of the Access Metadata.
        :type effective_until: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DeletedEntityResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_custom_entity_access_metadata_with_http_info(entity_type, identifier_type, identifier_value, metadata_key, identifier_scope, **kwargs)  # noqa: E501

    def delete_custom_entity_access_metadata_with_http_info(self, entity_type, identifier_type, identifier_value, metadata_key, identifier_scope, **kwargs):  # noqa: E501
        """[EARLY ACCESS] DeleteCustomEntityAccessMetadata: Delete a Custom Entity Access Metadata entry  # noqa: E501

        Deletes the Custom Entity Access Metadata entry that exactly matches the provided identifier parts.    It is important to always check to verify success (or failure).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_custom_entity_access_metadata_with_http_info(entity_type, identifier_type, identifier_value, metadata_key, identifier_scope, async_req=True)
        >>> result = thread.get()

        :param entity_type: The type of the Custom Entity. (required)
        :type entity_type: str
        :param identifier_type: An identifier type attached to the Custom Entity instance. (required)
        :type identifier_type: str
        :param identifier_value: The identifier value. (required)
        :type identifier_value: str
        :param metadata_key: Key of the metadata entry to delete. (required)
        :type metadata_key: str
        :param identifier_scope: The identifier scope. (required)
        :type identifier_scope: str
        :param effective_at: The effectiveAt datetime at which to retrieve the Access Metadata.
        :type effective_at: str
        :param effective_until: The effective datetime until which the Access Metadata is valid. If not supplied this will be valid indefinitely, or until the next 'effectiveAt' datetime of the Access Metadata.
        :type effective_until: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (DeletedEntityResponse, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'entity_type',
            'identifier_type',
            'identifier_value',
            'metadata_key',
            'identifier_scope',
            'effective_at',
            'effective_until'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_custom_entity_access_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'entity_type' is set
        if self.api_client.client_side_validation and ('entity_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['entity_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `entity_type` when calling `delete_custom_entity_access_metadata`")  # noqa: E501
        # verify the required parameter 'identifier_type' is set
        if self.api_client.client_side_validation and ('identifier_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['identifier_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier_type` when calling `delete_custom_entity_access_metadata`")  # noqa: E501
        # verify the required parameter 'identifier_value' is set
        if self.api_client.client_side_validation and ('identifier_value' not in local_var_params or  # noqa: E501
                                                        local_var_params['identifier_value'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier_value` when calling `delete_custom_entity_access_metadata`")  # noqa: E501
        # verify the required parameter 'metadata_key' is set
        if self.api_client.client_side_validation and ('metadata_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['metadata_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `metadata_key` when calling `delete_custom_entity_access_metadata`")  # noqa: E501
        # verify the required parameter 'identifier_scope' is set
        if self.api_client.client_side_validation and ('identifier_scope' not in local_var_params or  # noqa: E501
                                                        local_var_params['identifier_scope'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier_scope` when calling `delete_custom_entity_access_metadata`")  # noqa: E501

        if self.api_client.client_side_validation and ('entity_type' in local_var_params and  # noqa: E501
                                                        len(local_var_params['entity_type']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `entity_type` when calling `delete_custom_entity_access_metadata`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('entity_type' in local_var_params and  # noqa: E501
                                                        len(local_var_params['entity_type']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `entity_type` when calling `delete_custom_entity_access_metadata`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'entity_type' in local_var_params and not re.search(r'^~[a-zA-Z0-9\-_]+$', local_var_params['entity_type']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `entity_type` when calling `delete_custom_entity_access_metadata`, must conform to the pattern `/^~[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_type' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_type']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_type` when calling `delete_custom_entity_access_metadata`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_type' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_type']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_type` when calling `delete_custom_entity_access_metadata`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'identifier_type' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['identifier_type']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_type` when calling `delete_custom_entity_access_metadata`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_value' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_value']) > 1024):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_value` when calling `delete_custom_entity_access_metadata`, length must be less than or equal to `1024`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_value' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_value']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_value` when calling `delete_custom_entity_access_metadata`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'identifier_value' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['identifier_value']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_value` when calling `delete_custom_entity_access_metadata`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('metadata_key' in local_var_params and  # noqa: E501
                                                        len(local_var_params['metadata_key']) > 100):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `metadata_key` when calling `delete_custom_entity_access_metadata`, length must be less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and ('metadata_key' in local_var_params and  # noqa: E501
                                                        len(local_var_params['metadata_key']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `metadata_key` when calling `delete_custom_entity_access_metadata`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'metadata_key' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['metadata_key']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `metadata_key` when calling `delete_custom_entity_access_metadata`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_scope']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_scope` when calling `delete_custom_entity_access_metadata`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_scope']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_scope` when calling `delete_custom_entity_access_metadata`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'identifier_scope' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['identifier_scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_scope` when calling `delete_custom_entity_access_metadata`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'entity_type' in local_var_params:
            path_params['entityType'] = local_var_params['entity_type']  # noqa: E501
        if 'identifier_type' in local_var_params:
            path_params['identifierType'] = local_var_params['identifier_type']  # noqa: E501
        if 'identifier_value' in local_var_params:
            path_params['identifierValue'] = local_var_params['identifier_value']  # noqa: E501
        if 'metadata_key' in local_var_params:
            path_params['metadataKey'] = local_var_params['metadata_key']  # noqa: E501

        query_params = []
        if 'identifier_scope' in local_var_params and local_var_params['identifier_scope'] is not None:  # noqa: E501
            query_params.append(('identifierScope', local_var_params['identifier_scope']))  # noqa: E501
        if 'effective_at' in local_var_params and local_var_params['effective_at'] is not None:  # noqa: E501
            query_params.append(('effectiveAt', local_var_params['effective_at']))  # noqa: E501
        if 'effective_until' in local_var_params and local_var_params['effective_until'] is not None:  # noqa: E501
            query_params.append(('effectiveUntil', local_var_params['effective_until']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '1.1.92'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "DeletedEntityResponse",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/customentities/{entityType}/{identifierType}/{identifierValue}/metadata/{metadataKey}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_all_custom_entity_access_metadata(self, entity_type, identifier_type, identifier_value, identifier_scope, **kwargs):  # noqa: E501
        """[EARLY ACCESS] GetAllCustomEntityAccessMetadata: Get all the Access Metadata rules for a Custom Entity  # noqa: E501

        Get all the Custom Entity access metadata for the specified identifier scope, code and value  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_custom_entity_access_metadata(entity_type, identifier_type, identifier_value, identifier_scope, async_req=True)
        >>> result = thread.get()

        :param entity_type: The type of the Custom Entity. (required)
        :type entity_type: str
        :param identifier_type: An identifier type attached to the Custom Entity instance. (required)
        :type identifier_type: str
        :param identifier_value: The identifier value. (required)
        :type identifier_value: str
        :param identifier_scope: The identifier scope. (required)
        :type identifier_scope: str
        :param effective_at: The effective datetime or cut label at which to get the entities. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the Access Metadata. Defaults to returning the latest version of the metadata if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: dict(str, list[AccessMetadataValue])
        """
        kwargs['_return_http_data_only'] = True
        return self.get_all_custom_entity_access_metadata_with_http_info(entity_type, identifier_type, identifier_value, identifier_scope, **kwargs)  # noqa: E501

    def get_all_custom_entity_access_metadata_with_http_info(self, entity_type, identifier_type, identifier_value, identifier_scope, **kwargs):  # noqa: E501
        """[EARLY ACCESS] GetAllCustomEntityAccessMetadata: Get all the Access Metadata rules for a Custom Entity  # noqa: E501

        Get all the Custom Entity access metadata for the specified identifier scope, code and value  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_all_custom_entity_access_metadata_with_http_info(entity_type, identifier_type, identifier_value, identifier_scope, async_req=True)
        >>> result = thread.get()

        :param entity_type: The type of the Custom Entity. (required)
        :type entity_type: str
        :param identifier_type: An identifier type attached to the Custom Entity instance. (required)
        :type identifier_type: str
        :param identifier_value: The identifier value. (required)
        :type identifier_value: str
        :param identifier_scope: The identifier scope. (required)
        :type identifier_scope: str
        :param effective_at: The effective datetime or cut label at which to get the entities. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the Access Metadata. Defaults to returning the latest version of the metadata if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (dict(str, list[AccessMetadataValue]), int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'entity_type',
            'identifier_type',
            'identifier_value',
            'identifier_scope',
            'effective_at',
            'as_at'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_custom_entity_access_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'entity_type' is set
        if self.api_client.client_side_validation and ('entity_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['entity_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `entity_type` when calling `get_all_custom_entity_access_metadata`")  # noqa: E501
        # verify the required parameter 'identifier_type' is set
        if self.api_client.client_side_validation and ('identifier_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['identifier_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier_type` when calling `get_all_custom_entity_access_metadata`")  # noqa: E501
        # verify the required parameter 'identifier_value' is set
        if self.api_client.client_side_validation and ('identifier_value' not in local_var_params or  # noqa: E501
                                                        local_var_params['identifier_value'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier_value` when calling `get_all_custom_entity_access_metadata`")  # noqa: E501
        # verify the required parameter 'identifier_scope' is set
        if self.api_client.client_side_validation and ('identifier_scope' not in local_var_params or  # noqa: E501
                                                        local_var_params['identifier_scope'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier_scope` when calling `get_all_custom_entity_access_metadata`")  # noqa: E501

        if self.api_client.client_side_validation and ('entity_type' in local_var_params and  # noqa: E501
                                                        len(local_var_params['entity_type']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `entity_type` when calling `get_all_custom_entity_access_metadata`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('entity_type' in local_var_params and  # noqa: E501
                                                        len(local_var_params['entity_type']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `entity_type` when calling `get_all_custom_entity_access_metadata`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'entity_type' in local_var_params and not re.search(r'^~[a-zA-Z0-9\-_]+$', local_var_params['entity_type']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `entity_type` when calling `get_all_custom_entity_access_metadata`, must conform to the pattern `/^~[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_type' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_type']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_type` when calling `get_all_custom_entity_access_metadata`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_type' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_type']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_type` when calling `get_all_custom_entity_access_metadata`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'identifier_type' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['identifier_type']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_type` when calling `get_all_custom_entity_access_metadata`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_value' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_value']) > 1024):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_value` when calling `get_all_custom_entity_access_metadata`, length must be less than or equal to `1024`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_value' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_value']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_value` when calling `get_all_custom_entity_access_metadata`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'identifier_value' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['identifier_value']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_value` when calling `get_all_custom_entity_access_metadata`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_scope']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_scope` when calling `get_all_custom_entity_access_metadata`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_scope']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_scope` when calling `get_all_custom_entity_access_metadata`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'identifier_scope' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['identifier_scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_scope` when calling `get_all_custom_entity_access_metadata`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'entity_type' in local_var_params:
            path_params['entityType'] = local_var_params['entity_type']  # noqa: E501
        if 'identifier_type' in local_var_params:
            path_params['identifierType'] = local_var_params['identifier_type']  # noqa: E501
        if 'identifier_value' in local_var_params:
            path_params['identifierValue'] = local_var_params['identifier_value']  # noqa: E501

        query_params = []
        if 'identifier_scope' in local_var_params and local_var_params['identifier_scope'] is not None:  # noqa: E501
            query_params.append(('identifierScope', local_var_params['identifier_scope']))  # noqa: E501
        if 'effective_at' in local_var_params and local_var_params['effective_at'] is not None:  # noqa: E501
            query_params.append(('effectiveAt', local_var_params['effective_at']))  # noqa: E501
        if 'as_at' in local_var_params and local_var_params['as_at'] is not None:  # noqa: E501
            query_params.append(('asAt', local_var_params['as_at']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '1.1.92'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "dict(str, list[AccessMetadataValue])",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/customentities/{entityType}/{identifierType}/{identifierValue}/metadata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_custom_entity(self, entity_type, identifier_type, identifier_value, identifier_scope, **kwargs):  # noqa: E501
        """[EARLY ACCESS] GetCustomEntity: Get a Custom Entity instance.  # noqa: E501

        Retrieve a Custom Entity instance by a specific entity type at a point in AsAt time.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_custom_entity(entity_type, identifier_type, identifier_value, identifier_scope, async_req=True)
        >>> result = thread.get()

        :param entity_type: The type of Custom Entity to retrieve. An entityType can be created using the \"CreateCustomEntityDefinition\" endpoint for CustomEntityDefinitions. (required)
        :type entity_type: str
        :param identifier_type: An identifier type attached to the Custom Entity instance. (required)
        :type identifier_type: str
        :param identifier_value: The identifier value. (required)
        :type identifier_value: str
        :param identifier_scope: The identifier scope. (required)
        :type identifier_scope: str
        :param as_at: The AsAt datetime at which to retrieve the Custom Entity instance.
        :type as_at: datetime
        :param effective_at: The effective datetime or cut label at which to get the Custom Entity instance. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param related_entity_property_keys: A list of property keys from any domain that supports relationships              to decorate onto related entities. These must take the format {domain}/{scope}/{code}, for example 'Portfolio/Manager/Id'.
        :type related_entity_property_keys: list[str]
        :param relationship_definition_ids: A list of relationship definitions that are used to decorate related entities              onto the entity in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.
        :type relationship_definition_ids: list[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CustomEntityResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.get_custom_entity_with_http_info(entity_type, identifier_type, identifier_value, identifier_scope, **kwargs)  # noqa: E501

    def get_custom_entity_with_http_info(self, entity_type, identifier_type, identifier_value, identifier_scope, **kwargs):  # noqa: E501
        """[EARLY ACCESS] GetCustomEntity: Get a Custom Entity instance.  # noqa: E501

        Retrieve a Custom Entity instance by a specific entity type at a point in AsAt time.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_custom_entity_with_http_info(entity_type, identifier_type, identifier_value, identifier_scope, async_req=True)
        >>> result = thread.get()

        :param entity_type: The type of Custom Entity to retrieve. An entityType can be created using the \"CreateCustomEntityDefinition\" endpoint for CustomEntityDefinitions. (required)
        :type entity_type: str
        :param identifier_type: An identifier type attached to the Custom Entity instance. (required)
        :type identifier_type: str
        :param identifier_value: The identifier value. (required)
        :type identifier_value: str
        :param identifier_scope: The identifier scope. (required)
        :type identifier_scope: str
        :param as_at: The AsAt datetime at which to retrieve the Custom Entity instance.
        :type as_at: datetime
        :param effective_at: The effective datetime or cut label at which to get the Custom Entity instance. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param related_entity_property_keys: A list of property keys from any domain that supports relationships              to decorate onto related entities. These must take the format {domain}/{scope}/{code}, for example 'Portfolio/Manager/Id'.
        :type related_entity_property_keys: list[str]
        :param relationship_definition_ids: A list of relationship definitions that are used to decorate related entities              onto the entity in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.
        :type relationship_definition_ids: list[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (CustomEntityResponse, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'entity_type',
            'identifier_type',
            'identifier_value',
            'identifier_scope',
            'as_at',
            'effective_at',
            'related_entity_property_keys',
            'relationship_definition_ids'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_custom_entity" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'entity_type' is set
        if self.api_client.client_side_validation and ('entity_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['entity_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `entity_type` when calling `get_custom_entity`")  # noqa: E501
        # verify the required parameter 'identifier_type' is set
        if self.api_client.client_side_validation and ('identifier_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['identifier_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier_type` when calling `get_custom_entity`")  # noqa: E501
        # verify the required parameter 'identifier_value' is set
        if self.api_client.client_side_validation and ('identifier_value' not in local_var_params or  # noqa: E501
                                                        local_var_params['identifier_value'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier_value` when calling `get_custom_entity`")  # noqa: E501
        # verify the required parameter 'identifier_scope' is set
        if self.api_client.client_side_validation and ('identifier_scope' not in local_var_params or  # noqa: E501
                                                        local_var_params['identifier_scope'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier_scope` when calling `get_custom_entity`")  # noqa: E501

        if self.api_client.client_side_validation and ('entity_type' in local_var_params and  # noqa: E501
                                                        len(local_var_params['entity_type']) > 65):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `entity_type` when calling `get_custom_entity`, length must be less than or equal to `65`")  # noqa: E501
        if self.api_client.client_side_validation and ('entity_type' in local_var_params and  # noqa: E501
                                                        len(local_var_params['entity_type']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `entity_type` when calling `get_custom_entity`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_type' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_type']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_type` when calling `get_custom_entity`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_type' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_type']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_type` when calling `get_custom_entity`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'identifier_type' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['identifier_type']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_type` when calling `get_custom_entity`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_value' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_value']) > 1024):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_value` when calling `get_custom_entity`, length must be less than or equal to `1024`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_value' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_value']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_value` when calling `get_custom_entity`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'identifier_value' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['identifier_value']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_value` when calling `get_custom_entity`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_scope']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_scope` when calling `get_custom_entity`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_scope']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_scope` when calling `get_custom_entity`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'identifier_scope' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['identifier_scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_scope` when calling `get_custom_entity`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'entity_type' in local_var_params:
            path_params['entityType'] = local_var_params['entity_type']  # noqa: E501
        if 'identifier_type' in local_var_params:
            path_params['identifierType'] = local_var_params['identifier_type']  # noqa: E501
        if 'identifier_value' in local_var_params:
            path_params['identifierValue'] = local_var_params['identifier_value']  # noqa: E501

        query_params = []
        if 'identifier_scope' in local_var_params and local_var_params['identifier_scope'] is not None:  # noqa: E501
            query_params.append(('identifierScope', local_var_params['identifier_scope']))  # noqa: E501
        if 'as_at' in local_var_params and local_var_params['as_at'] is not None:  # noqa: E501
            query_params.append(('asAt', local_var_params['as_at']))  # noqa: E501
        if 'effective_at' in local_var_params and local_var_params['effective_at'] is not None:  # noqa: E501
            query_params.append(('effectiveAt', local_var_params['effective_at']))  # noqa: E501
        if 'related_entity_property_keys' in local_var_params and local_var_params['related_entity_property_keys'] is not None:  # noqa: E501
            query_params.append(('relatedEntityPropertyKeys', local_var_params['related_entity_property_keys']))  # noqa: E501
            collection_formats['relatedEntityPropertyKeys'] = 'multi'  # noqa: E501
        if 'relationship_definition_ids' in local_var_params and local_var_params['relationship_definition_ids'] is not None:  # noqa: E501
            query_params.append(('relationshipDefinitionIds', local_var_params['relationship_definition_ids']))  # noqa: E501
            collection_formats['relationshipDefinitionIds'] = 'multi'  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '1.1.92'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "CustomEntityResponse",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/customentities/{entityType}/{identifierType}/{identifierValue}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_custom_entity_access_metadata_by_key(self, entity_type, identifier_type, identifier_value, metadata_key, identifier_scope, **kwargs):  # noqa: E501
        """[EARLY ACCESS] GetCustomEntityAccessMetadataByKey: Get an entry identified by a metadataKey in the Access Metadata of a Custom Entity  # noqa: E501

        Get Custom Entity access metadata for the specified metadata key  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_custom_entity_access_metadata_by_key(entity_type, identifier_type, identifier_value, metadata_key, identifier_scope, async_req=True)
        >>> result = thread.get()

        :param entity_type: The type of the Custom Entity. (required)
        :type entity_type: str
        :param identifier_type: An identifier type attached to the Custom Entity instance. (required)
        :type identifier_type: str
        :param identifier_value: The identifier value. (required)
        :type identifier_value: str
        :param metadata_key: Key of the metadata entry to retrieve (required)
        :type metadata_key: str
        :param identifier_scope: The identifier scope. (required)
        :type identifier_scope: str
        :param effective_at: The effective datetime or cut label at which to get the entities. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the Access Metadata. Defaults to returning the latest version of the metadata if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[AccessMetadataValue]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_custom_entity_access_metadata_by_key_with_http_info(entity_type, identifier_type, identifier_value, metadata_key, identifier_scope, **kwargs)  # noqa: E501

    def get_custom_entity_access_metadata_by_key_with_http_info(self, entity_type, identifier_type, identifier_value, metadata_key, identifier_scope, **kwargs):  # noqa: E501
        """[EARLY ACCESS] GetCustomEntityAccessMetadataByKey: Get an entry identified by a metadataKey in the Access Metadata of a Custom Entity  # noqa: E501

        Get Custom Entity access metadata for the specified metadata key  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_custom_entity_access_metadata_by_key_with_http_info(entity_type, identifier_type, identifier_value, metadata_key, identifier_scope, async_req=True)
        >>> result = thread.get()

        :param entity_type: The type of the Custom Entity. (required)
        :type entity_type: str
        :param identifier_type: An identifier type attached to the Custom Entity instance. (required)
        :type identifier_type: str
        :param identifier_value: The identifier value. (required)
        :type identifier_value: str
        :param metadata_key: Key of the metadata entry to retrieve (required)
        :type metadata_key: str
        :param identifier_scope: The identifier scope. (required)
        :type identifier_scope: str
        :param effective_at: The effective datetime or cut label at which to get the entities. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve the Access Metadata. Defaults to returning the latest version of the metadata if not specified.
        :type as_at: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (list[AccessMetadataValue], int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'entity_type',
            'identifier_type',
            'identifier_value',
            'metadata_key',
            'identifier_scope',
            'effective_at',
            'as_at'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_custom_entity_access_metadata_by_key" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'entity_type' is set
        if self.api_client.client_side_validation and ('entity_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['entity_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `entity_type` when calling `get_custom_entity_access_metadata_by_key`")  # noqa: E501
        # verify the required parameter 'identifier_type' is set
        if self.api_client.client_side_validation and ('identifier_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['identifier_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier_type` when calling `get_custom_entity_access_metadata_by_key`")  # noqa: E501
        # verify the required parameter 'identifier_value' is set
        if self.api_client.client_side_validation and ('identifier_value' not in local_var_params or  # noqa: E501
                                                        local_var_params['identifier_value'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier_value` when calling `get_custom_entity_access_metadata_by_key`")  # noqa: E501
        # verify the required parameter 'metadata_key' is set
        if self.api_client.client_side_validation and ('metadata_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['metadata_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `metadata_key` when calling `get_custom_entity_access_metadata_by_key`")  # noqa: E501
        # verify the required parameter 'identifier_scope' is set
        if self.api_client.client_side_validation and ('identifier_scope' not in local_var_params or  # noqa: E501
                                                        local_var_params['identifier_scope'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier_scope` when calling `get_custom_entity_access_metadata_by_key`")  # noqa: E501

        if self.api_client.client_side_validation and ('entity_type' in local_var_params and  # noqa: E501
                                                        len(local_var_params['entity_type']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `entity_type` when calling `get_custom_entity_access_metadata_by_key`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('entity_type' in local_var_params and  # noqa: E501
                                                        len(local_var_params['entity_type']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `entity_type` when calling `get_custom_entity_access_metadata_by_key`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'entity_type' in local_var_params and not re.search(r'^~[a-zA-Z0-9\-_]+$', local_var_params['entity_type']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `entity_type` when calling `get_custom_entity_access_metadata_by_key`, must conform to the pattern `/^~[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_type' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_type']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_type` when calling `get_custom_entity_access_metadata_by_key`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_type' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_type']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_type` when calling `get_custom_entity_access_metadata_by_key`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'identifier_type' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['identifier_type']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_type` when calling `get_custom_entity_access_metadata_by_key`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_value' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_value']) > 1024):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_value` when calling `get_custom_entity_access_metadata_by_key`, length must be less than or equal to `1024`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_value' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_value']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_value` when calling `get_custom_entity_access_metadata_by_key`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'identifier_value' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['identifier_value']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_value` when calling `get_custom_entity_access_metadata_by_key`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('metadata_key' in local_var_params and  # noqa: E501
                                                        len(local_var_params['metadata_key']) > 100):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `metadata_key` when calling `get_custom_entity_access_metadata_by_key`, length must be less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and ('metadata_key' in local_var_params and  # noqa: E501
                                                        len(local_var_params['metadata_key']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `metadata_key` when calling `get_custom_entity_access_metadata_by_key`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'metadata_key' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['metadata_key']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `metadata_key` when calling `get_custom_entity_access_metadata_by_key`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_scope']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_scope` when calling `get_custom_entity_access_metadata_by_key`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_scope']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_scope` when calling `get_custom_entity_access_metadata_by_key`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'identifier_scope' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['identifier_scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_scope` when calling `get_custom_entity_access_metadata_by_key`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'entity_type' in local_var_params:
            path_params['entityType'] = local_var_params['entity_type']  # noqa: E501
        if 'identifier_type' in local_var_params:
            path_params['identifierType'] = local_var_params['identifier_type']  # noqa: E501
        if 'identifier_value' in local_var_params:
            path_params['identifierValue'] = local_var_params['identifier_value']  # noqa: E501
        if 'metadata_key' in local_var_params:
            path_params['metadataKey'] = local_var_params['metadata_key']  # noqa: E501

        query_params = []
        if 'identifier_scope' in local_var_params and local_var_params['identifier_scope'] is not None:  # noqa: E501
            query_params.append(('identifierScope', local_var_params['identifier_scope']))  # noqa: E501
        if 'effective_at' in local_var_params and local_var_params['effective_at'] is not None:  # noqa: E501
            query_params.append(('effectiveAt', local_var_params['effective_at']))  # noqa: E501
        if 'as_at' in local_var_params and local_var_params['as_at'] is not None:  # noqa: E501
            query_params.append(('asAt', local_var_params['as_at']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '1.1.92'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "list[AccessMetadataValue]",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/customentities/{entityType}/{identifierType}/{identifierValue}/metadata/{metadataKey}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_custom_entity_relationships(self, entity_type, identifier_scope, identifier_type, identifier_value, **kwargs):  # noqa: E501
        """[EARLY ACCESS] GetCustomEntityRelationships: Get Relationships for Custom Entity  # noqa: E501

        Get relationships for the specified Custom Entity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_custom_entity_relationships(entity_type, identifier_scope, identifier_type, identifier_value, async_req=True)
        >>> result = thread.get()

        :param entity_type: The type of entity get relationships for. (required)
        :type entity_type: str
        :param identifier_scope: The identifier scope. (required)
        :type identifier_scope: str
        :param identifier_type: An identifier type attached to the Custom Entity. (required)
        :type identifier_type: str
        :param identifier_value: The identifier value. (required)
        :type identifier_value: str
        :param effective_at: The effective datetime or cut label at which to get relationships. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve relationships. Defaults to return the latest LUSID AsAt time if not specified.
        :type as_at: datetime
        :param filter: Expression to filter relationships. Users should provide null or empty string for this field until further notice.
        :type filter: str
        :param identifier_types: Identifiers types (as property keys) used for referencing Persons or Legal Entities. These take the format              {domain}/{scope}/{code} e.g. \"Person/CompanyDetails/Role\". They must be from the \"Person\" or \"LegalEntity\" domain.              Only identifier types stated will be used to look up relevant entities in relationships. If not applicable, provide an empty array.
        :type identifier_types: list[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ResourceListOfRelationship
        """
        kwargs['_return_http_data_only'] = True
        return self.get_custom_entity_relationships_with_http_info(entity_type, identifier_scope, identifier_type, identifier_value, **kwargs)  # noqa: E501

    def get_custom_entity_relationships_with_http_info(self, entity_type, identifier_scope, identifier_type, identifier_value, **kwargs):  # noqa: E501
        """[EARLY ACCESS] GetCustomEntityRelationships: Get Relationships for Custom Entity  # noqa: E501

        Get relationships for the specified Custom Entity.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_custom_entity_relationships_with_http_info(entity_type, identifier_scope, identifier_type, identifier_value, async_req=True)
        >>> result = thread.get()

        :param entity_type: The type of entity get relationships for. (required)
        :type entity_type: str
        :param identifier_scope: The identifier scope. (required)
        :type identifier_scope: str
        :param identifier_type: An identifier type attached to the Custom Entity. (required)
        :type identifier_type: str
        :param identifier_value: The identifier value. (required)
        :type identifier_value: str
        :param effective_at: The effective datetime or cut label at which to get relationships. Defaults to the current LUSID system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to retrieve relationships. Defaults to return the latest LUSID AsAt time if not specified.
        :type as_at: datetime
        :param filter: Expression to filter relationships. Users should provide null or empty string for this field until further notice.
        :type filter: str
        :param identifier_types: Identifiers types (as property keys) used for referencing Persons or Legal Entities. These take the format              {domain}/{scope}/{code} e.g. \"Person/CompanyDetails/Role\". They must be from the \"Person\" or \"LegalEntity\" domain.              Only identifier types stated will be used to look up relevant entities in relationships. If not applicable, provide an empty array.
        :type identifier_types: list[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (ResourceListOfRelationship, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'entity_type',
            'identifier_scope',
            'identifier_type',
            'identifier_value',
            'effective_at',
            'as_at',
            'filter',
            'identifier_types'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_custom_entity_relationships" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'entity_type' is set
        if self.api_client.client_side_validation and ('entity_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['entity_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `entity_type` when calling `get_custom_entity_relationships`")  # noqa: E501
        # verify the required parameter 'identifier_scope' is set
        if self.api_client.client_side_validation and ('identifier_scope' not in local_var_params or  # noqa: E501
                                                        local_var_params['identifier_scope'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier_scope` when calling `get_custom_entity_relationships`")  # noqa: E501
        # verify the required parameter 'identifier_type' is set
        if self.api_client.client_side_validation and ('identifier_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['identifier_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier_type` when calling `get_custom_entity_relationships`")  # noqa: E501
        # verify the required parameter 'identifier_value' is set
        if self.api_client.client_side_validation and ('identifier_value' not in local_var_params or  # noqa: E501
                                                        local_var_params['identifier_value'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier_value` when calling `get_custom_entity_relationships`")  # noqa: E501

        if self.api_client.client_side_validation and ('entity_type' in local_var_params and  # noqa: E501
                                                        len(local_var_params['entity_type']) > 65):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `entity_type` when calling `get_custom_entity_relationships`, length must be less than or equal to `65`")  # noqa: E501
        if self.api_client.client_side_validation and ('entity_type' in local_var_params and  # noqa: E501
                                                        len(local_var_params['entity_type']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `entity_type` when calling `get_custom_entity_relationships`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_scope']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_scope` when calling `get_custom_entity_relationships`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_scope']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_scope` when calling `get_custom_entity_relationships`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'identifier_scope' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['identifier_scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_scope` when calling `get_custom_entity_relationships`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_type' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_type']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_type` when calling `get_custom_entity_relationships`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_type' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_type']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_type` when calling `get_custom_entity_relationships`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'identifier_type' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['identifier_type']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_type` when calling `get_custom_entity_relationships`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_value' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_value']) > 1024):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_value` when calling `get_custom_entity_relationships`, length must be less than or equal to `1024`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_value' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_value']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_value` when calling `get_custom_entity_relationships`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'identifier_value' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['identifier_value']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_value` when calling `get_custom_entity_relationships`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('effective_at' in local_var_params and  # noqa: E501
                                                        len(local_var_params['effective_at']) > 256):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `effective_at` when calling `get_custom_entity_relationships`, length must be less than or equal to `256`")  # noqa: E501
        if self.api_client.client_side_validation and ('effective_at' in local_var_params and  # noqa: E501
                                                        len(local_var_params['effective_at']) < 0):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `effective_at` when calling `get_custom_entity_relationships`, length must be greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'effective_at' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_\+:\.]+$', local_var_params['effective_at']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `effective_at` when calling `get_custom_entity_relationships`, must conform to the pattern `/^[a-zA-Z0-9\-_\+:\.]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('filter' in local_var_params and  # noqa: E501
                                                        len(local_var_params['filter']) > 16384):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `get_custom_entity_relationships`, length must be less than or equal to `16384`")  # noqa: E501
        if self.api_client.client_side_validation and ('filter' in local_var_params and  # noqa: E501
                                                        len(local_var_params['filter']) < 0):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `get_custom_entity_relationships`, length must be greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'filter' in local_var_params and not re.search(r'^[\s\S]*$', local_var_params['filter']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `get_custom_entity_relationships`, must conform to the pattern `/^[\s\S]*$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'entity_type' in local_var_params:
            path_params['entityType'] = local_var_params['entity_type']  # noqa: E501
        if 'identifier_type' in local_var_params:
            path_params['identifierType'] = local_var_params['identifier_type']  # noqa: E501
        if 'identifier_value' in local_var_params:
            path_params['identifierValue'] = local_var_params['identifier_value']  # noqa: E501

        query_params = []
        if 'identifier_scope' in local_var_params and local_var_params['identifier_scope'] is not None:  # noqa: E501
            query_params.append(('identifierScope', local_var_params['identifier_scope']))  # noqa: E501
        if 'effective_at' in local_var_params and local_var_params['effective_at'] is not None:  # noqa: E501
            query_params.append(('effectiveAt', local_var_params['effective_at']))  # noqa: E501
        if 'as_at' in local_var_params and local_var_params['as_at'] is not None:  # noqa: E501
            query_params.append(('asAt', local_var_params['as_at']))  # noqa: E501
        if 'filter' in local_var_params and local_var_params['filter'] is not None:  # noqa: E501
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501
        if 'identifier_types' in local_var_params and local_var_params['identifier_types'] is not None:  # noqa: E501
            query_params.append(('identifierTypes', local_var_params['identifier_types']))  # noqa: E501
            collection_formats['identifierTypes'] = 'multi'  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '1.1.92'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "ResourceListOfRelationship",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/customentities/{entityType}/{identifierType}/{identifierValue}/relationships', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def list_custom_entities(self, entity_type, **kwargs):  # noqa: E501
        """[EARLY ACCESS] ListCustomEntities: List Custom Entities of the specified entityType.  # noqa: E501

        List all the Custom Entities matching particular criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_custom_entities(entity_type, async_req=True)
        >>> result = thread.get()

        :param entity_type: The type of Custom Entity to list. (required)
        :type entity_type: str
        :param effective_at: The effective datetime or cut label at which to list the entities. Defaults to the current LUSID              system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to list the entities. Defaults to returning the latest version              of each portfolio if not specified.
        :type as_at: datetime
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results. For more information about filtering              results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param sort_by: A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"
        :type sort_by: list[str]
        :param page: The pagination token to use to continue listing entities; this              value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt              and asAt fields must not have changed since the original request.
        :type page: str
        :param related_entity_property_keys: A list of property keys from any domain that supports relationships              to decorate onto related entities. These must take the format {domain}/{scope}/{code}, for example 'Portfolio/Manager/Id'.
        :type related_entity_property_keys: list[str]
        :param relationship_definition_ids: A list of relationship definitions that are used to decorate related entities              onto the entities in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.
        :type relationship_definition_ids: list[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PagedResourceListOfCustomEntityResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.list_custom_entities_with_http_info(entity_type, **kwargs)  # noqa: E501

    def list_custom_entities_with_http_info(self, entity_type, **kwargs):  # noqa: E501
        """[EARLY ACCESS] ListCustomEntities: List Custom Entities of the specified entityType.  # noqa: E501

        List all the Custom Entities matching particular criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_custom_entities_with_http_info(entity_type, async_req=True)
        >>> result = thread.get()

        :param entity_type: The type of Custom Entity to list. (required)
        :type entity_type: str
        :param effective_at: The effective datetime or cut label at which to list the entities. Defaults to the current LUSID              system datetime if not specified.
        :type effective_at: str
        :param as_at: The asAt datetime at which to list the entities. Defaults to returning the latest version              of each portfolio if not specified.
        :type as_at: datetime
        :param limit: When paginating, limit the results to this number. Defaults to 100 if not specified.
        :type limit: int
        :param filter: Expression to filter the results. For more information about filtering              results, see https://support.lusid.com/knowledgebase/article/KA-01914.
        :type filter: str
        :param sort_by: A list of field names or properties to sort by, each suffixed by \" ASC\" or \" DESC\"
        :type sort_by: list[str]
        :param page: The pagination token to use to continue listing entities; this              value is returned from the previous call. If a pagination token is provided, the filter, effectiveAt              and asAt fields must not have changed since the original request.
        :type page: str
        :param related_entity_property_keys: A list of property keys from any domain that supports relationships              to decorate onto related entities. These must take the format {domain}/{scope}/{code}, for example 'Portfolio/Manager/Id'.
        :type related_entity_property_keys: list[str]
        :param relationship_definition_ids: A list of relationship definitions that are used to decorate related entities              onto the entities in the response. These must take the form {relationshipDefinitionScope}/{relationshipDefinitionCode}.
        :type relationship_definition_ids: list[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (PagedResourceListOfCustomEntityResponse, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'entity_type',
            'effective_at',
            'as_at',
            'limit',
            'filter',
            'sort_by',
            'page',
            'related_entity_property_keys',
            'relationship_definition_ids'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_custom_entities" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'entity_type' is set
        if self.api_client.client_side_validation and ('entity_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['entity_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `entity_type` when calling `list_custom_entities`")  # noqa: E501

        if self.api_client.client_side_validation and ('entity_type' in local_var_params and  # noqa: E501
                                                        len(local_var_params['entity_type']) > 65):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `entity_type` when calling `list_custom_entities`, length must be less than or equal to `65`")  # noqa: E501
        if self.api_client.client_side_validation and ('entity_type' in local_var_params and  # noqa: E501
                                                        len(local_var_params['entity_type']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `entity_type` when calling `list_custom_entities`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] > 5000:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `list_custom_entities`, must be a value less than or equal to `5000`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `list_custom_entities`, must be a value greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and ('filter' in local_var_params and  # noqa: E501
                                                        len(local_var_params['filter']) > 16384):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `list_custom_entities`, length must be less than or equal to `16384`")  # noqa: E501
        if self.api_client.client_side_validation and ('filter' in local_var_params and  # noqa: E501
                                                        len(local_var_params['filter']) < 0):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `list_custom_entities`, length must be greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'filter' in local_var_params and not re.search(r'^[\s\S]*$', local_var_params['filter']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `filter` when calling `list_custom_entities`, must conform to the pattern `/^[\s\S]*$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('page' in local_var_params and  # noqa: E501
                                                        len(local_var_params['page']) > 500):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page` when calling `list_custom_entities`, length must be less than or equal to `500`")  # noqa: E501
        if self.api_client.client_side_validation and ('page' in local_var_params and  # noqa: E501
                                                        len(local_var_params['page']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page` when calling `list_custom_entities`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'page' in local_var_params and not re.search(r'^[a-zA-Z0-9\+\/]*={0,3}$', local_var_params['page']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `page` when calling `list_custom_entities`, must conform to the pattern `/^[a-zA-Z0-9\+\/]*={0,3}$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'entity_type' in local_var_params:
            path_params['entityType'] = local_var_params['entity_type']  # noqa: E501

        query_params = []
        if 'effective_at' in local_var_params and local_var_params['effective_at'] is not None:  # noqa: E501
            query_params.append(('effectiveAt', local_var_params['effective_at']))  # noqa: E501
        if 'as_at' in local_var_params and local_var_params['as_at'] is not None:  # noqa: E501
            query_params.append(('asAt', local_var_params['as_at']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'filter' in local_var_params and local_var_params['filter'] is not None:  # noqa: E501
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501
        if 'sort_by' in local_var_params and local_var_params['sort_by'] is not None:  # noqa: E501
            query_params.append(('sortBy', local_var_params['sort_by']))  # noqa: E501
            collection_formats['sortBy'] = 'multi'  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'related_entity_property_keys' in local_var_params and local_var_params['related_entity_property_keys'] is not None:  # noqa: E501
            query_params.append(('relatedEntityPropertyKeys', local_var_params['related_entity_property_keys']))  # noqa: E501
            collection_formats['relatedEntityPropertyKeys'] = 'multi'  # noqa: E501
        if 'relationship_definition_ids' in local_var_params and local_var_params['relationship_definition_ids'] is not None:  # noqa: E501
            query_params.append(('relationshipDefinitionIds', local_var_params['relationship_definition_ids']))  # noqa: E501
            collection_formats['relationshipDefinitionIds'] = 'multi'  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"


        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '1.1.92'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "PagedResourceListOfCustomEntityResponse",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/customentities/{entityType}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def patch_custom_entity_access_metadata(self, entity_type, identifier_type, identifier_value, identifier_scope, access_metadata_operation, **kwargs):  # noqa: E501
        """[EARLY ACCESS] PatchCustomEntityAccessMetadata: Patch Access Metadata rules for a Custom Entity.  # noqa: E501

        Patch Custom Entity Access Metadata Rules in a single scope.  The behaviour is defined by the JSON Patch specification.                Currently only 'add' is a supported operation on the patch document    Currently only valid metadata keys are supported paths on the patch document                The response will return any affected Custom Entity Access Metadata rules or a failure message if unsuccessful.                It is important to always check to verify success (or failure).                Multiple rules for a metadataKey can exist with different effective at dates, when resources are accessed the rule that is active for the current time will be fetched.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_custom_entity_access_metadata(entity_type, identifier_type, identifier_value, identifier_scope, access_metadata_operation, async_req=True)
        >>> result = thread.get()

        :param entity_type: The type of the Custom Entity. (required)
        :type entity_type: str
        :param identifier_type: An identifier type attached to the Custom Entity instance. (required)
        :type identifier_type: str
        :param identifier_value: The identifier value. (required)
        :type identifier_value: str
        :param identifier_scope: The identifier scope. (required)
        :type identifier_scope: str
        :param access_metadata_operation: The Json Patch document (required)
        :type access_metadata_operation: list[AccessMetadataOperation]
        :param effective_at: The effectiveAt datetime at which the Access Metadata will be effective from
        :type effective_at: str
        :param effective_until: The effective datetime until which the Access Metadata is valid. If not supplied this will be valid indefinitely, or until the next 'effectiveAt' datetime of the Access Metadata
        :type effective_until: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: dict(str, list[AccessMetadataValue])
        """
        kwargs['_return_http_data_only'] = True
        return self.patch_custom_entity_access_metadata_with_http_info(entity_type, identifier_type, identifier_value, identifier_scope, access_metadata_operation, **kwargs)  # noqa: E501

    def patch_custom_entity_access_metadata_with_http_info(self, entity_type, identifier_type, identifier_value, identifier_scope, access_metadata_operation, **kwargs):  # noqa: E501
        """[EARLY ACCESS] PatchCustomEntityAccessMetadata: Patch Access Metadata rules for a Custom Entity.  # noqa: E501

        Patch Custom Entity Access Metadata Rules in a single scope.  The behaviour is defined by the JSON Patch specification.                Currently only 'add' is a supported operation on the patch document    Currently only valid metadata keys are supported paths on the patch document                The response will return any affected Custom Entity Access Metadata rules or a failure message if unsuccessful.                It is important to always check to verify success (or failure).                Multiple rules for a metadataKey can exist with different effective at dates, when resources are accessed the rule that is active for the current time will be fetched.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_custom_entity_access_metadata_with_http_info(entity_type, identifier_type, identifier_value, identifier_scope, access_metadata_operation, async_req=True)
        >>> result = thread.get()

        :param entity_type: The type of the Custom Entity. (required)
        :type entity_type: str
        :param identifier_type: An identifier type attached to the Custom Entity instance. (required)
        :type identifier_type: str
        :param identifier_value: The identifier value. (required)
        :type identifier_value: str
        :param identifier_scope: The identifier scope. (required)
        :type identifier_scope: str
        :param access_metadata_operation: The Json Patch document (required)
        :type access_metadata_operation: list[AccessMetadataOperation]
        :param effective_at: The effectiveAt datetime at which the Access Metadata will be effective from
        :type effective_at: str
        :param effective_until: The effective datetime until which the Access Metadata is valid. If not supplied this will be valid indefinitely, or until the next 'effectiveAt' datetime of the Access Metadata
        :type effective_until: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (dict(str, list[AccessMetadataValue]), int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'entity_type',
            'identifier_type',
            'identifier_value',
            'identifier_scope',
            'access_metadata_operation',
            'effective_at',
            'effective_until'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_custom_entity_access_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'entity_type' is set
        if self.api_client.client_side_validation and ('entity_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['entity_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `entity_type` when calling `patch_custom_entity_access_metadata`")  # noqa: E501
        # verify the required parameter 'identifier_type' is set
        if self.api_client.client_side_validation and ('identifier_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['identifier_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier_type` when calling `patch_custom_entity_access_metadata`")  # noqa: E501
        # verify the required parameter 'identifier_value' is set
        if self.api_client.client_side_validation and ('identifier_value' not in local_var_params or  # noqa: E501
                                                        local_var_params['identifier_value'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier_value` when calling `patch_custom_entity_access_metadata`")  # noqa: E501
        # verify the required parameter 'identifier_scope' is set
        if self.api_client.client_side_validation and ('identifier_scope' not in local_var_params or  # noqa: E501
                                                        local_var_params['identifier_scope'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier_scope` when calling `patch_custom_entity_access_metadata`")  # noqa: E501
        # verify the required parameter 'access_metadata_operation' is set
        if self.api_client.client_side_validation and ('access_metadata_operation' not in local_var_params or  # noqa: E501
                                                        local_var_params['access_metadata_operation'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `access_metadata_operation` when calling `patch_custom_entity_access_metadata`")  # noqa: E501

        if self.api_client.client_side_validation and ('entity_type' in local_var_params and  # noqa: E501
                                                        len(local_var_params['entity_type']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `entity_type` when calling `patch_custom_entity_access_metadata`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('entity_type' in local_var_params and  # noqa: E501
                                                        len(local_var_params['entity_type']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `entity_type` when calling `patch_custom_entity_access_metadata`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'entity_type' in local_var_params and not re.search(r'^~[a-zA-Z0-9\-_]+$', local_var_params['entity_type']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `entity_type` when calling `patch_custom_entity_access_metadata`, must conform to the pattern `/^~[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_type' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_type']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_type` when calling `patch_custom_entity_access_metadata`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_type' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_type']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_type` when calling `patch_custom_entity_access_metadata`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'identifier_type' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['identifier_type']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_type` when calling `patch_custom_entity_access_metadata`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_value' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_value']) > 1024):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_value` when calling `patch_custom_entity_access_metadata`, length must be less than or equal to `1024`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_value' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_value']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_value` when calling `patch_custom_entity_access_metadata`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'identifier_value' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['identifier_value']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_value` when calling `patch_custom_entity_access_metadata`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_scope']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_scope` when calling `patch_custom_entity_access_metadata`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_scope']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_scope` when calling `patch_custom_entity_access_metadata`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'identifier_scope' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['identifier_scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_scope` when calling `patch_custom_entity_access_metadata`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'entity_type' in local_var_params:
            path_params['entityType'] = local_var_params['entity_type']  # noqa: E501
        if 'identifier_type' in local_var_params:
            path_params['identifierType'] = local_var_params['identifier_type']  # noqa: E501
        if 'identifier_value' in local_var_params:
            path_params['identifierValue'] = local_var_params['identifier_value']  # noqa: E501

        query_params = []
        if 'identifier_scope' in local_var_params and local_var_params['identifier_scope'] is not None:  # noqa: E501
            query_params.append(('identifierScope', local_var_params['identifier_scope']))  # noqa: E501
        if 'effective_at' in local_var_params and local_var_params['effective_at'] is not None:  # noqa: E501
            query_params.append(('effectiveAt', local_var_params['effective_at']))  # noqa: E501
        if 'effective_until' in local_var_params and local_var_params['effective_until'] is not None:  # noqa: E501
            query_params.append(('effectiveUntil', local_var_params['effective_until']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'access_metadata_operation' in local_var_params:
            body_params = local_var_params['access_metadata_operation']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '1.1.92'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "dict(str, list[AccessMetadataValue])",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/customentities/{entityType}/{identifierType}/{identifierValue}/metadata', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def upsert_custom_entities(self, entity_type, success_mode, request_body, **kwargs):  # noqa: E501
        """[EARLY ACCESS] UpsertCustomEntities: Batch upsert instances of Custom Entities  # noqa: E501

        Note: If using partial failure modes, then it is important to check the response body for failures as any failures will still return a 200 status code  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_custom_entities(entity_type, success_mode, request_body, async_req=True)
        >>> result = thread.get()

        :param entity_type: The type of the Custom Entity to be created. An entityType can be created using the \"CreateCustomEntityDefinition\" endpoint for CustomEntityDefinitions. (required)
        :type entity_type: str
        :param success_mode: Whether the batch request should fail Atomically or in a Partial fashion - Allowed Values: Atomic, Partial (required)
        :type success_mode: str
        :param request_body: The payload describing the Custom Entity instances (required)
        :type request_body: dict(str, CustomEntityRequest)
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: UpsertCustomEntitiesResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.upsert_custom_entities_with_http_info(entity_type, success_mode, request_body, **kwargs)  # noqa: E501

    def upsert_custom_entities_with_http_info(self, entity_type, success_mode, request_body, **kwargs):  # noqa: E501
        """[EARLY ACCESS] UpsertCustomEntities: Batch upsert instances of Custom Entities  # noqa: E501

        Note: If using partial failure modes, then it is important to check the response body for failures as any failures will still return a 200 status code  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_custom_entities_with_http_info(entity_type, success_mode, request_body, async_req=True)
        >>> result = thread.get()

        :param entity_type: The type of the Custom Entity to be created. An entityType can be created using the \"CreateCustomEntityDefinition\" endpoint for CustomEntityDefinitions. (required)
        :type entity_type: str
        :param success_mode: Whether the batch request should fail Atomically or in a Partial fashion - Allowed Values: Atomic, Partial (required)
        :type success_mode: str
        :param request_body: The payload describing the Custom Entity instances (required)
        :type request_body: dict(str, CustomEntityRequest)
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (UpsertCustomEntitiesResponse, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'entity_type',
            'success_mode',
            'request_body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_custom_entities" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'entity_type' is set
        if self.api_client.client_side_validation and ('entity_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['entity_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `entity_type` when calling `upsert_custom_entities`")  # noqa: E501
        # verify the required parameter 'success_mode' is set
        if self.api_client.client_side_validation and ('success_mode' not in local_var_params or  # noqa: E501
                                                        local_var_params['success_mode'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `success_mode` when calling `upsert_custom_entities`")  # noqa: E501
        # verify the required parameter 'request_body' is set
        if self.api_client.client_side_validation and ('request_body' not in local_var_params or  # noqa: E501
                                                        local_var_params['request_body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `request_body` when calling `upsert_custom_entities`")  # noqa: E501

        if self.api_client.client_side_validation and ('entity_type' in local_var_params and  # noqa: E501
                                                        len(local_var_params['entity_type']) > 65):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `entity_type` when calling `upsert_custom_entities`, length must be less than or equal to `65`")  # noqa: E501
        if self.api_client.client_side_validation and ('entity_type' in local_var_params and  # noqa: E501
                                                        len(local_var_params['entity_type']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `entity_type` when calling `upsert_custom_entities`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and ('success_mode' in local_var_params and  # noqa: E501
                                                        len(local_var_params['success_mode']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `success_mode` when calling `upsert_custom_entities`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('success_mode' in local_var_params and  # noqa: E501
                                                        len(local_var_params['success_mode']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `success_mode` when calling `upsert_custom_entities`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'entity_type' in local_var_params:
            path_params['entityType'] = local_var_params['entity_type']  # noqa: E501

        query_params = []
        if 'success_mode' in local_var_params and local_var_params['success_mode'] is not None:  # noqa: E501
            query_params.append(('successMode', local_var_params['success_mode']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'request_body' in local_var_params:
            body_params = local_var_params['request_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '1.1.92'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "UpsertCustomEntitiesResponse",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/customentities/{entityType}/$batchUpsert', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def upsert_custom_entity(self, entity_type, custom_entity_request, **kwargs):  # noqa: E501
        """[EARLY ACCESS] UpsertCustomEntity: Upsert a Custom Entity instance  # noqa: E501

        Insert the Custom Entity if it does not exist or update the Custom Entity with the supplied state if it does exist.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_custom_entity(entity_type, custom_entity_request, async_req=True)
        >>> result = thread.get()

        :param entity_type: The type of the Custom Entity to be created. An entityType can be created using the \"CreateCustomEntityDefinition\" endpoint for CustomEntityDefinitions. (required)
        :type entity_type: str
        :param custom_entity_request: The payload describing the Custom Entity instance. (required)
        :type custom_entity_request: CustomEntityRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CustomEntityResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.upsert_custom_entity_with_http_info(entity_type, custom_entity_request, **kwargs)  # noqa: E501

    def upsert_custom_entity_with_http_info(self, entity_type, custom_entity_request, **kwargs):  # noqa: E501
        """[EARLY ACCESS] UpsertCustomEntity: Upsert a Custom Entity instance  # noqa: E501

        Insert the Custom Entity if it does not exist or update the Custom Entity with the supplied state if it does exist.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_custom_entity_with_http_info(entity_type, custom_entity_request, async_req=True)
        >>> result = thread.get()

        :param entity_type: The type of the Custom Entity to be created. An entityType can be created using the \"CreateCustomEntityDefinition\" endpoint for CustomEntityDefinitions. (required)
        :type entity_type: str
        :param custom_entity_request: The payload describing the Custom Entity instance. (required)
        :type custom_entity_request: CustomEntityRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (CustomEntityResponse, int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'entity_type',
            'custom_entity_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_custom_entity" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'entity_type' is set
        if self.api_client.client_side_validation and ('entity_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['entity_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `entity_type` when calling `upsert_custom_entity`")  # noqa: E501
        # verify the required parameter 'custom_entity_request' is set
        if self.api_client.client_side_validation and ('custom_entity_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['custom_entity_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `custom_entity_request` when calling `upsert_custom_entity`")  # noqa: E501

        if self.api_client.client_side_validation and ('entity_type' in local_var_params and  # noqa: E501
                                                        len(local_var_params['entity_type']) > 65):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `entity_type` when calling `upsert_custom_entity`, length must be less than or equal to `65`")  # noqa: E501
        if self.api_client.client_side_validation and ('entity_type' in local_var_params and  # noqa: E501
                                                        len(local_var_params['entity_type']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `entity_type` when calling `upsert_custom_entity`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'entity_type' in local_var_params:
            path_params['entityType'] = local_var_params['entity_type']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'custom_entity_request' in local_var_params:
            body_params = local_var_params['custom_entity_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '1.1.92'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "CustomEntityResponse",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/customentities/{entityType}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def upsert_custom_entity_access_metadata(self, entity_type, identifier_type, identifier_value, metadata_key, identifier_scope, upsert_custom_entity_access_metadata_request, **kwargs):  # noqa: E501
        """[EARLY ACCESS] UpsertCustomEntityAccessMetadata: Upsert a Custom Entity Access Metadata entry associated with a specific metadataKey. This creates or updates the data in LUSID.  # noqa: E501

        Update or insert one Custom Entity Access Metadata entry in a single scope. An item will be updated if it already exists  and inserted if it does not.                The response will return the successfully updated or inserted Custom Entity Access Metadata rule or failure message if unsuccessful.                It is important to always check to verify success (or failure).                Multiple rules for a metadataKey can exist with different effective at dates, when resources are accessed the rule that is active for the current time will be fetched.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_custom_entity_access_metadata(entity_type, identifier_type, identifier_value, metadata_key, identifier_scope, upsert_custom_entity_access_metadata_request, async_req=True)
        >>> result = thread.get()

        :param entity_type: The type of the Custom Entity. (required)
        :type entity_type: str
        :param identifier_type: An identifier type attached to the Custom Entity instance. (required)
        :type identifier_type: str
        :param identifier_value: The identifier value. (required)
        :type identifier_value: str
        :param metadata_key: Key of the metadata entry to retrieve (required)
        :type metadata_key: str
        :param identifier_scope: The identifier scope. (required)
        :type identifier_scope: str
        :param upsert_custom_entity_access_metadata_request: The Custom Entity Access Metadata entry to upsert (required)
        :type upsert_custom_entity_access_metadata_request: UpsertCustomEntityAccessMetadataRequest
        :param effective_at: The effectiveAt datetime at which the Access Metadata will be effective from
        :type effective_at: str
        :param effective_until: The effective datetime until which the Access Metadata is valid. If not supplied this will be valid indefinitely, or until the next 'effectiveAt' datetime of the Access Metadata
        :type effective_until: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[AccessMetadataValue]
        """
        kwargs['_return_http_data_only'] = True
        return self.upsert_custom_entity_access_metadata_with_http_info(entity_type, identifier_type, identifier_value, metadata_key, identifier_scope, upsert_custom_entity_access_metadata_request, **kwargs)  # noqa: E501

    def upsert_custom_entity_access_metadata_with_http_info(self, entity_type, identifier_type, identifier_value, metadata_key, identifier_scope, upsert_custom_entity_access_metadata_request, **kwargs):  # noqa: E501
        """[EARLY ACCESS] UpsertCustomEntityAccessMetadata: Upsert a Custom Entity Access Metadata entry associated with a specific metadataKey. This creates or updates the data in LUSID.  # noqa: E501

        Update or insert one Custom Entity Access Metadata entry in a single scope. An item will be updated if it already exists  and inserted if it does not.                The response will return the successfully updated or inserted Custom Entity Access Metadata rule or failure message if unsuccessful.                It is important to always check to verify success (or failure).                Multiple rules for a metadataKey can exist with different effective at dates, when resources are accessed the rule that is active for the current time will be fetched.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.upsert_custom_entity_access_metadata_with_http_info(entity_type, identifier_type, identifier_value, metadata_key, identifier_scope, upsert_custom_entity_access_metadata_request, async_req=True)
        >>> result = thread.get()

        :param entity_type: The type of the Custom Entity. (required)
        :type entity_type: str
        :param identifier_type: An identifier type attached to the Custom Entity instance. (required)
        :type identifier_type: str
        :param identifier_value: The identifier value. (required)
        :type identifier_value: str
        :param metadata_key: Key of the metadata entry to retrieve (required)
        :type metadata_key: str
        :param identifier_scope: The identifier scope. (required)
        :type identifier_scope: str
        :param upsert_custom_entity_access_metadata_request: The Custom Entity Access Metadata entry to upsert (required)
        :type upsert_custom_entity_access_metadata_request: UpsertCustomEntityAccessMetadataRequest
        :param effective_at: The effectiveAt datetime at which the Access Metadata will be effective from
        :type effective_at: str
        :param effective_until: The effective datetime until which the Access Metadata is valid. If not supplied this will be valid indefinitely, or until the next 'effectiveAt' datetime of the Access Metadata
        :type effective_until: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object, the HTTP status code, and the headers.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: (list[AccessMetadataValue], int, HTTPHeaderDict)
        """

        local_var_params = locals()

        all_params = [
            'entity_type',
            'identifier_type',
            'identifier_value',
            'metadata_key',
            'identifier_scope',
            'upsert_custom_entity_access_metadata_request',
            'effective_at',
            'effective_until'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upsert_custom_entity_access_metadata" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'entity_type' is set
        if self.api_client.client_side_validation and ('entity_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['entity_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `entity_type` when calling `upsert_custom_entity_access_metadata`")  # noqa: E501
        # verify the required parameter 'identifier_type' is set
        if self.api_client.client_side_validation and ('identifier_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['identifier_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier_type` when calling `upsert_custom_entity_access_metadata`")  # noqa: E501
        # verify the required parameter 'identifier_value' is set
        if self.api_client.client_side_validation and ('identifier_value' not in local_var_params or  # noqa: E501
                                                        local_var_params['identifier_value'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier_value` when calling `upsert_custom_entity_access_metadata`")  # noqa: E501
        # verify the required parameter 'metadata_key' is set
        if self.api_client.client_side_validation and ('metadata_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['metadata_key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `metadata_key` when calling `upsert_custom_entity_access_metadata`")  # noqa: E501
        # verify the required parameter 'identifier_scope' is set
        if self.api_client.client_side_validation and ('identifier_scope' not in local_var_params or  # noqa: E501
                                                        local_var_params['identifier_scope'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `identifier_scope` when calling `upsert_custom_entity_access_metadata`")  # noqa: E501
        # verify the required parameter 'upsert_custom_entity_access_metadata_request' is set
        if self.api_client.client_side_validation and ('upsert_custom_entity_access_metadata_request' not in local_var_params or  # noqa: E501
                                                        local_var_params['upsert_custom_entity_access_metadata_request'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `upsert_custom_entity_access_metadata_request` when calling `upsert_custom_entity_access_metadata`")  # noqa: E501

        if self.api_client.client_side_validation and ('entity_type' in local_var_params and  # noqa: E501
                                                        len(local_var_params['entity_type']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `entity_type` when calling `upsert_custom_entity_access_metadata`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('entity_type' in local_var_params and  # noqa: E501
                                                        len(local_var_params['entity_type']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `entity_type` when calling `upsert_custom_entity_access_metadata`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'entity_type' in local_var_params and not re.search(r'^~[a-zA-Z0-9\-_]+$', local_var_params['entity_type']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `entity_type` when calling `upsert_custom_entity_access_metadata`, must conform to the pattern `/^~[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_type' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_type']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_type` when calling `upsert_custom_entity_access_metadata`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_type' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_type']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_type` when calling `upsert_custom_entity_access_metadata`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'identifier_type' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['identifier_type']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_type` when calling `upsert_custom_entity_access_metadata`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_value' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_value']) > 1024):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_value` when calling `upsert_custom_entity_access_metadata`, length must be less than or equal to `1024`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_value' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_value']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_value` when calling `upsert_custom_entity_access_metadata`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'identifier_value' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['identifier_value']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_value` when calling `upsert_custom_entity_access_metadata`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('metadata_key' in local_var_params and  # noqa: E501
                                                        len(local_var_params['metadata_key']) > 100):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `metadata_key` when calling `upsert_custom_entity_access_metadata`, length must be less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and ('metadata_key' in local_var_params and  # noqa: E501
                                                        len(local_var_params['metadata_key']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `metadata_key` when calling `upsert_custom_entity_access_metadata`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'metadata_key' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['metadata_key']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `metadata_key` when calling `upsert_custom_entity_access_metadata`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_scope']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_scope` when calling `upsert_custom_entity_access_metadata`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('identifier_scope' in local_var_params and  # noqa: E501
                                                        len(local_var_params['identifier_scope']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_scope` when calling `upsert_custom_entity_access_metadata`, length must be greater than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'identifier_scope' in local_var_params and not re.search(r'^[a-zA-Z0-9\-_]+$', local_var_params['identifier_scope']):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `identifier_scope` when calling `upsert_custom_entity_access_metadata`, must conform to the pattern `/^[a-zA-Z0-9\-_]+$/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'entity_type' in local_var_params:
            path_params['entityType'] = local_var_params['entity_type']  # noqa: E501
        if 'identifier_type' in local_var_params:
            path_params['identifierType'] = local_var_params['identifier_type']  # noqa: E501
        if 'identifier_value' in local_var_params:
            path_params['identifierValue'] = local_var_params['identifier_value']  # noqa: E501
        if 'metadata_key' in local_var_params:
            path_params['metadataKey'] = local_var_params['metadata_key']  # noqa: E501

        query_params = []
        if 'identifier_scope' in local_var_params and local_var_params['identifier_scope'] is not None:  # noqa: E501
            query_params.append(('identifierScope', local_var_params['identifier_scope']))  # noqa: E501
        if 'effective_at' in local_var_params and local_var_params['effective_at'] is not None:  # noqa: E501
            query_params.append(('effectiveAt', local_var_params['effective_at']))  # noqa: E501
        if 'effective_until' in local_var_params and local_var_params['effective_until'] is not None:  # noqa: E501
            query_params.append(('effectiveUntil', local_var_params['effective_until']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        if 'upsert_custom_entity_access_metadata_request' in local_var_params:
            body_params = local_var_params['upsert_custom_entity_access_metadata_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        header_params['Accept-Encoding'] = "gzip, deflate, br"

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # set the LUSID header
        header_params['X-LUSID-SDK-Language'] = 'Python'
        header_params['X-LUSID-SDK-Version'] = '1.1.92'

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        response_types_map = {
            200: "list[AccessMetadataValue]",
            400: "LusidValidationProblemDetails",
        }

        return self.api_client.call_api(
            '/api/customentities/{entityType}/{identifierType}/{identifierValue}/metadata/{metadataKey}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
