# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['FileArgs', 'File']

@pulumi.input_type
class FileArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[str],
                 content_base64: Optional[pulumi.Input[str]] = None,
                 md5: Optional[pulumi.Input[str]] = None,
                 remote_file_modified: Optional[pulumi.Input[bool]] = None,
                 source: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a File resource.
        :param pulumi.Input[str] path: The path of the file in which you wish to save. For example, `/Volumes/main/default/volume1/file.txt`.
        :param pulumi.Input[str] content_base64: Contents in base 64 format. Conflicts with `source`.
        :param pulumi.Input[str] source: The full absolute path to the file. Conflicts with `content_base64`.
        """
        pulumi.set(__self__, "path", path)
        if content_base64 is not None:
            pulumi.set(__self__, "content_base64", content_base64)
        if md5 is not None:
            pulumi.set(__self__, "md5", md5)
        if remote_file_modified is not None:
            pulumi.set(__self__, "remote_file_modified", remote_file_modified)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        The path of the file in which you wish to save. For example, `/Volumes/main/default/volume1/file.txt`.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="contentBase64")
    def content_base64(self) -> Optional[pulumi.Input[str]]:
        """
        Contents in base 64 format. Conflicts with `source`.
        """
        return pulumi.get(self, "content_base64")

    @content_base64.setter
    def content_base64(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_base64", value)

    @property
    @pulumi.getter
    def md5(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "md5")

    @md5.setter
    def md5(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "md5", value)

    @property
    @pulumi.getter(name="remoteFileModified")
    def remote_file_modified(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "remote_file_modified")

    @remote_file_modified.setter
    def remote_file_modified(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "remote_file_modified", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[str]]:
        """
        The full absolute path to the file. Conflicts with `content_base64`.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source", value)


@pulumi.input_type
class _FileState:
    def __init__(__self__, *,
                 content_base64: Optional[pulumi.Input[str]] = None,
                 file_size: Optional[pulumi.Input[int]] = None,
                 md5: Optional[pulumi.Input[str]] = None,
                 modification_time: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 remote_file_modified: Optional[pulumi.Input[bool]] = None,
                 source: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering File resources.
        :param pulumi.Input[str] content_base64: Contents in base 64 format. Conflicts with `source`.
        :param pulumi.Input[int] file_size: The file size of the file that is being tracked by this resource in bytes.
        :param pulumi.Input[str] modification_time: The last time stamp when the file was modified
        :param pulumi.Input[str] path: The path of the file in which you wish to save. For example, `/Volumes/main/default/volume1/file.txt`.
        :param pulumi.Input[str] source: The full absolute path to the file. Conflicts with `content_base64`.
        """
        if content_base64 is not None:
            pulumi.set(__self__, "content_base64", content_base64)
        if file_size is not None:
            pulumi.set(__self__, "file_size", file_size)
        if md5 is not None:
            pulumi.set(__self__, "md5", md5)
        if modification_time is not None:
            pulumi.set(__self__, "modification_time", modification_time)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if remote_file_modified is not None:
            pulumi.set(__self__, "remote_file_modified", remote_file_modified)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter(name="contentBase64")
    def content_base64(self) -> Optional[pulumi.Input[str]]:
        """
        Contents in base 64 format. Conflicts with `source`.
        """
        return pulumi.get(self, "content_base64")

    @content_base64.setter
    def content_base64(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_base64", value)

    @property
    @pulumi.getter(name="fileSize")
    def file_size(self) -> Optional[pulumi.Input[int]]:
        """
        The file size of the file that is being tracked by this resource in bytes.
        """
        return pulumi.get(self, "file_size")

    @file_size.setter
    def file_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "file_size", value)

    @property
    @pulumi.getter
    def md5(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "md5")

    @md5.setter
    def md5(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "md5", value)

    @property
    @pulumi.getter(name="modificationTime")
    def modification_time(self) -> Optional[pulumi.Input[str]]:
        """
        The last time stamp when the file was modified
        """
        return pulumi.get(self, "modification_time")

    @modification_time.setter
    def modification_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "modification_time", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path of the file in which you wish to save. For example, `/Volumes/main/default/volume1/file.txt`.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="remoteFileModified")
    def remote_file_modified(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "remote_file_modified")

    @remote_file_modified.setter
    def remote_file_modified(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "remote_file_modified", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[str]]:
        """
        The full absolute path to the file. Conflicts with `content_base64`.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source", value)


class File(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content_base64: Optional[pulumi.Input[str]] = None,
                 md5: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 remote_file_modified: Optional[pulumi.Input[bool]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Import

        The resource `databricks_file` can be imported using the path of the file:

        bash

        ```sh
        $ pulumi import databricks:index/file:File this <path>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] content_base64: Contents in base 64 format. Conflicts with `source`.
        :param pulumi.Input[str] path: The path of the file in which you wish to save. For example, `/Volumes/main/default/volume1/file.txt`.
        :param pulumi.Input[str] source: The full absolute path to the file. Conflicts with `content_base64`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FileArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        The resource `databricks_file` can be imported using the path of the file:

        bash

        ```sh
        $ pulumi import databricks:index/file:File this <path>
        ```

        :param str resource_name: The name of the resource.
        :param FileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 content_base64: Optional[pulumi.Input[str]] = None,
                 md5: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 remote_file_modified: Optional[pulumi.Input[bool]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FileArgs.__new__(FileArgs)

            __props__.__dict__["content_base64"] = content_base64
            __props__.__dict__["md5"] = md5
            if path is None and not opts.urn:
                raise TypeError("Missing required property 'path'")
            __props__.__dict__["path"] = path
            __props__.__dict__["remote_file_modified"] = remote_file_modified
            __props__.__dict__["source"] = source
            __props__.__dict__["file_size"] = None
            __props__.__dict__["modification_time"] = None
        super(File, __self__).__init__(
            'databricks:index/file:File',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            content_base64: Optional[pulumi.Input[str]] = None,
            file_size: Optional[pulumi.Input[int]] = None,
            md5: Optional[pulumi.Input[str]] = None,
            modification_time: Optional[pulumi.Input[str]] = None,
            path: Optional[pulumi.Input[str]] = None,
            remote_file_modified: Optional[pulumi.Input[bool]] = None,
            source: Optional[pulumi.Input[str]] = None) -> 'File':
        """
        Get an existing File resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] content_base64: Contents in base 64 format. Conflicts with `source`.
        :param pulumi.Input[int] file_size: The file size of the file that is being tracked by this resource in bytes.
        :param pulumi.Input[str] modification_time: The last time stamp when the file was modified
        :param pulumi.Input[str] path: The path of the file in which you wish to save. For example, `/Volumes/main/default/volume1/file.txt`.
        :param pulumi.Input[str] source: The full absolute path to the file. Conflicts with `content_base64`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FileState.__new__(_FileState)

        __props__.__dict__["content_base64"] = content_base64
        __props__.__dict__["file_size"] = file_size
        __props__.__dict__["md5"] = md5
        __props__.__dict__["modification_time"] = modification_time
        __props__.__dict__["path"] = path
        __props__.__dict__["remote_file_modified"] = remote_file_modified
        __props__.__dict__["source"] = source
        return File(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="contentBase64")
    def content_base64(self) -> pulumi.Output[Optional[str]]:
        """
        Contents in base 64 format. Conflicts with `source`.
        """
        return pulumi.get(self, "content_base64")

    @property
    @pulumi.getter(name="fileSize")
    def file_size(self) -> pulumi.Output[int]:
        """
        The file size of the file that is being tracked by this resource in bytes.
        """
        return pulumi.get(self, "file_size")

    @property
    @pulumi.getter
    def md5(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "md5")

    @property
    @pulumi.getter(name="modificationTime")
    def modification_time(self) -> pulumi.Output[str]:
        """
        The last time stamp when the file was modified
        """
        return pulumi.get(self, "modification_time")

    @property
    @pulumi.getter
    def path(self) -> pulumi.Output[str]:
        """
        The path of the file in which you wish to save. For example, `/Volumes/main/default/volume1/file.txt`.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="remoteFileModified")
    def remote_file_modified(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "remote_file_modified")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output[Optional[str]]:
        """
        The full absolute path to the file. Conflicts with `content_base64`.
        """
        return pulumi.get(self, "source")

