# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetAwsUnityCatalogAssumeRolePolicyResult',
    'AwaitableGetAwsUnityCatalogAssumeRolePolicyResult',
    'get_aws_unity_catalog_assume_role_policy',
    'get_aws_unity_catalog_assume_role_policy_output',
]

@pulumi.output_type
class GetAwsUnityCatalogAssumeRolePolicyResult:
    """
    A collection of values returned by getAwsUnityCatalogAssumeRolePolicy.
    """
    def __init__(__self__, aws_account_id=None, external_id=None, id=None, json=None, role_name=None, unity_catalog_iam_arn=None):
        if aws_account_id and not isinstance(aws_account_id, str):
            raise TypeError("Expected argument 'aws_account_id' to be a str")
        pulumi.set(__self__, "aws_account_id", aws_account_id)
        if external_id and not isinstance(external_id, str):
            raise TypeError("Expected argument 'external_id' to be a str")
        pulumi.set(__self__, "external_id", external_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if json and not isinstance(json, str):
            raise TypeError("Expected argument 'json' to be a str")
        pulumi.set(__self__, "json", json)
        if role_name and not isinstance(role_name, str):
            raise TypeError("Expected argument 'role_name' to be a str")
        pulumi.set(__self__, "role_name", role_name)
        if unity_catalog_iam_arn and not isinstance(unity_catalog_iam_arn, str):
            raise TypeError("Expected argument 'unity_catalog_iam_arn' to be a str")
        pulumi.set(__self__, "unity_catalog_iam_arn", unity_catalog_iam_arn)

    @property
    @pulumi.getter(name="awsAccountId")
    def aws_account_id(self) -> str:
        return pulumi.get(self, "aws_account_id")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> str:
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def json(self) -> str:
        """
        AWS IAM Policy JSON document for assume role
        """
        return pulumi.get(self, "json")

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> str:
        return pulumi.get(self, "role_name")

    @property
    @pulumi.getter(name="unityCatalogIamArn")
    def unity_catalog_iam_arn(self) -> str:
        return pulumi.get(self, "unity_catalog_iam_arn")


class AwaitableGetAwsUnityCatalogAssumeRolePolicyResult(GetAwsUnityCatalogAssumeRolePolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAwsUnityCatalogAssumeRolePolicyResult(
            aws_account_id=self.aws_account_id,
            external_id=self.external_id,
            id=self.id,
            json=self.json,
            role_name=self.role_name,
            unity_catalog_iam_arn=self.unity_catalog_iam_arn)


def get_aws_unity_catalog_assume_role_policy(aws_account_id: Optional[str] = None,
                                             external_id: Optional[str] = None,
                                             role_name: Optional[str] = None,
                                             unity_catalog_iam_arn: Optional[str] = None,
                                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAwsUnityCatalogAssumeRolePolicyResult:
    """
    > **Note** This resource has an evolving API, which may change in future versions of the provider. Please always consult [latest documentation](https://docs.databricks.com/data-governance/unity-catalog/get-started.html#configure-a-storage-bucket-and-iam-role-in-aws) in case of any questions.

    This data source constructs the necessary AWS Unity Catalog assume role policy for you.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws
    import pulumi_databricks as databricks

    this = databricks.get_aws_unity_catalog_policy(aws_account_id=aws_account_id,
        bucket_name="databricks-bucket",
        role_name=f"{prefix}-uc-access",
        kms_name="databricks-kms")
    this_get_aws_unity_catalog_assume_role_policy = databricks.get_aws_unity_catalog_assume_role_policy(aws_account_id=aws_account_id,
        role_name=f"{prefix}-uc-access",
        external_id="12345")
    unity_metastore = aws.iam.Policy("unity_metastore",
        name=f"{prefix}-unity-catalog-metastore-access-iam-policy",
        policy=this.json)
    metastore_data_access = aws.iam.Role("metastore_data_access",
        name=f"{prefix}-uc-access",
        assume_role_policy=this_aws_iam_policy_document["json"],
        managed_policy_arns=[unity_metastore.arn])
    ```


    :param str aws_account_id: The Account ID of the current AWS account (not your Databricks account).
    :param str external_id: The storage credential external id.
    :param str role_name: The name of the AWS IAM role to be created for Unity Catalog.
    :param str unity_catalog_iam_arn: The Databricks Unity Catalog IAM Role ARN. Defaults to `arn:aws:iam::414351767826:role/unity-catalog-prod-UCMasterRole-14S5ZJVKOTYTL`
    """
    __args__ = dict()
    __args__['awsAccountId'] = aws_account_id
    __args__['externalId'] = external_id
    __args__['roleName'] = role_name
    __args__['unityCatalogIamArn'] = unity_catalog_iam_arn
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getAwsUnityCatalogAssumeRolePolicy:getAwsUnityCatalogAssumeRolePolicy', __args__, opts=opts, typ=GetAwsUnityCatalogAssumeRolePolicyResult).value

    return AwaitableGetAwsUnityCatalogAssumeRolePolicyResult(
        aws_account_id=pulumi.get(__ret__, 'aws_account_id'),
        external_id=pulumi.get(__ret__, 'external_id'),
        id=pulumi.get(__ret__, 'id'),
        json=pulumi.get(__ret__, 'json'),
        role_name=pulumi.get(__ret__, 'role_name'),
        unity_catalog_iam_arn=pulumi.get(__ret__, 'unity_catalog_iam_arn'))


@_utilities.lift_output_func(get_aws_unity_catalog_assume_role_policy)
def get_aws_unity_catalog_assume_role_policy_output(aws_account_id: Optional[pulumi.Input[str]] = None,
                                                    external_id: Optional[pulumi.Input[str]] = None,
                                                    role_name: Optional[pulumi.Input[str]] = None,
                                                    unity_catalog_iam_arn: Optional[pulumi.Input[Optional[str]]] = None,
                                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAwsUnityCatalogAssumeRolePolicyResult]:
    """
    > **Note** This resource has an evolving API, which may change in future versions of the provider. Please always consult [latest documentation](https://docs.databricks.com/data-governance/unity-catalog/get-started.html#configure-a-storage-bucket-and-iam-role-in-aws) in case of any questions.

    This data source constructs the necessary AWS Unity Catalog assume role policy for you.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws
    import pulumi_databricks as databricks

    this = databricks.get_aws_unity_catalog_policy(aws_account_id=aws_account_id,
        bucket_name="databricks-bucket",
        role_name=f"{prefix}-uc-access",
        kms_name="databricks-kms")
    this_get_aws_unity_catalog_assume_role_policy = databricks.get_aws_unity_catalog_assume_role_policy(aws_account_id=aws_account_id,
        role_name=f"{prefix}-uc-access",
        external_id="12345")
    unity_metastore = aws.iam.Policy("unity_metastore",
        name=f"{prefix}-unity-catalog-metastore-access-iam-policy",
        policy=this.json)
    metastore_data_access = aws.iam.Role("metastore_data_access",
        name=f"{prefix}-uc-access",
        assume_role_policy=this_aws_iam_policy_document["json"],
        managed_policy_arns=[unity_metastore.arn])
    ```


    :param str aws_account_id: The Account ID of the current AWS account (not your Databricks account).
    :param str external_id: The storage credential external id.
    :param str role_name: The name of the AWS IAM role to be created for Unity Catalog.
    :param str unity_catalog_iam_arn: The Databricks Unity Catalog IAM Role ARN. Defaults to `arn:aws:iam::414351767826:role/unity-catalog-prod-UCMasterRole-14S5ZJVKOTYTL`
    """
    ...
