# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetCatalogResult',
    'AwaitableGetCatalogResult',
    'get_catalog',
    'get_catalog_output',
]

@pulumi.output_type
class GetCatalogResult:
    """
    A collection of values returned by getCatalog.
    """
    def __init__(__self__, catalog_info=None, id=None, name=None):
        if catalog_info and not isinstance(catalog_info, dict):
            raise TypeError("Expected argument 'catalog_info' to be a dict")
        pulumi.set(__self__, "catalog_info", catalog_info)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="catalogInfo")
    def catalog_info(self) -> 'outputs.GetCatalogCatalogInfoResult':
        """
        the [CatalogInfo](https://pkg.go.dev/github.com/databricks/databricks-sdk-go/service/catalog#CatalogInfo) object for a Unity Catalog catalog. This contains the following attributes (see ):
        """
        return pulumi.get(self, "catalog_info")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        same as the `name`
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the catalog
        """
        return pulumi.get(self, "name")


class AwaitableGetCatalogResult(GetCatalogResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCatalogResult(
            catalog_info=self.catalog_info,
            id=self.id,
            name=self.name)


def get_catalog(catalog_info: Optional[pulumi.InputType['GetCatalogCatalogInfoArgs']] = None,
                id: Optional[str] = None,
                name: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCatalogResult:
    """
    ## Example Usage

    Read  on a specific catalog `test`:

    ```python
    import pulumi
    import pulumi_databricks as databricks

    test = databricks.get_catalog(name="test")
    things = databricks.Grants("things",
        catalog=test.name,
        grants=[databricks.GrantsGrantArgs(
            principal="sensitive",
            privileges=["USE_CATALOG"],
        )])
    ```

    ## Related Resources

    The following resources are used in the same context:

    * Grant to manage grants within Unity Catalog.
    * get_catalogs to list all catalogs within Unity Catalog metastore.


    :param pulumi.InputType['GetCatalogCatalogInfoArgs'] catalog_info: the [CatalogInfo](https://pkg.go.dev/github.com/databricks/databricks-sdk-go/service/catalog#CatalogInfo) object for a Unity Catalog catalog. This contains the following attributes (see ):
    :param str id: same as the `name`
    :param str name: name of the catalog
    """
    __args__ = dict()
    __args__['catalogInfo'] = catalog_info
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getCatalog:getCatalog', __args__, opts=opts, typ=GetCatalogResult).value

    return AwaitableGetCatalogResult(
        catalog_info=pulumi.get(__ret__, 'catalog_info'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'))


@_utilities.lift_output_func(get_catalog)
def get_catalog_output(catalog_info: Optional[pulumi.Input[Optional[pulumi.InputType['GetCatalogCatalogInfoArgs']]]] = None,
                       id: Optional[pulumi.Input[Optional[str]]] = None,
                       name: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCatalogResult]:
    """
    ## Example Usage

    Read  on a specific catalog `test`:

    ```python
    import pulumi
    import pulumi_databricks as databricks

    test = databricks.get_catalog(name="test")
    things = databricks.Grants("things",
        catalog=test.name,
        grants=[databricks.GrantsGrantArgs(
            principal="sensitive",
            privileges=["USE_CATALOG"],
        )])
    ```

    ## Related Resources

    The following resources are used in the same context:

    * Grant to manage grants within Unity Catalog.
    * get_catalogs to list all catalogs within Unity Catalog metastore.


    :param pulumi.InputType['GetCatalogCatalogInfoArgs'] catalog_info: the [CatalogInfo](https://pkg.go.dev/github.com/databricks/databricks-sdk-go/service/catalog#CatalogInfo) object for a Unity Catalog catalog. This contains the following attributes (see ):
    :param str id: same as the `name`
    :param str name: name of the catalog
    """
    ...
