# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetCurrentMetastoreResult',
    'AwaitableGetCurrentMetastoreResult',
    'get_current_metastore',
    'get_current_metastore_output',
]

@pulumi.output_type
class GetCurrentMetastoreResult:
    """
    A collection of values returned by getCurrentMetastore.
    """
    def __init__(__self__, id=None, metastore_info=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if metastore_info and not isinstance(metastore_info, dict):
            raise TypeError("Expected argument 'metastore_info' to be a dict")
        pulumi.set(__self__, "metastore_info", metastore_info)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        metastore ID. Will be `no_metastore` if there is no metastore assigned for the current workspace
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="metastoreInfo")
    def metastore_info(self) -> 'outputs.GetCurrentMetastoreMetastoreInfoResult':
        """
        summary about a metastore attached to the current workspace returned by [Get a metastore summary API](https://docs.databricks.com/api/workspace/metastores/summary). This contains the following attributes (check the API page for up-to-date details):
        """
        return pulumi.get(self, "metastore_info")


class AwaitableGetCurrentMetastoreResult(GetCurrentMetastoreResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCurrentMetastoreResult(
            id=self.id,
            metastore_info=self.metastore_info)


def get_current_metastore(id: Optional[str] = None,
                          metastore_info: Optional[pulumi.InputType['GetCurrentMetastoreMetastoreInfoArgs']] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCurrentMetastoreResult:
    """
    Retrieves information about metastore attached to a given workspace.

    > **Note** This is the workspace-level data source.

    > **Note** If you have a fully automated setup with workspaces created by databricks_mws_workspaces, please make sure to add depends_on attribute to prevent _authentication is not configured for provider_ errors.

    ## Example Usage

    MetastoreSummary response for a metastore attached to the current workspace.

    ```python
    import pulumi
    import pulumi_databricks as databricks

    this = databricks.get_current_metastore()
    pulumi.export("someMetastore", this.metastore_info)
    ```

    ## Related Resources

    The following resources are used in the same context:

    * Metastore to get information for a metastore with a given ID.
    * get_metastores to get a mapping of name to id of all metastores.
    * Metastore to manage Metastores within Unity Catalog.
    * Catalog to manage catalogs within Unity Catalog.


    :param str id: metastore ID. Will be `no_metastore` if there is no metastore assigned for the current workspace
    :param pulumi.InputType['GetCurrentMetastoreMetastoreInfoArgs'] metastore_info: summary about a metastore attached to the current workspace returned by [Get a metastore summary API](https://docs.databricks.com/api/workspace/metastores/summary). This contains the following attributes (check the API page for up-to-date details):
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['metastoreInfo'] = metastore_info
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getCurrentMetastore:getCurrentMetastore', __args__, opts=opts, typ=GetCurrentMetastoreResult).value

    return AwaitableGetCurrentMetastoreResult(
        id=pulumi.get(__ret__, 'id'),
        metastore_info=pulumi.get(__ret__, 'metastore_info'))


@_utilities.lift_output_func(get_current_metastore)
def get_current_metastore_output(id: Optional[pulumi.Input[Optional[str]]] = None,
                                 metastore_info: Optional[pulumi.Input[Optional[pulumi.InputType['GetCurrentMetastoreMetastoreInfoArgs']]]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCurrentMetastoreResult]:
    """
    Retrieves information about metastore attached to a given workspace.

    > **Note** This is the workspace-level data source.

    > **Note** If you have a fully automated setup with workspaces created by databricks_mws_workspaces, please make sure to add depends_on attribute to prevent _authentication is not configured for provider_ errors.

    ## Example Usage

    MetastoreSummary response for a metastore attached to the current workspace.

    ```python
    import pulumi
    import pulumi_databricks as databricks

    this = databricks.get_current_metastore()
    pulumi.export("someMetastore", this.metastore_info)
    ```

    ## Related Resources

    The following resources are used in the same context:

    * Metastore to get information for a metastore with a given ID.
    * get_metastores to get a mapping of name to id of all metastores.
    * Metastore to manage Metastores within Unity Catalog.
    * Catalog to manage catalogs within Unity Catalog.


    :param str id: metastore ID. Will be `no_metastore` if there is no metastore assigned for the current workspace
    :param pulumi.InputType['GetCurrentMetastoreMetastoreInfoArgs'] metastore_info: summary about a metastore attached to the current workspace returned by [Get a metastore summary API](https://docs.databricks.com/api/workspace/metastores/summary). This contains the following attributes (check the API page for up-to-date details):
    """
    ...
