# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetNodeTypeResult',
    'AwaitableGetNodeTypeResult',
    'get_node_type',
    'get_node_type_output',
]

@pulumi.output_type
class GetNodeTypeResult:
    """
    A collection of values returned by getNodeType.
    """
    def __init__(__self__, category=None, fleet=None, gb_per_core=None, graviton=None, id=None, is_io_cache_enabled=None, local_disk=None, local_disk_min_size=None, min_cores=None, min_gpus=None, min_memory_gb=None, photon_driver_capable=None, photon_worker_capable=None, support_port_forwarding=None):
        if category and not isinstance(category, str):
            raise TypeError("Expected argument 'category' to be a str")
        pulumi.set(__self__, "category", category)
        if fleet and not isinstance(fleet, bool):
            raise TypeError("Expected argument 'fleet' to be a bool")
        pulumi.set(__self__, "fleet", fleet)
        if gb_per_core and not isinstance(gb_per_core, int):
            raise TypeError("Expected argument 'gb_per_core' to be a int")
        pulumi.set(__self__, "gb_per_core", gb_per_core)
        if graviton and not isinstance(graviton, bool):
            raise TypeError("Expected argument 'graviton' to be a bool")
        pulumi.set(__self__, "graviton", graviton)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_io_cache_enabled and not isinstance(is_io_cache_enabled, bool):
            raise TypeError("Expected argument 'is_io_cache_enabled' to be a bool")
        pulumi.set(__self__, "is_io_cache_enabled", is_io_cache_enabled)
        if local_disk and not isinstance(local_disk, bool):
            raise TypeError("Expected argument 'local_disk' to be a bool")
        pulumi.set(__self__, "local_disk", local_disk)
        if local_disk_min_size and not isinstance(local_disk_min_size, int):
            raise TypeError("Expected argument 'local_disk_min_size' to be a int")
        pulumi.set(__self__, "local_disk_min_size", local_disk_min_size)
        if min_cores and not isinstance(min_cores, int):
            raise TypeError("Expected argument 'min_cores' to be a int")
        pulumi.set(__self__, "min_cores", min_cores)
        if min_gpus and not isinstance(min_gpus, int):
            raise TypeError("Expected argument 'min_gpus' to be a int")
        pulumi.set(__self__, "min_gpus", min_gpus)
        if min_memory_gb and not isinstance(min_memory_gb, int):
            raise TypeError("Expected argument 'min_memory_gb' to be a int")
        pulumi.set(__self__, "min_memory_gb", min_memory_gb)
        if photon_driver_capable and not isinstance(photon_driver_capable, bool):
            raise TypeError("Expected argument 'photon_driver_capable' to be a bool")
        pulumi.set(__self__, "photon_driver_capable", photon_driver_capable)
        if photon_worker_capable and not isinstance(photon_worker_capable, bool):
            raise TypeError("Expected argument 'photon_worker_capable' to be a bool")
        pulumi.set(__self__, "photon_worker_capable", photon_worker_capable)
        if support_port_forwarding and not isinstance(support_port_forwarding, bool):
            raise TypeError("Expected argument 'support_port_forwarding' to be a bool")
        pulumi.set(__self__, "support_port_forwarding", support_port_forwarding)

    @property
    @pulumi.getter
    def category(self) -> Optional[str]:
        return pulumi.get(self, "category")

    @property
    @pulumi.getter
    def fleet(self) -> Optional[bool]:
        return pulumi.get(self, "fleet")

    @property
    @pulumi.getter(name="gbPerCore")
    def gb_per_core(self) -> Optional[int]:
        return pulumi.get(self, "gb_per_core")

    @property
    @pulumi.getter
    def graviton(self) -> Optional[bool]:
        return pulumi.get(self, "graviton")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        node type, that can be used for databricks_job, databricks_cluster, or databricks_instance_pool.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isIoCacheEnabled")
    def is_io_cache_enabled(self) -> Optional[bool]:
        return pulumi.get(self, "is_io_cache_enabled")

    @property
    @pulumi.getter(name="localDisk")
    def local_disk(self) -> Optional[bool]:
        return pulumi.get(self, "local_disk")

    @property
    @pulumi.getter(name="localDiskMinSize")
    def local_disk_min_size(self) -> Optional[int]:
        return pulumi.get(self, "local_disk_min_size")

    @property
    @pulumi.getter(name="minCores")
    def min_cores(self) -> Optional[int]:
        return pulumi.get(self, "min_cores")

    @property
    @pulumi.getter(name="minGpus")
    def min_gpus(self) -> Optional[int]:
        return pulumi.get(self, "min_gpus")

    @property
    @pulumi.getter(name="minMemoryGb")
    def min_memory_gb(self) -> Optional[int]:
        return pulumi.get(self, "min_memory_gb")

    @property
    @pulumi.getter(name="photonDriverCapable")
    def photon_driver_capable(self) -> Optional[bool]:
        return pulumi.get(self, "photon_driver_capable")

    @property
    @pulumi.getter(name="photonWorkerCapable")
    def photon_worker_capable(self) -> Optional[bool]:
        return pulumi.get(self, "photon_worker_capable")

    @property
    @pulumi.getter(name="supportPortForwarding")
    def support_port_forwarding(self) -> Optional[bool]:
        return pulumi.get(self, "support_port_forwarding")


class AwaitableGetNodeTypeResult(GetNodeTypeResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNodeTypeResult(
            category=self.category,
            fleet=self.fleet,
            gb_per_core=self.gb_per_core,
            graviton=self.graviton,
            id=self.id,
            is_io_cache_enabled=self.is_io_cache_enabled,
            local_disk=self.local_disk,
            local_disk_min_size=self.local_disk_min_size,
            min_cores=self.min_cores,
            min_gpus=self.min_gpus,
            min_memory_gb=self.min_memory_gb,
            photon_driver_capable=self.photon_driver_capable,
            photon_worker_capable=self.photon_worker_capable,
            support_port_forwarding=self.support_port_forwarding)


def get_node_type(category: Optional[str] = None,
                  fleet: Optional[bool] = None,
                  gb_per_core: Optional[int] = None,
                  graviton: Optional[bool] = None,
                  id: Optional[str] = None,
                  is_io_cache_enabled: Optional[bool] = None,
                  local_disk: Optional[bool] = None,
                  local_disk_min_size: Optional[int] = None,
                  min_cores: Optional[int] = None,
                  min_gpus: Optional[int] = None,
                  min_memory_gb: Optional[int] = None,
                  photon_driver_capable: Optional[bool] = None,
                  photon_worker_capable: Optional[bool] = None,
                  support_port_forwarding: Optional[bool] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNodeTypeResult:
    """
    > **Note** If you have a fully automated setup with workspaces created by databricks_mws_workspaces, please make sure to add depends_on attribute in order to prevent _default auth: cannot configure default credentials_ errors.

    Gets the smallest node type for Cluster that fits search criteria, like amount of RAM or number of cores. [AWS](https://databricks.com/product/aws-pricing/instance-types) or [Azure](https://azure.microsoft.com/en-us/pricing/details/databricks/). Internally data source fetches [node types](https://docs.databricks.com/dev-tools/api/latest/clusters.html#list-node-types) available per cloud, similar to executing `databricks clusters list-node-types`, and filters it to return the smallest possible node with criteria.

    > **Note** This is experimental functionality, which aims to simplify things. In case of wrong parameters given (e.g. `min_gpus = 876`) or no nodes matching, data source will return cloud-default node type, even though it doesn't match search criteria specified by data source arguments: [i3.xlarge](https://aws.amazon.com/ec2/instance-types/i3/) for AWS or [Standard_D3_v2](https://docs.microsoft.com/en-us/azure/cloud-services/cloud-services-sizes-specs#dv2-series) for Azure.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_databricks as databricks

    with_gpu = databricks.get_node_type(local_disk=True,
        min_cores=16,
        gb_per_core=1,
        min_gpus=1)
    gpu_ml = databricks.get_spark_version(gpu=True,
        ml=True)
    research = databricks.Cluster("research",
        cluster_name="Research Cluster",
        spark_version=gpu_ml.id,
        node_type_id=with_gpu.id,
        autotermination_minutes=20,
        autoscale=databricks.ClusterAutoscaleArgs(
            min_workers=1,
            max_workers=50,
        ))
    ```

    ## Related Resources

    The following resources are used in the same context:

    * End to end workspace management guide.
    * Cluster to create [Databricks Clusters](https://docs.databricks.com/clusters/index.html).
    * ClusterPolicy to create a Cluster policy, which limits the ability to create clusters based on a set of rules.
    * InstancePool to manage [instance pools](https://docs.databricks.com/clusters/instance-pools/index.html) to reduce cluster start and auto-scaling times by maintaining a set of idle, ready-to-use instances.
    * Job to manage [Databricks Jobs](https://docs.databricks.com/jobs.html) to run non-interactive code in a databricks_cluster.


    :param str category: Node category, which can be one of (depending on the cloud environment, could be checked with `databricks clusters list-node-types -o json|jq '.node_types[]|.category'|sort |uniq`):
           * `General Purpose` (all clouds)
           * `General Purpose (HDD)` (Azure)
           * `Compute Optimized` (all clouds)
           * `Memory Optimized` (all clouds)
           * `Memory Optimized (Remote HDD)` (Azure)
           * `Storage Optimized` (AWS, Azure)
           * `GPU Accelerated` (AWS, Azure)
    :param bool fleet: if we should limit the search only to [AWS fleet instance types](https://docs.databricks.com/compute/aws-fleet-instances.html). Default to _false_.
    :param int gb_per_core: Number of gigabytes per core available on instance. Conflicts with `min_memory_gb`. Defaults to _0_.
    :param bool graviton: if we should limit the search only to nodes with AWS Graviton CPUs. Default to _false_.
    :param str id: node type, that can be used for databricks_job, databricks_cluster, or databricks_instance_pool.
    :param bool is_io_cache_enabled: . Pick only nodes that have IO Cache. Defaults to _false_.
    :param bool local_disk: Pick only nodes with local storage. Defaults to _false_.
    :param int local_disk_min_size: Pick only nodes that have size local storage greater or equal to given value. Defaults to _0_.
    :param int min_cores: Minimum number of CPU cores available on instance. Defaults to _0_.
    :param int min_gpus: Minimum number of GPU's attached to instance. Defaults to _0_.
    :param int min_memory_gb: Minimum amount of memory per node in gigabytes. Defaults to _0_.
    :param bool photon_driver_capable: Pick only nodes that can run Photon driver. Defaults to _false_.
    :param bool photon_worker_capable: Pick only nodes that can run Photon workers. Defaults to _false_.
    :param bool support_port_forwarding: Pick only nodes that support port forwarding. Defaults to _false_.
    """
    __args__ = dict()
    __args__['category'] = category
    __args__['fleet'] = fleet
    __args__['gbPerCore'] = gb_per_core
    __args__['graviton'] = graviton
    __args__['id'] = id
    __args__['isIoCacheEnabled'] = is_io_cache_enabled
    __args__['localDisk'] = local_disk
    __args__['localDiskMinSize'] = local_disk_min_size
    __args__['minCores'] = min_cores
    __args__['minGpus'] = min_gpus
    __args__['minMemoryGb'] = min_memory_gb
    __args__['photonDriverCapable'] = photon_driver_capable
    __args__['photonWorkerCapable'] = photon_worker_capable
    __args__['supportPortForwarding'] = support_port_forwarding
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getNodeType:getNodeType', __args__, opts=opts, typ=GetNodeTypeResult).value

    return AwaitableGetNodeTypeResult(
        category=pulumi.get(__ret__, 'category'),
        fleet=pulumi.get(__ret__, 'fleet'),
        gb_per_core=pulumi.get(__ret__, 'gb_per_core'),
        graviton=pulumi.get(__ret__, 'graviton'),
        id=pulumi.get(__ret__, 'id'),
        is_io_cache_enabled=pulumi.get(__ret__, 'is_io_cache_enabled'),
        local_disk=pulumi.get(__ret__, 'local_disk'),
        local_disk_min_size=pulumi.get(__ret__, 'local_disk_min_size'),
        min_cores=pulumi.get(__ret__, 'min_cores'),
        min_gpus=pulumi.get(__ret__, 'min_gpus'),
        min_memory_gb=pulumi.get(__ret__, 'min_memory_gb'),
        photon_driver_capable=pulumi.get(__ret__, 'photon_driver_capable'),
        photon_worker_capable=pulumi.get(__ret__, 'photon_worker_capable'),
        support_port_forwarding=pulumi.get(__ret__, 'support_port_forwarding'))


@_utilities.lift_output_func(get_node_type)
def get_node_type_output(category: Optional[pulumi.Input[Optional[str]]] = None,
                         fleet: Optional[pulumi.Input[Optional[bool]]] = None,
                         gb_per_core: Optional[pulumi.Input[Optional[int]]] = None,
                         graviton: Optional[pulumi.Input[Optional[bool]]] = None,
                         id: Optional[pulumi.Input[Optional[str]]] = None,
                         is_io_cache_enabled: Optional[pulumi.Input[Optional[bool]]] = None,
                         local_disk: Optional[pulumi.Input[Optional[bool]]] = None,
                         local_disk_min_size: Optional[pulumi.Input[Optional[int]]] = None,
                         min_cores: Optional[pulumi.Input[Optional[int]]] = None,
                         min_gpus: Optional[pulumi.Input[Optional[int]]] = None,
                         min_memory_gb: Optional[pulumi.Input[Optional[int]]] = None,
                         photon_driver_capable: Optional[pulumi.Input[Optional[bool]]] = None,
                         photon_worker_capable: Optional[pulumi.Input[Optional[bool]]] = None,
                         support_port_forwarding: Optional[pulumi.Input[Optional[bool]]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetNodeTypeResult]:
    """
    > **Note** If you have a fully automated setup with workspaces created by databricks_mws_workspaces, please make sure to add depends_on attribute in order to prevent _default auth: cannot configure default credentials_ errors.

    Gets the smallest node type for Cluster that fits search criteria, like amount of RAM or number of cores. [AWS](https://databricks.com/product/aws-pricing/instance-types) or [Azure](https://azure.microsoft.com/en-us/pricing/details/databricks/). Internally data source fetches [node types](https://docs.databricks.com/dev-tools/api/latest/clusters.html#list-node-types) available per cloud, similar to executing `databricks clusters list-node-types`, and filters it to return the smallest possible node with criteria.

    > **Note** This is experimental functionality, which aims to simplify things. In case of wrong parameters given (e.g. `min_gpus = 876`) or no nodes matching, data source will return cloud-default node type, even though it doesn't match search criteria specified by data source arguments: [i3.xlarge](https://aws.amazon.com/ec2/instance-types/i3/) for AWS or [Standard_D3_v2](https://docs.microsoft.com/en-us/azure/cloud-services/cloud-services-sizes-specs#dv2-series) for Azure.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_databricks as databricks

    with_gpu = databricks.get_node_type(local_disk=True,
        min_cores=16,
        gb_per_core=1,
        min_gpus=1)
    gpu_ml = databricks.get_spark_version(gpu=True,
        ml=True)
    research = databricks.Cluster("research",
        cluster_name="Research Cluster",
        spark_version=gpu_ml.id,
        node_type_id=with_gpu.id,
        autotermination_minutes=20,
        autoscale=databricks.ClusterAutoscaleArgs(
            min_workers=1,
            max_workers=50,
        ))
    ```

    ## Related Resources

    The following resources are used in the same context:

    * End to end workspace management guide.
    * Cluster to create [Databricks Clusters](https://docs.databricks.com/clusters/index.html).
    * ClusterPolicy to create a Cluster policy, which limits the ability to create clusters based on a set of rules.
    * InstancePool to manage [instance pools](https://docs.databricks.com/clusters/instance-pools/index.html) to reduce cluster start and auto-scaling times by maintaining a set of idle, ready-to-use instances.
    * Job to manage [Databricks Jobs](https://docs.databricks.com/jobs.html) to run non-interactive code in a databricks_cluster.


    :param str category: Node category, which can be one of (depending on the cloud environment, could be checked with `databricks clusters list-node-types -o json|jq '.node_types[]|.category'|sort |uniq`):
           * `General Purpose` (all clouds)
           * `General Purpose (HDD)` (Azure)
           * `Compute Optimized` (all clouds)
           * `Memory Optimized` (all clouds)
           * `Memory Optimized (Remote HDD)` (Azure)
           * `Storage Optimized` (AWS, Azure)
           * `GPU Accelerated` (AWS, Azure)
    :param bool fleet: if we should limit the search only to [AWS fleet instance types](https://docs.databricks.com/compute/aws-fleet-instances.html). Default to _false_.
    :param int gb_per_core: Number of gigabytes per core available on instance. Conflicts with `min_memory_gb`. Defaults to _0_.
    :param bool graviton: if we should limit the search only to nodes with AWS Graviton CPUs. Default to _false_.
    :param str id: node type, that can be used for databricks_job, databricks_cluster, or databricks_instance_pool.
    :param bool is_io_cache_enabled: . Pick only nodes that have IO Cache. Defaults to _false_.
    :param bool local_disk: Pick only nodes with local storage. Defaults to _false_.
    :param int local_disk_min_size: Pick only nodes that have size local storage greater or equal to given value. Defaults to _0_.
    :param int min_cores: Minimum number of CPU cores available on instance. Defaults to _0_.
    :param int min_gpus: Minimum number of GPU's attached to instance. Defaults to _0_.
    :param int min_memory_gb: Minimum amount of memory per node in gigabytes. Defaults to _0_.
    :param bool photon_driver_capable: Pick only nodes that can run Photon driver. Defaults to _false_.
    :param bool photon_worker_capable: Pick only nodes that can run Photon workers. Defaults to _false_.
    :param bool support_port_forwarding: Pick only nodes that support port forwarding. Defaults to _false_.
    """
    ...
