# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetStorageCredentialsResult',
    'AwaitableGetStorageCredentialsResult',
    'get_storage_credentials',
    'get_storage_credentials_output',
]

@pulumi.output_type
class GetStorageCredentialsResult:
    """
    A collection of values returned by getStorageCredentials.
    """
    def __init__(__self__, id=None, names=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def names(self) -> Sequence[str]:
        """
        List of names of StorageCredential in the metastore
        """
        return pulumi.get(self, "names")


class AwaitableGetStorageCredentialsResult(GetStorageCredentialsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStorageCredentialsResult(
            id=self.id,
            names=self.names)


def get_storage_credentials(names: Optional[Sequence[str]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStorageCredentialsResult:
    """
    ## Example Usage

    List all storage credentials in the metastore

    ```python
    import pulumi
    import pulumi_databricks as databricks

    all = databricks.get_storage_credentials()
    pulumi.export("allStorageCredentials", all.names)
    ```

    ## Related Resources

    The following resources are used in the same context:

    * StorageCredential to get information about a single credential
    * StorageCredential to manage Storage Credentials within Unity Catalog.


    :param Sequence[str] names: List of names of StorageCredential in the metastore
    """
    __args__ = dict()
    __args__['names'] = names
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getStorageCredentials:getStorageCredentials', __args__, opts=opts, typ=GetStorageCredentialsResult).value

    return AwaitableGetStorageCredentialsResult(
        id=pulumi.get(__ret__, 'id'),
        names=pulumi.get(__ret__, 'names'))


@_utilities.lift_output_func(get_storage_credentials)
def get_storage_credentials_output(names: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetStorageCredentialsResult]:
    """
    ## Example Usage

    List all storage credentials in the metastore

    ```python
    import pulumi
    import pulumi_databricks as databricks

    all = databricks.get_storage_credentials()
    pulumi.export("allStorageCredentials", all.names)
    ```

    ## Related Resources

    The following resources are used in the same context:

    * StorageCredential to get information about a single credential
    * StorageCredential to manage Storage Credentials within Unity Catalog.


    :param Sequence[str] names: List of names of StorageCredential in the metastore
    """
    ...
