# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetVolumesResult',
    'AwaitableGetVolumesResult',
    'get_volumes',
    'get_volumes_output',
]

@pulumi.output_type
class GetVolumesResult:
    """
    A collection of values returned by getVolumes.
    """
    def __init__(__self__, catalog_name=None, id=None, ids=None, schema_name=None):
        if catalog_name and not isinstance(catalog_name, str):
            raise TypeError("Expected argument 'catalog_name' to be a str")
        pulumi.set(__self__, "catalog_name", catalog_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if schema_name and not isinstance(schema_name, str):
            raise TypeError("Expected argument 'schema_name' to be a str")
        pulumi.set(__self__, "schema_name", schema_name)

    @property
    @pulumi.getter(name="catalogName")
    def catalog_name(self) -> str:
        return pulumi.get(self, "catalog_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Sequence[str]:
        """
        a list of Volume full names: *`catalog`.`schema`.`volume`*
        """
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> str:
        return pulumi.get(self, "schema_name")


class AwaitableGetVolumesResult(GetVolumesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVolumesResult(
            catalog_name=self.catalog_name,
            id=self.id,
            ids=self.ids,
            schema_name=self.schema_name)


def get_volumes(catalog_name: Optional[str] = None,
                ids: Optional[Sequence[str]] = None,
                schema_name: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVolumesResult:
    """
    ## Example Usage

    Listing all volumes in a _things_ Schema of a  _sandbox_ databricks_catalog:

    ```python
    import pulumi
    import pulumi_databricks as databricks

    this = databricks.get_volumes(catalog_name="sandbox",
        schema_name="things")
    pulumi.export("allVolumes", this)
    ```

    ## Related Resources

    The following resources are used in the same context:

    * Volume to manage volumes within Unity Catalog.
    * Schema to manage schemas within Unity Catalog.
    * Catalog to manage catalogs within Unity Catalog.


    :param str catalog_name: Name of databricks_catalog
    :param Sequence[str] ids: a list of Volume full names: *`catalog`.`schema`.`volume`*
    :param str schema_name: Name of databricks_schema
    """
    __args__ = dict()
    __args__['catalogName'] = catalog_name
    __args__['ids'] = ids
    __args__['schemaName'] = schema_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getVolumes:getVolumes', __args__, opts=opts, typ=GetVolumesResult).value

    return AwaitableGetVolumesResult(
        catalog_name=pulumi.get(__ret__, 'catalog_name'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        schema_name=pulumi.get(__ret__, 'schema_name'))


@_utilities.lift_output_func(get_volumes)
def get_volumes_output(catalog_name: Optional[pulumi.Input[str]] = None,
                       ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                       schema_name: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetVolumesResult]:
    """
    ## Example Usage

    Listing all volumes in a _things_ Schema of a  _sandbox_ databricks_catalog:

    ```python
    import pulumi
    import pulumi_databricks as databricks

    this = databricks.get_volumes(catalog_name="sandbox",
        schema_name="things")
    pulumi.export("allVolumes", this)
    ```

    ## Related Resources

    The following resources are used in the same context:

    * Volume to manage volumes within Unity Catalog.
    * Schema to manage schemas within Unity Catalog.
    * Catalog to manage catalogs within Unity Catalog.


    :param str catalog_name: Name of databricks_catalog
    :param Sequence[str] ids: a list of Volume full names: *`catalog`.`schema`.`volume`*
    :param str schema_name: Name of databricks_schema
    """
    ...
