# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MountArgs', 'Mount']

@pulumi.input_type
class MountArgs:
    def __init__(__self__, *,
                 abfs: Optional[pulumi.Input['MountAbfsArgs']] = None,
                 adl: Optional[pulumi.Input['MountAdlArgs']] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 encryption_type: Optional[pulumi.Input[str]] = None,
                 extra_configs: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 gs: Optional[pulumi.Input['MountGsArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 s3: Optional[pulumi.Input['MountS3Args']] = None,
                 uri: Optional[pulumi.Input[str]] = None,
                 wasb: Optional[pulumi.Input['MountWasbArgs']] = None):
        """
        The set of arguments for constructing a Mount resource.
        """
        if abfs is not None:
            pulumi.set(__self__, "abfs", abfs)
        if adl is not None:
            pulumi.set(__self__, "adl", adl)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if encryption_type is not None:
            pulumi.set(__self__, "encryption_type", encryption_type)
        if extra_configs is not None:
            pulumi.set(__self__, "extra_configs", extra_configs)
        if gs is not None:
            pulumi.set(__self__, "gs", gs)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)
        if wasb is not None:
            pulumi.set(__self__, "wasb", wasb)

    @property
    @pulumi.getter
    def abfs(self) -> Optional[pulumi.Input['MountAbfsArgs']]:
        return pulumi.get(self, "abfs")

    @abfs.setter
    def abfs(self, value: Optional[pulumi.Input['MountAbfsArgs']]):
        pulumi.set(self, "abfs", value)

    @property
    @pulumi.getter
    def adl(self) -> Optional[pulumi.Input['MountAdlArgs']]:
        return pulumi.get(self, "adl")

    @adl.setter
    def adl(self, value: Optional[pulumi.Input['MountAdlArgs']]):
        pulumi.set(self, "adl", value)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "encryption_type")

    @encryption_type.setter
    def encryption_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption_type", value)

    @property
    @pulumi.getter(name="extraConfigs")
    def extra_configs(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        return pulumi.get(self, "extra_configs")

    @extra_configs.setter
    def extra_configs(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "extra_configs", value)

    @property
    @pulumi.getter
    def gs(self) -> Optional[pulumi.Input['MountGsArgs']]:
        return pulumi.get(self, "gs")

    @gs.setter
    def gs(self, value: Optional[pulumi.Input['MountGsArgs']]):
        pulumi.set(self, "gs", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter
    def s3(self) -> Optional[pulumi.Input['MountS3Args']]:
        return pulumi.get(self, "s3")

    @s3.setter
    def s3(self, value: Optional[pulumi.Input['MountS3Args']]):
        pulumi.set(self, "s3", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)

    @property
    @pulumi.getter
    def wasb(self) -> Optional[pulumi.Input['MountWasbArgs']]:
        return pulumi.get(self, "wasb")

    @wasb.setter
    def wasb(self, value: Optional[pulumi.Input['MountWasbArgs']]):
        pulumi.set(self, "wasb", value)


@pulumi.input_type
class _MountState:
    def __init__(__self__, *,
                 abfs: Optional[pulumi.Input['MountAbfsArgs']] = None,
                 adl: Optional[pulumi.Input['MountAdlArgs']] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 encryption_type: Optional[pulumi.Input[str]] = None,
                 extra_configs: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 gs: Optional[pulumi.Input['MountGsArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 s3: Optional[pulumi.Input['MountS3Args']] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 uri: Optional[pulumi.Input[str]] = None,
                 wasb: Optional[pulumi.Input['MountWasbArgs']] = None):
        """
        Input properties used for looking up and filtering Mount resources.
        :param pulumi.Input[str] source: (String) HDFS-compatible url
        """
        if abfs is not None:
            pulumi.set(__self__, "abfs", abfs)
        if adl is not None:
            pulumi.set(__self__, "adl", adl)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if encryption_type is not None:
            pulumi.set(__self__, "encryption_type", encryption_type)
        if extra_configs is not None:
            pulumi.set(__self__, "extra_configs", extra_configs)
        if gs is not None:
            pulumi.set(__self__, "gs", gs)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if s3 is not None:
            pulumi.set(__self__, "s3", s3)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)
        if wasb is not None:
            pulumi.set(__self__, "wasb", wasb)

    @property
    @pulumi.getter
    def abfs(self) -> Optional[pulumi.Input['MountAbfsArgs']]:
        return pulumi.get(self, "abfs")

    @abfs.setter
    def abfs(self, value: Optional[pulumi.Input['MountAbfsArgs']]):
        pulumi.set(self, "abfs", value)

    @property
    @pulumi.getter
    def adl(self) -> Optional[pulumi.Input['MountAdlArgs']]:
        return pulumi.get(self, "adl")

    @adl.setter
    def adl(self, value: Optional[pulumi.Input['MountAdlArgs']]):
        pulumi.set(self, "adl", value)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "encryption_type")

    @encryption_type.setter
    def encryption_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption_type", value)

    @property
    @pulumi.getter(name="extraConfigs")
    def extra_configs(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        return pulumi.get(self, "extra_configs")

    @extra_configs.setter
    def extra_configs(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "extra_configs", value)

    @property
    @pulumi.getter
    def gs(self) -> Optional[pulumi.Input['MountGsArgs']]:
        return pulumi.get(self, "gs")

    @gs.setter
    def gs(self, value: Optional[pulumi.Input['MountGsArgs']]):
        pulumi.set(self, "gs", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter
    def s3(self) -> Optional[pulumi.Input['MountS3Args']]:
        return pulumi.get(self, "s3")

    @s3.setter
    def s3(self, value: Optional[pulumi.Input['MountS3Args']]):
        pulumi.set(self, "s3", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[str]]:
        """
        (String) HDFS-compatible url
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)

    @property
    @pulumi.getter
    def wasb(self) -> Optional[pulumi.Input['MountWasbArgs']]:
        return pulumi.get(self, "wasb")

    @wasb.setter
    def wasb(self, value: Optional[pulumi.Input['MountWasbArgs']]):
        pulumi.set(self, "wasb", value)


class Mount(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 abfs: Optional[pulumi.Input[pulumi.InputType['MountAbfsArgs']]] = None,
                 adl: Optional[pulumi.Input[pulumi.InputType['MountAdlArgs']]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 encryption_type: Optional[pulumi.Input[str]] = None,
                 extra_configs: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 gs: Optional[pulumi.Input[pulumi.InputType['MountGsArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 s3: Optional[pulumi.Input[pulumi.InputType['MountS3Args']]] = None,
                 uri: Optional[pulumi.Input[str]] = None,
                 wasb: Optional[pulumi.Input[pulumi.InputType['MountWasbArgs']]] = None,
                 __props__=None):
        """
        This resource will mount your cloud storage
        * `gs` - to [mount Google Cloud Storage](https://docs.gcp.databricks.com/data/data-sources/google/gcs.html)
        * `abfs` - to [mount ADLS Gen2](https://docs.microsoft.com/en-us/azure/databricks/data/data-sources/azure/adls-gen2/) using Azure Blob Filesystem (ABFS) driver
        * `adl` - to [mount ADLS Gen1](https://docs.microsoft.com/en-us/azure/databricks/data/data-sources/azure/azure-datalake) using Azure Data Lake (ADL) driver
        * `wasb`  - to [mount Azure Blob Storage](https://docs.microsoft.com/en-us/azure/databricks/data/data-sources/azure/azure-storage) using Windows Azure Storage Blob (WASB) driver

        1. Use generic arguments - you have a responsibility for providing all necessary parameters that are required to mount specific storage. This is most flexible option

        ## Common arguments

        * `cluster_id` - (Optional, String) Cluster to use for mounting. If no cluster is specified, a new cluster will be created and will mount the bucket for all of the clusters in this workspace. If the cluster is not running - it's going to be started, so be aware to set auto-termination rules on it.
        * `name` - (Optional, String) Name, under which mount will be accessible in `dbfs:/mnt/<MOUNT_NAME>`. If not specified, provider will try to infer it from depending on the resource type:
          * `bucket_name` for AWS S3 and Google Cloud Storage
          * `container_name` for ADLS Gen2 and Azure Blob Storage
          * `storage_resource_name` for ADLS Gen1
        * `uri` - (Optional, String) the URI for accessing specific storage (`s3a://....`, `abfss://....`, `gs://....`, etc.)
        * `extra_configs` - (Optional, String map) configuration parameters that are necessary for mounting of specific storage
        * `resource_id` - (Optional, String) resource ID for a given storage account. Could be used to fill defaults, such as storage account & container names on Azure.
        * `encryption_type` - (Optional, String) encryption type. Currently used only for [AWS S3 mounts](https://docs.databricks.com/data/data-sources/aws/amazon-s3.html#encrypt-data-in-s3-buckets)

        ### Example mounting ADLS Gen2 using uri and extra_configs

        ```python
        import pulumi
        import pulumi_databricks as databricks

        tenant_id = "00000000-1111-2222-3333-444444444444"
        client_id = "55555555-6666-7777-8888-999999999999"
        secret_scope = "some-kv"
        secret_key = "some-sp-secret"
        container = "test"
        storage_acc = "lrs"
        this = databricks.Mount("this",
            name="tf-abfss",
            uri=f"abfss://{container}@{storage_acc}.dfs.core.windows.net",
            extra_configs={
                "fs.azure.account.auth.type": "OAuth",
                "fs.azure.account.oauth.provider.type": "org.apache.hadoop.fs.azurebfs.oauth2.ClientCredsTokenProvider",
                "fs.azure.account.oauth2.client.id": client_id,
                "fs.azure.account.oauth2.client.secret": f"{{{{secrets/{secret_scope}/{secret_key}}}}}",
                "fs.azure.account.oauth2.client.endpoint": f"https://login.microsoftonline.com/{tenant_id}/oauth2/token",
                "fs.azure.createRemoteFileSystemDuringInitialization": "false",
            })
        ```

        ### Example mounting ADLS Gen2 with AAD passthrough

        > **Note** AAD passthrough is considered a legacy data access pattern. Use Unity Catalog for fine-grained data access control.

        > **Note** Mounts using AAD passthrough cannot be created using a service principal.

        To mount ALDS Gen2 with Azure Active Directory Credentials passthrough we need to execute the mount commands using the cluster configured with AAD Credentials passthrough & provide necessary configuration parameters (see [documentation](https://docs.microsoft.com/en-us/azure/databricks/security/credential-passthrough/adls-passthrough#--mount-azure-data-lake-storage-to-dbfs-using-credential-passthrough) for more details).

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_databricks as databricks

        config = pulumi.Config()
        # Resource group for Databricks Workspace
        resource_group = config.require("resourceGroup")
        # Name of the Databricks Workspace
        workspace_name = config.require("workspaceName")
        this = azure.databricks.get_workspace(name=workspace_name,
            resource_group_name=resource_group)
        smallest = databricks.get_node_type(local_disk=True)
        latest = databricks.get_spark_version()
        shared_passthrough = databricks.Cluster("shared_passthrough",
            cluster_name="Shared Passthrough for mount",
            spark_version=latest.id,
            node_type_id=smallest.id,
            autotermination_minutes=10,
            num_workers=1,
            spark_conf={
                "spark.databricks.cluster.profile": "serverless",
                "spark.databricks.repl.allowedLanguages": "python,sql",
                "spark.databricks.passthrough.enabled": "true",
                "spark.databricks.pyspark.enableProcessIsolation": "true",
            },
            custom_tags={
                "ResourceClass": "Serverless",
            })
        # Name of the ADLS Gen2 storage container
        storage_acc = config.require("storageAcc")
        # Name of container inside storage account
        container = config.require("container")
        passthrough = databricks.Mount("passthrough",
            name="passthrough-test",
            cluster_id=shared_passthrough.id,
            uri=f"abfss://{container}@{storage_acc}.dfs.core.windows.net",
            extra_configs={
                "fs.azure.account.auth.type": "CustomAccessToken",
                "fs.azure.account.custom.token.provider.class": "{{sparkconf/spark.databricks.passthrough.adls.gen2.tokenProviderClassName}}",
            })
        ```

        ## s3 block

        This block allows specifying parameters for mounting of the ADLS Gen2. The following arguments are required inside the `s3` block:

        * `instance_profile` - (Optional) (String) ARN of registered instance profile for data access.  If it's not specified, then the `cluster_id` should be provided, and the cluster should have an instance profile attached to it. If both `cluster_id` & `instance_profile` are specified, then `cluster_id` takes precedence.
        * `bucket_name` - (Required) (String) S3 bucket name to be mounted.

        ### Example of mounting S3

        ```python
        import pulumi
        import pulumi_databricks as databricks

        # now you can do `%fs ls /mnt/experiments` in notebooks
        this = databricks.Mount("this",
            name="experiments",
            s3=databricks.MountS3Args(
                instance_profile=ds["id"],
                bucket_name=this_aws_s3_bucket["bucket"],
            ))
        ```

        ## abfs block

        This block allows specifying parameters for mounting of the ADLS Gen2. The following arguments are required inside the `abfs` block:

        * `client_id` - (Required) (String) This is the client_id (Application Object ID) for the enterprise application for the service principal.
        * `tenant_id` - (Optional) (String) This is your azure directory tenant id. It is required for creating the mount. (Could be omitted if Azure authentication is used, and we can extract `tenant_id` from it).
        * `client_secret_key` - (Required) (String) This is the secret key in which your service principal/enterprise app client secret will be stored.
        * `client_secret_scope` - (Required) (String) This is the secret scope in which your service principal/enterprise app client secret will be stored.
        * `container_name` - (Required) (String) ADLS gen2 container name. (Could be omitted if `resource_id` is provided)
        * `storage_account_name` - (Required) (String) The name of the storage resource in which the data is. (Could be omitted if `resource_id` is provided)
        * `directory` - (Computed) (String) This is optional if you don't want to add an additional directory that you wish to mount. This must start with a "/".
        * `initialize_file_system` - (Required) (Bool) either or not initialize FS for the first use

        ### Creating mount for ADLS Gen2 using abfs block

        In this example, we're using Azure authentication, so we can omit some parameters (`tenant_id`, `storage_account_name`, and `container_name`) that will be detected automatically.

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_databricks as databricks

        terraform = databricks.SecretScope("terraform",
            name="application",
            initial_manage_principal="users")
        service_principal_key = databricks.Secret("service_principal_key",
            key="service_principal_key",
            string_value=ar_m__clien_t__secret,
            scope=terraform.name)
        this = azure.storage.Account("this",
            name=f"{prefix}datalake",
            resource_group_name=resource_group_name,
            location=resource_group_location,
            account_tier="Standard",
            account_replication_type="GRS",
            account_kind="StorageV2",
            is_hns_enabled=True)
        this_assignment = azure.authorization.Assignment("this",
            scope=this.id,
            role_definition_name="Storage Blob Data Contributor",
            principal_id=current["objectId"])
        this_container = azure.storage.Container("this",
            name="marketing",
            storage_account_name=this.name,
            container_access_type="private")
        marketing = databricks.Mount("marketing",
            name="marketing",
            resource_id=this_container.resource_manager_id,
            abfs=databricks.MountAbfsArgs(
                client_id=current["clientId"],
                client_secret_scope=terraform.name,
                client_secret_key=service_principal_key.key,
                initialize_file_system=True,
            ))
        ```

        ## gs block

        This block allows specifying parameters for mounting of the Google Cloud Storage. The following arguments are required inside the `gs` block:

        * `service_account` - (Optional) (String) email of registered [Google Service Account](https://docs.gcp.databricks.com/data/data-sources/google/gcs.html#step-1-set-up-google-cloud-service-account-using-google-cloud-console) for data access.  If it's not specified, then the `cluster_id` should be provided, and the cluster should have a Google service account attached to it.
        * `bucket_name` - (Required) (String) GCS bucket name to be mounted.

        ### Example mounting Google Cloud Storage

        ```python
        import pulumi
        import pulumi_databricks as databricks

        this_gs = databricks.Mount("this_gs",
            name="gs-mount",
            gs=databricks.MountGsArgs(
                service_account="acc@company.iam.gserviceaccount.com",
                bucket_name="mybucket",
            ))
        ```

        ## adl block

        This block allows specifying parameters for mounting of the ADLS Gen1. The following arguments are required inside the `adl` block:

        * `client_id` - (Required) (String) This is the client_id for the enterprise application for the service principal.
        * `tenant_id` - (Optional) (String) This is your azure directory tenant id. It is required for creating the mount. (Could be omitted if Azure authentication is used, and we can extract `tenant_id` from it)
        * `client_secret_key` - (Required) (String) This is the secret key in which your service principal/enterprise app client secret will be stored.
        * `client_secret_scope` - (Required) (String) This is the secret scope in which your service principal/enterprise app client secret will be stored.

        * `storage_resource_name` - (Required) (String) The name of the storage resource in which the data is for ADLS gen 1. This is what you are trying to mount. (Could be omitted if `resource_id` is provided)
        * `spark_conf_prefix` - (Optional) (String) This is the spark configuration prefix for adls gen 1 mount. The options are `fs.adl`, `dfs.adls`. Use `fs.adl` for runtime 6.0 and above for the clusters. Otherwise use `dfs.adls`. The default value is: `fs.adl`.
        * `directory` - (Computed) (String) This is optional if you don't want to add an additional directory that you wish to mount. This must start with a "/".

        ### Example mounting ADLS Gen1

        ```python
        import pulumi
        import pulumi_databricks as databricks

        mount = databricks.Mount("mount",
            name="{var.RANDOM}",
            adl=databricks.MountAdlArgs(
                storage_resource_name="{env.TEST_STORAGE_ACCOUNT_NAME}",
                tenant_id=current["tenantId"],
                client_id=current["clientId"],
                client_secret_scope=terraform["name"],
                client_secret_key=service_principal_key["key"],
                spark_conf_prefix="fs.adl",
            ))
        ```

        ## wasb block

        This block allows specifying parameters for mounting of the Azure Blob Storage. The following arguments are required inside the `wasb` block:

        * `auth_type` - (Required) (String) This is the auth type for blob storage. This can either be SAS tokens (`SAS`) or account access keys (`ACCESS_KEY`).
        * `token_secret_scope` - (Required) (String) This is the secret scope in which your auth type token is stored.
        * `token_secret_key` - (Required) (String) This is the secret key in which your auth type token is stored.
        * `container_name` - (Required) (String) The container in which the data is. This is what you are trying to mount. (Could be omitted if `resource_id` is provided)
        * `storage_account_name` - (Required) (String) The name of the storage resource in which the data is. (Could be omitted if `resource_id` is provided)
        * `directory` - (Computed) (String) This is optional if you don't want to add an additional directory that you wish to mount. This must start with a "/".

        ### Example mounting Azure Blob Storage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_databricks as databricks

        blobaccount = azure.storage.Account("blobaccount",
            name=f"{prefix}blob",
            resource_group_name=resource_group_name,
            location=resource_group_location,
            account_tier="Standard",
            account_replication_type="LRS",
            account_kind="StorageV2")
        marketing = azure.storage.Container("marketing",
            name="marketing",
            storage_account_name=blobaccount.name,
            container_access_type="private")
        terraform = databricks.SecretScope("terraform",
            name="application",
            initial_manage_principal="users")
        storage_key = databricks.Secret("storage_key",
            key="blob_storage_key",
            string_value=blobaccount.primary_access_key,
            scope=terraform.name)
        marketing_mount = databricks.Mount("marketing",
            name="marketing",
            wasb=databricks.MountWasbArgs(
                container_name=marketing.name,
                storage_account_name=blobaccount.name,
                auth_type="ACCESS_KEY",
                token_secret_scope=terraform.name,
                token_secret_key=storage_key.key,
            ))
        ```

        ## Migration from other mount resources

        Migration from the specific mount resource is straightforward:

        * rename `mount_name` to `name`
        * wrap storage-specific settings (`container_name`, ...) into corresponding block (`adl`, `abfs`, `s3`, `wasbs`)
        * for S3 mounts, rename `s3_bucket_name` to `bucket_name`

        ## Related Resources

        The following resources are often used in the same context:

        * End to end workspace management guide.
        * get_aws_bucket_policy data to configure a simple access policy for AWS S3 buckets, so that Databricks can access data in it.
        * Cluster to create [Databricks Clusters](https://docs.databricks.com/clusters/index.html).
        * DbfsFile data to get file content from [Databricks File System (DBFS)](https://docs.databricks.com/data/databricks-file-system.html).
        * get_dbfs_file_paths data to get list of file names from get file content from [Databricks File System (DBFS)](https://docs.databricks.com/data/databricks-file-system.html).
        * DbfsFile to manage relatively small files on [Databricks File System (DBFS)](https://docs.databricks.com/data/databricks-file-system.html).
        * InstanceProfile to manage AWS EC2 instance profiles that users can launch Cluster and access data, like databricks_mount.
        * Library to install a [library](https://docs.databricks.com/libraries/index.html) on databricks_cluster.

        ## Import

        -> **Note** Importing this resource is not currently supported.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[MountArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource will mount your cloud storage
        * `gs` - to [mount Google Cloud Storage](https://docs.gcp.databricks.com/data/data-sources/google/gcs.html)
        * `abfs` - to [mount ADLS Gen2](https://docs.microsoft.com/en-us/azure/databricks/data/data-sources/azure/adls-gen2/) using Azure Blob Filesystem (ABFS) driver
        * `adl` - to [mount ADLS Gen1](https://docs.microsoft.com/en-us/azure/databricks/data/data-sources/azure/azure-datalake) using Azure Data Lake (ADL) driver
        * `wasb`  - to [mount Azure Blob Storage](https://docs.microsoft.com/en-us/azure/databricks/data/data-sources/azure/azure-storage) using Windows Azure Storage Blob (WASB) driver

        1. Use generic arguments - you have a responsibility for providing all necessary parameters that are required to mount specific storage. This is most flexible option

        ## Common arguments

        * `cluster_id` - (Optional, String) Cluster to use for mounting. If no cluster is specified, a new cluster will be created and will mount the bucket for all of the clusters in this workspace. If the cluster is not running - it's going to be started, so be aware to set auto-termination rules on it.
        * `name` - (Optional, String) Name, under which mount will be accessible in `dbfs:/mnt/<MOUNT_NAME>`. If not specified, provider will try to infer it from depending on the resource type:
          * `bucket_name` for AWS S3 and Google Cloud Storage
          * `container_name` for ADLS Gen2 and Azure Blob Storage
          * `storage_resource_name` for ADLS Gen1
        * `uri` - (Optional, String) the URI for accessing specific storage (`s3a://....`, `abfss://....`, `gs://....`, etc.)
        * `extra_configs` - (Optional, String map) configuration parameters that are necessary for mounting of specific storage
        * `resource_id` - (Optional, String) resource ID for a given storage account. Could be used to fill defaults, such as storage account & container names on Azure.
        * `encryption_type` - (Optional, String) encryption type. Currently used only for [AWS S3 mounts](https://docs.databricks.com/data/data-sources/aws/amazon-s3.html#encrypt-data-in-s3-buckets)

        ### Example mounting ADLS Gen2 using uri and extra_configs

        ```python
        import pulumi
        import pulumi_databricks as databricks

        tenant_id = "00000000-1111-2222-3333-444444444444"
        client_id = "55555555-6666-7777-8888-999999999999"
        secret_scope = "some-kv"
        secret_key = "some-sp-secret"
        container = "test"
        storage_acc = "lrs"
        this = databricks.Mount("this",
            name="tf-abfss",
            uri=f"abfss://{container}@{storage_acc}.dfs.core.windows.net",
            extra_configs={
                "fs.azure.account.auth.type": "OAuth",
                "fs.azure.account.oauth.provider.type": "org.apache.hadoop.fs.azurebfs.oauth2.ClientCredsTokenProvider",
                "fs.azure.account.oauth2.client.id": client_id,
                "fs.azure.account.oauth2.client.secret": f"{{{{secrets/{secret_scope}/{secret_key}}}}}",
                "fs.azure.account.oauth2.client.endpoint": f"https://login.microsoftonline.com/{tenant_id}/oauth2/token",
                "fs.azure.createRemoteFileSystemDuringInitialization": "false",
            })
        ```

        ### Example mounting ADLS Gen2 with AAD passthrough

        > **Note** AAD passthrough is considered a legacy data access pattern. Use Unity Catalog for fine-grained data access control.

        > **Note** Mounts using AAD passthrough cannot be created using a service principal.

        To mount ALDS Gen2 with Azure Active Directory Credentials passthrough we need to execute the mount commands using the cluster configured with AAD Credentials passthrough & provide necessary configuration parameters (see [documentation](https://docs.microsoft.com/en-us/azure/databricks/security/credential-passthrough/adls-passthrough#--mount-azure-data-lake-storage-to-dbfs-using-credential-passthrough) for more details).

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_databricks as databricks

        config = pulumi.Config()
        # Resource group for Databricks Workspace
        resource_group = config.require("resourceGroup")
        # Name of the Databricks Workspace
        workspace_name = config.require("workspaceName")
        this = azure.databricks.get_workspace(name=workspace_name,
            resource_group_name=resource_group)
        smallest = databricks.get_node_type(local_disk=True)
        latest = databricks.get_spark_version()
        shared_passthrough = databricks.Cluster("shared_passthrough",
            cluster_name="Shared Passthrough for mount",
            spark_version=latest.id,
            node_type_id=smallest.id,
            autotermination_minutes=10,
            num_workers=1,
            spark_conf={
                "spark.databricks.cluster.profile": "serverless",
                "spark.databricks.repl.allowedLanguages": "python,sql",
                "spark.databricks.passthrough.enabled": "true",
                "spark.databricks.pyspark.enableProcessIsolation": "true",
            },
            custom_tags={
                "ResourceClass": "Serverless",
            })
        # Name of the ADLS Gen2 storage container
        storage_acc = config.require("storageAcc")
        # Name of container inside storage account
        container = config.require("container")
        passthrough = databricks.Mount("passthrough",
            name="passthrough-test",
            cluster_id=shared_passthrough.id,
            uri=f"abfss://{container}@{storage_acc}.dfs.core.windows.net",
            extra_configs={
                "fs.azure.account.auth.type": "CustomAccessToken",
                "fs.azure.account.custom.token.provider.class": "{{sparkconf/spark.databricks.passthrough.adls.gen2.tokenProviderClassName}}",
            })
        ```

        ## s3 block

        This block allows specifying parameters for mounting of the ADLS Gen2. The following arguments are required inside the `s3` block:

        * `instance_profile` - (Optional) (String) ARN of registered instance profile for data access.  If it's not specified, then the `cluster_id` should be provided, and the cluster should have an instance profile attached to it. If both `cluster_id` & `instance_profile` are specified, then `cluster_id` takes precedence.
        * `bucket_name` - (Required) (String) S3 bucket name to be mounted.

        ### Example of mounting S3

        ```python
        import pulumi
        import pulumi_databricks as databricks

        # now you can do `%fs ls /mnt/experiments` in notebooks
        this = databricks.Mount("this",
            name="experiments",
            s3=databricks.MountS3Args(
                instance_profile=ds["id"],
                bucket_name=this_aws_s3_bucket["bucket"],
            ))
        ```

        ## abfs block

        This block allows specifying parameters for mounting of the ADLS Gen2. The following arguments are required inside the `abfs` block:

        * `client_id` - (Required) (String) This is the client_id (Application Object ID) for the enterprise application for the service principal.
        * `tenant_id` - (Optional) (String) This is your azure directory tenant id. It is required for creating the mount. (Could be omitted if Azure authentication is used, and we can extract `tenant_id` from it).
        * `client_secret_key` - (Required) (String) This is the secret key in which your service principal/enterprise app client secret will be stored.
        * `client_secret_scope` - (Required) (String) This is the secret scope in which your service principal/enterprise app client secret will be stored.
        * `container_name` - (Required) (String) ADLS gen2 container name. (Could be omitted if `resource_id` is provided)
        * `storage_account_name` - (Required) (String) The name of the storage resource in which the data is. (Could be omitted if `resource_id` is provided)
        * `directory` - (Computed) (String) This is optional if you don't want to add an additional directory that you wish to mount. This must start with a "/".
        * `initialize_file_system` - (Required) (Bool) either or not initialize FS for the first use

        ### Creating mount for ADLS Gen2 using abfs block

        In this example, we're using Azure authentication, so we can omit some parameters (`tenant_id`, `storage_account_name`, and `container_name`) that will be detected automatically.

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_databricks as databricks

        terraform = databricks.SecretScope("terraform",
            name="application",
            initial_manage_principal="users")
        service_principal_key = databricks.Secret("service_principal_key",
            key="service_principal_key",
            string_value=ar_m__clien_t__secret,
            scope=terraform.name)
        this = azure.storage.Account("this",
            name=f"{prefix}datalake",
            resource_group_name=resource_group_name,
            location=resource_group_location,
            account_tier="Standard",
            account_replication_type="GRS",
            account_kind="StorageV2",
            is_hns_enabled=True)
        this_assignment = azure.authorization.Assignment("this",
            scope=this.id,
            role_definition_name="Storage Blob Data Contributor",
            principal_id=current["objectId"])
        this_container = azure.storage.Container("this",
            name="marketing",
            storage_account_name=this.name,
            container_access_type="private")
        marketing = databricks.Mount("marketing",
            name="marketing",
            resource_id=this_container.resource_manager_id,
            abfs=databricks.MountAbfsArgs(
                client_id=current["clientId"],
                client_secret_scope=terraform.name,
                client_secret_key=service_principal_key.key,
                initialize_file_system=True,
            ))
        ```

        ## gs block

        This block allows specifying parameters for mounting of the Google Cloud Storage. The following arguments are required inside the `gs` block:

        * `service_account` - (Optional) (String) email of registered [Google Service Account](https://docs.gcp.databricks.com/data/data-sources/google/gcs.html#step-1-set-up-google-cloud-service-account-using-google-cloud-console) for data access.  If it's not specified, then the `cluster_id` should be provided, and the cluster should have a Google service account attached to it.
        * `bucket_name` - (Required) (String) GCS bucket name to be mounted.

        ### Example mounting Google Cloud Storage

        ```python
        import pulumi
        import pulumi_databricks as databricks

        this_gs = databricks.Mount("this_gs",
            name="gs-mount",
            gs=databricks.MountGsArgs(
                service_account="acc@company.iam.gserviceaccount.com",
                bucket_name="mybucket",
            ))
        ```

        ## adl block

        This block allows specifying parameters for mounting of the ADLS Gen1. The following arguments are required inside the `adl` block:

        * `client_id` - (Required) (String) This is the client_id for the enterprise application for the service principal.
        * `tenant_id` - (Optional) (String) This is your azure directory tenant id. It is required for creating the mount. (Could be omitted if Azure authentication is used, and we can extract `tenant_id` from it)
        * `client_secret_key` - (Required) (String) This is the secret key in which your service principal/enterprise app client secret will be stored.
        * `client_secret_scope` - (Required) (String) This is the secret scope in which your service principal/enterprise app client secret will be stored.

        * `storage_resource_name` - (Required) (String) The name of the storage resource in which the data is for ADLS gen 1. This is what you are trying to mount. (Could be omitted if `resource_id` is provided)
        * `spark_conf_prefix` - (Optional) (String) This is the spark configuration prefix for adls gen 1 mount. The options are `fs.adl`, `dfs.adls`. Use `fs.adl` for runtime 6.0 and above for the clusters. Otherwise use `dfs.adls`. The default value is: `fs.adl`.
        * `directory` - (Computed) (String) This is optional if you don't want to add an additional directory that you wish to mount. This must start with a "/".

        ### Example mounting ADLS Gen1

        ```python
        import pulumi
        import pulumi_databricks as databricks

        mount = databricks.Mount("mount",
            name="{var.RANDOM}",
            adl=databricks.MountAdlArgs(
                storage_resource_name="{env.TEST_STORAGE_ACCOUNT_NAME}",
                tenant_id=current["tenantId"],
                client_id=current["clientId"],
                client_secret_scope=terraform["name"],
                client_secret_key=service_principal_key["key"],
                spark_conf_prefix="fs.adl",
            ))
        ```

        ## wasb block

        This block allows specifying parameters for mounting of the Azure Blob Storage. The following arguments are required inside the `wasb` block:

        * `auth_type` - (Required) (String) This is the auth type for blob storage. This can either be SAS tokens (`SAS`) or account access keys (`ACCESS_KEY`).
        * `token_secret_scope` - (Required) (String) This is the secret scope in which your auth type token is stored.
        * `token_secret_key` - (Required) (String) This is the secret key in which your auth type token is stored.
        * `container_name` - (Required) (String) The container in which the data is. This is what you are trying to mount. (Could be omitted if `resource_id` is provided)
        * `storage_account_name` - (Required) (String) The name of the storage resource in which the data is. (Could be omitted if `resource_id` is provided)
        * `directory` - (Computed) (String) This is optional if you don't want to add an additional directory that you wish to mount. This must start with a "/".

        ### Example mounting Azure Blob Storage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_databricks as databricks

        blobaccount = azure.storage.Account("blobaccount",
            name=f"{prefix}blob",
            resource_group_name=resource_group_name,
            location=resource_group_location,
            account_tier="Standard",
            account_replication_type="LRS",
            account_kind="StorageV2")
        marketing = azure.storage.Container("marketing",
            name="marketing",
            storage_account_name=blobaccount.name,
            container_access_type="private")
        terraform = databricks.SecretScope("terraform",
            name="application",
            initial_manage_principal="users")
        storage_key = databricks.Secret("storage_key",
            key="blob_storage_key",
            string_value=blobaccount.primary_access_key,
            scope=terraform.name)
        marketing_mount = databricks.Mount("marketing",
            name="marketing",
            wasb=databricks.MountWasbArgs(
                container_name=marketing.name,
                storage_account_name=blobaccount.name,
                auth_type="ACCESS_KEY",
                token_secret_scope=terraform.name,
                token_secret_key=storage_key.key,
            ))
        ```

        ## Migration from other mount resources

        Migration from the specific mount resource is straightforward:

        * rename `mount_name` to `name`
        * wrap storage-specific settings (`container_name`, ...) into corresponding block (`adl`, `abfs`, `s3`, `wasbs`)
        * for S3 mounts, rename `s3_bucket_name` to `bucket_name`

        ## Related Resources

        The following resources are often used in the same context:

        * End to end workspace management guide.
        * get_aws_bucket_policy data to configure a simple access policy for AWS S3 buckets, so that Databricks can access data in it.
        * Cluster to create [Databricks Clusters](https://docs.databricks.com/clusters/index.html).
        * DbfsFile data to get file content from [Databricks File System (DBFS)](https://docs.databricks.com/data/databricks-file-system.html).
        * get_dbfs_file_paths data to get list of file names from get file content from [Databricks File System (DBFS)](https://docs.databricks.com/data/databricks-file-system.html).
        * DbfsFile to manage relatively small files on [Databricks File System (DBFS)](https://docs.databricks.com/data/databricks-file-system.html).
        * InstanceProfile to manage AWS EC2 instance profiles that users can launch Cluster and access data, like databricks_mount.
        * Library to install a [library](https://docs.databricks.com/libraries/index.html) on databricks_cluster.

        ## Import

        -> **Note** Importing this resource is not currently supported.

        :param str resource_name: The name of the resource.
        :param MountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 abfs: Optional[pulumi.Input[pulumi.InputType['MountAbfsArgs']]] = None,
                 adl: Optional[pulumi.Input[pulumi.InputType['MountAdlArgs']]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 encryption_type: Optional[pulumi.Input[str]] = None,
                 extra_configs: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 gs: Optional[pulumi.Input[pulumi.InputType['MountGsArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 s3: Optional[pulumi.Input[pulumi.InputType['MountS3Args']]] = None,
                 uri: Optional[pulumi.Input[str]] = None,
                 wasb: Optional[pulumi.Input[pulumi.InputType['MountWasbArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MountArgs.__new__(MountArgs)

            __props__.__dict__["abfs"] = abfs
            __props__.__dict__["adl"] = adl
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["encryption_type"] = encryption_type
            __props__.__dict__["extra_configs"] = extra_configs
            __props__.__dict__["gs"] = gs
            __props__.__dict__["name"] = name
            __props__.__dict__["resource_id"] = resource_id
            __props__.__dict__["s3"] = s3
            __props__.__dict__["uri"] = uri
            __props__.__dict__["wasb"] = wasb
            __props__.__dict__["source"] = None
        super(Mount, __self__).__init__(
            'databricks:index/mount:Mount',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            abfs: Optional[pulumi.Input[pulumi.InputType['MountAbfsArgs']]] = None,
            adl: Optional[pulumi.Input[pulumi.InputType['MountAdlArgs']]] = None,
            cluster_id: Optional[pulumi.Input[str]] = None,
            encryption_type: Optional[pulumi.Input[str]] = None,
            extra_configs: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            gs: Optional[pulumi.Input[pulumi.InputType['MountGsArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            resource_id: Optional[pulumi.Input[str]] = None,
            s3: Optional[pulumi.Input[pulumi.InputType['MountS3Args']]] = None,
            source: Optional[pulumi.Input[str]] = None,
            uri: Optional[pulumi.Input[str]] = None,
            wasb: Optional[pulumi.Input[pulumi.InputType['MountWasbArgs']]] = None) -> 'Mount':
        """
        Get an existing Mount resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] source: (String) HDFS-compatible url
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MountState.__new__(_MountState)

        __props__.__dict__["abfs"] = abfs
        __props__.__dict__["adl"] = adl
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["encryption_type"] = encryption_type
        __props__.__dict__["extra_configs"] = extra_configs
        __props__.__dict__["gs"] = gs
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_id"] = resource_id
        __props__.__dict__["s3"] = s3
        __props__.__dict__["source"] = source
        __props__.__dict__["uri"] = uri
        __props__.__dict__["wasb"] = wasb
        return Mount(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def abfs(self) -> pulumi.Output[Optional['outputs.MountAbfs']]:
        return pulumi.get(self, "abfs")

    @property
    @pulumi.getter
    def adl(self) -> pulumi.Output[Optional['outputs.MountAdl']]:
        return pulumi.get(self, "adl")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "encryption_type")

    @property
    @pulumi.getter(name="extraConfigs")
    def extra_configs(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        return pulumi.get(self, "extra_configs")

    @property
    @pulumi.getter
    def gs(self) -> pulumi.Output[Optional['outputs.MountGs']]:
        return pulumi.get(self, "gs")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter
    def s3(self) -> pulumi.Output[Optional['outputs.MountS3']]:
        return pulumi.get(self, "s3")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output[str]:
        """
        (String) HDFS-compatible url
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def uri(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter
    def wasb(self) -> pulumi.Output[Optional['outputs.MountWasb']]:
        return pulumi.get(self, "wasb")

