# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['MwsNccPrivateEndpointRuleArgs', 'MwsNccPrivateEndpointRule']

@pulumi.input_type
class MwsNccPrivateEndpointRuleArgs:
    def __init__(__self__, *,
                 group_id: pulumi.Input[str],
                 network_connectivity_config_id: pulumi.Input[str],
                 resource_id: pulumi.Input[str],
                 connection_state: Optional[pulumi.Input[str]] = None,
                 creation_time: Optional[pulumi.Input[int]] = None,
                 deactivated: Optional[pulumi.Input[bool]] = None,
                 deactivated_at: Optional[pulumi.Input[int]] = None,
                 endpoint_name: Optional[pulumi.Input[str]] = None,
                 rule_id: Optional[pulumi.Input[str]] = None,
                 updated_time: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a MwsNccPrivateEndpointRule resource.
        :param pulumi.Input[str] group_id: The sub-resource type (group ID) of the target resource. Must be one of `blob`, `dfs`, `sqlServer` or `mysqlServer`. Note that to connect to workspace root storage (root DBFS), you need two endpoints, one for blob and one for dfs. Change forces creation of a new resource.
        :param pulumi.Input[str] network_connectivity_config_id: Canonical unique identifier of Network Connectivity Config in Databricks Account. Change forces creation of a new resource.
        :param pulumi.Input[str] resource_id: The Azure resource ID of the target resource. Change forces creation of a new resource.
        :param pulumi.Input[str] connection_state: The current status of this private endpoint. The private endpoint rules are effective only if the connection state is ESTABLISHED. Remember that you must approve new endpoints on your resources in the Azure portal before they take effect.
               The possible values are:
               * `PENDING`: The endpoint has been created and pending approval.
               * `ESTABLISHED`: The endpoint has been approved and is ready to be used in your serverless compute resources.
               * `REJECTED`: Connection was rejected by the private link resource owner.
               * `DISCONNECTED`: Connection was removed by the private link resource owner, the private endpoint becomes informative and should be deleted for clean-up.
        :param pulumi.Input[int] creation_time: Time in epoch milliseconds when this object was created.
        :param pulumi.Input[bool] deactivated: Whether this private endpoint is deactivated.
        :param pulumi.Input[int] deactivated_at: Time in epoch milliseconds when this object was deactivated.
        :param pulumi.Input[str] endpoint_name: The name of the Azure private endpoint resource, e.g. "databricks-088781b3-77fa-4132-b429-1af0d91bc593-pe-3cb31234"
        :param pulumi.Input[str] rule_id: the ID of a private endpoint rule.
        :param pulumi.Input[int] updated_time: Time in epoch milliseconds when this object was updated.
        """
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "network_connectivity_config_id", network_connectivity_config_id)
        pulumi.set(__self__, "resource_id", resource_id)
        if connection_state is not None:
            pulumi.set(__self__, "connection_state", connection_state)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if deactivated is not None:
            pulumi.set(__self__, "deactivated", deactivated)
        if deactivated_at is not None:
            pulumi.set(__self__, "deactivated_at", deactivated_at)
        if endpoint_name is not None:
            pulumi.set(__self__, "endpoint_name", endpoint_name)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)
        if updated_time is not None:
            pulumi.set(__self__, "updated_time", updated_time)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Input[str]:
        """
        The sub-resource type (group ID) of the target resource. Must be one of `blob`, `dfs`, `sqlServer` or `mysqlServer`. Note that to connect to workspace root storage (root DBFS), you need two endpoints, one for blob and one for dfs. Change forces creation of a new resource.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter(name="networkConnectivityConfigId")
    def network_connectivity_config_id(self) -> pulumi.Input[str]:
        """
        Canonical unique identifier of Network Connectivity Config in Databricks Account. Change forces creation of a new resource.
        """
        return pulumi.get(self, "network_connectivity_config_id")

    @network_connectivity_config_id.setter
    def network_connectivity_config_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_connectivity_config_id", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[str]:
        """
        The Azure resource ID of the target resource. Change forces creation of a new resource.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="connectionState")
    def connection_state(self) -> Optional[pulumi.Input[str]]:
        """
        The current status of this private endpoint. The private endpoint rules are effective only if the connection state is ESTABLISHED. Remember that you must approve new endpoints on your resources in the Azure portal before they take effect.
        The possible values are:
        * `PENDING`: The endpoint has been created and pending approval.
        * `ESTABLISHED`: The endpoint has been approved and is ready to be used in your serverless compute resources.
        * `REJECTED`: Connection was rejected by the private link resource owner.
        * `DISCONNECTED`: Connection was removed by the private link resource owner, the private endpoint becomes informative and should be deleted for clean-up.
        """
        return pulumi.get(self, "connection_state")

    @connection_state.setter
    def connection_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_state", value)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[int]]:
        """
        Time in epoch milliseconds when this object was created.
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "creation_time", value)

    @property
    @pulumi.getter
    def deactivated(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this private endpoint is deactivated.
        """
        return pulumi.get(self, "deactivated")

    @deactivated.setter
    def deactivated(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deactivated", value)

    @property
    @pulumi.getter(name="deactivatedAt")
    def deactivated_at(self) -> Optional[pulumi.Input[int]]:
        """
        Time in epoch milliseconds when this object was deactivated.
        """
        return pulumi.get(self, "deactivated_at")

    @deactivated_at.setter
    def deactivated_at(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "deactivated_at", value)

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Azure private endpoint resource, e.g. "databricks-088781b3-77fa-4132-b429-1af0d91bc593-pe-3cb31234"
        """
        return pulumi.get(self, "endpoint_name")

    @endpoint_name.setter
    def endpoint_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_name", value)

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[pulumi.Input[str]]:
        """
        the ID of a private endpoint rule.
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rule_id", value)

    @property
    @pulumi.getter(name="updatedTime")
    def updated_time(self) -> Optional[pulumi.Input[int]]:
        """
        Time in epoch milliseconds when this object was updated.
        """
        return pulumi.get(self, "updated_time")

    @updated_time.setter
    def updated_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "updated_time", value)


@pulumi.input_type
class _MwsNccPrivateEndpointRuleState:
    def __init__(__self__, *,
                 connection_state: Optional[pulumi.Input[str]] = None,
                 creation_time: Optional[pulumi.Input[int]] = None,
                 deactivated: Optional[pulumi.Input[bool]] = None,
                 deactivated_at: Optional[pulumi.Input[int]] = None,
                 endpoint_name: Optional[pulumi.Input[str]] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 network_connectivity_config_id: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 rule_id: Optional[pulumi.Input[str]] = None,
                 updated_time: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering MwsNccPrivateEndpointRule resources.
        :param pulumi.Input[str] connection_state: The current status of this private endpoint. The private endpoint rules are effective only if the connection state is ESTABLISHED. Remember that you must approve new endpoints on your resources in the Azure portal before they take effect.
               The possible values are:
               * `PENDING`: The endpoint has been created and pending approval.
               * `ESTABLISHED`: The endpoint has been approved and is ready to be used in your serverless compute resources.
               * `REJECTED`: Connection was rejected by the private link resource owner.
               * `DISCONNECTED`: Connection was removed by the private link resource owner, the private endpoint becomes informative and should be deleted for clean-up.
        :param pulumi.Input[int] creation_time: Time in epoch milliseconds when this object was created.
        :param pulumi.Input[bool] deactivated: Whether this private endpoint is deactivated.
        :param pulumi.Input[int] deactivated_at: Time in epoch milliseconds when this object was deactivated.
        :param pulumi.Input[str] endpoint_name: The name of the Azure private endpoint resource, e.g. "databricks-088781b3-77fa-4132-b429-1af0d91bc593-pe-3cb31234"
        :param pulumi.Input[str] group_id: The sub-resource type (group ID) of the target resource. Must be one of `blob`, `dfs`, `sqlServer` or `mysqlServer`. Note that to connect to workspace root storage (root DBFS), you need two endpoints, one for blob and one for dfs. Change forces creation of a new resource.
        :param pulumi.Input[str] network_connectivity_config_id: Canonical unique identifier of Network Connectivity Config in Databricks Account. Change forces creation of a new resource.
        :param pulumi.Input[str] resource_id: The Azure resource ID of the target resource. Change forces creation of a new resource.
        :param pulumi.Input[str] rule_id: the ID of a private endpoint rule.
        :param pulumi.Input[int] updated_time: Time in epoch milliseconds when this object was updated.
        """
        if connection_state is not None:
            pulumi.set(__self__, "connection_state", connection_state)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if deactivated is not None:
            pulumi.set(__self__, "deactivated", deactivated)
        if deactivated_at is not None:
            pulumi.set(__self__, "deactivated_at", deactivated_at)
        if endpoint_name is not None:
            pulumi.set(__self__, "endpoint_name", endpoint_name)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if network_connectivity_config_id is not None:
            pulumi.set(__self__, "network_connectivity_config_id", network_connectivity_config_id)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)
        if updated_time is not None:
            pulumi.set(__self__, "updated_time", updated_time)

    @property
    @pulumi.getter(name="connectionState")
    def connection_state(self) -> Optional[pulumi.Input[str]]:
        """
        The current status of this private endpoint. The private endpoint rules are effective only if the connection state is ESTABLISHED. Remember that you must approve new endpoints on your resources in the Azure portal before they take effect.
        The possible values are:
        * `PENDING`: The endpoint has been created and pending approval.
        * `ESTABLISHED`: The endpoint has been approved and is ready to be used in your serverless compute resources.
        * `REJECTED`: Connection was rejected by the private link resource owner.
        * `DISCONNECTED`: Connection was removed by the private link resource owner, the private endpoint becomes informative and should be deleted for clean-up.
        """
        return pulumi.get(self, "connection_state")

    @connection_state.setter
    def connection_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_state", value)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[int]]:
        """
        Time in epoch milliseconds when this object was created.
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "creation_time", value)

    @property
    @pulumi.getter
    def deactivated(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this private endpoint is deactivated.
        """
        return pulumi.get(self, "deactivated")

    @deactivated.setter
    def deactivated(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deactivated", value)

    @property
    @pulumi.getter(name="deactivatedAt")
    def deactivated_at(self) -> Optional[pulumi.Input[int]]:
        """
        Time in epoch milliseconds when this object was deactivated.
        """
        return pulumi.get(self, "deactivated_at")

    @deactivated_at.setter
    def deactivated_at(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "deactivated_at", value)

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Azure private endpoint resource, e.g. "databricks-088781b3-77fa-4132-b429-1af0d91bc593-pe-3cb31234"
        """
        return pulumi.get(self, "endpoint_name")

    @endpoint_name.setter
    def endpoint_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_name", value)

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The sub-resource type (group ID) of the target resource. Must be one of `blob`, `dfs`, `sqlServer` or `mysqlServer`. Note that to connect to workspace root storage (root DBFS), you need two endpoints, one for blob and one for dfs. Change forces creation of a new resource.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_id", value)

    @property
    @pulumi.getter(name="networkConnectivityConfigId")
    def network_connectivity_config_id(self) -> Optional[pulumi.Input[str]]:
        """
        Canonical unique identifier of Network Connectivity Config in Databricks Account. Change forces creation of a new resource.
        """
        return pulumi.get(self, "network_connectivity_config_id")

    @network_connectivity_config_id.setter
    def network_connectivity_config_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_connectivity_config_id", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Azure resource ID of the target resource. Change forces creation of a new resource.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[pulumi.Input[str]]:
        """
        the ID of a private endpoint rule.
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rule_id", value)

    @property
    @pulumi.getter(name="updatedTime")
    def updated_time(self) -> Optional[pulumi.Input[int]]:
        """
        Time in epoch milliseconds when this object was updated.
        """
        return pulumi.get(self, "updated_time")

    @updated_time.setter
    def updated_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "updated_time", value)


class MwsNccPrivateEndpointRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_state: Optional[pulumi.Input[str]] = None,
                 creation_time: Optional[pulumi.Input[int]] = None,
                 deactivated: Optional[pulumi.Input[bool]] = None,
                 deactivated_at: Optional[pulumi.Input[int]] = None,
                 endpoint_name: Optional[pulumi.Input[str]] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 network_connectivity_config_id: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 rule_id: Optional[pulumi.Input[str]] = None,
                 updated_time: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        > **Note** Initialize provider with `alias = "account"`, `host = "https://accounts.azuredatabricks.net"` and use `provider = databricks.account` for all `databricks_mws_*` resources.

        > **Note** This feature is only available in Azure.

        Allows you to create a private endpoint in a Network Connectivity Config that can be used to [configure private connectivity from serverless compute](https://learn.microsoft.com/en-us/azure/databricks/security/network/serverless-network-security/serverless-private-link).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_databricks as databricks

        config = pulumi.Config()
        region = config.require_object("region")
        prefix = config.require_object("prefix")
        ncc = databricks.MwsNetworkConnectivityConfig("ncc",
            name=f"Network Connectivity Config for {prefix}",
            region=region)
        storage = databricks.MwsNccPrivateEndpointRule("storage",
            network_connectivity_config_id=ncc.network_connectivity_config_id,
            resource_id="/subscriptions/653bb673-1234-abcd-a90b-d064d5d53ca4/resourcegroups/example-resource-group/providers/Microsoft.Storage/storageAccounts/examplesa",
            group_id="blob")
        ```

        ## Related Resources

        The following resources are used in the context:

        * MwsNetworkConnectivityConfig to create Network Connectivity Config objects.
        * MwsNccBinding to attach an NCC to a workspace.

        ## Import

        This resource can be imported by Databricks account ID and Network Connectivity Config ID.

        ```sh
        $ pulumi import databricks:index/mwsNccPrivateEndpointRule:MwsNccPrivateEndpointRule rule <network_connectivity_config_id>/<rule_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] connection_state: The current status of this private endpoint. The private endpoint rules are effective only if the connection state is ESTABLISHED. Remember that you must approve new endpoints on your resources in the Azure portal before they take effect.
               The possible values are:
               * `PENDING`: The endpoint has been created and pending approval.
               * `ESTABLISHED`: The endpoint has been approved and is ready to be used in your serverless compute resources.
               * `REJECTED`: Connection was rejected by the private link resource owner.
               * `DISCONNECTED`: Connection was removed by the private link resource owner, the private endpoint becomes informative and should be deleted for clean-up.
        :param pulumi.Input[int] creation_time: Time in epoch milliseconds when this object was created.
        :param pulumi.Input[bool] deactivated: Whether this private endpoint is deactivated.
        :param pulumi.Input[int] deactivated_at: Time in epoch milliseconds when this object was deactivated.
        :param pulumi.Input[str] endpoint_name: The name of the Azure private endpoint resource, e.g. "databricks-088781b3-77fa-4132-b429-1af0d91bc593-pe-3cb31234"
        :param pulumi.Input[str] group_id: The sub-resource type (group ID) of the target resource. Must be one of `blob`, `dfs`, `sqlServer` or `mysqlServer`. Note that to connect to workspace root storage (root DBFS), you need two endpoints, one for blob and one for dfs. Change forces creation of a new resource.
        :param pulumi.Input[str] network_connectivity_config_id: Canonical unique identifier of Network Connectivity Config in Databricks Account. Change forces creation of a new resource.
        :param pulumi.Input[str] resource_id: The Azure resource ID of the target resource. Change forces creation of a new resource.
        :param pulumi.Input[str] rule_id: the ID of a private endpoint rule.
        :param pulumi.Input[int] updated_time: Time in epoch milliseconds when this object was updated.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MwsNccPrivateEndpointRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > **Note** Initialize provider with `alias = "account"`, `host = "https://accounts.azuredatabricks.net"` and use `provider = databricks.account` for all `databricks_mws_*` resources.

        > **Note** This feature is only available in Azure.

        Allows you to create a private endpoint in a Network Connectivity Config that can be used to [configure private connectivity from serverless compute](https://learn.microsoft.com/en-us/azure/databricks/security/network/serverless-network-security/serverless-private-link).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_databricks as databricks

        config = pulumi.Config()
        region = config.require_object("region")
        prefix = config.require_object("prefix")
        ncc = databricks.MwsNetworkConnectivityConfig("ncc",
            name=f"Network Connectivity Config for {prefix}",
            region=region)
        storage = databricks.MwsNccPrivateEndpointRule("storage",
            network_connectivity_config_id=ncc.network_connectivity_config_id,
            resource_id="/subscriptions/653bb673-1234-abcd-a90b-d064d5d53ca4/resourcegroups/example-resource-group/providers/Microsoft.Storage/storageAccounts/examplesa",
            group_id="blob")
        ```

        ## Related Resources

        The following resources are used in the context:

        * MwsNetworkConnectivityConfig to create Network Connectivity Config objects.
        * MwsNccBinding to attach an NCC to a workspace.

        ## Import

        This resource can be imported by Databricks account ID and Network Connectivity Config ID.

        ```sh
        $ pulumi import databricks:index/mwsNccPrivateEndpointRule:MwsNccPrivateEndpointRule rule <network_connectivity_config_id>/<rule_id>
        ```

        :param str resource_name: The name of the resource.
        :param MwsNccPrivateEndpointRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MwsNccPrivateEndpointRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 connection_state: Optional[pulumi.Input[str]] = None,
                 creation_time: Optional[pulumi.Input[int]] = None,
                 deactivated: Optional[pulumi.Input[bool]] = None,
                 deactivated_at: Optional[pulumi.Input[int]] = None,
                 endpoint_name: Optional[pulumi.Input[str]] = None,
                 group_id: Optional[pulumi.Input[str]] = None,
                 network_connectivity_config_id: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 rule_id: Optional[pulumi.Input[str]] = None,
                 updated_time: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MwsNccPrivateEndpointRuleArgs.__new__(MwsNccPrivateEndpointRuleArgs)

            __props__.__dict__["connection_state"] = connection_state
            __props__.__dict__["creation_time"] = creation_time
            __props__.__dict__["deactivated"] = deactivated
            __props__.__dict__["deactivated_at"] = deactivated_at
            __props__.__dict__["endpoint_name"] = endpoint_name
            if group_id is None and not opts.urn:
                raise TypeError("Missing required property 'group_id'")
            __props__.__dict__["group_id"] = group_id
            if network_connectivity_config_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_connectivity_config_id'")
            __props__.__dict__["network_connectivity_config_id"] = network_connectivity_config_id
            if resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'resource_id'")
            __props__.__dict__["resource_id"] = resource_id
            __props__.__dict__["rule_id"] = rule_id
            __props__.__dict__["updated_time"] = updated_time
        super(MwsNccPrivateEndpointRule, __self__).__init__(
            'databricks:index/mwsNccPrivateEndpointRule:MwsNccPrivateEndpointRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            connection_state: Optional[pulumi.Input[str]] = None,
            creation_time: Optional[pulumi.Input[int]] = None,
            deactivated: Optional[pulumi.Input[bool]] = None,
            deactivated_at: Optional[pulumi.Input[int]] = None,
            endpoint_name: Optional[pulumi.Input[str]] = None,
            group_id: Optional[pulumi.Input[str]] = None,
            network_connectivity_config_id: Optional[pulumi.Input[str]] = None,
            resource_id: Optional[pulumi.Input[str]] = None,
            rule_id: Optional[pulumi.Input[str]] = None,
            updated_time: Optional[pulumi.Input[int]] = None) -> 'MwsNccPrivateEndpointRule':
        """
        Get an existing MwsNccPrivateEndpointRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] connection_state: The current status of this private endpoint. The private endpoint rules are effective only if the connection state is ESTABLISHED. Remember that you must approve new endpoints on your resources in the Azure portal before they take effect.
               The possible values are:
               * `PENDING`: The endpoint has been created and pending approval.
               * `ESTABLISHED`: The endpoint has been approved and is ready to be used in your serverless compute resources.
               * `REJECTED`: Connection was rejected by the private link resource owner.
               * `DISCONNECTED`: Connection was removed by the private link resource owner, the private endpoint becomes informative and should be deleted for clean-up.
        :param pulumi.Input[int] creation_time: Time in epoch milliseconds when this object was created.
        :param pulumi.Input[bool] deactivated: Whether this private endpoint is deactivated.
        :param pulumi.Input[int] deactivated_at: Time in epoch milliseconds when this object was deactivated.
        :param pulumi.Input[str] endpoint_name: The name of the Azure private endpoint resource, e.g. "databricks-088781b3-77fa-4132-b429-1af0d91bc593-pe-3cb31234"
        :param pulumi.Input[str] group_id: The sub-resource type (group ID) of the target resource. Must be one of `blob`, `dfs`, `sqlServer` or `mysqlServer`. Note that to connect to workspace root storage (root DBFS), you need two endpoints, one for blob and one for dfs. Change forces creation of a new resource.
        :param pulumi.Input[str] network_connectivity_config_id: Canonical unique identifier of Network Connectivity Config in Databricks Account. Change forces creation of a new resource.
        :param pulumi.Input[str] resource_id: The Azure resource ID of the target resource. Change forces creation of a new resource.
        :param pulumi.Input[str] rule_id: the ID of a private endpoint rule.
        :param pulumi.Input[int] updated_time: Time in epoch milliseconds when this object was updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MwsNccPrivateEndpointRuleState.__new__(_MwsNccPrivateEndpointRuleState)

        __props__.__dict__["connection_state"] = connection_state
        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["deactivated"] = deactivated
        __props__.__dict__["deactivated_at"] = deactivated_at
        __props__.__dict__["endpoint_name"] = endpoint_name
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["network_connectivity_config_id"] = network_connectivity_config_id
        __props__.__dict__["resource_id"] = resource_id
        __props__.__dict__["rule_id"] = rule_id
        __props__.__dict__["updated_time"] = updated_time
        return MwsNccPrivateEndpointRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="connectionState")
    def connection_state(self) -> pulumi.Output[str]:
        """
        The current status of this private endpoint. The private endpoint rules are effective only if the connection state is ESTABLISHED. Remember that you must approve new endpoints on your resources in the Azure portal before they take effect.
        The possible values are:
        * `PENDING`: The endpoint has been created and pending approval.
        * `ESTABLISHED`: The endpoint has been approved and is ready to be used in your serverless compute resources.
        * `REJECTED`: Connection was rejected by the private link resource owner.
        * `DISCONNECTED`: Connection was removed by the private link resource owner, the private endpoint becomes informative and should be deleted for clean-up.
        """
        return pulumi.get(self, "connection_state")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[int]:
        """
        Time in epoch milliseconds when this object was created.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def deactivated(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether this private endpoint is deactivated.
        """
        return pulumi.get(self, "deactivated")

    @property
    @pulumi.getter(name="deactivatedAt")
    def deactivated_at(self) -> pulumi.Output[Optional[int]]:
        """
        Time in epoch milliseconds when this object was deactivated.
        """
        return pulumi.get(self, "deactivated_at")

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> pulumi.Output[str]:
        """
        The name of the Azure private endpoint resource, e.g. "databricks-088781b3-77fa-4132-b429-1af0d91bc593-pe-3cb31234"
        """
        return pulumi.get(self, "endpoint_name")

    @property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[str]:
        """
        The sub-resource type (group ID) of the target resource. Must be one of `blob`, `dfs`, `sqlServer` or `mysqlServer`. Note that to connect to workspace root storage (root DBFS), you need two endpoints, one for blob and one for dfs. Change forces creation of a new resource.
        """
        return pulumi.get(self, "group_id")

    @property
    @pulumi.getter(name="networkConnectivityConfigId")
    def network_connectivity_config_id(self) -> pulumi.Output[str]:
        """
        Canonical unique identifier of Network Connectivity Config in Databricks Account. Change forces creation of a new resource.
        """
        return pulumi.get(self, "network_connectivity_config_id")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Output[str]:
        """
        The Azure resource ID of the target resource. Change forces creation of a new resource.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> pulumi.Output[str]:
        """
        the ID of a private endpoint rule.
        """
        return pulumi.get(self, "rule_id")

    @property
    @pulumi.getter(name="updatedTime")
    def updated_time(self) -> pulumi.Output[int]:
        """
        Time in epoch milliseconds when this object was updated.
        """
        return pulumi.get(self, "updated_time")

