# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PipelineArgs', 'Pipeline']

@pulumi.input_type
class PipelineArgs:
    def __init__(__self__, *,
                 allow_duplicate_names: Optional[pulumi.Input[bool]] = None,
                 catalog: Optional[pulumi.Input[str]] = None,
                 channel: Optional[pulumi.Input[str]] = None,
                 clusters: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineClusterArgs']]]] = None,
                 configuration: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 continuous: Optional[pulumi.Input[bool]] = None,
                 deployment: Optional[pulumi.Input['PipelineDeploymentArgs']] = None,
                 development: Optional[pulumi.Input[bool]] = None,
                 edition: Optional[pulumi.Input[str]] = None,
                 filters: Optional[pulumi.Input['PipelineFiltersArgs']] = None,
                 libraries: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineLibraryArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notifications: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineNotificationArgs']]]] = None,
                 photon: Optional[pulumi.Input[bool]] = None,
                 serverless: Optional[pulumi.Input[bool]] = None,
                 storage: Optional[pulumi.Input[str]] = None,
                 target: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Pipeline resource.
        :param pulumi.Input[str] catalog: The name of catalog in Unity Catalog. *Change of this parameter forces recreation of the pipeline.* (Conflicts with `storage`).
        :param pulumi.Input[str] channel: optional name of the release channel for Spark version used by DLT pipeline.  Supported values are: `CURRENT` (default) and `PREVIEW`.
        :param pulumi.Input[Sequence[pulumi.Input['PipelineClusterArgs']]] clusters: blocks - Clusters to run the pipeline. If none is specified, pipelines will automatically select a default cluster configuration for the pipeline. *Please note that DLT pipeline clusters are supporting only subset of attributes as described in [documentation](https://docs.databricks.com/data-engineering/delta-live-tables/delta-live-tables-api-guide.html#pipelinesnewcluster).*  Also, note that `autoscale` block is extended with the `mode` parameter that controls the autoscaling algorithm (possible values are `ENHANCED` for new, enhanced autoscaling algorithm, or `LEGACY` for old algorithm).
        :param pulumi.Input[Mapping[str, Any]] configuration: An optional list of values to apply to the entire pipeline. Elements must be formatted as key:value pairs.
        :param pulumi.Input[bool] continuous: A flag indicating whether to run the pipeline continuously. The default value is `false`.
        :param pulumi.Input[bool] development: A flag indicating whether to run the pipeline in development mode. The default value is `true`.
        :param pulumi.Input[str] edition: optional name of the [product edition](https://docs.databricks.com/data-engineering/delta-live-tables/delta-live-tables-concepts.html#editions). Supported values are: `CORE`, `PRO`, `ADVANCED` (default).
        :param pulumi.Input[Sequence[pulumi.Input['PipelineLibraryArgs']]] libraries: blocks - Specifies pipeline code and required artifacts. Syntax resembles library configuration block with the addition of a special `notebook` & `file` library types that should have the `path` attribute. *Right now only the `notebook` & `file` types are supported.*
        :param pulumi.Input[str] name: A user-friendly name for this pipeline. The name can be used to identify pipeline jobs in the UI.
        :param pulumi.Input[bool] photon: A flag indicating whether to use Photon engine. The default value is `false`.
        :param pulumi.Input[str] storage: A location on DBFS or cloud storage where output data and metadata required for pipeline execution are stored. By default, tables are stored in a subdirectory of this location. *Change of this parameter forces recreation of the pipeline.* (Conflicts with `catalog`).
        :param pulumi.Input[str] target: The name of a database (in either the Hive metastore or in a UC catalog) for persisting pipeline output data. Configuring the target setting allows you to view and query the pipeline output data from the Databricks UI.
        """
        if allow_duplicate_names is not None:
            pulumi.set(__self__, "allow_duplicate_names", allow_duplicate_names)
        if catalog is not None:
            pulumi.set(__self__, "catalog", catalog)
        if channel is not None:
            pulumi.set(__self__, "channel", channel)
        if clusters is not None:
            pulumi.set(__self__, "clusters", clusters)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if continuous is not None:
            pulumi.set(__self__, "continuous", continuous)
        if deployment is not None:
            pulumi.set(__self__, "deployment", deployment)
        if development is not None:
            pulumi.set(__self__, "development", development)
        if edition is not None:
            pulumi.set(__self__, "edition", edition)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if libraries is not None:
            pulumi.set(__self__, "libraries", libraries)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notifications is not None:
            pulumi.set(__self__, "notifications", notifications)
        if photon is not None:
            pulumi.set(__self__, "photon", photon)
        if serverless is not None:
            pulumi.set(__self__, "serverless", serverless)
        if storage is not None:
            pulumi.set(__self__, "storage", storage)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="allowDuplicateNames")
    def allow_duplicate_names(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "allow_duplicate_names")

    @allow_duplicate_names.setter
    def allow_duplicate_names(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_duplicate_names", value)

    @property
    @pulumi.getter
    def catalog(self) -> Optional[pulumi.Input[str]]:
        """
        The name of catalog in Unity Catalog. *Change of this parameter forces recreation of the pipeline.* (Conflicts with `storage`).
        """
        return pulumi.get(self, "catalog")

    @catalog.setter
    def catalog(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "catalog", value)

    @property
    @pulumi.getter
    def channel(self) -> Optional[pulumi.Input[str]]:
        """
        optional name of the release channel for Spark version used by DLT pipeline.  Supported values are: `CURRENT` (default) and `PREVIEW`.
        """
        return pulumi.get(self, "channel")

    @channel.setter
    def channel(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "channel", value)

    @property
    @pulumi.getter
    def clusters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineClusterArgs']]]]:
        """
        blocks - Clusters to run the pipeline. If none is specified, pipelines will automatically select a default cluster configuration for the pipeline. *Please note that DLT pipeline clusters are supporting only subset of attributes as described in [documentation](https://docs.databricks.com/data-engineering/delta-live-tables/delta-live-tables-api-guide.html#pipelinesnewcluster).*  Also, note that `autoscale` block is extended with the `mode` parameter that controls the autoscaling algorithm (possible values are `ENHANCED` for new, enhanced autoscaling algorithm, or `LEGACY` for old algorithm).
        """
        return pulumi.get(self, "clusters")

    @clusters.setter
    def clusters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineClusterArgs']]]]):
        pulumi.set(self, "clusters", value)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        An optional list of values to apply to the entire pipeline. Elements must be formatted as key:value pairs.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter
    def continuous(self) -> Optional[pulumi.Input[bool]]:
        """
        A flag indicating whether to run the pipeline continuously. The default value is `false`.
        """
        return pulumi.get(self, "continuous")

    @continuous.setter
    def continuous(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "continuous", value)

    @property
    @pulumi.getter
    def deployment(self) -> Optional[pulumi.Input['PipelineDeploymentArgs']]:
        return pulumi.get(self, "deployment")

    @deployment.setter
    def deployment(self, value: Optional[pulumi.Input['PipelineDeploymentArgs']]):
        pulumi.set(self, "deployment", value)

    @property
    @pulumi.getter
    def development(self) -> Optional[pulumi.Input[bool]]:
        """
        A flag indicating whether to run the pipeline in development mode. The default value is `true`.
        """
        return pulumi.get(self, "development")

    @development.setter
    def development(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "development", value)

    @property
    @pulumi.getter
    def edition(self) -> Optional[pulumi.Input[str]]:
        """
        optional name of the [product edition](https://docs.databricks.com/data-engineering/delta-live-tables/delta-live-tables-concepts.html#editions). Supported values are: `CORE`, `PRO`, `ADVANCED` (default).
        """
        return pulumi.get(self, "edition")

    @edition.setter
    def edition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "edition", value)

    @property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input['PipelineFiltersArgs']]:
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input['PipelineFiltersArgs']]):
        pulumi.set(self, "filters", value)

    @property
    @pulumi.getter
    def libraries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineLibraryArgs']]]]:
        """
        blocks - Specifies pipeline code and required artifacts. Syntax resembles library configuration block with the addition of a special `notebook` & `file` library types that should have the `path` attribute. *Right now only the `notebook` & `file` types are supported.*
        """
        return pulumi.get(self, "libraries")

    @libraries.setter
    def libraries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineLibraryArgs']]]]):
        pulumi.set(self, "libraries", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A user-friendly name for this pipeline. The name can be used to identify pipeline jobs in the UI.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def notifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineNotificationArgs']]]]:
        return pulumi.get(self, "notifications")

    @notifications.setter
    def notifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineNotificationArgs']]]]):
        pulumi.set(self, "notifications", value)

    @property
    @pulumi.getter
    def photon(self) -> Optional[pulumi.Input[bool]]:
        """
        A flag indicating whether to use Photon engine. The default value is `false`.
        """
        return pulumi.get(self, "photon")

    @photon.setter
    def photon(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "photon", value)

    @property
    @pulumi.getter
    def serverless(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "serverless")

    @serverless.setter
    def serverless(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "serverless", value)

    @property
    @pulumi.getter
    def storage(self) -> Optional[pulumi.Input[str]]:
        """
        A location on DBFS or cloud storage where output data and metadata required for pipeline execution are stored. By default, tables are stored in a subdirectory of this location. *Change of this parameter forces recreation of the pipeline.* (Conflicts with `catalog`).
        """
        return pulumi.get(self, "storage")

    @storage.setter
    def storage(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[str]]:
        """
        The name of a database (in either the Hive metastore or in a UC catalog) for persisting pipeline output data. Configuring the target setting allows you to view and query the pipeline output data from the Databricks UI.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target", value)


@pulumi.input_type
class _PipelineState:
    def __init__(__self__, *,
                 allow_duplicate_names: Optional[pulumi.Input[bool]] = None,
                 catalog: Optional[pulumi.Input[str]] = None,
                 channel: Optional[pulumi.Input[str]] = None,
                 clusters: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineClusterArgs']]]] = None,
                 configuration: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 continuous: Optional[pulumi.Input[bool]] = None,
                 deployment: Optional[pulumi.Input['PipelineDeploymentArgs']] = None,
                 development: Optional[pulumi.Input[bool]] = None,
                 edition: Optional[pulumi.Input[str]] = None,
                 filters: Optional[pulumi.Input['PipelineFiltersArgs']] = None,
                 libraries: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineLibraryArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notifications: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineNotificationArgs']]]] = None,
                 photon: Optional[pulumi.Input[bool]] = None,
                 serverless: Optional[pulumi.Input[bool]] = None,
                 storage: Optional[pulumi.Input[str]] = None,
                 target: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Pipeline resources.
        :param pulumi.Input[str] catalog: The name of catalog in Unity Catalog. *Change of this parameter forces recreation of the pipeline.* (Conflicts with `storage`).
        :param pulumi.Input[str] channel: optional name of the release channel for Spark version used by DLT pipeline.  Supported values are: `CURRENT` (default) and `PREVIEW`.
        :param pulumi.Input[Sequence[pulumi.Input['PipelineClusterArgs']]] clusters: blocks - Clusters to run the pipeline. If none is specified, pipelines will automatically select a default cluster configuration for the pipeline. *Please note that DLT pipeline clusters are supporting only subset of attributes as described in [documentation](https://docs.databricks.com/data-engineering/delta-live-tables/delta-live-tables-api-guide.html#pipelinesnewcluster).*  Also, note that `autoscale` block is extended with the `mode` parameter that controls the autoscaling algorithm (possible values are `ENHANCED` for new, enhanced autoscaling algorithm, or `LEGACY` for old algorithm).
        :param pulumi.Input[Mapping[str, Any]] configuration: An optional list of values to apply to the entire pipeline. Elements must be formatted as key:value pairs.
        :param pulumi.Input[bool] continuous: A flag indicating whether to run the pipeline continuously. The default value is `false`.
        :param pulumi.Input[bool] development: A flag indicating whether to run the pipeline in development mode. The default value is `true`.
        :param pulumi.Input[str] edition: optional name of the [product edition](https://docs.databricks.com/data-engineering/delta-live-tables/delta-live-tables-concepts.html#editions). Supported values are: `CORE`, `PRO`, `ADVANCED` (default).
        :param pulumi.Input[Sequence[pulumi.Input['PipelineLibraryArgs']]] libraries: blocks - Specifies pipeline code and required artifacts. Syntax resembles library configuration block with the addition of a special `notebook` & `file` library types that should have the `path` attribute. *Right now only the `notebook` & `file` types are supported.*
        :param pulumi.Input[str] name: A user-friendly name for this pipeline. The name can be used to identify pipeline jobs in the UI.
        :param pulumi.Input[bool] photon: A flag indicating whether to use Photon engine. The default value is `false`.
        :param pulumi.Input[str] storage: A location on DBFS or cloud storage where output data and metadata required for pipeline execution are stored. By default, tables are stored in a subdirectory of this location. *Change of this parameter forces recreation of the pipeline.* (Conflicts with `catalog`).
        :param pulumi.Input[str] target: The name of a database (in either the Hive metastore or in a UC catalog) for persisting pipeline output data. Configuring the target setting allows you to view and query the pipeline output data from the Databricks UI.
        :param pulumi.Input[str] url: URL of the DLT pipeline on the given workspace.
        """
        if allow_duplicate_names is not None:
            pulumi.set(__self__, "allow_duplicate_names", allow_duplicate_names)
        if catalog is not None:
            pulumi.set(__self__, "catalog", catalog)
        if channel is not None:
            pulumi.set(__self__, "channel", channel)
        if clusters is not None:
            pulumi.set(__self__, "clusters", clusters)
        if configuration is not None:
            pulumi.set(__self__, "configuration", configuration)
        if continuous is not None:
            pulumi.set(__self__, "continuous", continuous)
        if deployment is not None:
            pulumi.set(__self__, "deployment", deployment)
        if development is not None:
            pulumi.set(__self__, "development", development)
        if edition is not None:
            pulumi.set(__self__, "edition", edition)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if libraries is not None:
            pulumi.set(__self__, "libraries", libraries)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notifications is not None:
            pulumi.set(__self__, "notifications", notifications)
        if photon is not None:
            pulumi.set(__self__, "photon", photon)
        if serverless is not None:
            pulumi.set(__self__, "serverless", serverless)
        if storage is not None:
            pulumi.set(__self__, "storage", storage)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="allowDuplicateNames")
    def allow_duplicate_names(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "allow_duplicate_names")

    @allow_duplicate_names.setter
    def allow_duplicate_names(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_duplicate_names", value)

    @property
    @pulumi.getter
    def catalog(self) -> Optional[pulumi.Input[str]]:
        """
        The name of catalog in Unity Catalog. *Change of this parameter forces recreation of the pipeline.* (Conflicts with `storage`).
        """
        return pulumi.get(self, "catalog")

    @catalog.setter
    def catalog(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "catalog", value)

    @property
    @pulumi.getter
    def channel(self) -> Optional[pulumi.Input[str]]:
        """
        optional name of the release channel for Spark version used by DLT pipeline.  Supported values are: `CURRENT` (default) and `PREVIEW`.
        """
        return pulumi.get(self, "channel")

    @channel.setter
    def channel(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "channel", value)

    @property
    @pulumi.getter
    def clusters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineClusterArgs']]]]:
        """
        blocks - Clusters to run the pipeline. If none is specified, pipelines will automatically select a default cluster configuration for the pipeline. *Please note that DLT pipeline clusters are supporting only subset of attributes as described in [documentation](https://docs.databricks.com/data-engineering/delta-live-tables/delta-live-tables-api-guide.html#pipelinesnewcluster).*  Also, note that `autoscale` block is extended with the `mode` parameter that controls the autoscaling algorithm (possible values are `ENHANCED` for new, enhanced autoscaling algorithm, or `LEGACY` for old algorithm).
        """
        return pulumi.get(self, "clusters")

    @clusters.setter
    def clusters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineClusterArgs']]]]):
        pulumi.set(self, "clusters", value)

    @property
    @pulumi.getter
    def configuration(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        An optional list of values to apply to the entire pipeline. Elements must be formatted as key:value pairs.
        """
        return pulumi.get(self, "configuration")

    @configuration.setter
    def configuration(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "configuration", value)

    @property
    @pulumi.getter
    def continuous(self) -> Optional[pulumi.Input[bool]]:
        """
        A flag indicating whether to run the pipeline continuously. The default value is `false`.
        """
        return pulumi.get(self, "continuous")

    @continuous.setter
    def continuous(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "continuous", value)

    @property
    @pulumi.getter
    def deployment(self) -> Optional[pulumi.Input['PipelineDeploymentArgs']]:
        return pulumi.get(self, "deployment")

    @deployment.setter
    def deployment(self, value: Optional[pulumi.Input['PipelineDeploymentArgs']]):
        pulumi.set(self, "deployment", value)

    @property
    @pulumi.getter
    def development(self) -> Optional[pulumi.Input[bool]]:
        """
        A flag indicating whether to run the pipeline in development mode. The default value is `true`.
        """
        return pulumi.get(self, "development")

    @development.setter
    def development(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "development", value)

    @property
    @pulumi.getter
    def edition(self) -> Optional[pulumi.Input[str]]:
        """
        optional name of the [product edition](https://docs.databricks.com/data-engineering/delta-live-tables/delta-live-tables-concepts.html#editions). Supported values are: `CORE`, `PRO`, `ADVANCED` (default).
        """
        return pulumi.get(self, "edition")

    @edition.setter
    def edition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "edition", value)

    @property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input['PipelineFiltersArgs']]:
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input['PipelineFiltersArgs']]):
        pulumi.set(self, "filters", value)

    @property
    @pulumi.getter
    def libraries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineLibraryArgs']]]]:
        """
        blocks - Specifies pipeline code and required artifacts. Syntax resembles library configuration block with the addition of a special `notebook` & `file` library types that should have the `path` attribute. *Right now only the `notebook` & `file` types are supported.*
        """
        return pulumi.get(self, "libraries")

    @libraries.setter
    def libraries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineLibraryArgs']]]]):
        pulumi.set(self, "libraries", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A user-friendly name for this pipeline. The name can be used to identify pipeline jobs in the UI.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def notifications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PipelineNotificationArgs']]]]:
        return pulumi.get(self, "notifications")

    @notifications.setter
    def notifications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PipelineNotificationArgs']]]]):
        pulumi.set(self, "notifications", value)

    @property
    @pulumi.getter
    def photon(self) -> Optional[pulumi.Input[bool]]:
        """
        A flag indicating whether to use Photon engine. The default value is `false`.
        """
        return pulumi.get(self, "photon")

    @photon.setter
    def photon(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "photon", value)

    @property
    @pulumi.getter
    def serverless(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "serverless")

    @serverless.setter
    def serverless(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "serverless", value)

    @property
    @pulumi.getter
    def storage(self) -> Optional[pulumi.Input[str]]:
        """
        A location on DBFS or cloud storage where output data and metadata required for pipeline execution are stored. By default, tables are stored in a subdirectory of this location. *Change of this parameter forces recreation of the pipeline.* (Conflicts with `catalog`).
        """
        return pulumi.get(self, "storage")

    @storage.setter
    def storage(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[str]]:
        """
        The name of a database (in either the Hive metastore or in a UC catalog) for persisting pipeline output data. Configuring the target setting allows you to view and query the pipeline output data from the Databricks UI.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the DLT pipeline on the given workspace.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


class Pipeline(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_duplicate_names: Optional[pulumi.Input[bool]] = None,
                 catalog: Optional[pulumi.Input[str]] = None,
                 channel: Optional[pulumi.Input[str]] = None,
                 clusters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PipelineClusterArgs']]]]] = None,
                 configuration: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 continuous: Optional[pulumi.Input[bool]] = None,
                 deployment: Optional[pulumi.Input[pulumi.InputType['PipelineDeploymentArgs']]] = None,
                 development: Optional[pulumi.Input[bool]] = None,
                 edition: Optional[pulumi.Input[str]] = None,
                 filters: Optional[pulumi.Input[pulumi.InputType['PipelineFiltersArgs']]] = None,
                 libraries: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PipelineLibraryArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notifications: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PipelineNotificationArgs']]]]] = None,
                 photon: Optional[pulumi.Input[bool]] = None,
                 serverless: Optional[pulumi.Input[bool]] = None,
                 storage: Optional[pulumi.Input[str]] = None,
                 target: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Use `Pipeline` to deploy [Delta Live Tables](https://docs.databricks.com/data-engineering/delta-live-tables/index.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_databricks as databricks

        dlt_demo = databricks.Notebook("dlt_demo")
        dlt_demo_repo = databricks.Repo("dlt_demo")
        this = databricks.Pipeline("this",
            name="Pipeline Name",
            storage="/test/first-pipeline",
            configuration={
                "key1": "value1",
                "key2": "value2",
            },
            clusters=[
                databricks.PipelineClusterArgs(
                    label="default",
                    num_workers=2,
                    custom_tags={
                        "cluster_type": "default",
                    },
                ),
                databricks.PipelineClusterArgs(
                    label="maintenance",
                    num_workers=1,
                    custom_tags={
                        "cluster_type": "maintenance",
                    },
                ),
            ],
            libraries=[
                databricks.PipelineLibraryArgs(
                    notebook=databricks.PipelineLibraryNotebookArgs(
                        path=dlt_demo.id,
                    ),
                ),
                databricks.PipelineLibraryArgs(
                    file=databricks.PipelineLibraryFileArgs(
                        path=dlt_demo_repo.path.apply(lambda path: f"{path}/pipeline.sql"),
                    ),
                ),
            ],
            continuous=False,
            notifications=[databricks.PipelineNotificationArgs(
                email_recipients=[
                    "user@domain.com",
                    "user1@domain.com",
                ],
                alerts=[
                    "on-update-failure",
                    "on-update-fatal-failure",
                    "on-update-success",
                    "on-flow-failure",
                ],
            )])
        ```

        ## Related Resources

        The following resources are often used in the same context:

        * End to end workspace management guide.
        * get_pipelines to retrieve [Delta Live Tables](https://docs.databricks.com/data-engineering/delta-live-tables/index.html) pipeline data.
        * Cluster to create [Databricks Clusters](https://docs.databricks.com/clusters/index.html).
        * Job to manage [Databricks Jobs](https://docs.databricks.com/jobs.html) to run non-interactive code in a databricks_cluster.
        * Notebook to manage [Databricks Notebooks](https://docs.databricks.com/notebooks/index.html).

        ## Import

        The resource job can be imported using the id of the pipeline

        bash

        ```sh
        $ pulumi import databricks:index/pipeline:Pipeline this <pipeline-id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] catalog: The name of catalog in Unity Catalog. *Change of this parameter forces recreation of the pipeline.* (Conflicts with `storage`).
        :param pulumi.Input[str] channel: optional name of the release channel for Spark version used by DLT pipeline.  Supported values are: `CURRENT` (default) and `PREVIEW`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PipelineClusterArgs']]]] clusters: blocks - Clusters to run the pipeline. If none is specified, pipelines will automatically select a default cluster configuration for the pipeline. *Please note that DLT pipeline clusters are supporting only subset of attributes as described in [documentation](https://docs.databricks.com/data-engineering/delta-live-tables/delta-live-tables-api-guide.html#pipelinesnewcluster).*  Also, note that `autoscale` block is extended with the `mode` parameter that controls the autoscaling algorithm (possible values are `ENHANCED` for new, enhanced autoscaling algorithm, or `LEGACY` for old algorithm).
        :param pulumi.Input[Mapping[str, Any]] configuration: An optional list of values to apply to the entire pipeline. Elements must be formatted as key:value pairs.
        :param pulumi.Input[bool] continuous: A flag indicating whether to run the pipeline continuously. The default value is `false`.
        :param pulumi.Input[bool] development: A flag indicating whether to run the pipeline in development mode. The default value is `true`.
        :param pulumi.Input[str] edition: optional name of the [product edition](https://docs.databricks.com/data-engineering/delta-live-tables/delta-live-tables-concepts.html#editions). Supported values are: `CORE`, `PRO`, `ADVANCED` (default).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PipelineLibraryArgs']]]] libraries: blocks - Specifies pipeline code and required artifacts. Syntax resembles library configuration block with the addition of a special `notebook` & `file` library types that should have the `path` attribute. *Right now only the `notebook` & `file` types are supported.*
        :param pulumi.Input[str] name: A user-friendly name for this pipeline. The name can be used to identify pipeline jobs in the UI.
        :param pulumi.Input[bool] photon: A flag indicating whether to use Photon engine. The default value is `false`.
        :param pulumi.Input[str] storage: A location on DBFS or cloud storage where output data and metadata required for pipeline execution are stored. By default, tables are stored in a subdirectory of this location. *Change of this parameter forces recreation of the pipeline.* (Conflicts with `catalog`).
        :param pulumi.Input[str] target: The name of a database (in either the Hive metastore or in a UC catalog) for persisting pipeline output data. Configuring the target setting allows you to view and query the pipeline output data from the Databricks UI.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[PipelineArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Use `Pipeline` to deploy [Delta Live Tables](https://docs.databricks.com/data-engineering/delta-live-tables/index.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_databricks as databricks

        dlt_demo = databricks.Notebook("dlt_demo")
        dlt_demo_repo = databricks.Repo("dlt_demo")
        this = databricks.Pipeline("this",
            name="Pipeline Name",
            storage="/test/first-pipeline",
            configuration={
                "key1": "value1",
                "key2": "value2",
            },
            clusters=[
                databricks.PipelineClusterArgs(
                    label="default",
                    num_workers=2,
                    custom_tags={
                        "cluster_type": "default",
                    },
                ),
                databricks.PipelineClusterArgs(
                    label="maintenance",
                    num_workers=1,
                    custom_tags={
                        "cluster_type": "maintenance",
                    },
                ),
            ],
            libraries=[
                databricks.PipelineLibraryArgs(
                    notebook=databricks.PipelineLibraryNotebookArgs(
                        path=dlt_demo.id,
                    ),
                ),
                databricks.PipelineLibraryArgs(
                    file=databricks.PipelineLibraryFileArgs(
                        path=dlt_demo_repo.path.apply(lambda path: f"{path}/pipeline.sql"),
                    ),
                ),
            ],
            continuous=False,
            notifications=[databricks.PipelineNotificationArgs(
                email_recipients=[
                    "user@domain.com",
                    "user1@domain.com",
                ],
                alerts=[
                    "on-update-failure",
                    "on-update-fatal-failure",
                    "on-update-success",
                    "on-flow-failure",
                ],
            )])
        ```

        ## Related Resources

        The following resources are often used in the same context:

        * End to end workspace management guide.
        * get_pipelines to retrieve [Delta Live Tables](https://docs.databricks.com/data-engineering/delta-live-tables/index.html) pipeline data.
        * Cluster to create [Databricks Clusters](https://docs.databricks.com/clusters/index.html).
        * Job to manage [Databricks Jobs](https://docs.databricks.com/jobs.html) to run non-interactive code in a databricks_cluster.
        * Notebook to manage [Databricks Notebooks](https://docs.databricks.com/notebooks/index.html).

        ## Import

        The resource job can be imported using the id of the pipeline

        bash

        ```sh
        $ pulumi import databricks:index/pipeline:Pipeline this <pipeline-id>
        ```

        :param str resource_name: The name of the resource.
        :param PipelineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PipelineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_duplicate_names: Optional[pulumi.Input[bool]] = None,
                 catalog: Optional[pulumi.Input[str]] = None,
                 channel: Optional[pulumi.Input[str]] = None,
                 clusters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PipelineClusterArgs']]]]] = None,
                 configuration: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 continuous: Optional[pulumi.Input[bool]] = None,
                 deployment: Optional[pulumi.Input[pulumi.InputType['PipelineDeploymentArgs']]] = None,
                 development: Optional[pulumi.Input[bool]] = None,
                 edition: Optional[pulumi.Input[str]] = None,
                 filters: Optional[pulumi.Input[pulumi.InputType['PipelineFiltersArgs']]] = None,
                 libraries: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PipelineLibraryArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notifications: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PipelineNotificationArgs']]]]] = None,
                 photon: Optional[pulumi.Input[bool]] = None,
                 serverless: Optional[pulumi.Input[bool]] = None,
                 storage: Optional[pulumi.Input[str]] = None,
                 target: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PipelineArgs.__new__(PipelineArgs)

            __props__.__dict__["allow_duplicate_names"] = allow_duplicate_names
            __props__.__dict__["catalog"] = catalog
            __props__.__dict__["channel"] = channel
            __props__.__dict__["clusters"] = clusters
            __props__.__dict__["configuration"] = configuration
            __props__.__dict__["continuous"] = continuous
            __props__.__dict__["deployment"] = deployment
            __props__.__dict__["development"] = development
            __props__.__dict__["edition"] = edition
            __props__.__dict__["filters"] = filters
            __props__.__dict__["libraries"] = libraries
            __props__.__dict__["name"] = name
            __props__.__dict__["notifications"] = notifications
            __props__.__dict__["photon"] = photon
            __props__.__dict__["serverless"] = serverless
            __props__.__dict__["storage"] = storage
            __props__.__dict__["target"] = target
            __props__.__dict__["url"] = None
        super(Pipeline, __self__).__init__(
            'databricks:index/pipeline:Pipeline',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_duplicate_names: Optional[pulumi.Input[bool]] = None,
            catalog: Optional[pulumi.Input[str]] = None,
            channel: Optional[pulumi.Input[str]] = None,
            clusters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PipelineClusterArgs']]]]] = None,
            configuration: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            continuous: Optional[pulumi.Input[bool]] = None,
            deployment: Optional[pulumi.Input[pulumi.InputType['PipelineDeploymentArgs']]] = None,
            development: Optional[pulumi.Input[bool]] = None,
            edition: Optional[pulumi.Input[str]] = None,
            filters: Optional[pulumi.Input[pulumi.InputType['PipelineFiltersArgs']]] = None,
            libraries: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PipelineLibraryArgs']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            notifications: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PipelineNotificationArgs']]]]] = None,
            photon: Optional[pulumi.Input[bool]] = None,
            serverless: Optional[pulumi.Input[bool]] = None,
            storage: Optional[pulumi.Input[str]] = None,
            target: Optional[pulumi.Input[str]] = None,
            url: Optional[pulumi.Input[str]] = None) -> 'Pipeline':
        """
        Get an existing Pipeline resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] catalog: The name of catalog in Unity Catalog. *Change of this parameter forces recreation of the pipeline.* (Conflicts with `storage`).
        :param pulumi.Input[str] channel: optional name of the release channel for Spark version used by DLT pipeline.  Supported values are: `CURRENT` (default) and `PREVIEW`.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PipelineClusterArgs']]]] clusters: blocks - Clusters to run the pipeline. If none is specified, pipelines will automatically select a default cluster configuration for the pipeline. *Please note that DLT pipeline clusters are supporting only subset of attributes as described in [documentation](https://docs.databricks.com/data-engineering/delta-live-tables/delta-live-tables-api-guide.html#pipelinesnewcluster).*  Also, note that `autoscale` block is extended with the `mode` parameter that controls the autoscaling algorithm (possible values are `ENHANCED` for new, enhanced autoscaling algorithm, or `LEGACY` for old algorithm).
        :param pulumi.Input[Mapping[str, Any]] configuration: An optional list of values to apply to the entire pipeline. Elements must be formatted as key:value pairs.
        :param pulumi.Input[bool] continuous: A flag indicating whether to run the pipeline continuously. The default value is `false`.
        :param pulumi.Input[bool] development: A flag indicating whether to run the pipeline in development mode. The default value is `true`.
        :param pulumi.Input[str] edition: optional name of the [product edition](https://docs.databricks.com/data-engineering/delta-live-tables/delta-live-tables-concepts.html#editions). Supported values are: `CORE`, `PRO`, `ADVANCED` (default).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['PipelineLibraryArgs']]]] libraries: blocks - Specifies pipeline code and required artifacts. Syntax resembles library configuration block with the addition of a special `notebook` & `file` library types that should have the `path` attribute. *Right now only the `notebook` & `file` types are supported.*
        :param pulumi.Input[str] name: A user-friendly name for this pipeline. The name can be used to identify pipeline jobs in the UI.
        :param pulumi.Input[bool] photon: A flag indicating whether to use Photon engine. The default value is `false`.
        :param pulumi.Input[str] storage: A location on DBFS or cloud storage where output data and metadata required for pipeline execution are stored. By default, tables are stored in a subdirectory of this location. *Change of this parameter forces recreation of the pipeline.* (Conflicts with `catalog`).
        :param pulumi.Input[str] target: The name of a database (in either the Hive metastore or in a UC catalog) for persisting pipeline output data. Configuring the target setting allows you to view and query the pipeline output data from the Databricks UI.
        :param pulumi.Input[str] url: URL of the DLT pipeline on the given workspace.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PipelineState.__new__(_PipelineState)

        __props__.__dict__["allow_duplicate_names"] = allow_duplicate_names
        __props__.__dict__["catalog"] = catalog
        __props__.__dict__["channel"] = channel
        __props__.__dict__["clusters"] = clusters
        __props__.__dict__["configuration"] = configuration
        __props__.__dict__["continuous"] = continuous
        __props__.__dict__["deployment"] = deployment
        __props__.__dict__["development"] = development
        __props__.__dict__["edition"] = edition
        __props__.__dict__["filters"] = filters
        __props__.__dict__["libraries"] = libraries
        __props__.__dict__["name"] = name
        __props__.__dict__["notifications"] = notifications
        __props__.__dict__["photon"] = photon
        __props__.__dict__["serverless"] = serverless
        __props__.__dict__["storage"] = storage
        __props__.__dict__["target"] = target
        __props__.__dict__["url"] = url
        return Pipeline(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowDuplicateNames")
    def allow_duplicate_names(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "allow_duplicate_names")

    @property
    @pulumi.getter
    def catalog(self) -> pulumi.Output[Optional[str]]:
        """
        The name of catalog in Unity Catalog. *Change of this parameter forces recreation of the pipeline.* (Conflicts with `storage`).
        """
        return pulumi.get(self, "catalog")

    @property
    @pulumi.getter
    def channel(self) -> pulumi.Output[Optional[str]]:
        """
        optional name of the release channel for Spark version used by DLT pipeline.  Supported values are: `CURRENT` (default) and `PREVIEW`.
        """
        return pulumi.get(self, "channel")

    @property
    @pulumi.getter
    def clusters(self) -> pulumi.Output[Optional[Sequence['outputs.PipelineCluster']]]:
        """
        blocks - Clusters to run the pipeline. If none is specified, pipelines will automatically select a default cluster configuration for the pipeline. *Please note that DLT pipeline clusters are supporting only subset of attributes as described in [documentation](https://docs.databricks.com/data-engineering/delta-live-tables/delta-live-tables-api-guide.html#pipelinesnewcluster).*  Also, note that `autoscale` block is extended with the `mode` parameter that controls the autoscaling algorithm (possible values are `ENHANCED` for new, enhanced autoscaling algorithm, or `LEGACY` for old algorithm).
        """
        return pulumi.get(self, "clusters")

    @property
    @pulumi.getter
    def configuration(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        An optional list of values to apply to the entire pipeline. Elements must be formatted as key:value pairs.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter
    def continuous(self) -> pulumi.Output[Optional[bool]]:
        """
        A flag indicating whether to run the pipeline continuously. The default value is `false`.
        """
        return pulumi.get(self, "continuous")

    @property
    @pulumi.getter
    def deployment(self) -> pulumi.Output[Optional['outputs.PipelineDeployment']]:
        return pulumi.get(self, "deployment")

    @property
    @pulumi.getter
    def development(self) -> pulumi.Output[Optional[bool]]:
        """
        A flag indicating whether to run the pipeline in development mode. The default value is `true`.
        """
        return pulumi.get(self, "development")

    @property
    @pulumi.getter
    def edition(self) -> pulumi.Output[Optional[str]]:
        """
        optional name of the [product edition](https://docs.databricks.com/data-engineering/delta-live-tables/delta-live-tables-concepts.html#editions). Supported values are: `CORE`, `PRO`, `ADVANCED` (default).
        """
        return pulumi.get(self, "edition")

    @property
    @pulumi.getter
    def filters(self) -> pulumi.Output[Optional['outputs.PipelineFilters']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def libraries(self) -> pulumi.Output[Optional[Sequence['outputs.PipelineLibrary']]]:
        """
        blocks - Specifies pipeline code and required artifacts. Syntax resembles library configuration block with the addition of a special `notebook` & `file` library types that should have the `path` attribute. *Right now only the `notebook` & `file` types are supported.*
        """
        return pulumi.get(self, "libraries")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A user-friendly name for this pipeline. The name can be used to identify pipeline jobs in the UI.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def notifications(self) -> pulumi.Output[Optional[Sequence['outputs.PipelineNotification']]]:
        return pulumi.get(self, "notifications")

    @property
    @pulumi.getter
    def photon(self) -> pulumi.Output[Optional[bool]]:
        """
        A flag indicating whether to use Photon engine. The default value is `false`.
        """
        return pulumi.get(self, "photon")

    @property
    @pulumi.getter
    def serverless(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "serverless")

    @property
    @pulumi.getter
    def storage(self) -> pulumi.Output[Optional[str]]:
        """
        A location on DBFS or cloud storage where output data and metadata required for pipeline execution are stored. By default, tables are stored in a subdirectory of this location. *Change of this parameter forces recreation of the pipeline.* (Conflicts with `catalog`).
        """
        return pulumi.get(self, "storage")

    @property
    @pulumi.getter
    def target(self) -> pulumi.Output[Optional[str]]:
        """
        The name of a database (in either the Hive metastore or in a UC catalog) for persisting pipeline output data. Configuring the target setting allows you to view and query the pipeline output data from the Databricks UI.
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[str]:
        """
        URL of the DLT pipeline on the given workspace.
        """
        return pulumi.get(self, "url")

