# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['QualityMonitorArgs', 'QualityMonitor']

@pulumi.input_type
class QualityMonitorArgs:
    def __init__(__self__, *,
                 assets_dir: pulumi.Input[str],
                 output_schema_name: pulumi.Input[str],
                 table_name: pulumi.Input[str],
                 baseline_table_name: Optional[pulumi.Input[str]] = None,
                 custom_metrics: Optional[pulumi.Input[Sequence[pulumi.Input['QualityMonitorCustomMetricArgs']]]] = None,
                 data_classification_config: Optional[pulumi.Input['QualityMonitorDataClassificationConfigArgs']] = None,
                 inference_log: Optional[pulumi.Input['QualityMonitorInferenceLogArgs']] = None,
                 latest_monitor_failure_msg: Optional[pulumi.Input[str]] = None,
                 notifications: Optional[pulumi.Input['QualityMonitorNotificationsArgs']] = None,
                 schedule: Optional[pulumi.Input['QualityMonitorScheduleArgs']] = None,
                 skip_builtin_dashboard: Optional[pulumi.Input[bool]] = None,
                 slicing_exprs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 snapshot: Optional[pulumi.Input['QualityMonitorSnapshotArgs']] = None,
                 time_series: Optional[pulumi.Input['QualityMonitorTimeSeriesArgs']] = None,
                 warehouse_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a QualityMonitor resource.
        :param pulumi.Input[str] assets_dir: The directory to store the monitoring assets (Eg. Dashboard and Metric Tables)
        :param pulumi.Input[str] output_schema_name: Schema where output metric tables are created
        :param pulumi.Input[str] table_name: The full name of the table to attach the monitor too. Its of the format {catalog}.{schema}.{tableName}
        :param pulumi.Input[str] baseline_table_name: Name of the baseline table from which drift metrics are computed from.Columns in the monitored table should also be present in the baseline
               table.
        :param pulumi.Input[Sequence[pulumi.Input['QualityMonitorCustomMetricArgs']]] custom_metrics: Custom metrics to compute on the monitored table. These can be aggregate metrics, derived metrics (from already computed aggregate metrics), or drift metrics (comparing metrics across time windows).
        :param pulumi.Input['QualityMonitorDataClassificationConfigArgs'] data_classification_config: The data classification config for the monitor
        :param pulumi.Input['QualityMonitorInferenceLogArgs'] inference_log: Configuration for the inference log monitor
        :param pulumi.Input['QualityMonitorNotificationsArgs'] notifications: The notification settings for the monitor.  The following optional blocks are supported, each consisting of the single string array field with name `email_addresses` containing a list of emails to notify:
        :param pulumi.Input['QualityMonitorScheduleArgs'] schedule: The schedule for automatically updating and refreshing metric tables.  This block consists of following fields:
        :param pulumi.Input[bool] skip_builtin_dashboard: Whether to skip creating a default dashboard summarizing data quality metrics.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] slicing_exprs: List of column expressions to slice data with for targeted analysis. The data is grouped by each expression independently, resulting in a separate slice for each predicate and its complements. For high-cardinality columns, only the top 100 unique values by frequency will generate slices.
        :param pulumi.Input['QualityMonitorSnapshotArgs'] snapshot: Configuration for monitoring snapshot tables.
        :param pulumi.Input['QualityMonitorTimeSeriesArgs'] time_series: Configuration for monitoring timeseries tables.
        :param pulumi.Input[str] warehouse_id: Optional argument to specify the warehouse for dashboard creation. If not specified, the first running warehouse will be used.
        """
        pulumi.set(__self__, "assets_dir", assets_dir)
        pulumi.set(__self__, "output_schema_name", output_schema_name)
        pulumi.set(__self__, "table_name", table_name)
        if baseline_table_name is not None:
            pulumi.set(__self__, "baseline_table_name", baseline_table_name)
        if custom_metrics is not None:
            pulumi.set(__self__, "custom_metrics", custom_metrics)
        if data_classification_config is not None:
            pulumi.set(__self__, "data_classification_config", data_classification_config)
        if inference_log is not None:
            pulumi.set(__self__, "inference_log", inference_log)
        if latest_monitor_failure_msg is not None:
            pulumi.set(__self__, "latest_monitor_failure_msg", latest_monitor_failure_msg)
        if notifications is not None:
            pulumi.set(__self__, "notifications", notifications)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if skip_builtin_dashboard is not None:
            pulumi.set(__self__, "skip_builtin_dashboard", skip_builtin_dashboard)
        if slicing_exprs is not None:
            pulumi.set(__self__, "slicing_exprs", slicing_exprs)
        if snapshot is not None:
            pulumi.set(__self__, "snapshot", snapshot)
        if time_series is not None:
            pulumi.set(__self__, "time_series", time_series)
        if warehouse_id is not None:
            pulumi.set(__self__, "warehouse_id", warehouse_id)

    @property
    @pulumi.getter(name="assetsDir")
    def assets_dir(self) -> pulumi.Input[str]:
        """
        The directory to store the monitoring assets (Eg. Dashboard and Metric Tables)
        """
        return pulumi.get(self, "assets_dir")

    @assets_dir.setter
    def assets_dir(self, value: pulumi.Input[str]):
        pulumi.set(self, "assets_dir", value)

    @property
    @pulumi.getter(name="outputSchemaName")
    def output_schema_name(self) -> pulumi.Input[str]:
        """
        Schema where output metric tables are created
        """
        return pulumi.get(self, "output_schema_name")

    @output_schema_name.setter
    def output_schema_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "output_schema_name", value)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Input[str]:
        """
        The full name of the table to attach the monitor too. Its of the format {catalog}.{schema}.{tableName}
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "table_name", value)

    @property
    @pulumi.getter(name="baselineTableName")
    def baseline_table_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the baseline table from which drift metrics are computed from.Columns in the monitored table should also be present in the baseline
        table.
        """
        return pulumi.get(self, "baseline_table_name")

    @baseline_table_name.setter
    def baseline_table_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "baseline_table_name", value)

    @property
    @pulumi.getter(name="customMetrics")
    def custom_metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['QualityMonitorCustomMetricArgs']]]]:
        """
        Custom metrics to compute on the monitored table. These can be aggregate metrics, derived metrics (from already computed aggregate metrics), or drift metrics (comparing metrics across time windows).
        """
        return pulumi.get(self, "custom_metrics")

    @custom_metrics.setter
    def custom_metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['QualityMonitorCustomMetricArgs']]]]):
        pulumi.set(self, "custom_metrics", value)

    @property
    @pulumi.getter(name="dataClassificationConfig")
    def data_classification_config(self) -> Optional[pulumi.Input['QualityMonitorDataClassificationConfigArgs']]:
        """
        The data classification config for the monitor
        """
        return pulumi.get(self, "data_classification_config")

    @data_classification_config.setter
    def data_classification_config(self, value: Optional[pulumi.Input['QualityMonitorDataClassificationConfigArgs']]):
        pulumi.set(self, "data_classification_config", value)

    @property
    @pulumi.getter(name="inferenceLog")
    def inference_log(self) -> Optional[pulumi.Input['QualityMonitorInferenceLogArgs']]:
        """
        Configuration for the inference log monitor
        """
        return pulumi.get(self, "inference_log")

    @inference_log.setter
    def inference_log(self, value: Optional[pulumi.Input['QualityMonitorInferenceLogArgs']]):
        pulumi.set(self, "inference_log", value)

    @property
    @pulumi.getter(name="latestMonitorFailureMsg")
    def latest_monitor_failure_msg(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "latest_monitor_failure_msg")

    @latest_monitor_failure_msg.setter
    def latest_monitor_failure_msg(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "latest_monitor_failure_msg", value)

    @property
    @pulumi.getter
    def notifications(self) -> Optional[pulumi.Input['QualityMonitorNotificationsArgs']]:
        """
        The notification settings for the monitor.  The following optional blocks are supported, each consisting of the single string array field with name `email_addresses` containing a list of emails to notify:
        """
        return pulumi.get(self, "notifications")

    @notifications.setter
    def notifications(self, value: Optional[pulumi.Input['QualityMonitorNotificationsArgs']]):
        pulumi.set(self, "notifications", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['QualityMonitorScheduleArgs']]:
        """
        The schedule for automatically updating and refreshing metric tables.  This block consists of following fields:
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['QualityMonitorScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="skipBuiltinDashboard")
    def skip_builtin_dashboard(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to skip creating a default dashboard summarizing data quality metrics.
        """
        return pulumi.get(self, "skip_builtin_dashboard")

    @skip_builtin_dashboard.setter
    def skip_builtin_dashboard(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_builtin_dashboard", value)

    @property
    @pulumi.getter(name="slicingExprs")
    def slicing_exprs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of column expressions to slice data with for targeted analysis. The data is grouped by each expression independently, resulting in a separate slice for each predicate and its complements. For high-cardinality columns, only the top 100 unique values by frequency will generate slices.
        """
        return pulumi.get(self, "slicing_exprs")

    @slicing_exprs.setter
    def slicing_exprs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "slicing_exprs", value)

    @property
    @pulumi.getter
    def snapshot(self) -> Optional[pulumi.Input['QualityMonitorSnapshotArgs']]:
        """
        Configuration for monitoring snapshot tables.
        """
        return pulumi.get(self, "snapshot")

    @snapshot.setter
    def snapshot(self, value: Optional[pulumi.Input['QualityMonitorSnapshotArgs']]):
        pulumi.set(self, "snapshot", value)

    @property
    @pulumi.getter(name="timeSeries")
    def time_series(self) -> Optional[pulumi.Input['QualityMonitorTimeSeriesArgs']]:
        """
        Configuration for monitoring timeseries tables.
        """
        return pulumi.get(self, "time_series")

    @time_series.setter
    def time_series(self, value: Optional[pulumi.Input['QualityMonitorTimeSeriesArgs']]):
        pulumi.set(self, "time_series", value)

    @property
    @pulumi.getter(name="warehouseId")
    def warehouse_id(self) -> Optional[pulumi.Input[str]]:
        """
        Optional argument to specify the warehouse for dashboard creation. If not specified, the first running warehouse will be used.
        """
        return pulumi.get(self, "warehouse_id")

    @warehouse_id.setter
    def warehouse_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "warehouse_id", value)


@pulumi.input_type
class _QualityMonitorState:
    def __init__(__self__, *,
                 assets_dir: Optional[pulumi.Input[str]] = None,
                 baseline_table_name: Optional[pulumi.Input[str]] = None,
                 custom_metrics: Optional[pulumi.Input[Sequence[pulumi.Input['QualityMonitorCustomMetricArgs']]]] = None,
                 dashboard_id: Optional[pulumi.Input[str]] = None,
                 data_classification_config: Optional[pulumi.Input['QualityMonitorDataClassificationConfigArgs']] = None,
                 drift_metrics_table_name: Optional[pulumi.Input[str]] = None,
                 inference_log: Optional[pulumi.Input['QualityMonitorInferenceLogArgs']] = None,
                 latest_monitor_failure_msg: Optional[pulumi.Input[str]] = None,
                 monitor_version: Optional[pulumi.Input[str]] = None,
                 notifications: Optional[pulumi.Input['QualityMonitorNotificationsArgs']] = None,
                 output_schema_name: Optional[pulumi.Input[str]] = None,
                 profile_metrics_table_name: Optional[pulumi.Input[str]] = None,
                 schedule: Optional[pulumi.Input['QualityMonitorScheduleArgs']] = None,
                 skip_builtin_dashboard: Optional[pulumi.Input[bool]] = None,
                 slicing_exprs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 snapshot: Optional[pulumi.Input['QualityMonitorSnapshotArgs']] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 table_name: Optional[pulumi.Input[str]] = None,
                 time_series: Optional[pulumi.Input['QualityMonitorTimeSeriesArgs']] = None,
                 warehouse_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering QualityMonitor resources.
        :param pulumi.Input[str] assets_dir: The directory to store the monitoring assets (Eg. Dashboard and Metric Tables)
        :param pulumi.Input[str] baseline_table_name: Name of the baseline table from which drift metrics are computed from.Columns in the monitored table should also be present in the baseline
               table.
        :param pulumi.Input[Sequence[pulumi.Input['QualityMonitorCustomMetricArgs']]] custom_metrics: Custom metrics to compute on the monitored table. These can be aggregate metrics, derived metrics (from already computed aggregate metrics), or drift metrics (comparing metrics across time windows).
        :param pulumi.Input[str] dashboard_id: The ID of the generated dashboard.
        :param pulumi.Input['QualityMonitorDataClassificationConfigArgs'] data_classification_config: The data classification config for the monitor
        :param pulumi.Input[str] drift_metrics_table_name: The full name of the drift metrics table. Format: __catalog_name__.__schema_name__.__table_name__.
        :param pulumi.Input['QualityMonitorInferenceLogArgs'] inference_log: Configuration for the inference log monitor
        :param pulumi.Input[str] monitor_version: The version of the monitor config (e.g. 1,2,3). If negative, the monitor may be corrupted
        :param pulumi.Input['QualityMonitorNotificationsArgs'] notifications: The notification settings for the monitor.  The following optional blocks are supported, each consisting of the single string array field with name `email_addresses` containing a list of emails to notify:
        :param pulumi.Input[str] output_schema_name: Schema where output metric tables are created
        :param pulumi.Input[str] profile_metrics_table_name: The full name of the profile metrics table. Format: __catalog_name__.__schema_name__.__table_name__.
        :param pulumi.Input['QualityMonitorScheduleArgs'] schedule: The schedule for automatically updating and refreshing metric tables.  This block consists of following fields:
        :param pulumi.Input[bool] skip_builtin_dashboard: Whether to skip creating a default dashboard summarizing data quality metrics.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] slicing_exprs: List of column expressions to slice data with for targeted analysis. The data is grouped by each expression independently, resulting in a separate slice for each predicate and its complements. For high-cardinality columns, only the top 100 unique values by frequency will generate slices.
        :param pulumi.Input['QualityMonitorSnapshotArgs'] snapshot: Configuration for monitoring snapshot tables.
        :param pulumi.Input[str] status: Status of the Monitor
        :param pulumi.Input[str] table_name: The full name of the table to attach the monitor too. Its of the format {catalog}.{schema}.{tableName}
        :param pulumi.Input['QualityMonitorTimeSeriesArgs'] time_series: Configuration for monitoring timeseries tables.
        :param pulumi.Input[str] warehouse_id: Optional argument to specify the warehouse for dashboard creation. If not specified, the first running warehouse will be used.
        """
        if assets_dir is not None:
            pulumi.set(__self__, "assets_dir", assets_dir)
        if baseline_table_name is not None:
            pulumi.set(__self__, "baseline_table_name", baseline_table_name)
        if custom_metrics is not None:
            pulumi.set(__self__, "custom_metrics", custom_metrics)
        if dashboard_id is not None:
            pulumi.set(__self__, "dashboard_id", dashboard_id)
        if data_classification_config is not None:
            pulumi.set(__self__, "data_classification_config", data_classification_config)
        if drift_metrics_table_name is not None:
            pulumi.set(__self__, "drift_metrics_table_name", drift_metrics_table_name)
        if inference_log is not None:
            pulumi.set(__self__, "inference_log", inference_log)
        if latest_monitor_failure_msg is not None:
            pulumi.set(__self__, "latest_monitor_failure_msg", latest_monitor_failure_msg)
        if monitor_version is not None:
            pulumi.set(__self__, "monitor_version", monitor_version)
        if notifications is not None:
            pulumi.set(__self__, "notifications", notifications)
        if output_schema_name is not None:
            pulumi.set(__self__, "output_schema_name", output_schema_name)
        if profile_metrics_table_name is not None:
            pulumi.set(__self__, "profile_metrics_table_name", profile_metrics_table_name)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if skip_builtin_dashboard is not None:
            pulumi.set(__self__, "skip_builtin_dashboard", skip_builtin_dashboard)
        if slicing_exprs is not None:
            pulumi.set(__self__, "slicing_exprs", slicing_exprs)
        if snapshot is not None:
            pulumi.set(__self__, "snapshot", snapshot)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if table_name is not None:
            pulumi.set(__self__, "table_name", table_name)
        if time_series is not None:
            pulumi.set(__self__, "time_series", time_series)
        if warehouse_id is not None:
            pulumi.set(__self__, "warehouse_id", warehouse_id)

    @property
    @pulumi.getter(name="assetsDir")
    def assets_dir(self) -> Optional[pulumi.Input[str]]:
        """
        The directory to store the monitoring assets (Eg. Dashboard and Metric Tables)
        """
        return pulumi.get(self, "assets_dir")

    @assets_dir.setter
    def assets_dir(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "assets_dir", value)

    @property
    @pulumi.getter(name="baselineTableName")
    def baseline_table_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the baseline table from which drift metrics are computed from.Columns in the monitored table should also be present in the baseline
        table.
        """
        return pulumi.get(self, "baseline_table_name")

    @baseline_table_name.setter
    def baseline_table_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "baseline_table_name", value)

    @property
    @pulumi.getter(name="customMetrics")
    def custom_metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['QualityMonitorCustomMetricArgs']]]]:
        """
        Custom metrics to compute on the monitored table. These can be aggregate metrics, derived metrics (from already computed aggregate metrics), or drift metrics (comparing metrics across time windows).
        """
        return pulumi.get(self, "custom_metrics")

    @custom_metrics.setter
    def custom_metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['QualityMonitorCustomMetricArgs']]]]):
        pulumi.set(self, "custom_metrics", value)

    @property
    @pulumi.getter(name="dashboardId")
    def dashboard_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the generated dashboard.
        """
        return pulumi.get(self, "dashboard_id")

    @dashboard_id.setter
    def dashboard_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dashboard_id", value)

    @property
    @pulumi.getter(name="dataClassificationConfig")
    def data_classification_config(self) -> Optional[pulumi.Input['QualityMonitorDataClassificationConfigArgs']]:
        """
        The data classification config for the monitor
        """
        return pulumi.get(self, "data_classification_config")

    @data_classification_config.setter
    def data_classification_config(self, value: Optional[pulumi.Input['QualityMonitorDataClassificationConfigArgs']]):
        pulumi.set(self, "data_classification_config", value)

    @property
    @pulumi.getter(name="driftMetricsTableName")
    def drift_metrics_table_name(self) -> Optional[pulumi.Input[str]]:
        """
        The full name of the drift metrics table. Format: __catalog_name__.__schema_name__.__table_name__.
        """
        return pulumi.get(self, "drift_metrics_table_name")

    @drift_metrics_table_name.setter
    def drift_metrics_table_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "drift_metrics_table_name", value)

    @property
    @pulumi.getter(name="inferenceLog")
    def inference_log(self) -> Optional[pulumi.Input['QualityMonitorInferenceLogArgs']]:
        """
        Configuration for the inference log monitor
        """
        return pulumi.get(self, "inference_log")

    @inference_log.setter
    def inference_log(self, value: Optional[pulumi.Input['QualityMonitorInferenceLogArgs']]):
        pulumi.set(self, "inference_log", value)

    @property
    @pulumi.getter(name="latestMonitorFailureMsg")
    def latest_monitor_failure_msg(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "latest_monitor_failure_msg")

    @latest_monitor_failure_msg.setter
    def latest_monitor_failure_msg(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "latest_monitor_failure_msg", value)

    @property
    @pulumi.getter(name="monitorVersion")
    def monitor_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the monitor config (e.g. 1,2,3). If negative, the monitor may be corrupted
        """
        return pulumi.get(self, "monitor_version")

    @monitor_version.setter
    def monitor_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "monitor_version", value)

    @property
    @pulumi.getter
    def notifications(self) -> Optional[pulumi.Input['QualityMonitorNotificationsArgs']]:
        """
        The notification settings for the monitor.  The following optional blocks are supported, each consisting of the single string array field with name `email_addresses` containing a list of emails to notify:
        """
        return pulumi.get(self, "notifications")

    @notifications.setter
    def notifications(self, value: Optional[pulumi.Input['QualityMonitorNotificationsArgs']]):
        pulumi.set(self, "notifications", value)

    @property
    @pulumi.getter(name="outputSchemaName")
    def output_schema_name(self) -> Optional[pulumi.Input[str]]:
        """
        Schema where output metric tables are created
        """
        return pulumi.get(self, "output_schema_name")

    @output_schema_name.setter
    def output_schema_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "output_schema_name", value)

    @property
    @pulumi.getter(name="profileMetricsTableName")
    def profile_metrics_table_name(self) -> Optional[pulumi.Input[str]]:
        """
        The full name of the profile metrics table. Format: __catalog_name__.__schema_name__.__table_name__.
        """
        return pulumi.get(self, "profile_metrics_table_name")

    @profile_metrics_table_name.setter
    def profile_metrics_table_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "profile_metrics_table_name", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['QualityMonitorScheduleArgs']]:
        """
        The schedule for automatically updating and refreshing metric tables.  This block consists of following fields:
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['QualityMonitorScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="skipBuiltinDashboard")
    def skip_builtin_dashboard(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to skip creating a default dashboard summarizing data quality metrics.
        """
        return pulumi.get(self, "skip_builtin_dashboard")

    @skip_builtin_dashboard.setter
    def skip_builtin_dashboard(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_builtin_dashboard", value)

    @property
    @pulumi.getter(name="slicingExprs")
    def slicing_exprs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of column expressions to slice data with for targeted analysis. The data is grouped by each expression independently, resulting in a separate slice for each predicate and its complements. For high-cardinality columns, only the top 100 unique values by frequency will generate slices.
        """
        return pulumi.get(self, "slicing_exprs")

    @slicing_exprs.setter
    def slicing_exprs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "slicing_exprs", value)

    @property
    @pulumi.getter
    def snapshot(self) -> Optional[pulumi.Input['QualityMonitorSnapshotArgs']]:
        """
        Configuration for monitoring snapshot tables.
        """
        return pulumi.get(self, "snapshot")

    @snapshot.setter
    def snapshot(self, value: Optional[pulumi.Input['QualityMonitorSnapshotArgs']]):
        pulumi.set(self, "snapshot", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the Monitor
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> Optional[pulumi.Input[str]]:
        """
        The full name of the table to attach the monitor too. Its of the format {catalog}.{schema}.{tableName}
        """
        return pulumi.get(self, "table_name")

    @table_name.setter
    def table_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table_name", value)

    @property
    @pulumi.getter(name="timeSeries")
    def time_series(self) -> Optional[pulumi.Input['QualityMonitorTimeSeriesArgs']]:
        """
        Configuration for monitoring timeseries tables.
        """
        return pulumi.get(self, "time_series")

    @time_series.setter
    def time_series(self, value: Optional[pulumi.Input['QualityMonitorTimeSeriesArgs']]):
        pulumi.set(self, "time_series", value)

    @property
    @pulumi.getter(name="warehouseId")
    def warehouse_id(self) -> Optional[pulumi.Input[str]]:
        """
        Optional argument to specify the warehouse for dashboard creation. If not specified, the first running warehouse will be used.
        """
        return pulumi.get(self, "warehouse_id")

    @warehouse_id.setter
    def warehouse_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "warehouse_id", value)


class QualityMonitor(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assets_dir: Optional[pulumi.Input[str]] = None,
                 baseline_table_name: Optional[pulumi.Input[str]] = None,
                 custom_metrics: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['QualityMonitorCustomMetricArgs']]]]] = None,
                 data_classification_config: Optional[pulumi.Input[pulumi.InputType['QualityMonitorDataClassificationConfigArgs']]] = None,
                 inference_log: Optional[pulumi.Input[pulumi.InputType['QualityMonitorInferenceLogArgs']]] = None,
                 latest_monitor_failure_msg: Optional[pulumi.Input[str]] = None,
                 notifications: Optional[pulumi.Input[pulumi.InputType['QualityMonitorNotificationsArgs']]] = None,
                 output_schema_name: Optional[pulumi.Input[str]] = None,
                 schedule: Optional[pulumi.Input[pulumi.InputType['QualityMonitorScheduleArgs']]] = None,
                 skip_builtin_dashboard: Optional[pulumi.Input[bool]] = None,
                 slicing_exprs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 snapshot: Optional[pulumi.Input[pulumi.InputType['QualityMonitorSnapshotArgs']]] = None,
                 table_name: Optional[pulumi.Input[str]] = None,
                 time_series: Optional[pulumi.Input[pulumi.InputType['QualityMonitorTimeSeriesArgs']]] = None,
                 warehouse_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource allows you to manage [Lakehouse Monitors](https://docs.databricks.com/en/lakehouse-monitoring/index.html) in Databricks.

        A `QualityMonitor` is attached to a SqlTable and can be of type timeseries, snapshot or inference.

        ### Inference Monitor

        ```python
        import pulumi
        import pulumi_databricks as databricks

        test_monitor_inference = databricks.QualityMonitor("testMonitorInference",
            table_name=f"{sandbox['name']}.{things['name']}.{my_test_table['name']}",
            assets_dir=f"/Shared/provider-test/databricks_quality_monitoring/{my_test_table['name']}",
            output_schema_name=f"{sandbox['name']}.{things['name']}",
            inference_log=databricks.QualityMonitorInferenceLogArgs(
                granularities=["1 hour"],
                timestamp_col="timestamp",
                prediction_col="prediction",
                model_id_col="model_id",
                problem_type="PROBLEM_TYPE_REGRESSION",
            ))
        ```
        ### Snapshot Monitor
        ```python
        import pulumi
        import pulumi_databricks as databricks

        test_monitor_inference = databricks.QualityMonitor("testMonitorInference",
            table_name=f"{sandbox['name']}.{things['name']}.{my_test_table['name']}",
            assets_dir=f"/Shared/provider-test/databricks_quality_monitoring/{my_test_table['name']}",
            output_schema_name=f"{sandbox['name']}.{things['name']}",
            snapshot=databricks.QualityMonitorSnapshotArgs())
        ```

        ## Related Resources

        The following resources are often used in the same context:

        * Catalog
        * Schema
        * SqlTable

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] assets_dir: The directory to store the monitoring assets (Eg. Dashboard and Metric Tables)
        :param pulumi.Input[str] baseline_table_name: Name of the baseline table from which drift metrics are computed from.Columns in the monitored table should also be present in the baseline
               table.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['QualityMonitorCustomMetricArgs']]]] custom_metrics: Custom metrics to compute on the monitored table. These can be aggregate metrics, derived metrics (from already computed aggregate metrics), or drift metrics (comparing metrics across time windows).
        :param pulumi.Input[pulumi.InputType['QualityMonitorDataClassificationConfigArgs']] data_classification_config: The data classification config for the monitor
        :param pulumi.Input[pulumi.InputType['QualityMonitorInferenceLogArgs']] inference_log: Configuration for the inference log monitor
        :param pulumi.Input[pulumi.InputType['QualityMonitorNotificationsArgs']] notifications: The notification settings for the monitor.  The following optional blocks are supported, each consisting of the single string array field with name `email_addresses` containing a list of emails to notify:
        :param pulumi.Input[str] output_schema_name: Schema where output metric tables are created
        :param pulumi.Input[pulumi.InputType['QualityMonitorScheduleArgs']] schedule: The schedule for automatically updating and refreshing metric tables.  This block consists of following fields:
        :param pulumi.Input[bool] skip_builtin_dashboard: Whether to skip creating a default dashboard summarizing data quality metrics.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] slicing_exprs: List of column expressions to slice data with for targeted analysis. The data is grouped by each expression independently, resulting in a separate slice for each predicate and its complements. For high-cardinality columns, only the top 100 unique values by frequency will generate slices.
        :param pulumi.Input[pulumi.InputType['QualityMonitorSnapshotArgs']] snapshot: Configuration for monitoring snapshot tables.
        :param pulumi.Input[str] table_name: The full name of the table to attach the monitor too. Its of the format {catalog}.{schema}.{tableName}
        :param pulumi.Input[pulumi.InputType['QualityMonitorTimeSeriesArgs']] time_series: Configuration for monitoring timeseries tables.
        :param pulumi.Input[str] warehouse_id: Optional argument to specify the warehouse for dashboard creation. If not specified, the first running warehouse will be used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: QualityMonitorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to manage [Lakehouse Monitors](https://docs.databricks.com/en/lakehouse-monitoring/index.html) in Databricks.

        A `QualityMonitor` is attached to a SqlTable and can be of type timeseries, snapshot or inference.

        ### Inference Monitor

        ```python
        import pulumi
        import pulumi_databricks as databricks

        test_monitor_inference = databricks.QualityMonitor("testMonitorInference",
            table_name=f"{sandbox['name']}.{things['name']}.{my_test_table['name']}",
            assets_dir=f"/Shared/provider-test/databricks_quality_monitoring/{my_test_table['name']}",
            output_schema_name=f"{sandbox['name']}.{things['name']}",
            inference_log=databricks.QualityMonitorInferenceLogArgs(
                granularities=["1 hour"],
                timestamp_col="timestamp",
                prediction_col="prediction",
                model_id_col="model_id",
                problem_type="PROBLEM_TYPE_REGRESSION",
            ))
        ```
        ### Snapshot Monitor
        ```python
        import pulumi
        import pulumi_databricks as databricks

        test_monitor_inference = databricks.QualityMonitor("testMonitorInference",
            table_name=f"{sandbox['name']}.{things['name']}.{my_test_table['name']}",
            assets_dir=f"/Shared/provider-test/databricks_quality_monitoring/{my_test_table['name']}",
            output_schema_name=f"{sandbox['name']}.{things['name']}",
            snapshot=databricks.QualityMonitorSnapshotArgs())
        ```

        ## Related Resources

        The following resources are often used in the same context:

        * Catalog
        * Schema
        * SqlTable

        :param str resource_name: The name of the resource.
        :param QualityMonitorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(QualityMonitorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assets_dir: Optional[pulumi.Input[str]] = None,
                 baseline_table_name: Optional[pulumi.Input[str]] = None,
                 custom_metrics: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['QualityMonitorCustomMetricArgs']]]]] = None,
                 data_classification_config: Optional[pulumi.Input[pulumi.InputType['QualityMonitorDataClassificationConfigArgs']]] = None,
                 inference_log: Optional[pulumi.Input[pulumi.InputType['QualityMonitorInferenceLogArgs']]] = None,
                 latest_monitor_failure_msg: Optional[pulumi.Input[str]] = None,
                 notifications: Optional[pulumi.Input[pulumi.InputType['QualityMonitorNotificationsArgs']]] = None,
                 output_schema_name: Optional[pulumi.Input[str]] = None,
                 schedule: Optional[pulumi.Input[pulumi.InputType['QualityMonitorScheduleArgs']]] = None,
                 skip_builtin_dashboard: Optional[pulumi.Input[bool]] = None,
                 slicing_exprs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 snapshot: Optional[pulumi.Input[pulumi.InputType['QualityMonitorSnapshotArgs']]] = None,
                 table_name: Optional[pulumi.Input[str]] = None,
                 time_series: Optional[pulumi.Input[pulumi.InputType['QualityMonitorTimeSeriesArgs']]] = None,
                 warehouse_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = QualityMonitorArgs.__new__(QualityMonitorArgs)

            if assets_dir is None and not opts.urn:
                raise TypeError("Missing required property 'assets_dir'")
            __props__.__dict__["assets_dir"] = assets_dir
            __props__.__dict__["baseline_table_name"] = baseline_table_name
            __props__.__dict__["custom_metrics"] = custom_metrics
            __props__.__dict__["data_classification_config"] = data_classification_config
            __props__.__dict__["inference_log"] = inference_log
            __props__.__dict__["latest_monitor_failure_msg"] = latest_monitor_failure_msg
            __props__.__dict__["notifications"] = notifications
            if output_schema_name is None and not opts.urn:
                raise TypeError("Missing required property 'output_schema_name'")
            __props__.__dict__["output_schema_name"] = output_schema_name
            __props__.__dict__["schedule"] = schedule
            __props__.__dict__["skip_builtin_dashboard"] = skip_builtin_dashboard
            __props__.__dict__["slicing_exprs"] = slicing_exprs
            __props__.__dict__["snapshot"] = snapshot
            if table_name is None and not opts.urn:
                raise TypeError("Missing required property 'table_name'")
            __props__.__dict__["table_name"] = table_name
            __props__.__dict__["time_series"] = time_series
            __props__.__dict__["warehouse_id"] = warehouse_id
            __props__.__dict__["dashboard_id"] = None
            __props__.__dict__["drift_metrics_table_name"] = None
            __props__.__dict__["monitor_version"] = None
            __props__.__dict__["profile_metrics_table_name"] = None
            __props__.__dict__["status"] = None
        super(QualityMonitor, __self__).__init__(
            'databricks:index/qualityMonitor:QualityMonitor',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            assets_dir: Optional[pulumi.Input[str]] = None,
            baseline_table_name: Optional[pulumi.Input[str]] = None,
            custom_metrics: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['QualityMonitorCustomMetricArgs']]]]] = None,
            dashboard_id: Optional[pulumi.Input[str]] = None,
            data_classification_config: Optional[pulumi.Input[pulumi.InputType['QualityMonitorDataClassificationConfigArgs']]] = None,
            drift_metrics_table_name: Optional[pulumi.Input[str]] = None,
            inference_log: Optional[pulumi.Input[pulumi.InputType['QualityMonitorInferenceLogArgs']]] = None,
            latest_monitor_failure_msg: Optional[pulumi.Input[str]] = None,
            monitor_version: Optional[pulumi.Input[str]] = None,
            notifications: Optional[pulumi.Input[pulumi.InputType['QualityMonitorNotificationsArgs']]] = None,
            output_schema_name: Optional[pulumi.Input[str]] = None,
            profile_metrics_table_name: Optional[pulumi.Input[str]] = None,
            schedule: Optional[pulumi.Input[pulumi.InputType['QualityMonitorScheduleArgs']]] = None,
            skip_builtin_dashboard: Optional[pulumi.Input[bool]] = None,
            slicing_exprs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            snapshot: Optional[pulumi.Input[pulumi.InputType['QualityMonitorSnapshotArgs']]] = None,
            status: Optional[pulumi.Input[str]] = None,
            table_name: Optional[pulumi.Input[str]] = None,
            time_series: Optional[pulumi.Input[pulumi.InputType['QualityMonitorTimeSeriesArgs']]] = None,
            warehouse_id: Optional[pulumi.Input[str]] = None) -> 'QualityMonitor':
        """
        Get an existing QualityMonitor resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] assets_dir: The directory to store the monitoring assets (Eg. Dashboard and Metric Tables)
        :param pulumi.Input[str] baseline_table_name: Name of the baseline table from which drift metrics are computed from.Columns in the monitored table should also be present in the baseline
               table.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['QualityMonitorCustomMetricArgs']]]] custom_metrics: Custom metrics to compute on the monitored table. These can be aggregate metrics, derived metrics (from already computed aggregate metrics), or drift metrics (comparing metrics across time windows).
        :param pulumi.Input[str] dashboard_id: The ID of the generated dashboard.
        :param pulumi.Input[pulumi.InputType['QualityMonitorDataClassificationConfigArgs']] data_classification_config: The data classification config for the monitor
        :param pulumi.Input[str] drift_metrics_table_name: The full name of the drift metrics table. Format: __catalog_name__.__schema_name__.__table_name__.
        :param pulumi.Input[pulumi.InputType['QualityMonitorInferenceLogArgs']] inference_log: Configuration for the inference log monitor
        :param pulumi.Input[str] monitor_version: The version of the monitor config (e.g. 1,2,3). If negative, the monitor may be corrupted
        :param pulumi.Input[pulumi.InputType['QualityMonitorNotificationsArgs']] notifications: The notification settings for the monitor.  The following optional blocks are supported, each consisting of the single string array field with name `email_addresses` containing a list of emails to notify:
        :param pulumi.Input[str] output_schema_name: Schema where output metric tables are created
        :param pulumi.Input[str] profile_metrics_table_name: The full name of the profile metrics table. Format: __catalog_name__.__schema_name__.__table_name__.
        :param pulumi.Input[pulumi.InputType['QualityMonitorScheduleArgs']] schedule: The schedule for automatically updating and refreshing metric tables.  This block consists of following fields:
        :param pulumi.Input[bool] skip_builtin_dashboard: Whether to skip creating a default dashboard summarizing data quality metrics.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] slicing_exprs: List of column expressions to slice data with for targeted analysis. The data is grouped by each expression independently, resulting in a separate slice for each predicate and its complements. For high-cardinality columns, only the top 100 unique values by frequency will generate slices.
        :param pulumi.Input[pulumi.InputType['QualityMonitorSnapshotArgs']] snapshot: Configuration for monitoring snapshot tables.
        :param pulumi.Input[str] status: Status of the Monitor
        :param pulumi.Input[str] table_name: The full name of the table to attach the monitor too. Its of the format {catalog}.{schema}.{tableName}
        :param pulumi.Input[pulumi.InputType['QualityMonitorTimeSeriesArgs']] time_series: Configuration for monitoring timeseries tables.
        :param pulumi.Input[str] warehouse_id: Optional argument to specify the warehouse for dashboard creation. If not specified, the first running warehouse will be used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _QualityMonitorState.__new__(_QualityMonitorState)

        __props__.__dict__["assets_dir"] = assets_dir
        __props__.__dict__["baseline_table_name"] = baseline_table_name
        __props__.__dict__["custom_metrics"] = custom_metrics
        __props__.__dict__["dashboard_id"] = dashboard_id
        __props__.__dict__["data_classification_config"] = data_classification_config
        __props__.__dict__["drift_metrics_table_name"] = drift_metrics_table_name
        __props__.__dict__["inference_log"] = inference_log
        __props__.__dict__["latest_monitor_failure_msg"] = latest_monitor_failure_msg
        __props__.__dict__["monitor_version"] = monitor_version
        __props__.__dict__["notifications"] = notifications
        __props__.__dict__["output_schema_name"] = output_schema_name
        __props__.__dict__["profile_metrics_table_name"] = profile_metrics_table_name
        __props__.__dict__["schedule"] = schedule
        __props__.__dict__["skip_builtin_dashboard"] = skip_builtin_dashboard
        __props__.__dict__["slicing_exprs"] = slicing_exprs
        __props__.__dict__["snapshot"] = snapshot
        __props__.__dict__["status"] = status
        __props__.__dict__["table_name"] = table_name
        __props__.__dict__["time_series"] = time_series
        __props__.__dict__["warehouse_id"] = warehouse_id
        return QualityMonitor(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="assetsDir")
    def assets_dir(self) -> pulumi.Output[str]:
        """
        The directory to store the monitoring assets (Eg. Dashboard and Metric Tables)
        """
        return pulumi.get(self, "assets_dir")

    @property
    @pulumi.getter(name="baselineTableName")
    def baseline_table_name(self) -> pulumi.Output[Optional[str]]:
        """
        Name of the baseline table from which drift metrics are computed from.Columns in the monitored table should also be present in the baseline
        table.
        """
        return pulumi.get(self, "baseline_table_name")

    @property
    @pulumi.getter(name="customMetrics")
    def custom_metrics(self) -> pulumi.Output[Optional[Sequence['outputs.QualityMonitorCustomMetric']]]:
        """
        Custom metrics to compute on the monitored table. These can be aggregate metrics, derived metrics (from already computed aggregate metrics), or drift metrics (comparing metrics across time windows).
        """
        return pulumi.get(self, "custom_metrics")

    @property
    @pulumi.getter(name="dashboardId")
    def dashboard_id(self) -> pulumi.Output[str]:
        """
        The ID of the generated dashboard.
        """
        return pulumi.get(self, "dashboard_id")

    @property
    @pulumi.getter(name="dataClassificationConfig")
    def data_classification_config(self) -> pulumi.Output[Optional['outputs.QualityMonitorDataClassificationConfig']]:
        """
        The data classification config for the monitor
        """
        return pulumi.get(self, "data_classification_config")

    @property
    @pulumi.getter(name="driftMetricsTableName")
    def drift_metrics_table_name(self) -> pulumi.Output[str]:
        """
        The full name of the drift metrics table. Format: __catalog_name__.__schema_name__.__table_name__.
        """
        return pulumi.get(self, "drift_metrics_table_name")

    @property
    @pulumi.getter(name="inferenceLog")
    def inference_log(self) -> pulumi.Output[Optional['outputs.QualityMonitorInferenceLog']]:
        """
        Configuration for the inference log monitor
        """
        return pulumi.get(self, "inference_log")

    @property
    @pulumi.getter(name="latestMonitorFailureMsg")
    def latest_monitor_failure_msg(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "latest_monitor_failure_msg")

    @property
    @pulumi.getter(name="monitorVersion")
    def monitor_version(self) -> pulumi.Output[str]:
        """
        The version of the monitor config (e.g. 1,2,3). If negative, the monitor may be corrupted
        """
        return pulumi.get(self, "monitor_version")

    @property
    @pulumi.getter
    def notifications(self) -> pulumi.Output[Optional['outputs.QualityMonitorNotifications']]:
        """
        The notification settings for the monitor.  The following optional blocks are supported, each consisting of the single string array field with name `email_addresses` containing a list of emails to notify:
        """
        return pulumi.get(self, "notifications")

    @property
    @pulumi.getter(name="outputSchemaName")
    def output_schema_name(self) -> pulumi.Output[str]:
        """
        Schema where output metric tables are created
        """
        return pulumi.get(self, "output_schema_name")

    @property
    @pulumi.getter(name="profileMetricsTableName")
    def profile_metrics_table_name(self) -> pulumi.Output[str]:
        """
        The full name of the profile metrics table. Format: __catalog_name__.__schema_name__.__table_name__.
        """
        return pulumi.get(self, "profile_metrics_table_name")

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Output[Optional['outputs.QualityMonitorSchedule']]:
        """
        The schedule for automatically updating and refreshing metric tables.  This block consists of following fields:
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter(name="skipBuiltinDashboard")
    def skip_builtin_dashboard(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to skip creating a default dashboard summarizing data quality metrics.
        """
        return pulumi.get(self, "skip_builtin_dashboard")

    @property
    @pulumi.getter(name="slicingExprs")
    def slicing_exprs(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of column expressions to slice data with for targeted analysis. The data is grouped by each expression independently, resulting in a separate slice for each predicate and its complements. For high-cardinality columns, only the top 100 unique values by frequency will generate slices.
        """
        return pulumi.get(self, "slicing_exprs")

    @property
    @pulumi.getter
    def snapshot(self) -> pulumi.Output[Optional['outputs.QualityMonitorSnapshot']]:
        """
        Configuration for monitoring snapshot tables.
        """
        return pulumi.get(self, "snapshot")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Status of the Monitor
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="tableName")
    def table_name(self) -> pulumi.Output[str]:
        """
        The full name of the table to attach the monitor too. Its of the format {catalog}.{schema}.{tableName}
        """
        return pulumi.get(self, "table_name")

    @property
    @pulumi.getter(name="timeSeries")
    def time_series(self) -> pulumi.Output[Optional['outputs.QualityMonitorTimeSeries']]:
        """
        Configuration for monitoring timeseries tables.
        """
        return pulumi.get(self, "time_series")

    @property
    @pulumi.getter(name="warehouseId")
    def warehouse_id(self) -> pulumi.Output[Optional[str]]:
        """
        Optional argument to specify the warehouse for dashboard creation. If not specified, the first running warehouse will be used.
        """
        return pulumi.get(self, "warehouse_id")

