# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ServicePrincipalRoleArgs', 'ServicePrincipalRole']

@pulumi.input_type
class ServicePrincipalRoleArgs:
    def __init__(__self__, *,
                 role: pulumi.Input[str],
                 service_principal_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a ServicePrincipalRole resource.
        :param pulumi.Input[str] role: This is the id of the role or instance profile resource.
        :param pulumi.Input[str] service_principal_id: This is the id of the service principal resource.
        """
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "service_principal_id", service_principal_id)

    @property
    @pulumi.getter
    def role(self) -> pulumi.Input[str]:
        """
        This is the id of the role or instance profile resource.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: pulumi.Input[str]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> pulumi.Input[str]:
        """
        This is the id of the service principal resource.
        """
        return pulumi.get(self, "service_principal_id")

    @service_principal_id.setter
    def service_principal_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_principal_id", value)


@pulumi.input_type
class _ServicePrincipalRoleState:
    def __init__(__self__, *,
                 role: Optional[pulumi.Input[str]] = None,
                 service_principal_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ServicePrincipalRole resources.
        :param pulumi.Input[str] role: This is the id of the role or instance profile resource.
        :param pulumi.Input[str] service_principal_id: This is the id of the service principal resource.
        """
        if role is not None:
            pulumi.set(__self__, "role", role)
        if service_principal_id is not None:
            pulumi.set(__self__, "service_principal_id", service_principal_id)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        This is the id of the role or instance profile resource.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> Optional[pulumi.Input[str]]:
        """
        This is the id of the service principal resource.
        """
        return pulumi.get(self, "service_principal_id")

    @service_principal_id.setter
    def service_principal_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_principal_id", value)


class ServicePrincipalRole(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 service_principal_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource allows you to attach a role or InstanceProfile (AWS) to a databricks_service_principal.

        ## Example Usage

        Granting a service principal access to an instance profile

        ```python
        import pulumi
        import pulumi_databricks as databricks

        instance_profile = databricks.InstanceProfile("instance_profile", instance_profile_arn="my_instance_profile_arn")
        this = databricks.ServicePrincipal("this", display_name="My Service Principal")
        my_service_principal_instance_profile = databricks.ServicePrincipalRole("my_service_principal_instance_profile",
            service_principal_id=this.id,
            role=instance_profile.id)
        ```

        ## Related Resources

        The following resources are often used in the same context:

        * End to end workspace management guide.
        * UserRole to attach role or InstanceProfile (AWS) to databricks_user.
        * GroupInstanceProfile to attach InstanceProfile (AWS) to databricks_group.
        * GroupMember to attach users and groups as group members.
        * InstanceProfile to manage AWS EC2 instance profiles that users can launch Cluster and access data, like databricks_mount.

        ## Import

        -> **Note** Importing this resource is not currently supported.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] role: This is the id of the role or instance profile resource.
        :param pulumi.Input[str] service_principal_id: This is the id of the service principal resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServicePrincipalRoleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource allows you to attach a role or InstanceProfile (AWS) to a databricks_service_principal.

        ## Example Usage

        Granting a service principal access to an instance profile

        ```python
        import pulumi
        import pulumi_databricks as databricks

        instance_profile = databricks.InstanceProfile("instance_profile", instance_profile_arn="my_instance_profile_arn")
        this = databricks.ServicePrincipal("this", display_name="My Service Principal")
        my_service_principal_instance_profile = databricks.ServicePrincipalRole("my_service_principal_instance_profile",
            service_principal_id=this.id,
            role=instance_profile.id)
        ```

        ## Related Resources

        The following resources are often used in the same context:

        * End to end workspace management guide.
        * UserRole to attach role or InstanceProfile (AWS) to databricks_user.
        * GroupInstanceProfile to attach InstanceProfile (AWS) to databricks_group.
        * GroupMember to attach users and groups as group members.
        * InstanceProfile to manage AWS EC2 instance profiles that users can launch Cluster and access data, like databricks_mount.

        ## Import

        -> **Note** Importing this resource is not currently supported.

        :param str resource_name: The name of the resource.
        :param ServicePrincipalRoleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServicePrincipalRoleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 service_principal_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServicePrincipalRoleArgs.__new__(ServicePrincipalRoleArgs)

            if role is None and not opts.urn:
                raise TypeError("Missing required property 'role'")
            __props__.__dict__["role"] = role
            if service_principal_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_principal_id'")
            __props__.__dict__["service_principal_id"] = service_principal_id
        super(ServicePrincipalRole, __self__).__init__(
            'databricks:index/servicePrincipalRole:ServicePrincipalRole',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            role: Optional[pulumi.Input[str]] = None,
            service_principal_id: Optional[pulumi.Input[str]] = None) -> 'ServicePrincipalRole':
        """
        Get an existing ServicePrincipalRole resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] role: This is the id of the role or instance profile resource.
        :param pulumi.Input[str] service_principal_id: This is the id of the service principal resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServicePrincipalRoleState.__new__(_ServicePrincipalRoleState)

        __props__.__dict__["role"] = role
        __props__.__dict__["service_principal_id"] = service_principal_id
        return ServicePrincipalRole(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output[str]:
        """
        This is the id of the role or instance profile resource.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> pulumi.Output[str]:
        """
        This is the id of the service principal resource.
        """
        return pulumi.get(self, "service_principal_id")

