# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ServicePrincipalSecretArgs', 'ServicePrincipalSecret']

@pulumi.input_type
class ServicePrincipalSecretArgs:
    def __init__(__self__, *,
                 service_principal_id: pulumi.Input[str],
                 secret: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ServicePrincipalSecret resource.
        :param pulumi.Input[str] service_principal_id: ID of the ServicePrincipal (not application ID).
        :param pulumi.Input[str] secret: Generated secret for the service principal
        """
        pulumi.set(__self__, "service_principal_id", service_principal_id)
        if secret is not None:
            pulumi.set(__self__, "secret", secret)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> pulumi.Input[str]:
        """
        ID of the ServicePrincipal (not application ID).
        """
        return pulumi.get(self, "service_principal_id")

    @service_principal_id.setter
    def service_principal_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_principal_id", value)

    @property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input[str]]:
        """
        Generated secret for the service principal
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _ServicePrincipalSecretState:
    def __init__(__self__, *,
                 secret: Optional[pulumi.Input[str]] = None,
                 service_principal_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ServicePrincipalSecret resources.
        :param pulumi.Input[str] secret: Generated secret for the service principal
        :param pulumi.Input[str] service_principal_id: ID of the ServicePrincipal (not application ID).
        """
        if secret is not None:
            pulumi.set(__self__, "secret", secret)
        if service_principal_id is not None:
            pulumi.set(__self__, "service_principal_id", service_principal_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def secret(self) -> Optional[pulumi.Input[str]]:
        """
        Generated secret for the service principal
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret", value)

    @property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the ServicePrincipal (not application ID).
        """
        return pulumi.get(self, "service_principal_id")

    @service_principal_id.setter
    def service_principal_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_principal_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


class ServicePrincipalSecret(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 secret: Optional[pulumi.Input[str]] = None,
                 service_principal_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        Create service principal secret

        ```python
        import pulumi
        import pulumi_databricks as databricks

        terraform_sp = databricks.ServicePrincipalSecret("terraform_sp", service_principal_id=this["id"])
        ```

        ## Related Resources

        The following resources are often used in the same context:

        * ServicePrincipal to manage [Service Principals](https://docs.databricks.com/administration-guide/users-groups/service-principals.html) in Databricks

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] secret: Generated secret for the service principal
        :param pulumi.Input[str] service_principal_id: ID of the ServicePrincipal (not application ID).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServicePrincipalSecretArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        Create service principal secret

        ```python
        import pulumi
        import pulumi_databricks as databricks

        terraform_sp = databricks.ServicePrincipalSecret("terraform_sp", service_principal_id=this["id"])
        ```

        ## Related Resources

        The following resources are often used in the same context:

        * ServicePrincipal to manage [Service Principals](https://docs.databricks.com/administration-guide/users-groups/service-principals.html) in Databricks

        :param str resource_name: The name of the resource.
        :param ServicePrincipalSecretArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServicePrincipalSecretArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 secret: Optional[pulumi.Input[str]] = None,
                 service_principal_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServicePrincipalSecretArgs.__new__(ServicePrincipalSecretArgs)

            __props__.__dict__["secret"] = None if secret is None else pulumi.Output.secret(secret)
            if service_principal_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_principal_id'")
            __props__.__dict__["service_principal_id"] = service_principal_id
            __props__.__dict__["status"] = status
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["secret"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ServicePrincipalSecret, __self__).__init__(
            'databricks:index/servicePrincipalSecret:ServicePrincipalSecret',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            secret: Optional[pulumi.Input[str]] = None,
            service_principal_id: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None) -> 'ServicePrincipalSecret':
        """
        Get an existing ServicePrincipalSecret resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] secret: Generated secret for the service principal
        :param pulumi.Input[str] service_principal_id: ID of the ServicePrincipal (not application ID).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServicePrincipalSecretState.__new__(_ServicePrincipalSecretState)

        __props__.__dict__["secret"] = secret
        __props__.__dict__["service_principal_id"] = service_principal_id
        __props__.__dict__["status"] = status
        return ServicePrincipalSecret(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def secret(self) -> pulumi.Output[str]:
        """
        Generated secret for the service principal
        """
        return pulumi.get(self, "secret")

    @property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> pulumi.Output[str]:
        """
        ID of the ServicePrincipal (not application ID).
        """
        return pulumi.get(self, "service_principal_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        return pulumi.get(self, "status")

