from setuptools import setup, find_packages

setup(
    name="PyDNI",
    version="0.6.0",
    description="Validador de identificadores españoles (DNI, NIE, CIF y NIF genérico) y generador de nombres",
    long_description=open("README.md", encoding="utf-8").read(),
    long_description_content_type="text/markdown",
    author="Alberto Gonzalez",
    author_email="agonzalezla@protonmail.com",
    url="https://github.com/agonzalezla/PyDNI",
    license="MIT",
    packages=find_packages(),
    python_requires=">=3.7",
    classifiers=[
        "Development Status :: 5 - Production/Stable",
        "Intended Audience :: Developers",
        "Topic :: Software Development :: Libraries :: Python Modules",
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Operating System :: OS Independent",
        "Natural Language :: Spanish",
    ],
)