# PTT-CLI

Command Line Interface for PentestTools.

# Installing
PentestTools Python module is delivered through PyPI, so it can be installed directly via pip:
```bash
pip install pentesttools
```

# Usage
The `pentesttools` package provides a command line interface through the `ptt` utility. Right
now it supports the Website Scanner service.

Example for the simplest scan:
```bash
ptt run website_scanner <url>
```
This runs a freemium Website Scanner scan on the `<url>`. Unlike in the platform itself, you can omit the schema part from the url.

Global arguments, like a suitable key for a deep scan, have to be passed straight to `ptt`. Tool arguments have to be passed to the tool.

```bash
ptt --key <key> run website_scanner --scan_type deep <url>
```

If you want the command to fail if the report contains vulnerabilities with a higher risk than some value, you can use the `--fail argument`.

```bash
ptt --fail high run website_scanner <url>
```

You can also run `ptt` using docker. The docker image has `ptt` as an entrypoint, so you don't have to type it anymore. Note that the old `ptt-scan` name is still used on docker.

```bash
docker run pentesttoolscom/ptt-scan:latest run website_scanner <url>
```

# Development installation
If you want to easily modify the sources and your modifications:
```bash
pip install --edit .
```

# Uninstalling

```bash
pip uninstall pentesttools
```

# Testing and Coverage
You can run the tests and make coverage reports like this:
```bash
python3 -m pytest src/tests
```

```bash
coverage run -m pytest src/tests
coverage report -m
```
