"""Module that holds the global context class, used by the CLI components."""
from __future__ import annotations
from argparse import Namespace
from dataclasses import dataclass
from typing import TYPE_CHECKING, Optional

if TYPE_CHECKING:
    from . import cli


@dataclass
class Context:
    """Holds the variables that are globally used throughout the components of the package."""

    scan_output: Optional[dict] = None
    summary: Optional[cli.ScanStatus] = None
    _args: Optional[Namespace] = None
    _target: Optional[str] = None

    @property
    def args(self) -> Namespace:
        """Parsed command line arguments."""
        if self._args is None:
            raise AttributeError
        return self._args

    @args.setter
    def args(self, val: Namespace) -> None:
        self._args = val

    @property
    def has_args(self) -> bool:
        """Returns if the command line arguments have been set."""
        return self._args is not None

    @property
    def target(self) -> str:
        """The URL that was scanned or to be scanned."""
        return self._target if self._target is not None else self.args.target

    @target.setter
    def target(self, target: Optional[str]) -> None:
        self._target = target
