import sys
import logging

from .context import Context

# Guide for logging: https://docs.python.org/3/howto/logging.html#configuring-logging-for-a-library
logger = logging.getLogger(__name__)
logger.setLevel(logging.INFO)
logger.addHandler(logging.NullHandler())


def configure_logger_for_cli(ctx: Context) -> None:
    """Sets the logger for the current module. Logs DEBUG and INFO to stdout and everything from
    WARNING and above, to stderr."""
    stdout_handler = logging.StreamHandler(stream=sys.stdout)
    stdout_handler.setLevel(logging.INFO)
    stdout_handler.addFilter(lambda record: record.levelno == logging.INFO)
    stdout_handler.terminator = ""

    stderr_handler = logging.StreamHandler(stream=sys.stderr)
    stderr_handler.setLevel(logging.WARNING)
    stderr_handler.terminator = ""

    if not ctx.args.quiet:
        logger.addHandler(stdout_handler)
        logger.addHandler(stderr_handler)

    logger.setLevel(logging.INFO)
