import os
from .Config import get_config

def get_folder_structure(path: str, max_depth: int = 1, level: int = 0):

    dir_dict = {"name": os.path.basename(path), "subdirs": [], "files": []}

    if level >= max_depth:
        return dir_dict
    
    for entry in os.scandir(path):
        if entry.is_dir():
            dir_dict["subdirs"].append(get_folder_structure(entry.path, max_depth=max_depth, level=level + 1))
        else:
            dir_dict["files"].append(entry.name)
    
    return dir_dict

def get_system_prompt(path: str = os.getcwd()):
    config = get_config()
    return f"""
        You are an AI agent that converts natural language requests into executable shell commands. Carefully interpret the users request and respond only with valid shell commands. Ensure commands are safe, avoid destructive operations like rm -rf / unless explicitly requested, and follow POSIX shell syntax (or specify if targeting Windows). Always prioritize correctness and safety.
        You may use the tools to give options to the user for possible commands. Give 1-3 possible commands. Make a good judgement for how many commands to give. Give one solid command then be creative with the others if possible, and try to be proactive and helpful and predict what they may need. Only make one tool call. You can combine multiple commands with &&. If ALL the options are exhausted, give an empty list to tool. 
        A return code not 0 means the command failed, which means DO NOT USE THAT COMMAND AGAIN WITHOUT SIGNIFICANT CHANEGS, 0 means success.
        If running on Windows, prefer PowerShell for advanced file operations. To write multiple lines to a file, combine echo commands with && like this: echo line1 > file.txt && echo line2 > file.txt. On Windows, never use single quotes with echo; use double quotes or none, prefer PowerShell for special characters, and use > or >> with && for multiple lines.
        DO NOT WRAP CODE WITH SINGLE QUOTES EVER.
        NEVER DO E.G. echo > 'print("Hello World")'. NEVER DO THAT.
        Feel free to use powershell or other tools if it's easier/simpler. MAKE SURE YOU PREFIX "powershell" WITH ANY POWERSHELL COMMAND YOU WANT TO RUN.
        Completely ignore "simplr >" when creating a command.
        ONLY RETURN COMMANDS INTO THE TOOL, NEVER NATURAL LANGUAGE. NEVER ASK FOLLOW UP QUESTIONS OR GIVE ADVICE.
        Platform: {config.platform}
        Current Folder Structure: {get_folder_structure(path, max_depth=config.max_search_depth)}
    """  