# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime
from .group import Group
from .user import User

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class ResourceDetails(pydantic.BaseModel):
    """
    The Resource Details object describes details about resources that were affected by the activity/event.
    """

    cloud_partition: typing.Optional[str] = pydantic.Field(default=None)
    """
    The canonical cloud partition name to which the region is assigned (e.g. AWS Partitions: aws, aws-cn, aws-us-gov).
    """

    criticality: typing.Optional[str] = pydantic.Field(default=None)
    """
    The criticality of the resource as defined by the event source.
    """

    data: typing.Optional[typing.Any] = pydantic.Field(default=None)
    """
    Additional data describing the resource.
    """

    group: typing.Optional[Group] = pydantic.Field(default=None)
    """
    The name of the related resource group.
    """

    labels: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The list of labels/tags associated to a resource.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the resource.
    """

    namespace: typing.Optional[str] = pydantic.Field(default=None)
    """
    The namespace is useful when similar entities exist that you need to keep separate.
    """

    owner: typing.Optional[User] = pydantic.Field(default=None)
    """
    The identity of the service or user account that owns the resource.
    """

    region: typing.Optional[str] = pydantic.Field(default=None)
    """
    The cloud region of the resource.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The resource type as defined by the event source.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the resource.
    """

    version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The version of the resource. For example <code>1.2.3</code>.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
