# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime
from .actor import Actor
from .api import Api
from .dns_query import DnsQuery
from .file import File
from .network_connection_info import NetworkConnectionInfo
from .network_endpoint import NetworkEndpoint
from .process import Process

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Evidences(pydantic.BaseModel):
    """
    A collection of evidence artifacts associated to the activity/activities that triggered a security detection.
    """

    actor: typing.Optional[Actor] = pydantic.Field(default=None)
    """
    Describes details about the user/role/process that was the source of the activity that triggered the detection.
    """

    api: typing.Optional[Api] = pydantic.Field(default=None)
    """
    Describes details about the API call associated to the activity that triggered the detection.
    """

    connection_info: typing.Optional[NetworkConnectionInfo] = pydantic.Field(default=None)
    """
    Describes details about the network connection associated to the activity that triggered the detection.
    """

    data: typing.Optional[typing.Any] = pydantic.Field(default=None)
    """
    Additional evidence data that is not accounted for in the specific evidence attributes.<code> Use only when absolutely necessary.</code>
    """

    dst_endpoint: typing.Optional[NetworkEndpoint] = pydantic.Field(default=None)
    """
    Describes details about the destination of the network activity that triggered the detection.
    """

    file: typing.Optional[File] = pydantic.Field(default=None)
    """
    Describes details about the file associated to the activity that triggered the detection.
    """

    process: typing.Optional[Process] = pydantic.Field(default=None)
    """
    Describes details about the process associated to the activity that triggered the detection.
    """

    query: typing.Optional[DnsQuery] = pydantic.Field(default=None)
    """
    Describes details about the DNS query associated to the activity that triggered the detection.
    """

    src_endpoint: typing.Optional[NetworkEndpoint] = pydantic.Field(default=None)
    """
    Describes details about the source of the network activity that triggered the detection.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
