# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime
from ...base.types.hostname import Hostname
from ...base.types.ip_address import IpAddress
from ...base.types.mac_address import MacAddress
from .network_interface_type_id import NetworkInterfaceTypeId

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class NetworkInterface(pydantic.BaseModel):
    """
    The Network Interface object describes the type and associated attributes of a network interface.
    """

    hostname: typing.Optional[Hostname] = pydantic.Field(default=None)
    """
    The hostname associated with the network interface.
    """

    ip: typing.Optional[IpAddress] = pydantic.Field(default=None)
    """
    The IP address associated with the network interface.
    """

    ip_addresses: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    A list of IP addresses available on the network interface.
    """

    mac: typing.Optional[MacAddress] = pydantic.Field(default=None)
    """
    The MAC address of the network interface.
    """

    mac_addresses: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    A list of MAC addresses available on the network interface.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the network interface.
    """

    namespace: typing.Optional[str] = pydantic.Field(default=None)
    """
    The namespace is useful in merger or acquisition situations. For example, when similar entities exist that you need to keep separate.
    """

    subnet_prefix: typing.Optional[int] = pydantic.Field(default=None)
    """
    The subnet prefix length determines the number of bits used to represent the network part of the IP address. The remaining bits are reserved for identifying individual hosts within that subnet.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The type of network interface.
    """

    type_id: NetworkInterfaceTypeId = pydantic.Field()
    """
    The network interface type identifier.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier for the network interface.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
