# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime
from ...base.types.email_address import EmailAddress
from ...base.types.user_name import UserName
from .account import Account
from .group import Group
from .ldap_person import LdapPerson
from .organization import Organization
from .user_mfa_status_id import UserMfaStatusId
from .user_type_id import UserTypeId
from .user_user_status_id import UserUserStatusId

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class User(pydantic.BaseModel):
    """
    The User object describes the characteristics of a user/person or a security principal. Defined by D3FEND <a target='_blank' href='https://d3fend.mitre.org/dao/artifact/d3f:UserAccount/'>d3f:UserAccount</a>.
    """

    account: typing.Optional[Account] = pydantic.Field(default=None)
    """
    The user's account or the account associated with the user.
    """

    credential_uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the user's credential. For example, AWS Access Key ID.
    """

    domain: typing.Optional[str] = pydantic.Field(default=None)
    """
    The domain where the user is defined. For example: the LDAP or Active Directory domain.
    """

    email_addr: typing.Optional[EmailAddress] = pydantic.Field(default=None)
    """
    The user's primary email address.
    """

    full_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The full name of the person, as per the LDAP Common Name attribute (cn).
    """

    groups: typing.Optional[typing.List[Group]] = pydantic.Field(default=None)
    """
    The administrative groups to which the user belongs.
    """

    ldap_person: typing.Optional[LdapPerson] = pydantic.Field(default=None)
    """
    The additional LDAP attributes that describe a person.
    """

    mfa_status: typing.Optional[str] = pydantic.Field(default=None)
    """
    The multi-factor authentication status, normalized to the caption of the mfa_status_id value. In the case of 'Other', it is defined by the data source.
    """

    mfa_status_id: typing.Optional[UserMfaStatusId] = pydantic.Field(default=None)
    """
    The normalized identifier of the user's multi-factor authentication status.
    """

    name: typing.Optional[UserName] = pydantic.Field(default=None)
    """
    The username. For example, <code>janedoe1</code>.
    """

    org: typing.Optional[Organization] = pydantic.Field(default=None)
    """
    Organization and org unit related to the user.
    """

    privileges: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The user's privileges.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The type of the user. For example, System, AWS IAM User, etc.
    """

    type_id: typing.Optional[UserTypeId] = pydantic.Field(default=None)
    """
    The account type identifier.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique user identifier. For example, the Windows user SID, ActiveDirectory DN or AWS user ARN.
    """

    uid_alt: typing.Optional[str] = pydantic.Field(default=None)
    """
    The alternate user identifier. For example, the Active Directory user GUID or AWS user Principal ID.
    """

    user_status: typing.Optional[str] = pydantic.Field(default=None)
    """
    The user status, normalized to the caption of the user_status_id value. In the case of 'Other', it is defined by the data source.
    """

    user_status_id: typing.Optional[UserUserStatusId] = pydantic.Field(default=None)
    """
    The normalized identifier of the user's status.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
