# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Enrichment(pydantic.BaseModel):
    """
    The Enrichment object provides inline enrichment data for specific attributes of interest within an event. It serves as a mechanism to enhance or supplement the information associated with the event by adding additional relevant details or context.
    """

    data: typing.Any = pydantic.Field()
    """
    The enrichment data associated with the attribute and value. The meaning of this data depends on the type the enrichment record.
    """

    name: str = pydantic.Field()
    """
    The name of the attribute to which the enriched data pertains.
    """

    provider: typing.Optional[str] = pydantic.Field(default=None)
    """
    The enrichment data provider name.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The enrichment type. For example: <code>location</code>.
    """

    value: str = pydantic.Field()
    """
    The value of the attribute to which the enriched data pertains.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
