# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime
from .cve import Cve
from .malware_classification_ids import MalwareClassificationIds

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Malware(pydantic.BaseModel):
    """
    The Malware object describes the classification of known malicious software, which is intentionally designed to cause damage to a computer, server, client, or computer network.
    """

    classification_ids: typing.List[MalwareClassificationIds] = pydantic.Field()
    """
    The list of normalized identifiers of the malware classifications. Reference: <a target='_blank' href='https://docs.oasis-open.org/cti/stix/v2.1/os/stix-v2.1-os.html#_oxlc4df65spl'>STIX Malware Types</a>
    """

    classifications: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The list of malware classifications, normalized to the captions of the classification_id values. In the case of 'Other', they are defined by the event source.
    """

    cves: typing.Optional[typing.List[Cve]] = pydantic.Field(default=None)
    """
    List of Common Vulnerabilities and Exposures (<a target='_blank' href='https://cve.mitre.org/'>CVE</a>).
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The malware name, as reported by the detection engine.
    """

    path: typing.Optional[str] = pydantic.Field(default=None)
    """
    The filesystem path of the malware that was observed.
    """

    provider: typing.Optional[str] = pydantic.Field(default=None)
    """
    The provider of the malware information.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The malware unique identifier, as reported by the detection engine. For example a virus id or an IPS signature id.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
