# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime
from .file import File
from .module_load_type_id import ModuleLoadTypeId

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Module(pydantic.BaseModel):
    """
    The Module object describes the load attributes of a module.
    """

    base_address: typing.Optional[str] = pydantic.Field(default=None)
    """
    The memory address where the module was loaded.
    """

    file: typing.Optional[File] = pydantic.Field(default=None)
    """
    The module file object.
    """

    function_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The entry-point function of the module. The system calls the entry-point function whenever a process or thread loads or unloads the module.
    """

    load_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The load type, normalized to the caption of the load_type_id value. In the case of 'Other', it is defined by the event source. It describes how the module was loaded in memory.
    """

    load_type_id: ModuleLoadTypeId = pydantic.Field()
    """
    The normalized identifier of the load type. It identifies how the module was loaded in memory.
    """

    start_address: typing.Optional[str] = pydantic.Field(default=None)
    """
    The start address of the execution.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The module type.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
