# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime
from ...base.types.timestamp import Timestamp
from ...base.types.url_string import UrlString
from .os import Os
from .product import Product

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class KbArticle(pydantic.BaseModel):
    """
    The KB Article object contains metadata that describes the patch or update.
    """

    bulletin: typing.Optional[str] = pydantic.Field(default=None)
    """
    The kb article bulletin identifier.
    """

    classification: typing.Optional[str] = pydantic.Field(default=None)
    """
    The vendors classification of the kb article.
    """

    created_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The date the kb article was released by the vendor.
    """

    created_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The date the kb article was released by the vendor.
    """

    is_superseded: typing.Optional[bool] = pydantic.Field(default=None)
    """
    The kb article has been replaced by another.
    """

    os: typing.Optional[Os] = pydantic.Field(default=None)
    """
    The operating system the kb article applies.
    """

    product: typing.Optional[Product] = pydantic.Field(default=None)
    """
    The product details the kb article applies.
    """

    severity: typing.Optional[str] = pydantic.Field(default=None)
    """
    The severity of the kb article.
    """

    size: typing.Optional[int] = pydantic.Field(default=None)
    """
    The size in bytes for the kb article.
    """

    src_url: typing.Optional[UrlString] = pydantic.Field(default=None)
    """
    The kb article link from the source vendor.
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    The title of the kb article.
    """

    uid: str = pydantic.Field()
    """
    The unique identifier for the kb article.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
