# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime
from ...base.types.email_address import EmailAddress
from .auth_factor_factor_type_id import AuthFactorFactorTypeId
from .device import Device

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class AuthFactor(pydantic.BaseModel):
    """
    An Authentication Factor object describes a category of methods used for identity verification in an authentication attempt.
    """

    device: typing.Optional[Device] = pydantic.Field(default=None)
    """
    Device used to complete an authentication request.
    """

    email_addr: typing.Optional[EmailAddress] = pydantic.Field(default=None)
    """
    The email address used in an email-based authentication factor.
    """

    factor_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The type of authentication factor used in an authentication attempt.
    """

    factor_type_id: AuthFactorFactorTypeId = pydantic.Field()
    """
    The normalized identifier for the authentication factor.
    """

    is_hotp: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the authentication factor is an HMAC-based One-time Password (HOTP).
    """

    is_totp: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the authentication factor is a Time-based One-time Password (TOTP).
    """

    phone_number: typing.Optional[str] = pydantic.Field(default=None)
    """
    The phone number used for a telephony-based authentication request.
    """

    provider: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of provider for an authentication factor.
    """

    security_questions: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The question(s) provided to user for a question-based authentication factor.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
