# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime
from .actor import Actor
from .api import Api
from .container import Container
from .database import Database
from .databucket import Databucket
from .device import Device
from .dns_query import DnsQuery
from .email import Email
from .file import File
from .job import Job
from .network_connection_info import NetworkConnectionInfo
from .network_endpoint import NetworkEndpoint
from .process import Process
from .url import Url
from .user import User

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Evidences(pydantic.BaseModel):
    """
    A collection of evidence artifacts associated to the activity/activities that triggered a security detection.
    """

    actor: typing.Optional[Actor] = pydantic.Field(default=None)
    """
    Describes details about the user/role/process that was the source of the activity that triggered the detection.
    """

    api: typing.Optional[Api] = pydantic.Field(default=None)
    """
    Describes details about the API call associated to the activity that triggered the detection.
    """

    connection_info: typing.Optional[NetworkConnectionInfo] = pydantic.Field(default=None)
    """
    Describes details about the network connection associated to the activity that triggered the detection.
    """

    container: typing.Optional[Container] = pydantic.Field(default=None)
    """
    Describes details about the container associated to the activity that triggered the detection.
    """

    data: typing.Optional[typing.Any] = pydantic.Field(default=None)
    """
    Additional evidence data that is not accounted for in the specific evidence attributes.<code> Use only when absolutely necessary.</code>
    """

    database: typing.Optional[Database] = pydantic.Field(default=None)
    """
    Describes details about the database associated to the activity that triggered the detection.
    """

    databucket: typing.Optional[Databucket] = pydantic.Field(default=None)
    """
    Describes details about the databucket associated to the activity that triggered the detection.
    """

    device: typing.Optional[Device] = pydantic.Field(default=None)
    """
    An addressable device, computer system or host associated to the activity that triggered the detection.
    """

    dst_endpoint: typing.Optional[NetworkEndpoint] = pydantic.Field(default=None)
    """
    Describes details about the destination of the network activity that triggered the detection.
    """

    email: typing.Optional[Email] = pydantic.Field(default=None)
    """
    The email object associated to the activity that triggered the detection.
    """

    file: typing.Optional[File] = pydantic.Field(default=None)
    """
    Describes details about the file associated to the activity that triggered the detection.
    """

    job: typing.Optional[Job] = pydantic.Field(default=None)
    """
    Describes details about the scheduled job that was associated with the activity that triggered the detection.
    """

    process: typing.Optional[Process] = pydantic.Field(default=None)
    """
    Describes details about the process associated to the activity that triggered the detection.
    """

    query: typing.Optional[DnsQuery] = pydantic.Field(default=None)
    """
    Describes details about the DNS query associated to the activity that triggered the detection.
    """

    src_endpoint: typing.Optional[NetworkEndpoint] = pydantic.Field(default=None)
    """
    Describes details about the source of the network activity that triggered the detection.
    """

    url: typing.Optional[Url] = pydantic.Field(default=None)
    """
    The URL object that pertains to the event or object associated to the activity that triggered the detection.
    """

    user: typing.Optional[User] = pydantic.Field(default=None)
    """
    Describes details about the user that was the target or somehow else associated with the activity that triggered the detection.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
