# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime
from ...base.types.email_address import EmailAddress
from ...base.types.ip_address import IpAddress

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Email(pydantic.BaseModel):
    """
    The Email object describes the email metadata such as sender, recipients, and direction. Defined by D3FEND <a target='_blank' href='https://d3fend.mitre.org/dao/artifact/d3f:Email/'>d3f:Email</a>.
    """

    cc: typing.Optional[typing.List[EmailAddress]] = pydantic.Field(default=None)
    """
    The email header Cc values, as defined by RFC 5322.
    """

    delivered_to: typing.Optional[EmailAddress] = pydantic.Field(default=None)
    """
    The <strong>Delivered-To</strong> email header field.
    """

    from_: EmailAddress = pydantic.Field(alias="from")
    """
    The email header From values, as defined by RFC 5322.
    """

    message_uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The email header Message-Id value, as defined by RFC 5322.
    """

    raw_header: typing.Optional[str] = pydantic.Field(default=None)
    """
    The email authentication header.
    """

    reply_to: typing.Optional[EmailAddress] = pydantic.Field(default=None)
    """
    The email header Reply-To values, as defined by RFC 5322.
    """

    size: typing.Optional[int] = pydantic.Field(default=None)
    """
    The size in bytes of the email, including attachments.
    """

    smtp_from: typing.Optional[EmailAddress] = pydantic.Field(default=None)
    """
    The value of the SMTP MAIL FROM command.
    """

    smtp_to: typing.Optional[typing.List[EmailAddress]] = pydantic.Field(default=None)
    """
    The value of the SMTP envelope RCPT TO command.
    """

    subject: typing.Optional[str] = pydantic.Field(default=None)
    """
    The email header Subject value, as defined by RFC 5322.
    """

    to: typing.List[EmailAddress] = pydantic.Field()
    """
    The email header To values, as defined by RFC 5322.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The email unique identifier.
    """

    x_originating_ip: typing.Optional[typing.List[IpAddress]] = pydantic.Field(default=None)
    """
    The X-Originating-IP header identifying the emails originating IP address(es).
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
