# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..........core.datetime_utils import serialize_datetime
from .reputation_score_id import ReputationScoreId

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Reputation(pydantic.BaseModel):
    """
    The Reputation object describes the reputation/risk score of an entity (e.g. device, user, domain).
    """

    base_score: float = pydantic.Field()
    """
    The reputation score as reported by the event source.
    """

    provider: typing.Optional[str] = pydantic.Field(default=None)
    """
    The provider of the reputation information.
    """

    score: typing.Optional[str] = pydantic.Field(default=None)
    """
    The reputation score, normalized to the caption of the score_id value. In the case of 'Other', it is defined by the event source.
    """

    score_id: ReputationScoreId = pydantic.Field()
    """
    The normalized reputation score identifier.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
