# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

from ......core.datetime_utils import serialize_datetime
from .external_reference import ExternalReference
from .granular_marking import GranularMarking
from .id import Id
from .marking_definition import MarkingDefinition

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class CommonProperties(pydantic.BaseModel):
    spec_version: typing.Literal["2.1"]
    id: Id = pydantic.Field()
    """
    The id property uniquely identifies this object.
    """

    created_by_ref: typing.Optional[Identity] = pydantic.Field(default=None)
    """
    The created_by_ref property specifies the id property of the identity object that describes the entity that created this object.
    """

    created: dt.datetime = pydantic.Field()
    """
    The created property represents the time at which the object was originally created.
    """

    modified: dt.datetime = pydantic.Field()
    """
    The modified property is only used by STIX Objects that support versioning and represents the time that this particular version of the object was last modified.
    """

    revoked: typing.Optional[bool] = pydantic.Field(default=None)
    """
    The revoked property indicates whether this object has been revoked. If the revoked property is present and set to true, then the object has been revoked.
    """

    labels: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The labels property is an array of strings that are used to categorize this object.
    """

    confidence: typing.Optional[int] = pydantic.Field(default=None)
    """
    The confidence property is an integer from 0 to 100 that represents the confidence that this object is accurate and valid.
    """

    lang: typing.Optional[str] = pydantic.Field(default=None)
    """
    The lang property specifies the language used in the properties of the object.
    """

    external_references: typing.Optional[typing.List[ExternalReference]] = pydantic.Field(default=None)
    """
    The external_references property is an array of external references that are relevant to this object.
    """

    object_marking_refs: typing.Optional[typing.List[MarkingDefinition]] = pydantic.Field(default=None)
    """
    The object_marking_refs property is an array of ids of marking_definition objects that apply to this object.
    """

    granular_markings: typing.Optional[typing.List[GranularMarking]] = pydantic.Field(default=None)
    """
    The granular_markings property is an array of granular markings that are applied to this object.
    """

    extensions: typing.Optional[typing.Dict[str, typing.Any]] = pydantic.Field(default=None)
    """
    The extensions property is an object that contains custom properties or objects that extend the object.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}


from .identity import Identity  # noqa: E402

CommonProperties.update_forward_refs()
