# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ......core.datetime_utils import serialize_datetime

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class ExternalReference(pydantic.BaseModel):
    source_name: str = pydantic.Field()
    """
    The source_name property specifies the name of the source that provided the external reference.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description property provides a human-readable explanation of the external reference.
    """

    url: typing.Optional[str] = pydantic.Field(default=None)
    """
    The url property specifies the URL of the external reference.
    """

    hash: typing.Optional[str] = pydantic.Field(default=None)
    """
    The hash property specifies a hash value that uniquely identifies the external reference.
    """

    external_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The external_id property specifies an identifier used by the source of the external reference.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
