# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ......core.datetime_utils import serialize_datetime
from .marking_definition import MarkingDefinition

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class GranularMarking(pydantic.BaseModel):
    lang: typing.Optional[str] = pydantic.Field(default=None)
    """
    The lang property specifies the language used in the properties of the marking_definition object.
    """

    marking_ref: typing.Optional[MarkingDefinition] = pydantic.Field(default=None)
    """
    The marking_ref property specifies the id property of the marking_definition object that applies to this object.
    """

    selectors: typing.List[str] = pydantic.Field()
    """
    The selectors property is an array of strings that represent the selectors that are used to apply the marking_definition object to this object.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
