# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ......core.datetime_utils import serialize_datetime
from ...common.types.common_properties import CommonProperties
from ...common.types.kill_chain_phase import KillChainPhase
from ...open_vocab.types.indicator_type_ov import IndicatorTypeOv
from ...open_vocab.types.pattern_type_ov import PatternTypeOv

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Indicator(CommonProperties):
    type: typing.Literal["indicator"]
    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    A name used to identify the Indicator.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    A description that provides more details and context about the Indicator, potentially including its purpose and its key characteristics.
    """

    indicator_types: typing.Optional[typing.List[IndicatorTypeOv]] = pydantic.Field(default=None)
    """
    A set of categorizations for this indicator.
    """

    pattern: typing.Optional[str] = pydantic.Field(default=None)
    """
    The detection pattern for this Indicator MAY be expressed as a STIX Pattern as specified in section 9 or another appropriate language such as SNORT, YARA, etc.
    """

    pattern_type: typing.Optional[PatternTypeOv] = pydantic.Field(default=None)
    """
    The type of pattern expression used in the pattern property.
    """

    pattern_version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The version of the pattern expression used in the pattern property.
    """

    valid_from: dt.datetime = pydantic.Field()
    """
    The time from which this Indicator is considered a valid indicator of the behaviors it is related or represents.
    """

    valid_until: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time at which this Indicator is no longer considered valid.
    """

    kill_chain_phases: typing.Optional[typing.List[KillChainPhase]] = pydantic.Field(default=None)
    """
    The kill chain phase to which this Indicator corresponds.
    """

    raw_data: typing.Optional[str] = pydantic.Field(default=None)
    """
    The data as received from the source.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
