# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from .remote_field_schema import RemoteFieldSchema
from .remote_field_scope import RemoteFieldScope

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class RemoteField(pydantic.BaseModel):
    field_id: str = pydantic.Field()
    """
    Remote ID of the field.
    """

    schema_: RemoteFieldSchema = pydantic.Field(alias="schema")
    """
    Schema of the field.
    """

    field_scope: RemoteFieldScope = pydantic.Field()
    """
    Scope of remote field - standard or some kind of customization?
    """

    provider_field_name: str = pydantic.Field()
    """
    Name of field in the remote ticketing provider.
    """

    provider_field_path: typing.Optional[str] = pydantic.Field(default=None)
    """
    Path to the field in the remote ticketing provider. Uses dot notation for nested fields.
    """

    project_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Project id to which this field is scoped to
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
