# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class VulnerabilitySeverityFilterValue(str, enum.Enum):
    """
    Values supported by using severity as a filter. Supports `[eq]` and `[in]` operators.
    For example, `severity[eq]critical` or `severity[in]critical, high`.
    """

    CRITICAL = "critical"
    HIGH = "high"
    MEDIUM = "medium"
    LOW = "low"
    INFO = "info"

    def visit(
        self,
        critical: typing.Callable[[], T_Result],
        high: typing.Callable[[], T_Result],
        medium: typing.Callable[[], T_Result],
        low: typing.Callable[[], T_Result],
        info: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is VulnerabilitySeverityFilterValue.CRITICAL:
            return critical()
        if self is VulnerabilitySeverityFilterValue.HIGH:
            return high()
        if self is VulnerabilitySeverityFilterValue.MEDIUM:
            return medium()
        if self is VulnerabilitySeverityFilterValue.LOW:
            return low()
        if self is VulnerabilitySeverityFilterValue.INFO:
            return info()
